/* test-merge-ref.c generated by valac 0.32.1, the Vala compiler
 * generated from test-merge-ref.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "libgitg/libgitg.h"
#include "libgitg-ext/libgitg-ext.h"
#include <stdlib.h>
#include <string.h>
#include <libgit2-glib/ggit.h>
#include <gitg-assert.h>
#include <gio/gio.h>
#include <gee.h>
#include <gtk/gtk.h>


#define GITG_TEST_TYPE_TEST (gitg_test_test_get_type ())
#define GITG_TEST_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_TEST, GitgTestTest))
#define GITG_TEST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_TEST, GitgTestTestClass))
#define GITG_TEST_IS_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_TEST))
#define GITG_TEST_IS_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_TEST))
#define GITG_TEST_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_TEST, GitgTestTestClass))

typedef struct _GitgTestTest GitgTestTest;
typedef struct _GitgTestTestClass GitgTestTestClass;
typedef struct _GitgTestTestPrivate GitgTestTestPrivate;

#define GITG_TEST_TYPE_REPOSITORY (gitg_test_repository_get_type ())
#define GITG_TEST_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepository))
#define GITG_TEST_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))
#define GITG_TEST_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))

typedef struct _GitgTestRepository GitgTestRepository;
typedef struct _GitgTestRepositoryClass GitgTestRepositoryClass;
typedef struct _GitgTestRepositoryPrivate GitgTestRepositoryPrivate;

#define GITG_TEST_TYPE_APPLICATION (gitg_test_application_get_type ())
#define GITG_TEST_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_APPLICATION, GitgTestApplication))
#define GITG_TEST_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_APPLICATION, GitgTestApplicationClass))
#define GITG_TEST_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_APPLICATION))
#define GITG_TEST_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_APPLICATION))
#define GITG_TEST_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_APPLICATION, GitgTestApplicationClass))

typedef struct _GitgTestApplication GitgTestApplication;
typedef struct _GitgTestApplicationClass GitgTestApplicationClass;
typedef struct _GitgTestApplicationPrivate GitgTestApplicationPrivate;

#define GITG_TEST_TYPE_MERGE_REF (gitg_test_merge_ref_get_type ())
#define GITG_TEST_MERGE_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_MERGE_REF, GitgTestMergeRef))
#define GITG_TEST_MERGE_REF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_MERGE_REF, GitgTestMergeRefClass))
#define GITG_TEST_IS_MERGE_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_MERGE_REF))
#define GITG_TEST_IS_MERGE_REF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_MERGE_REF))
#define GITG_TEST_MERGE_REF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_MERGE_REF, GitgTestMergeRefClass))

typedef struct _GitgTestMergeRef GitgTestMergeRef;
typedef struct _GitgTestMergeRefClass GitgTestMergeRefClass;
typedef struct _GitgTestMergeRefPrivate GitgTestMergeRefPrivate;

#define GITG_TEST_TYPE_REF_ACTION_INTERFACE (gitg_test_ref_action_interface_get_type ())
#define GITG_TEST_REF_ACTION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_REF_ACTION_INTERFACE, GitgTestRefActionInterface))
#define GITG_TEST_REF_ACTION_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_REF_ACTION_INTERFACE, GitgTestRefActionInterfaceClass))
#define GITG_TEST_IS_REF_ACTION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_REF_ACTION_INTERFACE))
#define GITG_TEST_IS_REF_ACTION_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_REF_ACTION_INTERFACE))
#define GITG_TEST_REF_ACTION_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_REF_ACTION_INTERFACE, GitgTestRefActionInterfaceClass))

typedef struct _GitgTestRefActionInterface GitgTestRefActionInterface;
typedef struct _GitgTestRefActionInterfaceClass GitgTestRefActionInterfaceClass;

#define GITG_TYPE_REF_ACTION_CHECKOUT (gitg_ref_action_checkout_get_type ())
#define GITG_REF_ACTION_CHECKOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckout))
#define GITG_REF_ACTION_CHECKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckoutClass))
#define GITG_IS_REF_ACTION_CHECKOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF_ACTION_CHECKOUT))
#define GITG_IS_REF_ACTION_CHECKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REF_ACTION_CHECKOUT))
#define GITG_REF_ACTION_CHECKOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckoutClass))

typedef struct _GitgRefActionCheckout GitgRefActionCheckout;
typedef struct _GitgRefActionCheckoutClass GitgRefActionCheckoutClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))

#define GITG_TYPE_REF_ACTION_MERGE (gitg_ref_action_merge_get_type ())
#define GITG_REF_ACTION_MERGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF_ACTION_MERGE, GitgRefActionMerge))
#define GITG_REF_ACTION_MERGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REF_ACTION_MERGE, GitgRefActionMergeClass))
#define GITG_IS_REF_ACTION_MERGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF_ACTION_MERGE))
#define GITG_IS_REF_ACTION_MERGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REF_ACTION_MERGE))
#define GITG_REF_ACTION_MERGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REF_ACTION_MERGE, GitgRefActionMergeClass))

typedef struct _GitgRefActionMerge GitgRefActionMerge;
typedef struct _GitgRefActionMergeClass GitgRefActionMergeClass;
typedef struct _Block4Data Block4Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

#define GITG_TYPE_SIMPLE_NOTIFICATION (gitg_simple_notification_get_type ())
#define GITG_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotification))
#define GITG_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))
#define GITG_IS_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_IS_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_SIMPLE_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))

typedef struct _GitgSimpleNotification GitgSimpleNotification;
typedef struct _GitgSimpleNotificationClass GitgSimpleNotificationClass;

#define GITG_SIMPLE_NOTIFICATION_TYPE_STATUS (gitg_simple_notification_status_get_type ())
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GitgTestTest {
	GObject parent_instance;
	GitgTestTestPrivate * priv;
};

struct _GitgTestTestClass {
	GObjectClass parent_class;
	void (*set_up) (GitgTestTest* self);
	void (*tear_down) (GitgTestTest* self);
};

struct _GitgTestRepository {
	GitgTestTest parent_instance;
	GitgTestRepositoryPrivate * priv;
	GitgRepository* d_repository;
};

struct _GitgTestRepositoryClass {
	GitgTestTestClass parent_class;
};

struct _GitgTestApplication {
	GitgTestRepository parent_instance;
	GitgTestApplicationPrivate * priv;
};

struct _GitgTestApplicationClass {
	GitgTestRepositoryClass parent_class;
};

struct _GitgTestMergeRef {
	GitgTestApplication parent_instance;
	GitgTestMergeRefPrivate * priv;
};

struct _GitgTestMergeRefClass {
	GitgTestApplicationClass parent_class;
	void (*test_merge_simple) (GitgTestMergeRef* self);
	void (*test_merge_not_head) (GitgTestMergeRef* self);
	void (*test_merge_not_head_would_have_conflicted) (GitgTestMergeRef* self);
	void (*test_merge_theirs_conflicts_no_checkout) (GitgTestMergeRef* self);
	void (*test_merge_theirs_conflicts_checkout) (GitgTestMergeRef* self);
	void (*test_merge_theirs_dirty_stash) (GitgTestMergeRef* self);
	void (*test_merge_theirs_not_master_conflicts_checkout) (GitgTestMergeRef* self);
	void (*test_merge_theirs_not_master_conflicts_checkout_dirty) (GitgTestMergeRef* self);
	void (*test_merge_theirs_not_master_conflicts_checkout_dirty_no_stash) (GitgTestMergeRef* self);
};

struct _GitgTestMergeRefPrivate {
	GitgBranch* ours;
	GitgBranch* theirs;
	GitgBranch* master;
	GitgBranch* not_master;
	GitgTestRefActionInterface* action_interface;
	GitgRefActionCheckout* action;
};

struct _Block4Data {
	int _ref_count_;
	GitgTestMergeRef* self;
	GMainLoop* loop;
	GitgRefActionMerge* action;
};

typedef enum  {
	GITG_SIMPLE_NOTIFICATION_STATUS_NONE,
	GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS,
	GITG_SIMPLE_NOTIFICATION_STATUS_ERROR
} GitgSimpleNotificationStatus;

struct _Block5Data {
	int _ref_count_;
	GitgTestMergeRef* self;
	GMainLoop* loop;
	GitgRefActionMerge* action;
};

struct _Block6Data {
	int _ref_count_;
	GitgTestMergeRef* self;
	GMainLoop* loop;
	GitgRefActionMerge* action;
};

struct _Block7Data {
	int _ref_count_;
	GitgTestMergeRef* self;
	GMainLoop* loop;
	GitgRefActionMerge* action;
};

struct _Block8Data {
	int _ref_count_;
	GitgTestMergeRef* self;
	GMainLoop* loop;
	GitgRefActionMerge* action;
};

struct _Block9Data {
	int _ref_count_;
	GitgTestMergeRef* self;
	GMainLoop* loop;
	GitgRefActionMerge* action;
	gchar** messages;
	gint messages_length1;
	gint _messages_size_;
	GgitOId** oids;
	gint oids_length1;
	gint _oids_size_;
};

struct _Block10Data {
	int _ref_count_;
	GitgTestMergeRef* self;
	GMainLoop* loop;
	GitgRefActionMerge* action;
};

struct _Block11Data {
	int _ref_count_;
	GitgTestMergeRef* self;
	GMainLoop* loop;
	GitgRefActionMerge* action;
	gchar** messages;
	gint messages_length1;
	gint _messages_size_;
	GgitOId** oids;
	gint oids_length1;
	gint _oids_size_;
};

struct _Block12Data {
	int _ref_count_;
	GitgTestMergeRef* self;
	GMainLoop* loop;
	GitgRefActionMerge* action;
};


static gpointer gitg_test_merge_ref_parent_class = NULL;

GType gitg_test_test_get_type (void) G_GNUC_CONST;
GType gitg_test_repository_get_type (void) G_GNUC_CONST;
GType gitg_test_application_get_type (void) G_GNUC_CONST;
GType gitg_test_merge_ref_get_type (void) G_GNUC_CONST;
GType gitg_test_ref_action_interface_get_type (void) G_GNUC_CONST;
GType gitg_ref_action_checkout_get_type (void) G_GNUC_CONST;
#define GITG_TEST_MERGE_REF_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TEST_TYPE_MERGE_REF, GitgTestMergeRefPrivate))
enum  {
	GITG_TEST_MERGE_REF_DUMMY_PROPERTY
};
static void gitg_test_merge_ref_real_set_up (GitgTestTest* base);
void gitg_test_test_set_up (GitgTestTest* self);
void gitg_test_repository_commit (GitgTestRepository* self, const gchar* filename, ...);
GitgBranch* gitg_test_repository_create_branch (GitgTestRepository* self, const gchar* name);
void gitg_test_repository_checkout_branch (GitgTestRepository* self, const gchar* name);
GitgBranch* gitg_test_repository_lookup_branch (GitgTestRepository* self, const gchar* name);
GitgTestRefActionInterface* gitg_test_ref_action_interface_new (GitgExtApplication* application);
GitgTestRefActionInterface* gitg_test_ref_action_interface_construct (GType object_type, GitgExtApplication* application);
static void gitg_test_merge_ref_assert_merged (GitgTestMergeRef* self, GgitOId* ours, GgitOId* theirs, const gchar* name);
GitgCommit* gitg_test_repository_lookup_commit (GitgTestRepository* self, const gchar* name);
guint ggit_commit_parents_get_size (GgitCommitParents* self);
static void _vala_GgitOId_free (GgitOId* self);
GitgTestMergeRef* gitg_test_merge_ref_new (void);
GitgTestMergeRef* gitg_test_merge_ref_construct (GType object_type);
GitgTestApplication* gitg_test_application_new (void);
GitgTestApplication* gitg_test_application_construct (GType object_type);
static void gitg_test_merge_ref_real_test_merge_simple (GitgTestMergeRef* self);
GType gitg_ref_action_merge_get_type (void) G_GNUC_CONST;
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
GitgRefActionMerge* gitg_ref_action_merge_new (GitgExtApplication* application, GitgExtRefActionInterface* action_interface, GitgRef* reference);
GitgRefActionMerge* gitg_ref_action_merge_construct (GType object_type, GitgExtApplication* application, GitgExtRefActionInterface* action_interface, GitgRef* reference);
void gitg_ref_action_merge_merge (GitgRefActionMerge* self, GitgRef* source, GAsyncReadyCallback _callback_, gpointer _user_data_);
GgitOId* gitg_ref_action_merge_merge_finish (GitgRefActionMerge* self, GAsyncResult* _res_);
static void __lambda17_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res);
static void ___lambda17__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GType gitg_simple_notification_get_type (void) G_GNUC_CONST;
GeeArrayList* gitg_test_application_get_simple_notifications (GitgTestApplication* self);
const gchar* gitg_simple_notification_get_title (GitgSimpleNotification* self);
const gchar* gitg_simple_notification_get_message (GitgSimpleNotification* self);
GType gitg_simple_notification_status_get_type (void) G_GNUC_CONST;
GitgSimpleNotificationStatus gitg_simple_notification_get_status (GitgSimpleNotification* self);
void gitg_test_repository_assert_file_contents (GitgTestRepository* self, const gchar* filename, const gchar* expected_contents);
static void gitg_test_merge_ref_real_test_merge_not_head (GitgTestMergeRef* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda18_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res);
static void ___lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gboolean gitg_test_repository_file_exists (GitgTestRepository* self, const gchar* filename);
static void gitg_test_merge_ref_real_test_merge_not_head_would_have_conflicted (GitgTestMergeRef* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda19_ (Block6Data* _data6_, GObject* obj, GAsyncResult* res);
static void ___lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_merge_ref_real_test_merge_theirs_conflicts_no_checkout (GitgTestMergeRef* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
GitgTestApplication* gitg_test_application_expect_user_query (GitgTestApplication* self, GitgExtUserQuery* query, GtkResponseType response);
static void __lambda20_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res);
static void ___lambda20__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_merge_ref_real_test_merge_theirs_conflicts_checkout (GitgTestMergeRef* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda21_ (Block8Data* _data8_, GObject* obj, GAsyncResult* res);
static void ___lambda21__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_merge_ref_real_test_merge_theirs_dirty_stash (GitgTestMergeRef* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
void gitg_test_repository_write_file (GitgTestRepository* self, const gchar* filename, const gchar* contents);
static void __lambda22_ (Block9Data* _data9_, GObject* obj, GAsyncResult* res);
static void ___lambda22__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gint __lambda23_ (Block9Data* _data9_, gsize index, const gchar* message, GgitOId* oid);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static void _vala_array_add2 (GgitOId*** array, int* length, int* size, GgitOId* value);
static gint ___lambda23__ggit_stash_callback (gsize index, const gchar* message, GgitOId* stash_oid, gpointer self);
static void gitg_test_merge_ref_real_test_merge_theirs_not_master_conflicts_checkout (GitgTestMergeRef* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda24_ (Block10Data* _data10_, GObject* obj, GAsyncResult* res);
static void ___lambda24__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_merge_ref_real_test_merge_theirs_not_master_conflicts_checkout_dirty (GitgTestMergeRef* self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda25_ (Block11Data* _data11_, GObject* obj, GAsyncResult* res);
static void ___lambda25__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gint __lambda26_ (Block11Data* _data11_, gsize index, const gchar* message, GgitOId* oid);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (GgitOId*** array, int* length, int* size, GgitOId* value);
static gint ___lambda26__ggit_stash_callback (gsize index, const gchar* message, GgitOId* stash_oid, gpointer self);
static void gitg_test_merge_ref_real_test_merge_theirs_not_master_conflicts_checkout_dirty_no_stash (GitgTestMergeRef* self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda27_ (Block12Data* _data12_, GObject* obj, GAsyncResult* res);
static void ___lambda27__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gint __lambda28_ (GitgTestMergeRef* self, gsize index, const gchar* message, GgitOId* oid);
static gint ___lambda28__ggit_stash_callback (gsize index, const gchar* message, GgitOId* stash_oid, gpointer self);
static void gitg_test_merge_ref_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void gitg_test_merge_ref_real_set_up (GitgTestTest* base) {
	GitgTestMergeRef * self;
	GitgBranch* _tmp0_ = NULL;
	GitgBranch* _tmp1_ = NULL;
	GitgBranch* _tmp2_ = NULL;
	GitgBranch* _tmp3_ = NULL;
	GitgBranch* _tmp4_ = NULL;
	GitgTestRefActionInterface* _tmp5_ = NULL;
#line 32 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = (GitgTestMergeRef*) base;
#line 34 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	GITG_TEST_TEST_CLASS (gitg_test_merge_ref_parent_class)->set_up ((GitgTestTest*) G_TYPE_CHECK_INSTANCE_CAST (self, GITG_TEST_TYPE_APPLICATION, GitgTestApplication));
#line 36 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "a", "a file\n", NULL);
#line 37 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = gitg_test_repository_create_branch ((GitgTestRepository*) self, "theirs");
#line 37 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = _tmp0_;
#line 37 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp1_);
#line 39 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "b", "b file\n", NULL);
#line 41 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "theirs");
#line 42 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file\n", NULL);
#line 44 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "theirs");
#line 44 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->theirs);
#line 44 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self->priv->theirs = _tmp2_;
#line 46 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "master");
#line 47 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = gitg_test_repository_create_branch ((GitgTestRepository*) self, "not_master");
#line 47 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->not_master);
#line 47 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self->priv->not_master = _tmp3_;
#line 49 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp4_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "master");
#line 49 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->master);
#line 49 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self->priv->master = _tmp4_;
#line 51 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp5_ = gitg_test_ref_action_interface_new ((GitgExtApplication*) self);
#line 51 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->action_interface);
#line 51 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self->priv->action_interface = _tmp5_;
#line 435 "test-merge-ref.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 442 "test-merge-ref.c"
}


static void gitg_test_merge_ref_assert_merged (GitgTestMergeRef* self, GgitOId* ours, GgitOId* theirs, const gchar* name) {
	GitgCommit* now_commit = NULL;
	const gchar* _tmp0_ = NULL;
	GitgCommit* _tmp1_ = NULL;
	GgitCommitParents* parents = NULL;
	GgitCommitParents* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	GgitCommit* _tmp5_ = NULL;
	GgitCommit* _tmp6_ = NULL;
	GgitOId* _tmp7_ = NULL;
	GgitOId* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GgitOId* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GgitCommit* _tmp14_ = NULL;
	GgitCommit* _tmp15_ = NULL;
	GgitOId* _tmp16_ = NULL;
	GgitOId* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GgitOId* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
#line 54 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (ours != NULL);
#line 54 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (theirs != NULL);
#line 54 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (name != NULL);
#line 56 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = name;
#line 56 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_test_repository_lookup_commit ((GitgTestRepository*) self, _tmp0_);
#line 56 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	now_commit = _tmp1_;
#line 58 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = ggit_commit_get_parents ((GgitCommit*) now_commit);
#line 58 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	parents = _tmp2_;
#line 59 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = ggit_commit_parents_get_size (parents);
#line 59 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp4_ = _tmp3_;
#line 59 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_uinteq (_tmp4_, (guint) 2);
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp5_ = ggit_commit_parents_get (parents, (guint) 0);
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp6_ = _tmp5_;
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp7_ = ggit_object_get_id ((GgitObject*) _tmp6_);
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp8_ = _tmp7_;
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp9_ = ggit_oid_to_string (_tmp8_);
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp10_ = _tmp9_;
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp11_ = ours;
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp12_ = ggit_oid_to_string (_tmp11_);
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp13_ = _tmp12_;
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp10_, _tmp13_);
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_free0 (_tmp13_);
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_free0 (_tmp10_);
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (_tmp8_);
#line 61 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp6_);
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp14_ = ggit_commit_parents_get (parents, (guint) 1);
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp15_ = _tmp14_;
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp16_ = ggit_object_get_id ((GgitObject*) _tmp15_);
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp17_ = _tmp16_;
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp18_ = ggit_oid_to_string (_tmp17_);
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp19_ = _tmp18_;
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp20_ = theirs;
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp21_ = ggit_oid_to_string (_tmp20_);
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp22_ = _tmp21_;
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp19_, _tmp22_);
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_free0 (_tmp22_);
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_free0 (_tmp19_);
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (_tmp17_);
#line 62 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp15_);
#line 54 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (parents);
#line 54 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (now_commit);
#line 556 "test-merge-ref.c"
}


GitgTestMergeRef* gitg_test_merge_ref_construct (GType object_type) {
	GitgTestMergeRef * self = NULL;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = (GitgTestMergeRef*) gitg_test_application_construct (object_type);
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return self;
#line 566 "test-merge-ref.c"
}


GitgTestMergeRef* gitg_test_merge_ref_new (void) {
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return gitg_test_merge_ref_construct (GITG_TEST_TYPE_MERGE_REF);
#line 573 "test-merge-ref.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return _data4_;
#line 582 "test-merge-ref.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 591 "test-merge-ref.c"
		GitgTestMergeRef* self;
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		self = _data4_->self;
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (_data4_->action);
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_main_loop_unref0 (_data4_->loop);
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (self);
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_slice_free (Block4Data, _data4_);
#line 603 "test-merge-ref.c"
	}
}


static void __lambda17_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res) {
	GitgTestMergeRef* self;
	GAsyncResult* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
#line 73 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = _data4_->self;
#line 73 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (res != NULL);
#line 74 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = res;
#line 74 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_ref_action_merge_merge_finish (_data4_->action, _tmp0_);
#line 74 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = _tmp1_;
#line 74 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 75 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_quit (_data4_->loop);
#line 627 "test-merge-ref.c"
}


static void ___lambda17__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 73 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__lambda17_ (self, source_object, res);
#line 73 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block4_data_unref (self);
#line 636 "test-merge-ref.c"
}


static void gitg_test_merge_ref_real_test_merge_simple (GitgTestMergeRef* self) {
	Block4Data* _data4_;
	GMainLoop* _tmp0_ = NULL;
	GitgTestRefActionInterface* _tmp1_ = NULL;
	GitgBranch* _tmp2_ = NULL;
	GitgRefActionMerge* _tmp3_ = NULL;
	GgitOId* ours_oid = NULL;
	GitgCommit* _tmp4_ = NULL;
	GitgCommit* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GgitOId* _tmp7_ = NULL;
	GgitOId* theirs_oid = NULL;
	GitgBranch* _tmp8_ = NULL;
	GgitOId* _tmp9_ = NULL;
	GitgBranch* _tmp10_ = NULL;
	GeeArrayList* _tmp11_ = NULL;
	GeeArrayList* _tmp12_ = NULL;
	GeeArrayList* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* _tmp17_ = NULL;
	GeeArrayList* _tmp18_ = NULL;
	gpointer _tmp19_ = NULL;
	GitgSimpleNotification* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GeeArrayList* _tmp23_ = NULL;
	GeeArrayList* _tmp24_ = NULL;
	GeeArrayList* _tmp25_ = NULL;
	gpointer _tmp26_ = NULL;
	GitgSimpleNotification* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GeeArrayList* _tmp30_ = NULL;
	GeeArrayList* _tmp31_ = NULL;
	GeeArrayList* _tmp32_ = NULL;
	gpointer _tmp33_ = NULL;
	GitgSimpleNotification* _tmp34_ = NULL;
	GitgSimpleNotificationStatus _tmp35_ = 0;
	GitgSimpleNotificationStatus _tmp36_ = 0;
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data4_->_ref_count_ = 1;
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data4_->self = g_object_ref (self);
#line 67 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 67 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data4_->loop = _tmp0_;
#line 68 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = self->priv->action_interface;
#line 68 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = self->priv->master;
#line 68 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = gitg_ref_action_merge_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp1_, (GitgRef*) _tmp2_);
#line 68 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data4_->action = _tmp3_;
#line 70 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp4_ = gitg_test_repository_lookup_commit ((GitgTestRepository*) self, "master");
#line 70 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp5_ = _tmp4_;
#line 70 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp6_ = ggit_object_get_id ((GgitObject*) _tmp5_);
#line 70 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp7_ = _tmp6_;
#line 70 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp5_);
#line 70 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	ours_oid = _tmp7_;
#line 71 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp8_ = self->priv->theirs;
#line 71 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp9_ = ggit_ref_get_target ((GgitRef*) _tmp8_);
#line 71 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	theirs_oid = _tmp9_;
#line 73 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp10_ = self->priv->theirs;
#line 73 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_ref_action_merge_merge (_data4_->action, (GitgRef*) _tmp10_, ___lambda17__gasync_ready_callback, block4_data_ref (_data4_));
#line 78 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_run (_data4_->loop);
#line 80 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp11_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 80 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp12_ = _tmp11_;
#line 80 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp13_ = _tmp12_;
#line 80 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
#line 80 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp15_ = _tmp14_;
#line 80 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq (_tmp15_, 1);
#line 80 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp13_);
#line 81 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp16_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 81 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp17_ = _tmp16_;
#line 81 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp18_ = _tmp17_;
#line 81 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, 0);
#line 81 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp20_ = (GitgSimpleNotification*) _tmp19_;
#line 81 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp21_ = gitg_simple_notification_get_title (_tmp20_);
#line 81 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp22_ = _tmp21_;
#line 81 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp22_, "Merge 'theirs' into 'master'");
#line 81 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp20_);
#line 81 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp18_);
#line 82 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp23_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 82 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp24_ = _tmp23_;
#line 82 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp25_ = _tmp24_;
#line 82 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
#line 82 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp27_ = (GitgSimpleNotification*) _tmp26_;
#line 82 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp28_ = gitg_simple_notification_get_message (_tmp27_);
#line 82 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp29_ = _tmp28_;
#line 82 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp29_, "Successfully merged 'theirs' into 'master'");
#line 82 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp27_);
#line 82 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp25_);
#line 83 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp30_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 83 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp31_ = _tmp30_;
#line 83 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp32_ = _tmp31_;
#line 83 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, 0);
#line 83 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp34_ = (GitgSimpleNotification*) _tmp33_;
#line 83 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp35_ = gitg_simple_notification_get_status (_tmp34_);
#line 83 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp36_ = _tmp35_;
#line 83 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp36_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 83 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp34_);
#line 83 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp32_);
#line 85 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 86 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 87 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "c file\n");
#line 89 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_merge_ref_assert_merged (self, ours_oid, theirs_oid, "master");
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (theirs_oid);
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (ours_oid);
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block4_data_unref (_data4_);
#line 65 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data4_ = NULL;
#line 813 "test-merge-ref.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return _data5_;
#line 822 "test-merge-ref.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 831 "test-merge-ref.c"
		GitgTestMergeRef* self;
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		self = _data5_->self;
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (_data5_->action);
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_main_loop_unref0 (_data5_->loop);
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (self);
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_slice_free (Block5Data, _data5_);
#line 843 "test-merge-ref.c"
	}
}


static void __lambda18_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res) {
	GitgTestMergeRef* self;
	GAsyncResult* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
#line 100 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = _data5_->self;
#line 100 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (res != NULL);
#line 101 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = res;
#line 101 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_ref_action_merge_merge_finish (_data5_->action, _tmp0_);
#line 101 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = _tmp1_;
#line 101 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 102 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_quit (_data5_->loop);
#line 867 "test-merge-ref.c"
}


static void ___lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 100 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__lambda18_ (self, source_object, res);
#line 100 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block5_data_unref (self);
#line 876 "test-merge-ref.c"
}


static void gitg_test_merge_ref_real_test_merge_not_head (GitgTestMergeRef* self) {
	Block5Data* _data5_;
	GMainLoop* _tmp0_ = NULL;
	GitgTestRefActionInterface* _tmp1_ = NULL;
	GitgBranch* _tmp2_ = NULL;
	GitgRefActionMerge* _tmp3_ = NULL;
	GgitOId* ours_oid = NULL;
	GitgBranch* _tmp4_ = NULL;
	GgitOId* _tmp5_ = NULL;
	GgitOId* theirs_oid = NULL;
	GitgBranch* _tmp6_ = NULL;
	GgitOId* _tmp7_ = NULL;
	GitgBranch* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	GeeArrayList* _tmp10_ = NULL;
	GeeArrayList* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GeeArrayList* _tmp14_ = NULL;
	GeeArrayList* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	gpointer _tmp17_ = NULL;
	GitgSimpleNotification* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GeeArrayList* _tmp21_ = NULL;
	GeeArrayList* _tmp22_ = NULL;
	GeeArrayList* _tmp23_ = NULL;
	gpointer _tmp24_ = NULL;
	GitgSimpleNotification* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GeeArrayList* _tmp28_ = NULL;
	GeeArrayList* _tmp29_ = NULL;
	GeeArrayList* _tmp30_ = NULL;
	gpointer _tmp31_ = NULL;
	GitgSimpleNotification* _tmp32_ = NULL;
	GitgSimpleNotificationStatus _tmp33_ = 0;
	GitgSimpleNotificationStatus _tmp34_ = 0;
	gboolean _tmp35_ = FALSE;
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data5_->_ref_count_ = 1;
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data5_->self = g_object_ref (self);
#line 94 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 94 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data5_->loop = _tmp0_;
#line 95 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = self->priv->action_interface;
#line 95 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = self->priv->not_master;
#line 95 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = gitg_ref_action_merge_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp1_, (GitgRef*) _tmp2_);
#line 95 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data5_->action = _tmp3_;
#line 97 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp4_ = self->priv->not_master;
#line 97 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp5_ = ggit_ref_get_target ((GgitRef*) _tmp4_);
#line 97 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	ours_oid = _tmp5_;
#line 98 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp6_ = self->priv->theirs;
#line 98 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp7_ = ggit_ref_get_target ((GgitRef*) _tmp6_);
#line 98 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	theirs_oid = _tmp7_;
#line 100 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp8_ = self->priv->theirs;
#line 100 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_ref_action_merge_merge (_data5_->action, (GitgRef*) _tmp8_, ___lambda18__gasync_ready_callback, block5_data_ref (_data5_));
#line 105 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_run (_data5_->loop);
#line 107 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp9_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 107 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp10_ = _tmp9_;
#line 107 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp11_ = _tmp10_;
#line 107 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
#line 107 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp13_ = _tmp12_;
#line 107 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq (_tmp13_, 1);
#line 107 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp11_);
#line 108 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp14_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 108 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp15_ = _tmp14_;
#line 108 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp16_ = _tmp15_;
#line 108 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, 0);
#line 108 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp18_ = (GitgSimpleNotification*) _tmp17_;
#line 108 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp19_ = gitg_simple_notification_get_title (_tmp18_);
#line 108 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp20_ = _tmp19_;
#line 108 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp20_, "Merge 'theirs' into 'not_master'");
#line 108 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp18_);
#line 108 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp16_);
#line 109 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp21_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 109 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp22_ = _tmp21_;
#line 109 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp23_ = _tmp22_;
#line 109 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, 0);
#line 109 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp25_ = (GitgSimpleNotification*) _tmp24_;
#line 109 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp26_ = gitg_simple_notification_get_message (_tmp25_);
#line 109 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp27_ = _tmp26_;
#line 109 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp27_, "Successfully merged 'theirs' into 'not_master'");
#line 109 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp25_);
#line 109 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp23_);
#line 110 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp28_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 110 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp29_ = _tmp28_;
#line 110 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp30_ = _tmp29_;
#line 110 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, 0);
#line 110 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp32_ = (GitgSimpleNotification*) _tmp31_;
#line 110 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp33_ = gitg_simple_notification_get_status (_tmp32_);
#line 110 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp34_ = _tmp33_;
#line 110 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp34_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 110 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp32_);
#line 110 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp30_);
#line 112 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 113 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 114 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp35_ = gitg_test_repository_file_exists ((GitgTestRepository*) self, "c");
#line 114 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_vala_assert (!_tmp35_, "!file_exists(\"c\")");
#line 116 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_merge_ref_assert_merged (self, ours_oid, theirs_oid, "not_master");
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (theirs_oid);
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (ours_oid);
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block5_data_unref (_data5_);
#line 92 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data5_ = NULL;
#line 1048 "test-merge-ref.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return _data6_;
#line 1057 "test-merge-ref.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 1066 "test-merge-ref.c"
		GitgTestMergeRef* self;
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		self = _data6_->self;
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (_data6_->action);
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_main_loop_unref0 (_data6_->loop);
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (self);
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_slice_free (Block6Data, _data6_);
#line 1078 "test-merge-ref.c"
	}
}


static void __lambda19_ (Block6Data* _data6_, GObject* obj, GAsyncResult* res) {
	GitgTestMergeRef* self;
	GAsyncResult* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
#line 130 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = _data6_->self;
#line 130 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (res != NULL);
#line 131 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = res;
#line 131 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_ref_action_merge_merge_finish (_data6_->action, _tmp0_);
#line 131 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = _tmp1_;
#line 131 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 132 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_quit (_data6_->loop);
#line 1102 "test-merge-ref.c"
}


static void ___lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 130 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__lambda19_ (self, source_object, res);
#line 130 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block6_data_unref (self);
#line 1111 "test-merge-ref.c"
}


static void gitg_test_merge_ref_real_test_merge_not_head_would_have_conflicted (GitgTestMergeRef* self) {
	Block6Data* _data6_;
	GMainLoop* _tmp0_ = NULL;
	GgitOId* ours_oid = NULL;
	GitgBranch* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitOId* theirs_oid = NULL;
	GitgBranch* _tmp3_ = NULL;
	GgitOId* _tmp4_ = NULL;
	GitgTestRefActionInterface* _tmp5_ = NULL;
	GitgBranch* _tmp6_ = NULL;
	GitgRefActionMerge* _tmp7_ = NULL;
	GitgBranch* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	GeeArrayList* _tmp10_ = NULL;
	GeeArrayList* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GeeArrayList* _tmp14_ = NULL;
	GeeArrayList* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	gpointer _tmp17_ = NULL;
	GitgSimpleNotification* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GeeArrayList* _tmp21_ = NULL;
	GeeArrayList* _tmp22_ = NULL;
	GeeArrayList* _tmp23_ = NULL;
	gpointer _tmp24_ = NULL;
	GitgSimpleNotification* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GeeArrayList* _tmp28_ = NULL;
	GeeArrayList* _tmp29_ = NULL;
	GeeArrayList* _tmp30_ = NULL;
	gpointer _tmp31_ = NULL;
	GitgSimpleNotification* _tmp32_ = NULL;
	GitgSimpleNotificationStatus _tmp33_ = 0;
	GitgSimpleNotificationStatus _tmp34_ = 0;
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data6_->_ref_count_ = 1;
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data6_->self = g_object_ref (self);
#line 121 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 121 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data6_->loop = _tmp0_;
#line 123 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file other content\n", NULL);
#line 125 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = self->priv->not_master;
#line 125 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = ggit_ref_get_target ((GgitRef*) _tmp1_);
#line 125 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	ours_oid = _tmp2_;
#line 126 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = self->priv->theirs;
#line 126 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp4_ = ggit_ref_get_target ((GgitRef*) _tmp3_);
#line 126 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	theirs_oid = _tmp4_;
#line 128 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp5_ = self->priv->action_interface;
#line 128 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp6_ = self->priv->not_master;
#line 128 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp7_ = gitg_ref_action_merge_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp5_, (GitgRef*) _tmp6_);
#line 128 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data6_->action = _tmp7_;
#line 130 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp8_ = self->priv->theirs;
#line 130 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_ref_action_merge_merge (_data6_->action, (GitgRef*) _tmp8_, ___lambda19__gasync_ready_callback, block6_data_ref (_data6_));
#line 135 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_run (_data6_->loop);
#line 137 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp9_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 137 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp10_ = _tmp9_;
#line 137 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp11_ = _tmp10_;
#line 137 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
#line 137 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp13_ = _tmp12_;
#line 137 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq (_tmp13_, 1);
#line 137 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp11_);
#line 138 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp14_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 138 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp15_ = _tmp14_;
#line 138 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp16_ = _tmp15_;
#line 138 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, 0);
#line 138 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp18_ = (GitgSimpleNotification*) _tmp17_;
#line 138 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp19_ = gitg_simple_notification_get_title (_tmp18_);
#line 138 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp20_ = _tmp19_;
#line 138 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp20_, "Merge 'theirs' into 'not_master'");
#line 138 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp18_);
#line 138 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp16_);
#line 139 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp21_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 139 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp22_ = _tmp21_;
#line 139 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp23_ = _tmp22_;
#line 139 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, 0);
#line 139 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp25_ = (GitgSimpleNotification*) _tmp24_;
#line 139 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp26_ = gitg_simple_notification_get_message (_tmp25_);
#line 139 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp27_ = _tmp26_;
#line 139 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp27_, "Successfully merged 'theirs' into 'not_master'");
#line 139 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp25_);
#line 139 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp23_);
#line 140 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp28_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 140 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp29_ = _tmp28_;
#line 140 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp30_ = _tmp29_;
#line 140 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, 0);
#line 140 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp32_ = (GitgSimpleNotification*) _tmp31_;
#line 140 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp33_ = gitg_simple_notification_get_status (_tmp32_);
#line 140 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp34_ = _tmp33_;
#line 140 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp34_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 140 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp32_);
#line 140 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp30_);
#line 142 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 143 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 144 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "c file other content\n");
#line 146 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_merge_ref_assert_merged (self, ours_oid, theirs_oid, "not_master");
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (theirs_oid);
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (ours_oid);
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block6_data_unref (_data6_);
#line 119 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data6_ = NULL;
#line 1282 "test-merge-ref.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return _data7_;
#line 1291 "test-merge-ref.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 1300 "test-merge-ref.c"
		GitgTestMergeRef* self;
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		self = _data7_->self;
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (_data7_->action);
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_main_loop_unref0 (_data7_->loop);
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (self);
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_slice_free (Block7Data, _data7_);
#line 1312 "test-merge-ref.c"
	}
}


static void __lambda20_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res) {
	GitgTestMergeRef* self;
	GAsyncResult* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
#line 169 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = _data7_->self;
#line 169 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (res != NULL);
#line 170 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = res;
#line 170 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_ref_action_merge_merge_finish (_data7_->action, _tmp0_);
#line 170 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = _tmp1_;
#line 170 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 171 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_quit (_data7_->loop);
#line 1336 "test-merge-ref.c"
}


static void ___lambda20__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 169 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__lambda20_ (self, source_object, res);
#line 169 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block7_data_unref (self);
#line 1345 "test-merge-ref.c"
}


static void gitg_test_merge_ref_real_test_merge_theirs_conflicts_no_checkout (GitgTestMergeRef* self) {
	Block7Data* _data7_;
	GMainLoop* _tmp0_ = NULL;
	GgitOId* ours_oid = NULL;
	GitgCommit* _tmp1_ = NULL;
	GitgCommit* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GgitOId* _tmp4_ = NULL;
	GgitOId* theirs_oid = NULL;
	GitgBranch* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GitgTestRefActionInterface* _tmp7_ = NULL;
	GitgBranch* _tmp8_ = NULL;
	GitgRefActionMerge* _tmp9_ = NULL;
	GitgExtUserQuery* _tmp10_ = NULL;
	GitgExtUserQuery* _tmp11_ = NULL;
	GitgTestApplication* _tmp12_ = NULL;
	GitgTestApplication* _tmp13_ = NULL;
	GitgBranch* _tmp14_ = NULL;
	GeeArrayList* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GeeArrayList* _tmp20_ = NULL;
	GeeArrayList* _tmp21_ = NULL;
	GeeArrayList* _tmp22_ = NULL;
	gpointer _tmp23_ = NULL;
	GitgSimpleNotification* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GeeArrayList* _tmp27_ = NULL;
	GeeArrayList* _tmp28_ = NULL;
	GeeArrayList* _tmp29_ = NULL;
	gpointer _tmp30_ = NULL;
	GitgSimpleNotification* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GeeArrayList* _tmp34_ = NULL;
	GeeArrayList* _tmp35_ = NULL;
	GeeArrayList* _tmp36_ = NULL;
	gpointer _tmp37_ = NULL;
	GitgSimpleNotification* _tmp38_ = NULL;
	GitgSimpleNotificationStatus _tmp39_ = 0;
	GitgSimpleNotificationStatus _tmp40_ = 0;
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data7_->_ref_count_ = 1;
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data7_->self = g_object_ref (self);
#line 151 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 151 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data7_->loop = _tmp0_;
#line 153 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file other content\n", NULL);
#line 155 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_test_repository_lookup_commit ((GitgTestRepository*) self, "master");
#line 155 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = _tmp1_;
#line 155 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = ggit_object_get_id ((GgitObject*) _tmp2_);
#line 155 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp4_ = _tmp3_;
#line 155 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp2_);
#line 155 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	ours_oid = _tmp4_;
#line 156 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp5_ = self->priv->theirs;
#line 156 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp6_ = ggit_ref_get_target ((GgitRef*) _tmp5_);
#line 156 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	theirs_oid = _tmp6_;
#line 158 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp7_ = self->priv->action_interface;
#line 158 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp8_ = self->priv->master;
#line 158 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp9_ = gitg_ref_action_merge_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp7_, (GitgRef*) _tmp8_);
#line 158 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data7_->action = _tmp9_;
#line 160 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp10_ = gitg_ext_user_query_new_full ("Merge has conflicts", "The merge of 'theirs' into 'master' has caused conflicts, would you li" \
"ke to checkout branch 'master' with the merge to your working director" \
"y to resolve the conflicts?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Checkout", GTK_RESPONSE_OK, NULL);
#line 160 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp11_ = _tmp10_;
#line 160 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp12_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp11_, GTK_RESPONSE_CANCEL);
#line 160 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp13_ = _tmp12_;
#line 160 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp13_);
#line 160 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp11_);
#line 169 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp14_ = self->priv->theirs;
#line 169 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_ref_action_merge_merge (_data7_->action, (GitgRef*) _tmp14_, ___lambda20__gasync_ready_callback, block7_data_ref (_data7_));
#line 174 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_run (_data7_->loop);
#line 176 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp15_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 176 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp16_ = _tmp15_;
#line 176 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp17_ = _tmp16_;
#line 176 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp17_);
#line 176 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp19_ = _tmp18_;
#line 176 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq (_tmp19_, 1);
#line 176 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp17_);
#line 177 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp20_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 177 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp21_ = _tmp20_;
#line 177 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp22_ = _tmp21_;
#line 177 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, 0);
#line 177 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp24_ = (GitgSimpleNotification*) _tmp23_;
#line 177 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp25_ = gitg_simple_notification_get_title (_tmp24_);
#line 177 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp26_ = _tmp25_;
#line 177 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp26_, "Merge 'theirs' into 'master'");
#line 177 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp24_);
#line 177 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp22_);
#line 178 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp27_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 178 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp28_ = _tmp27_;
#line 178 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp29_ = _tmp28_;
#line 178 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, 0);
#line 178 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp31_ = (GitgSimpleNotification*) _tmp30_;
#line 178 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp32_ = gitg_simple_notification_get_message (_tmp31_);
#line 178 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp33_ = _tmp32_;
#line 178 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp33_, "Merge failed with conflicts");
#line 178 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp31_);
#line 178 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp29_);
#line 179 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp34_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 179 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp35_ = _tmp34_;
#line 179 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp36_ = _tmp35_;
#line 179 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, 0);
#line 179 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp38_ = (GitgSimpleNotification*) _tmp37_;
#line 179 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp39_ = gitg_simple_notification_get_status (_tmp38_);
#line 179 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp40_ = _tmp39_;
#line 179 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp40_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_ERROR);
#line 179 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp38_);
#line 179 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp36_);
#line 181 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 182 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 183 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "c file other content\n");
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (theirs_oid);
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (ours_oid);
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block7_data_unref (_data7_);
#line 149 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data7_ = NULL;
#line 1538 "test-merge-ref.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return _data8_;
#line 1547 "test-merge-ref.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 1556 "test-merge-ref.c"
		GitgTestMergeRef* self;
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		self = _data8_->self;
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (_data8_->action);
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_main_loop_unref0 (_data8_->loop);
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (self);
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_slice_free (Block8Data, _data8_);
#line 1568 "test-merge-ref.c"
	}
}


static void __lambda21_ (Block8Data* _data8_, GObject* obj, GAsyncResult* res) {
	GitgTestMergeRef* self;
	GAsyncResult* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
#line 206 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = _data8_->self;
#line 206 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (res != NULL);
#line 207 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = res;
#line 207 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_ref_action_merge_merge_finish (_data8_->action, _tmp0_);
#line 207 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = _tmp1_;
#line 207 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 208 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_quit (_data8_->loop);
#line 1592 "test-merge-ref.c"
}


static void ___lambda21__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 206 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__lambda21_ (self, source_object, res);
#line 206 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block8_data_unref (self);
#line 1601 "test-merge-ref.c"
}


static void gitg_test_merge_ref_real_test_merge_theirs_conflicts_checkout (GitgTestMergeRef* self) {
	Block8Data* _data8_;
	GMainLoop* _tmp0_ = NULL;
	GgitOId* ours_oid = NULL;
	GitgCommit* _tmp1_ = NULL;
	GitgCommit* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GgitOId* _tmp4_ = NULL;
	GgitOId* theirs_oid = NULL;
	GitgBranch* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GitgTestRefActionInterface* _tmp7_ = NULL;
	GitgBranch* _tmp8_ = NULL;
	GitgRefActionMerge* _tmp9_ = NULL;
	GitgExtUserQuery* _tmp10_ = NULL;
	GitgExtUserQuery* _tmp11_ = NULL;
	GitgTestApplication* _tmp12_ = NULL;
	GitgTestApplication* _tmp13_ = NULL;
	GitgBranch* _tmp14_ = NULL;
	GeeArrayList* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GeeArrayList* _tmp20_ = NULL;
	GeeArrayList* _tmp21_ = NULL;
	GeeArrayList* _tmp22_ = NULL;
	gpointer _tmp23_ = NULL;
	GitgSimpleNotification* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GeeArrayList* _tmp27_ = NULL;
	GeeArrayList* _tmp28_ = NULL;
	GeeArrayList* _tmp29_ = NULL;
	gpointer _tmp30_ = NULL;
	GitgSimpleNotification* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GeeArrayList* _tmp34_ = NULL;
	GeeArrayList* _tmp35_ = NULL;
	GeeArrayList* _tmp36_ = NULL;
	gpointer _tmp37_ = NULL;
	GitgSimpleNotification* _tmp38_ = NULL;
	GitgSimpleNotificationStatus _tmp39_ = 0;
	GitgSimpleNotificationStatus _tmp40_ = 0;
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data8_->_ref_count_ = 1;
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data8_->self = g_object_ref (self);
#line 188 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 188 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data8_->loop = _tmp0_;
#line 190 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file other content\n", NULL);
#line 192 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_test_repository_lookup_commit ((GitgTestRepository*) self, "master");
#line 192 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = _tmp1_;
#line 192 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = ggit_object_get_id ((GgitObject*) _tmp2_);
#line 192 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp4_ = _tmp3_;
#line 192 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp2_);
#line 192 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	ours_oid = _tmp4_;
#line 193 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp5_ = self->priv->theirs;
#line 193 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp6_ = ggit_ref_get_target ((GgitRef*) _tmp5_);
#line 193 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	theirs_oid = _tmp6_;
#line 195 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp7_ = self->priv->action_interface;
#line 195 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp8_ = self->priv->master;
#line 195 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp9_ = gitg_ref_action_merge_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp7_, (GitgRef*) _tmp8_);
#line 195 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data8_->action = _tmp9_;
#line 197 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp10_ = gitg_ext_user_query_new_full ("Merge has conflicts", "The merge of 'theirs' into 'master' has caused conflicts, would you li" \
"ke to checkout branch 'master' with the merge to your working director" \
"y to resolve the conflicts?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Checkout", GTK_RESPONSE_OK, NULL);
#line 197 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp11_ = _tmp10_;
#line 197 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp12_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp11_, GTK_RESPONSE_OK);
#line 197 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp13_ = _tmp12_;
#line 197 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp13_);
#line 197 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp11_);
#line 206 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp14_ = self->priv->theirs;
#line 206 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_ref_action_merge_merge (_data8_->action, (GitgRef*) _tmp14_, ___lambda21__gasync_ready_callback, block8_data_ref (_data8_));
#line 211 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_run (_data8_->loop);
#line 213 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp15_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 213 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp16_ = _tmp15_;
#line 213 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp17_ = _tmp16_;
#line 213 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp17_);
#line 213 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp19_ = _tmp18_;
#line 213 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq (_tmp19_, 1);
#line 213 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp17_);
#line 214 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp20_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 214 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp21_ = _tmp20_;
#line 214 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp22_ = _tmp21_;
#line 214 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, 0);
#line 214 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp24_ = (GitgSimpleNotification*) _tmp23_;
#line 214 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp25_ = gitg_simple_notification_get_title (_tmp24_);
#line 214 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp26_ = _tmp25_;
#line 214 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp26_, "Merge 'theirs' into 'master'");
#line 214 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp24_);
#line 214 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp22_);
#line 215 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp27_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 215 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp28_ = _tmp27_;
#line 215 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp29_ = _tmp28_;
#line 215 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, 0);
#line 215 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp31_ = (GitgSimpleNotification*) _tmp30_;
#line 215 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp32_ = gitg_simple_notification_get_message (_tmp31_);
#line 215 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp33_ = _tmp32_;
#line 215 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp33_, "Finished merge with conflicts in working directory");
#line 215 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp31_);
#line 215 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp29_);
#line 216 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp34_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 216 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp35_ = _tmp34_;
#line 216 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp36_ = _tmp35_;
#line 216 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, 0);
#line 216 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp38_ = (GitgSimpleNotification*) _tmp37_;
#line 216 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp39_ = gitg_simple_notification_get_status (_tmp38_);
#line 216 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp40_ = _tmp39_;
#line 216 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp40_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 216 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp38_);
#line 216 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp36_);
#line 218 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 219 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 220 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "<<<<<<< ours\n" \
"c file other content\n" \
"=======\n" \
"c file\n" \
">>>>>>> theirs\n");
#line 222 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/ORIG_HEAD", "e1219dd5fbcf8fb5b17bbd3db7a9fa88e98d6651\n");
#line 223 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/MERGE_HEAD", "72af7ccf47852d832b06c7244de8ae9ded639024\n");
#line 224 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/MERGE_MODE", "no-ff\n");
#line 225 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/MERGE_MSG", "Merge branch 'theirs'\n\nConflicts:\n\tc\n");
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (theirs_oid);
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (ours_oid);
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block8_data_unref (_data8_);
#line 186 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data8_ = NULL;
#line 1802 "test-merge-ref.c"
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return _data9_;
#line 1811 "test-merge-ref.c"
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 1820 "test-merge-ref.c"
		GitgTestMergeRef* self;
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		self = _data9_->self;
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_data9_->oids = (_vala_array_free (_data9_->oids, _data9_->oids_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_data9_->messages = (_vala_array_free (_data9_->messages, _data9_->messages_length1, (GDestroyNotify) g_free), NULL);
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (_data9_->action);
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_main_loop_unref0 (_data9_->loop);
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (self);
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_slice_free (Block9Data, _data9_);
#line 1836 "test-merge-ref.c"
	}
}


static void __lambda22_ (Block9Data* _data9_, GObject* obj, GAsyncResult* res) {
	GitgTestMergeRef* self;
	GAsyncResult* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
#line 248 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = _data9_->self;
#line 248 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (res != NULL);
#line 249 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = res;
#line 249 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_ref_action_merge_merge_finish (_data9_->action, _tmp0_);
#line 249 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = _tmp1_;
#line 249 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 250 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_quit (_data9_->loop);
#line 1860 "test-merge-ref.c"
}


static void ___lambda22__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 248 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__lambda22_ (self, source_object, res);
#line 248 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block9_data_unref (self);
#line 1869 "test-merge-ref.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 268 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if ((*length) == (*size)) {
#line 268 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 268 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1880 "test-merge-ref.c"
	}
#line 268 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	(*array)[(*length)++] = value;
#line 268 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	(*array)[*length] = NULL;
#line 1886 "test-merge-ref.c"
}


static GgitOId* _vala_GgitOId_copy (GgitOId* self) {
#line 269 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return g_boxed_copy (ggit_oid_get_type (), self);
#line 1893 "test-merge-ref.c"
}


static gpointer __vala_GgitOId_copy0 (gpointer self) {
#line 269 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return self ? _vala_GgitOId_copy (self) : NULL;
#line 1900 "test-merge-ref.c"
}


static void _vala_array_add2 (GgitOId*** array, int* length, int* size, GgitOId* value) {
#line 269 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if ((*length) == (*size)) {
#line 269 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 269 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		*array = g_renew (GgitOId*, *array, (*size) + 1);
#line 1911 "test-merge-ref.c"
	}
#line 269 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	(*array)[(*length)++] = value;
#line 269 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	(*array)[*length] = NULL;
#line 1917 "test-merge-ref.c"
}


static gint __lambda23_ (Block9Data* _data9_, gsize index, const gchar* message, GgitOId* oid) {
	GitgTestMergeRef* self;
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = _data9_->self;
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_val_if_fail (message != NULL, 0);
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_val_if_fail (oid != NULL, 0);
#line 268 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = message;
#line 268 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 268 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_vala_array_add1 (&_data9_->messages, &_data9_->messages_length1, &_data9_->_messages_size_, _tmp1_);
#line 269 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = oid;
#line 269 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = __vala_GgitOId_copy0 (_tmp2_);
#line 269 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_vala_array_add2 (&_data9_->oids, &_data9_->oids_length1, &_data9_->_oids_size_, _tmp3_);
#line 271 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	result = 0;
#line 271 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return result;
#line 1950 "test-merge-ref.c"
}


static gint ___lambda23__ggit_stash_callback (gsize index, const gchar* message, GgitOId* stash_oid, gpointer self) {
	gint result;
	result = __lambda23_ (self, index, message, stash_oid);
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return result;
#line 1959 "test-merge-ref.c"
}


static void gitg_test_merge_ref_real_test_merge_theirs_dirty_stash (GitgTestMergeRef* self) {
	Block9Data* _data9_;
	GMainLoop* _tmp0_ = NULL;
	GgitOId* ours_oid = NULL;
	GitgCommit* _tmp1_ = NULL;
	GitgCommit* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GgitOId* _tmp4_ = NULL;
	GgitOId* theirs_oid = NULL;
	GitgBranch* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GitgTestRefActionInterface* _tmp7_ = NULL;
	GitgBranch* _tmp8_ = NULL;
	GitgRefActionMerge* _tmp9_ = NULL;
	GitgExtUserQuery* _tmp10_ = NULL;
	GitgExtUserQuery* _tmp11_ = NULL;
	GitgTestApplication* _tmp12_ = NULL;
	GitgTestApplication* _tmp13_ = NULL;
	GitgBranch* _tmp14_ = NULL;
	GeeArrayList* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GeeArrayList* _tmp20_ = NULL;
	GeeArrayList* _tmp21_ = NULL;
	GeeArrayList* _tmp22_ = NULL;
	gpointer _tmp23_ = NULL;
	GitgSimpleNotification* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GeeArrayList* _tmp27_ = NULL;
	GeeArrayList* _tmp28_ = NULL;
	GeeArrayList* _tmp29_ = NULL;
	gpointer _tmp30_ = NULL;
	GitgSimpleNotification* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GeeArrayList* _tmp34_ = NULL;
	GeeArrayList* _tmp35_ = NULL;
	GeeArrayList* _tmp36_ = NULL;
	gpointer _tmp37_ = NULL;
	GitgSimpleNotification* _tmp38_ = NULL;
	GitgSimpleNotificationStatus _tmp39_ = 0;
	GitgSimpleNotificationStatus _tmp40_ = 0;
	gchar** _tmp41_ = NULL;
	GgitOId** _tmp42_ = NULL;
	GitgRepository* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	GgitOId* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	GError * _inner_error_ = NULL;
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data9_ = g_slice_new0 (Block9Data);
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data9_->_ref_count_ = 1;
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data9_->self = g_object_ref (self);
#line 230 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 230 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data9_->loop = _tmp0_;
#line 232 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_write_file ((GitgTestRepository*) self, "b", "b file other content\n");
#line 234 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_test_repository_lookup_commit ((GitgTestRepository*) self, "master");
#line 234 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = _tmp1_;
#line 234 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = ggit_object_get_id ((GgitObject*) _tmp2_);
#line 234 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp4_ = _tmp3_;
#line 234 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp2_);
#line 234 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	ours_oid = _tmp4_;
#line 235 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp5_ = self->priv->theirs;
#line 235 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp6_ = ggit_ref_get_target ((GgitRef*) _tmp5_);
#line 235 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	theirs_oid = _tmp6_;
#line 237 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp7_ = self->priv->action_interface;
#line 237 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp8_ = self->priv->master;
#line 237 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp9_ = gitg_ref_action_merge_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp7_, (GitgRef*) _tmp8_);
#line 237 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data9_->action = _tmp9_;
#line 239 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp10_ = gitg_ext_user_query_new_full ("Unstaged changes", "You appear to have unstaged changes in your working directory. Would y" \
"ou like to stash the changes before the checkout?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Stash changes", GTK_RESPONSE_OK, NULL);
#line 239 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp11_ = _tmp10_;
#line 239 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp12_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp11_, GTK_RESPONSE_OK);
#line 239 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp13_ = _tmp12_;
#line 239 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp13_);
#line 239 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp11_);
#line 248 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp14_ = self->priv->theirs;
#line 248 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_ref_action_merge_merge (_data9_->action, (GitgRef*) _tmp14_, ___lambda22__gasync_ready_callback, block9_data_ref (_data9_));
#line 253 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_run (_data9_->loop);
#line 255 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp15_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 255 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp16_ = _tmp15_;
#line 255 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp17_ = _tmp16_;
#line 255 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp17_);
#line 255 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp19_ = _tmp18_;
#line 255 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq (_tmp19_, 1);
#line 255 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp17_);
#line 256 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp20_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 256 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp21_ = _tmp20_;
#line 256 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp22_ = _tmp21_;
#line 256 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, 0);
#line 256 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp24_ = (GitgSimpleNotification*) _tmp23_;
#line 256 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp25_ = gitg_simple_notification_get_title (_tmp24_);
#line 256 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp26_ = _tmp25_;
#line 256 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp26_, "Merge 'theirs' into 'master'");
#line 256 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp24_);
#line 256 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp22_);
#line 257 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp27_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 257 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp28_ = _tmp27_;
#line 257 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp29_ = _tmp28_;
#line 257 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, 0);
#line 257 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp31_ = (GitgSimpleNotification*) _tmp30_;
#line 257 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp32_ = gitg_simple_notification_get_message (_tmp31_);
#line 257 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp33_ = _tmp32_;
#line 257 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp33_, "Successfully merged 'theirs' into 'master'");
#line 257 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp31_);
#line 257 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp29_);
#line 258 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp34_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 258 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp35_ = _tmp34_;
#line 258 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp36_ = _tmp35_;
#line 258 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, 0);
#line 258 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp38_ = (GitgSimpleNotification*) _tmp37_;
#line 258 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp39_ = gitg_simple_notification_get_status (_tmp38_);
#line 258 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp40_ = _tmp39_;
#line 258 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp40_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 258 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp38_);
#line 258 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp36_);
#line 260 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 261 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 262 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "c file\n");
#line 264 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp41_ = g_new0 (gchar*, 0 + 1);
#line 264 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data9_->messages = _tmp41_;
#line 264 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data9_->messages_length1 = 0;
#line 264 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data9_->_messages_size_ = _data9_->messages_length1;
#line 265 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp42_ = g_new0 (GgitOId*, 0 + 1);
#line 265 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data9_->oids = _tmp42_;
#line 265 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data9_->oids_length1 = 0;
#line 265 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data9_->_oids_size_ = _data9_->oids_length1;
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp43_ = ((GitgTestRepository*) self)->d_repository;
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	ggit_repository_stash_foreach ((GgitRepository*) _tmp43_, ___lambda23__ggit_stash_callback, _data9_, &_inner_error_);
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		__vala_GgitOId_free0 (theirs_oid);
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		__vala_GgitOId_free0 (ours_oid);
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		block9_data_unref (_data9_);
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_data9_ = NULL;
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_clear_error (&_inner_error_);
#line 267 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		return;
#line 2188 "test-merge-ref.c"
	}
#line 274 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_merge_ref_assert_merged (self, ours_oid, theirs_oid, "master");
#line 276 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq (_data9_->messages_length1, 1);
#line 277 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp44_ = _data9_->messages[0];
#line 277 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp44_, "On master: WIP on HEAD: 50ac9b commit b");
#line 278 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp45_ = _data9_->oids[0];
#line 278 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp46_ = ggit_oid_to_string (_tmp45_);
#line 278 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp47_ = _tmp46_;
#line 278 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp47_, "aaf63a72d8c0d5799ccfcf1623daef228968382f");
#line 278 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_free0 (_tmp47_);
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (theirs_oid);
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (ours_oid);
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block9_data_unref (_data9_);
#line 228 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data9_ = NULL;
#line 2216 "test-merge-ref.c"
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return _data10_;
#line 2225 "test-merge-ref.c"
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 2234 "test-merge-ref.c"
		GitgTestMergeRef* self;
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		self = _data10_->self;
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (_data10_->action);
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_main_loop_unref0 (_data10_->loop);
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (self);
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_slice_free (Block10Data, _data10_);
#line 2246 "test-merge-ref.c"
	}
}


static void __lambda24_ (Block10Data* _data10_, GObject* obj, GAsyncResult* res) {
	GitgTestMergeRef* self;
	GAsyncResult* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
#line 313 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = _data10_->self;
#line 313 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (res != NULL);
#line 314 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = res;
#line 314 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_ref_action_merge_merge_finish (_data10_->action, _tmp0_);
#line 314 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = _tmp1_;
#line 314 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 315 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_quit (_data10_->loop);
#line 2270 "test-merge-ref.c"
}


static void ___lambda24__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 313 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__lambda24_ (self, source_object, res);
#line 313 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block10_data_unref (self);
#line 2279 "test-merge-ref.c"
}


static void gitg_test_merge_ref_real_test_merge_theirs_not_master_conflicts_checkout (GitgTestMergeRef* self) {
	Block10Data* _data10_;
	GMainLoop* _tmp0_ = NULL;
	GitgBranch* _tmp1_ = NULL;
	GgitOId* ours_oid = NULL;
	GitgBranch* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GgitOId* theirs_oid = NULL;
	GitgBranch* _tmp4_ = NULL;
	GgitOId* _tmp5_ = NULL;
	GitgTestRefActionInterface* _tmp6_ = NULL;
	GitgBranch* _tmp7_ = NULL;
	GitgRefActionMerge* _tmp8_ = NULL;
	GitgExtUserQuery* _tmp9_ = NULL;
	GitgExtUserQuery* _tmp10_ = NULL;
	GitgTestApplication* _tmp11_ = NULL;
	GitgTestApplication* _tmp12_ = NULL;
	GitgExtUserQuery* _tmp13_ = NULL;
	GitgExtUserQuery* _tmp14_ = NULL;
	GitgTestApplication* _tmp15_ = NULL;
	GitgTestApplication* _tmp16_ = NULL;
	GitgBranch* _tmp17_ = NULL;
	GeeArrayList* _tmp18_ = NULL;
	GeeArrayList* _tmp19_ = NULL;
	GeeArrayList* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	GeeArrayList* _tmp23_ = NULL;
	GeeArrayList* _tmp24_ = NULL;
	GeeArrayList* _tmp25_ = NULL;
	gpointer _tmp26_ = NULL;
	GitgSimpleNotification* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GeeArrayList* _tmp30_ = NULL;
	GeeArrayList* _tmp31_ = NULL;
	GeeArrayList* _tmp32_ = NULL;
	gpointer _tmp33_ = NULL;
	GitgSimpleNotification* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	GeeArrayList* _tmp37_ = NULL;
	GeeArrayList* _tmp38_ = NULL;
	GeeArrayList* _tmp39_ = NULL;
	gpointer _tmp40_ = NULL;
	GitgSimpleNotification* _tmp41_ = NULL;
	GitgSimpleNotificationStatus _tmp42_ = 0;
	GitgSimpleNotificationStatus _tmp43_ = 0;
	GeeArrayList* _tmp44_ = NULL;
	GeeArrayList* _tmp45_ = NULL;
	GeeArrayList* _tmp46_ = NULL;
	gpointer _tmp47_ = NULL;
	GitgSimpleNotification* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	GeeArrayList* _tmp51_ = NULL;
	GeeArrayList* _tmp52_ = NULL;
	GeeArrayList* _tmp53_ = NULL;
	gpointer _tmp54_ = NULL;
	GitgSimpleNotification* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	GeeArrayList* _tmp58_ = NULL;
	GeeArrayList* _tmp59_ = NULL;
	GeeArrayList* _tmp60_ = NULL;
	gpointer _tmp61_ = NULL;
	GitgSimpleNotification* _tmp62_ = NULL;
	GitgSimpleNotificationStatus _tmp63_ = 0;
	GitgSimpleNotificationStatus _tmp64_ = 0;
	GitgBranch* _tmp65_ = NULL;
	GitgBranch* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data10_ = g_slice_new0 (Block10Data);
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data10_->_ref_count_ = 1;
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data10_->self = g_object_ref (self);
#line 283 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 283 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data10_->loop = _tmp0_;
#line 285 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "not_master");
#line 286 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file other content\n", NULL);
#line 287 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "not_master");
#line 287 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->not_master);
#line 287 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self->priv->not_master = _tmp1_;
#line 288 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "master");
#line 290 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = self->priv->not_master;
#line 290 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = ggit_ref_get_target ((GgitRef*) _tmp2_);
#line 290 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	ours_oid = _tmp3_;
#line 291 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp4_ = self->priv->theirs;
#line 291 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp5_ = ggit_ref_get_target ((GgitRef*) _tmp4_);
#line 291 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	theirs_oid = _tmp5_;
#line 293 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp6_ = self->priv->action_interface;
#line 293 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp7_ = self->priv->not_master;
#line 293 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp8_ = gitg_ref_action_merge_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp6_, (GitgRef*) _tmp7_);
#line 293 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data10_->action = _tmp8_;
#line 295 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp9_ = gitg_ext_user_query_new_full ("Merge has conflicts", "The merge of 'theirs' into 'not_master' has caused conflicts, would yo" \
"u like to checkout the merge to your working directory to resolve the " \
"conflicts?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Checkout", GTK_RESPONSE_OK, NULL);
#line 295 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp10_ = _tmp9_;
#line 295 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp11_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp10_, GTK_RESPONSE_OK);
#line 295 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp12_ = _tmp11_;
#line 295 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp12_);
#line 295 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp10_);
#line 304 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp13_ = gitg_ext_user_query_new_full ("Unstaged changes", "You appear to have unstaged changes in your working directory. Would y" \
"ou like to stash the changes before the checkout?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Stash changes", GTK_RESPONSE_OK, NULL);
#line 304 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp14_ = _tmp13_;
#line 304 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp15_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp14_, GTK_RESPONSE_OK);
#line 304 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp16_ = _tmp15_;
#line 304 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp16_);
#line 304 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp14_);
#line 313 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp17_ = self->priv->theirs;
#line 313 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_ref_action_merge_merge (_data10_->action, (GitgRef*) _tmp17_, ___lambda24__gasync_ready_callback, block10_data_ref (_data10_));
#line 318 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_run (_data10_->loop);
#line 320 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp18_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 320 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp19_ = _tmp18_;
#line 320 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp20_ = _tmp19_;
#line 320 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp21_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp20_);
#line 320 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp22_ = _tmp21_;
#line 320 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq (_tmp22_, 2);
#line 320 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp20_);
#line 322 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp23_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 322 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp24_ = _tmp23_;
#line 322 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp25_ = _tmp24_;
#line 322 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
#line 322 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp27_ = (GitgSimpleNotification*) _tmp26_;
#line 322 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp28_ = gitg_simple_notification_get_title (_tmp27_);
#line 322 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp29_ = _tmp28_;
#line 322 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp29_, "Merge 'theirs' into 'not_master'");
#line 322 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp27_);
#line 322 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp25_);
#line 323 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp30_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 323 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp31_ = _tmp30_;
#line 323 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp32_ = _tmp31_;
#line 323 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, 0);
#line 323 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp34_ = (GitgSimpleNotification*) _tmp33_;
#line 323 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp35_ = gitg_simple_notification_get_message (_tmp34_);
#line 323 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp36_ = _tmp35_;
#line 323 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp36_, "Finished merge with conflicts in working directory");
#line 323 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp34_);
#line 323 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp32_);
#line 324 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp37_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 324 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp38_ = _tmp37_;
#line 324 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp39_ = _tmp38_;
#line 324 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, 0);
#line 324 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp41_ = (GitgSimpleNotification*) _tmp40_;
#line 324 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp42_ = gitg_simple_notification_get_status (_tmp41_);
#line 324 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp43_ = _tmp42_;
#line 324 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp43_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 324 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp41_);
#line 324 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp39_);
#line 326 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp44_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 326 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp45_ = _tmp44_;
#line 326 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp46_ = _tmp45_;
#line 326 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, 1);
#line 326 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp48_ = (GitgSimpleNotification*) _tmp47_;
#line 326 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp49_ = gitg_simple_notification_get_title (_tmp48_);
#line 326 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp50_ = _tmp49_;
#line 326 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp50_, "Checkout 'not_master'");
#line 326 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp48_);
#line 326 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp46_);
#line 327 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp51_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 327 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp52_ = _tmp51_;
#line 327 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp53_ = _tmp52_;
#line 327 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, 1);
#line 327 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp55_ = (GitgSimpleNotification*) _tmp54_;
#line 327 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp56_ = gitg_simple_notification_get_message (_tmp55_);
#line 327 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp57_ = _tmp56_;
#line 327 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp57_, "Successfully checked out branch to working directory");
#line 327 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp55_);
#line 327 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp53_);
#line 328 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp58_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 328 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp59_ = _tmp58_;
#line 328 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp60_ = _tmp59_;
#line 328 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp61_ = gee_abstract_list_get ((GeeAbstractList*) _tmp60_, 1);
#line 328 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp62_ = (GitgSimpleNotification*) _tmp61_;
#line 328 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp63_ = gitg_simple_notification_get_status (_tmp62_);
#line 328 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp64_ = _tmp63_;
#line 328 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp64_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 328 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp62_);
#line 328 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp60_);
#line 330 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp65_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "HEAD");
#line 330 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp66_ = _tmp65_;
#line 330 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp67_ = ggit_ref_get_name ((GgitRef*) _tmp66_);
#line 330 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp67_, "refs/heads/not_master");
#line 330 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp66_);
#line 332 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 333 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 334 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "<<<<<<< ours\n" \
"c file other content\n" \
"=======\n" \
"c file\n" \
">>>>>>> theirs\n");
#line 336 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/ORIG_HEAD", "e1219dd5fbcf8fb5b17bbd3db7a9fa88e98d6651\n");
#line 337 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/MERGE_HEAD", "72af7ccf47852d832b06c7244de8ae9ded639024\n");
#line 338 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/MERGE_MODE", "no-ff\n");
#line 339 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/MERGE_MSG", "Merge branch 'theirs'\n\nConflicts:\n\tc\n");
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (theirs_oid);
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (ours_oid);
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block10_data_unref (_data10_);
#line 281 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data10_ = NULL;
#line 2593 "test-merge-ref.c"
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return _data11_;
#line 2602 "test-merge-ref.c"
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 2611 "test-merge-ref.c"
		GitgTestMergeRef* self;
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		self = _data11_->self;
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_data11_->oids = (_vala_array_free (_data11_->oids, _data11_->oids_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_data11_->messages = (_vala_array_free (_data11_->messages, _data11_->messages_length1, (GDestroyNotify) g_free), NULL);
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (_data11_->action);
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_main_loop_unref0 (_data11_->loop);
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (self);
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_slice_free (Block11Data, _data11_);
#line 2627 "test-merge-ref.c"
	}
}


static void __lambda25_ (Block11Data* _data11_, GObject* obj, GAsyncResult* res) {
	GitgTestMergeRef* self;
	GAsyncResult* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
#line 376 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = _data11_->self;
#line 376 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (res != NULL);
#line 377 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = res;
#line 377 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_ref_action_merge_merge_finish (_data11_->action, _tmp0_);
#line 377 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = _tmp1_;
#line 377 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 378 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_quit (_data11_->loop);
#line 2651 "test-merge-ref.c"
}


static void ___lambda25__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 376 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__lambda25_ (self, source_object, res);
#line 376 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block11_data_unref (self);
#line 2660 "test-merge-ref.c"
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
#line 408 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if ((*length) == (*size)) {
#line 408 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 408 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2671 "test-merge-ref.c"
	}
#line 408 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	(*array)[(*length)++] = value;
#line 408 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	(*array)[*length] = NULL;
#line 2677 "test-merge-ref.c"
}


static void _vala_array_add4 (GgitOId*** array, int* length, int* size, GgitOId* value) {
#line 409 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if ((*length) == (*size)) {
#line 409 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 409 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		*array = g_renew (GgitOId*, *array, (*size) + 1);
#line 2688 "test-merge-ref.c"
	}
#line 409 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	(*array)[(*length)++] = value;
#line 409 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	(*array)[*length] = NULL;
#line 2694 "test-merge-ref.c"
}


static gint __lambda26_ (Block11Data* _data11_, gsize index, const gchar* message, GgitOId* oid) {
	GitgTestMergeRef* self;
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = _data11_->self;
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_val_if_fail (message != NULL, 0);
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_val_if_fail (oid != NULL, 0);
#line 408 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = message;
#line 408 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 408 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_vala_array_add3 (&_data11_->messages, &_data11_->messages_length1, &_data11_->_messages_size_, _tmp1_);
#line 409 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = oid;
#line 409 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = __vala_GgitOId_copy0 (_tmp2_);
#line 409 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_vala_array_add4 (&_data11_->oids, &_data11_->oids_length1, &_data11_->_oids_size_, _tmp3_);
#line 411 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	result = 0;
#line 411 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return result;
#line 2727 "test-merge-ref.c"
}


static gint ___lambda26__ggit_stash_callback (gsize index, const gchar* message, GgitOId* stash_oid, gpointer self) {
	gint result;
	result = __lambda26_ (self, index, message, stash_oid);
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return result;
#line 2736 "test-merge-ref.c"
}


static void gitg_test_merge_ref_real_test_merge_theirs_not_master_conflicts_checkout_dirty (GitgTestMergeRef* self) {
	Block11Data* _data11_;
	GMainLoop* _tmp0_ = NULL;
	GitgBranch* _tmp1_ = NULL;
	GgitOId* ours_oid = NULL;
	GitgBranch* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GgitOId* theirs_oid = NULL;
	GitgBranch* _tmp4_ = NULL;
	GgitOId* _tmp5_ = NULL;
	GitgTestRefActionInterface* _tmp6_ = NULL;
	GitgBranch* _tmp7_ = NULL;
	GitgRefActionMerge* _tmp8_ = NULL;
	GitgExtUserQuery* _tmp9_ = NULL;
	GitgExtUserQuery* _tmp10_ = NULL;
	GitgTestApplication* _tmp11_ = NULL;
	GitgTestApplication* _tmp12_ = NULL;
	GitgExtUserQuery* _tmp13_ = NULL;
	GitgExtUserQuery* _tmp14_ = NULL;
	GitgTestApplication* _tmp15_ = NULL;
	GitgTestApplication* _tmp16_ = NULL;
	GitgBranch* _tmp17_ = NULL;
	GeeArrayList* _tmp18_ = NULL;
	GeeArrayList* _tmp19_ = NULL;
	GeeArrayList* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	GeeArrayList* _tmp23_ = NULL;
	GeeArrayList* _tmp24_ = NULL;
	GeeArrayList* _tmp25_ = NULL;
	gpointer _tmp26_ = NULL;
	GitgSimpleNotification* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GeeArrayList* _tmp30_ = NULL;
	GeeArrayList* _tmp31_ = NULL;
	GeeArrayList* _tmp32_ = NULL;
	gpointer _tmp33_ = NULL;
	GitgSimpleNotification* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	GeeArrayList* _tmp37_ = NULL;
	GeeArrayList* _tmp38_ = NULL;
	GeeArrayList* _tmp39_ = NULL;
	gpointer _tmp40_ = NULL;
	GitgSimpleNotification* _tmp41_ = NULL;
	GitgSimpleNotificationStatus _tmp42_ = 0;
	GitgSimpleNotificationStatus _tmp43_ = 0;
	GeeArrayList* _tmp44_ = NULL;
	GeeArrayList* _tmp45_ = NULL;
	GeeArrayList* _tmp46_ = NULL;
	gpointer _tmp47_ = NULL;
	GitgSimpleNotification* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	GeeArrayList* _tmp51_ = NULL;
	GeeArrayList* _tmp52_ = NULL;
	GeeArrayList* _tmp53_ = NULL;
	gpointer _tmp54_ = NULL;
	GitgSimpleNotification* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	GeeArrayList* _tmp58_ = NULL;
	GeeArrayList* _tmp59_ = NULL;
	GeeArrayList* _tmp60_ = NULL;
	gpointer _tmp61_ = NULL;
	GitgSimpleNotification* _tmp62_ = NULL;
	GitgSimpleNotificationStatus _tmp63_ = 0;
	GitgSimpleNotificationStatus _tmp64_ = 0;
	GitgBranch* _tmp65_ = NULL;
	GitgBranch* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	gchar** _tmp68_ = NULL;
	GgitOId** _tmp69_ = NULL;
	GitgRepository* _tmp70_ = NULL;
	const gchar* _tmp71_ = NULL;
	GgitOId* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
	gchar* _tmp74_ = NULL;
	GError * _inner_error_ = NULL;
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data11_ = g_slice_new0 (Block11Data);
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data11_->_ref_count_ = 1;
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data11_->self = g_object_ref (self);
#line 344 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 344 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data11_->loop = _tmp0_;
#line 346 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "not_master");
#line 347 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file other content\n", NULL);
#line 348 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "not_master");
#line 348 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->not_master);
#line 348 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self->priv->not_master = _tmp1_;
#line 349 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "master");
#line 351 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_write_file ((GitgTestRepository*) self, "b", "b file other content\n");
#line 353 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = self->priv->not_master;
#line 353 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = ggit_ref_get_target ((GgitRef*) _tmp2_);
#line 353 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	ours_oid = _tmp3_;
#line 354 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp4_ = self->priv->theirs;
#line 354 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp5_ = ggit_ref_get_target ((GgitRef*) _tmp4_);
#line 354 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	theirs_oid = _tmp5_;
#line 356 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp6_ = self->priv->action_interface;
#line 356 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp7_ = self->priv->not_master;
#line 356 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp8_ = gitg_ref_action_merge_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp6_, (GitgRef*) _tmp7_);
#line 356 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data11_->action = _tmp8_;
#line 358 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp9_ = gitg_ext_user_query_new_full ("Merge has conflicts", "The merge of 'theirs' into 'not_master' has caused conflicts, would yo" \
"u like to checkout the merge to your working directory to resolve the " \
"conflicts?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Checkout", GTK_RESPONSE_OK, NULL);
#line 358 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp10_ = _tmp9_;
#line 358 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp11_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp10_, GTK_RESPONSE_OK);
#line 358 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp12_ = _tmp11_;
#line 358 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp12_);
#line 358 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp10_);
#line 367 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp13_ = gitg_ext_user_query_new_full ("Unstaged changes", "You appear to have unstaged changes in your working directory. Would y" \
"ou like to stash the changes before the checkout?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Stash changes", GTK_RESPONSE_OK, NULL);
#line 367 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp14_ = _tmp13_;
#line 367 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp15_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp14_, GTK_RESPONSE_OK);
#line 367 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp16_ = _tmp15_;
#line 367 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp16_);
#line 367 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp14_);
#line 376 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp17_ = self->priv->theirs;
#line 376 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_ref_action_merge_merge (_data11_->action, (GitgRef*) _tmp17_, ___lambda25__gasync_ready_callback, block11_data_ref (_data11_));
#line 381 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_run (_data11_->loop);
#line 383 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp18_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 383 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp19_ = _tmp18_;
#line 383 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp20_ = _tmp19_;
#line 383 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp21_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp20_);
#line 383 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp22_ = _tmp21_;
#line 383 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq (_tmp22_, 2);
#line 383 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp20_);
#line 385 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp23_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 385 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp24_ = _tmp23_;
#line 385 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp25_ = _tmp24_;
#line 385 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
#line 385 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp27_ = (GitgSimpleNotification*) _tmp26_;
#line 385 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp28_ = gitg_simple_notification_get_title (_tmp27_);
#line 385 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp29_ = _tmp28_;
#line 385 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp29_, "Merge 'theirs' into 'not_master'");
#line 385 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp27_);
#line 385 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp25_);
#line 386 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp30_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 386 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp31_ = _tmp30_;
#line 386 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp32_ = _tmp31_;
#line 386 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, 0);
#line 386 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp34_ = (GitgSimpleNotification*) _tmp33_;
#line 386 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp35_ = gitg_simple_notification_get_message (_tmp34_);
#line 386 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp36_ = _tmp35_;
#line 386 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp36_, "Finished merge with conflicts in working directory");
#line 386 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp34_);
#line 386 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp32_);
#line 387 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp37_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 387 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp38_ = _tmp37_;
#line 387 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp39_ = _tmp38_;
#line 387 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, 0);
#line 387 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp41_ = (GitgSimpleNotification*) _tmp40_;
#line 387 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp42_ = gitg_simple_notification_get_status (_tmp41_);
#line 387 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp43_ = _tmp42_;
#line 387 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp43_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 387 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp41_);
#line 387 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp39_);
#line 389 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp44_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 389 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp45_ = _tmp44_;
#line 389 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp46_ = _tmp45_;
#line 389 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, 1);
#line 389 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp48_ = (GitgSimpleNotification*) _tmp47_;
#line 389 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp49_ = gitg_simple_notification_get_title (_tmp48_);
#line 389 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp50_ = _tmp49_;
#line 389 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp50_, "Checkout 'not_master'");
#line 389 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp48_);
#line 389 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp46_);
#line 390 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp51_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 390 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp52_ = _tmp51_;
#line 390 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp53_ = _tmp52_;
#line 390 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, 1);
#line 390 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp55_ = (GitgSimpleNotification*) _tmp54_;
#line 390 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp56_ = gitg_simple_notification_get_message (_tmp55_);
#line 390 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp57_ = _tmp56_;
#line 390 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp57_, "Successfully checked out branch to working directory");
#line 390 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp55_);
#line 390 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp53_);
#line 391 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp58_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 391 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp59_ = _tmp58_;
#line 391 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp60_ = _tmp59_;
#line 391 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp61_ = gee_abstract_list_get ((GeeAbstractList*) _tmp60_, 1);
#line 391 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp62_ = (GitgSimpleNotification*) _tmp61_;
#line 391 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp63_ = gitg_simple_notification_get_status (_tmp62_);
#line 391 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp64_ = _tmp63_;
#line 391 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp64_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_SUCCESS);
#line 391 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp62_);
#line 391 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp60_);
#line 393 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp65_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "HEAD");
#line 393 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp66_ = _tmp65_;
#line 393 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp67_ = ggit_ref_get_name ((GgitRef*) _tmp66_);
#line 393 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp67_, "refs/heads/not_master");
#line 393 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp66_);
#line 395 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 396 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file\n");
#line 397 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "c", "<<<<<<< ours\n" \
"c file other content\n" \
"=======\n" \
"c file\n" \
">>>>>>> theirs\n");
#line 399 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/ORIG_HEAD", "e1219dd5fbcf8fb5b17bbd3db7a9fa88e98d6651\n");
#line 400 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/MERGE_HEAD", "72af7ccf47852d832b06c7244de8ae9ded639024\n");
#line 401 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/MERGE_MODE", "no-ff\n");
#line 402 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, ".git/MERGE_MSG", "Merge branch 'theirs'\n\nConflicts:\n\tc\n");
#line 404 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp68_ = g_new0 (gchar*, 0 + 1);
#line 404 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data11_->messages = _tmp68_;
#line 404 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data11_->messages_length1 = 0;
#line 404 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data11_->_messages_size_ = _data11_->messages_length1;
#line 405 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp69_ = g_new0 (GgitOId*, 0 + 1);
#line 405 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data11_->oids = _tmp69_;
#line 405 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data11_->oids_length1 = 0;
#line 405 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data11_->_oids_size_ = _data11_->oids_length1;
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp70_ = ((GitgTestRepository*) self)->d_repository;
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	ggit_repository_stash_foreach ((GgitRepository*) _tmp70_, ___lambda26__ggit_stash_callback, _data11_, &_inner_error_);
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		__vala_GgitOId_free0 (theirs_oid);
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		__vala_GgitOId_free0 (ours_oid);
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		block11_data_unref (_data11_);
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_data11_ = NULL;
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_clear_error (&_inner_error_);
#line 407 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		return;
#line 3088 "test-merge-ref.c"
	}
#line 414 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq (_data11_->messages_length1, 1);
#line 415 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp71_ = _data11_->messages[0];
#line 415 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp71_, "On master: WIP on HEAD");
#line 416 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp72_ = _data11_->oids[0];
#line 416 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp73_ = ggit_oid_to_string (_tmp72_);
#line 416 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp74_ = _tmp73_;
#line 416 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp74_, "147b7b7b6ad2f9c90f4c93f3bfda78c78ec2dcde");
#line 416 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_free0 (_tmp74_);
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (theirs_oid);
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (ours_oid);
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block11_data_unref (_data11_);
#line 342 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data11_ = NULL;
#line 3114 "test-merge-ref.c"
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_atomic_int_inc (&_data12_->_ref_count_);
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return _data12_;
#line 3123 "test-merge-ref.c"
}


static void block12_data_unref (void * _userdata_) {
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
#line 3132 "test-merge-ref.c"
		GitgTestMergeRef* self;
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		self = _data12_->self;
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (_data12_->action);
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_main_loop_unref0 (_data12_->loop);
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_g_object_unref0 (self);
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_slice_free (Block12Data, _data12_);
#line 3144 "test-merge-ref.c"
	}
}


static void __lambda27_ (Block12Data* _data12_, GObject* obj, GAsyncResult* res) {
	GitgTestMergeRef* self;
	GAsyncResult* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
#line 453 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = _data12_->self;
#line 453 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_if_fail (res != NULL);
#line 454 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = res;
#line 454 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_ref_action_merge_merge_finish (_data12_->action, _tmp0_);
#line 454 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = _tmp1_;
#line 454 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 455 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_quit (_data12_->loop);
#line 3168 "test-merge-ref.c"
}


static void ___lambda27__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 453 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__lambda27_ (self, source_object, res);
#line 453 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block12_data_unref (self);
#line 3177 "test-merge-ref.c"
}


static gint __lambda28_ (GitgTestMergeRef* self, gsize index, const gchar* message, GgitOId* oid) {
	gint result = 0;
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_val_if_fail (message != NULL, 0);
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_return_val_if_fail (oid != NULL, 0);
#line 478 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_vala_assert (FALSE, "false");
#line 479 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	result = 0;
#line 479 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return result;
#line 3193 "test-merge-ref.c"
}


static gint ___lambda28__ggit_stash_callback (gsize index, const gchar* message, GgitOId* stash_oid, gpointer self) {
	gint result;
	result = __lambda28_ ((GitgTestMergeRef*) self, index, message, stash_oid);
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	return result;
#line 3202 "test-merge-ref.c"
}


static void gitg_test_merge_ref_real_test_merge_theirs_not_master_conflicts_checkout_dirty_no_stash (GitgTestMergeRef* self) {
	Block12Data* _data12_;
	GMainLoop* _tmp0_ = NULL;
	GitgBranch* _tmp1_ = NULL;
	GgitOId* ours_oid = NULL;
	GitgBranch* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GgitOId* theirs_oid = NULL;
	GitgBranch* _tmp4_ = NULL;
	GgitOId* _tmp5_ = NULL;
	GitgTestRefActionInterface* _tmp6_ = NULL;
	GitgBranch* _tmp7_ = NULL;
	GitgRefActionMerge* _tmp8_ = NULL;
	GitgExtUserQuery* _tmp9_ = NULL;
	GitgExtUserQuery* _tmp10_ = NULL;
	GitgTestApplication* _tmp11_ = NULL;
	GitgTestApplication* _tmp12_ = NULL;
	GitgExtUserQuery* _tmp13_ = NULL;
	GitgExtUserQuery* _tmp14_ = NULL;
	GitgTestApplication* _tmp15_ = NULL;
	GitgTestApplication* _tmp16_ = NULL;
	GitgBranch* _tmp17_ = NULL;
	GeeArrayList* _tmp18_ = NULL;
	GeeArrayList* _tmp19_ = NULL;
	GeeArrayList* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	GeeArrayList* _tmp23_ = NULL;
	GeeArrayList* _tmp24_ = NULL;
	GeeArrayList* _tmp25_ = NULL;
	gpointer _tmp26_ = NULL;
	GitgSimpleNotification* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GeeArrayList* _tmp30_ = NULL;
	GeeArrayList* _tmp31_ = NULL;
	GeeArrayList* _tmp32_ = NULL;
	gpointer _tmp33_ = NULL;
	GitgSimpleNotification* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	GeeArrayList* _tmp37_ = NULL;
	GeeArrayList* _tmp38_ = NULL;
	GeeArrayList* _tmp39_ = NULL;
	gpointer _tmp40_ = NULL;
	GitgSimpleNotification* _tmp41_ = NULL;
	GitgSimpleNotificationStatus _tmp42_ = 0;
	GitgSimpleNotificationStatus _tmp43_ = 0;
	GitgBranch* _tmp44_ = NULL;
	GitgBranch* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	GitgRepository* _tmp52_ = NULL;
	GError * _inner_error_ = NULL;
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data12_ = g_slice_new0 (Block12Data);
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data12_->_ref_count_ = 1;
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data12_->self = g_object_ref (self);
#line 421 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 421 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data12_->loop = _tmp0_;
#line 423 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "not_master");
#line 424 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "c", "c file other content\n", NULL);
#line 425 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp1_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "not_master");
#line 425 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->not_master);
#line 425 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self->priv->not_master = _tmp1_;
#line 426 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_checkout_branch ((GitgTestRepository*) self, "master");
#line 428 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_write_file ((GitgTestRepository*) self, "b", "b file other content\n");
#line 430 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp2_ = self->priv->not_master;
#line 430 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp3_ = ggit_ref_get_target ((GgitRef*) _tmp2_);
#line 430 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	ours_oid = _tmp3_;
#line 431 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp4_ = self->priv->theirs;
#line 431 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp5_ = ggit_ref_get_target ((GgitRef*) _tmp4_);
#line 431 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	theirs_oid = _tmp5_;
#line 433 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp6_ = self->priv->action_interface;
#line 433 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp7_ = self->priv->not_master;
#line 433 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp8_ = gitg_ref_action_merge_new ((GitgExtApplication*) self, (GitgExtRefActionInterface*) _tmp6_, (GitgRef*) _tmp7_);
#line 433 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data12_->action = _tmp8_;
#line 435 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp9_ = gitg_ext_user_query_new_full ("Merge has conflicts", "The merge of 'theirs' into 'not_master' has caused conflicts, would yo" \
"u like to checkout the merge to your working directory to resolve the " \
"conflicts?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Checkout", GTK_RESPONSE_OK, NULL);
#line 435 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp10_ = _tmp9_;
#line 435 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp11_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp10_, GTK_RESPONSE_OK);
#line 435 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp12_ = _tmp11_;
#line 435 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp12_);
#line 435 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp10_);
#line 444 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp13_ = gitg_ext_user_query_new_full ("Unstaged changes", "You appear to have unstaged changes in your working directory. Would y" \
"ou like to stash the changes before the checkout?", GTK_MESSAGE_QUESTION, "Cancel", GTK_RESPONSE_CANCEL, "Stash changes", GTK_RESPONSE_OK, NULL);
#line 444 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp14_ = _tmp13_;
#line 444 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp15_ = gitg_test_application_expect_user_query ((GitgTestApplication*) self, _tmp14_, GTK_RESPONSE_CANCEL);
#line 444 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp16_ = _tmp15_;
#line 444 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp16_);
#line 444 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp14_);
#line 453 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp17_ = self->priv->theirs;
#line 453 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_ref_action_merge_merge (_data12_->action, (GitgRef*) _tmp17_, ___lambda27__gasync_ready_callback, block12_data_ref (_data12_));
#line 458 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_main_loop_run (_data12_->loop);
#line 460 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp18_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 460 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp19_ = _tmp18_;
#line 460 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp20_ = _tmp19_;
#line 460 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp21_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp20_);
#line 460 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp22_ = _tmp21_;
#line 460 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq (_tmp22_, 1);
#line 460 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp20_);
#line 462 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp23_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 462 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp24_ = _tmp23_;
#line 462 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp25_ = _tmp24_;
#line 462 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
#line 462 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp27_ = (GitgSimpleNotification*) _tmp26_;
#line 462 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp28_ = gitg_simple_notification_get_title (_tmp27_);
#line 462 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp29_ = _tmp28_;
#line 462 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp29_, "Merge 'theirs' into 'not_master'");
#line 462 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp27_);
#line 462 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp25_);
#line 463 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp30_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 463 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp31_ = _tmp30_;
#line 463 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp32_ = _tmp31_;
#line 463 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, 0);
#line 463 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp34_ = (GitgSimpleNotification*) _tmp33_;
#line 463 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp35_ = gitg_simple_notification_get_message (_tmp34_);
#line 463 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp36_ = _tmp35_;
#line 463 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp36_, "Failed with conflicts");
#line 463 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp34_);
#line 463 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp32_);
#line 464 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp37_ = gitg_test_application_get_simple_notifications ((GitgTestApplication*) self);
#line 464 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp38_ = _tmp37_;
#line 464 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp39_ = _tmp38_;
#line 464 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, 0);
#line 464 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp41_ = (GitgSimpleNotification*) _tmp40_;
#line 464 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp42_ = gitg_simple_notification_get_status (_tmp41_);
#line 464 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp43_ = _tmp42_;
#line 464 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_inteq ((gint) _tmp43_, (gint) GITG_SIMPLE_NOTIFICATION_STATUS_ERROR);
#line 464 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp41_);
#line 464 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp39_);
#line 466 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp44_ = gitg_test_repository_lookup_branch ((GitgTestRepository*) self, "HEAD");
#line 466 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp45_ = _tmp44_;
#line 466 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp46_ = ggit_ref_get_name ((GgitRef*) _tmp45_);
#line 466 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_assert_assert_streq (_tmp46_, "refs/heads/master");
#line 466 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (_tmp45_);
#line 468 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "a", "a file\n");
#line 469 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_repository_assert_file_contents ((GitgTestRepository*) self, "b", "b file other content\n");
#line 470 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp47_ = gitg_test_repository_file_exists ((GitgTestRepository*) self, "c");
#line 470 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_vala_assert (!_tmp47_, "!file_exists(\"c\")");
#line 472 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp48_ = gitg_test_repository_file_exists ((GitgTestRepository*) self, ".git/ORIG_HEAD");
#line 472 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_vala_assert (!_tmp48_, "!file_exists(\".git/ORIG_HEAD\")");
#line 473 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp49_ = gitg_test_repository_file_exists ((GitgTestRepository*) self, ".git/MERGE_HEAD");
#line 473 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_vala_assert (!_tmp49_, "!file_exists(\".git/MERGE_HEAD\")");
#line 474 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp50_ = gitg_test_repository_file_exists ((GitgTestRepository*) self, ".git/MERGE_MODE");
#line 474 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_vala_assert (!_tmp50_, "!file_exists(\".git/MERGE_MODE\")");
#line 475 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp51_ = gitg_test_repository_file_exists ((GitgTestRepository*) self, ".git/MERGE_MSG");
#line 475 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_vala_assert (!_tmp51_, "!file_exists(\".git/MERGE_MSG\")");
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_tmp52_ = ((GitgTestRepository*) self)->d_repository;
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	ggit_repository_stash_foreach ((GgitRepository*) _tmp52_, ___lambda28__ggit_stash_callback, self, &_inner_error_);
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		__vala_GgitOId_free0 (theirs_oid);
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		__vala_GgitOId_free0 (ours_oid);
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		block12_data_unref (_data12_);
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		_data12_ = NULL;
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		g_clear_error (&_inner_error_);
#line 477 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
		return;
#line 3466 "test-merge-ref.c"
	}
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (theirs_oid);
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	__vala_GgitOId_free0 (ours_oid);
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	block12_data_unref (_data12_);
#line 419 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_data12_ = NULL;
#line 3476 "test-merge-ref.c"
}


static void gitg_test_merge_ref_class_init (GitgTestMergeRefClass * klass) {
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	gitg_test_merge_ref_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_type_class_add_private (klass, sizeof (GitgTestMergeRefPrivate));
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	((GitgTestTestClass *) klass)->set_up = gitg_test_merge_ref_real_set_up;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	((GitgTestMergeRefClass *) klass)->test_merge_simple = gitg_test_merge_ref_real_test_merge_simple;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	((GitgTestMergeRefClass *) klass)->test_merge_not_head = gitg_test_merge_ref_real_test_merge_not_head;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	((GitgTestMergeRefClass *) klass)->test_merge_not_head_would_have_conflicted = gitg_test_merge_ref_real_test_merge_not_head_would_have_conflicted;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	((GitgTestMergeRefClass *) klass)->test_merge_theirs_conflicts_no_checkout = gitg_test_merge_ref_real_test_merge_theirs_conflicts_no_checkout;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	((GitgTestMergeRefClass *) klass)->test_merge_theirs_conflicts_checkout = gitg_test_merge_ref_real_test_merge_theirs_conflicts_checkout;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	((GitgTestMergeRefClass *) klass)->test_merge_theirs_dirty_stash = gitg_test_merge_ref_real_test_merge_theirs_dirty_stash;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	((GitgTestMergeRefClass *) klass)->test_merge_theirs_not_master_conflicts_checkout = gitg_test_merge_ref_real_test_merge_theirs_not_master_conflicts_checkout;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	((GitgTestMergeRefClass *) klass)->test_merge_theirs_not_master_conflicts_checkout_dirty = gitg_test_merge_ref_real_test_merge_theirs_not_master_conflicts_checkout_dirty;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	((GitgTestMergeRefClass *) klass)->test_merge_theirs_not_master_conflicts_checkout_dirty_no_stash = gitg_test_merge_ref_real_test_merge_theirs_not_master_conflicts_checkout_dirty_no_stash;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_test_merge_ref_finalize;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_signal_new ("test_merge_simple", GITG_TEST_TYPE_MERGE_REF, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestMergeRefClass, test_merge_simple), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_signal_new ("test_merge_not_head", GITG_TEST_TYPE_MERGE_REF, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestMergeRefClass, test_merge_not_head), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_signal_new ("test_merge_not_head_would_have_conflicted", GITG_TEST_TYPE_MERGE_REF, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestMergeRefClass, test_merge_not_head_would_have_conflicted), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_signal_new ("test_merge_theirs_conflicts_no_checkout", GITG_TEST_TYPE_MERGE_REF, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestMergeRefClass, test_merge_theirs_conflicts_no_checkout), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_signal_new ("test_merge_theirs_conflicts_checkout", GITG_TEST_TYPE_MERGE_REF, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestMergeRefClass, test_merge_theirs_conflicts_checkout), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_signal_new ("test_merge_theirs_dirty_stash", GITG_TEST_TYPE_MERGE_REF, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestMergeRefClass, test_merge_theirs_dirty_stash), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_signal_new ("test_merge_theirs_not_master_conflicts_checkout", GITG_TEST_TYPE_MERGE_REF, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestMergeRefClass, test_merge_theirs_not_master_conflicts_checkout), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_signal_new ("test_merge_theirs_not_master_conflicts_checkout_dirty", GITG_TEST_TYPE_MERGE_REF, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestMergeRefClass, test_merge_theirs_not_master_conflicts_checkout_dirty), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	g_signal_new ("test_merge_theirs_not_master_conflicts_checkout_dirty_no_stash", GITG_TEST_TYPE_MERGE_REF, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestMergeRefClass, test_merge_theirs_not_master_conflicts_checkout_dirty_no_stash), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3525 "test-merge-ref.c"
}


static void gitg_test_merge_ref_instance_init (GitgTestMergeRef * self) {
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self->priv = GITG_TEST_MERGE_REF_GET_PRIVATE (self);
#line 3532 "test-merge-ref.c"
}


static void gitg_test_merge_ref_finalize (GObject* obj) {
	GitgTestMergeRef * self;
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TEST_TYPE_MERGE_REF, GitgTestMergeRef);
#line 24 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->ours);
#line 25 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->theirs);
#line 26 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->master);
#line 27 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->not_master);
#line 29 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->action_interface);
#line 30 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	_g_object_unref0 (self->priv->action);
#line 22 "/home/jesse/dev/gitg/tests/gitg/test-merge-ref.vala"
	G_OBJECT_CLASS (gitg_test_merge_ref_parent_class)->finalize (obj);
#line 3554 "test-merge-ref.c"
}


GType gitg_test_merge_ref_get_type (void) {
	static volatile gsize gitg_test_merge_ref_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_test_merge_ref_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgTestMergeRefClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_test_merge_ref_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgTestMergeRef), 0, (GInstanceInitFunc) gitg_test_merge_ref_instance_init, NULL };
		GType gitg_test_merge_ref_type_id;
		gitg_test_merge_ref_type_id = g_type_register_static (GITG_TEST_TYPE_APPLICATION, "GitgTestMergeRef", &g_define_type_info, 0);
		g_once_init_leave (&gitg_test_merge_ref_type_id__volatile, gitg_test_merge_ref_type_id);
	}
	return gitg_test_merge_ref_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



