.TH GT 1 "8 Sep 1995" \" -*-nroff-*-
.SH NAME
gt \- version of TiMidity MIDI to WAVE converter and player
.P
.SH SYNOPSIS
.B gt
[\-options] [directoryname | filenames ...] [\-options]
.P
.SH DESCRIPTION
\fIGt\fR\ is a MIDI to WAVE converter using Gravis
Ultrasound\-compatible patch files,
extended GUS patch files,
or AWE\-compatible SoundFonts
to generate digital audio data from
General MIDI files.
.P
The data can be stored in a file for processing,
or played in real time through an audio device.
\fIGt\fR\ will generate 6 and 4 channel sound output on systems with
capable Alsa drivers and soundcards.
Currently, there is only a single output driver, for Alsa.
.P
It's not necessary to give any filenames on the command
line; if there are midi files in the current directory,
\fIgt\fR\ will find them and play them.  You can also give a
single directory name, and \fIgt\fR\ will look in that directory
for midi files.
(This automatic construction of play lists will not work
for compressed files.)
.P
The default display interface uses the ncurses library to
show the notes being played and give other information.
The alternatives to this interface are described below
under the \fB-i\fR\ option (they are \fB-int\fR\ for
ncurses in non-tracing mode, and \fB-id\fR\ or
\fB-idt\fR\ for the dumb interface).  As songs are playing,
a moderate amount of control can be exerted with keys
and the mouse (if the mouse works for your display window).
Key \fBq\fR or \fBend\fR or \fBF10\fR exits.
Key \fBV\fR or \fBup-arrow\fR and \fBv\fR or \fBdown-arrow\fR adjust the volume.
The space bar pauses playing or resumes playing when paused.
Key \fBn\fR or \fBpage-down\fR or \fBF9\fR goes to the next midi song.
Key \fBp\fR or \fBpage-up\fR goes to the previous midi song.
Key \fBr\fR or \fBhome\fR restarts the current midi song at the beginning.
Key \fBf\fR or \fBright-arrow\fR skips forward in the current song.
Key \fBb\fR or \fBleft-arrow\fR skips backward in the current song.
Shifted kays \fBleft-arrow\fR and \fBright-arrow\fR adjust the voices ceiling.
Kays \fBF2\fR, \fBF3\fR, and \fBF4\fR change the interpolation algorithm.
Kays \fBF5\fR, \fBF6\fR, \fBF7\fR, and \fBF8\fR change the patch set.
Key \fBF11\fR toggles between wet and dry mode.
.P
Here is what is shown on the ncurses display:
.TP
.I line 1
Program title.
.TP
.I line 2
Current patchset, interpolation method, loading mode.
A different patchset can be chosen with function keys F5-F8, as indicated
on the bottom line of the display.
A different interpolation method  can be chosen with function keys F2-F4
-- also as indicated on the bottom line of the display.
An "[F]" after the interpolation method means that the low pass filter
is being used.
Loading mode is either fast or full.  With fast loading, only the first
velocity layer is loaded from extended GUS patches (for ordinary GUS
patches, loading mode makes no difference).  You can toggle the
loading mode with the shifted \fBF\fR key.
.TP
.I line 3
Program status messages and karaoke lyrics or other midi text messages.
Fatal error messages are red if your display does color, otherwise
they are shown in bold.  (And all the colors mentioned below come out
in bold face on a non-color display.)
Loading progress for patch files required for the next song is shown
in cyan.
If there is a limit on the amount of memory to use for patches
(see the \fB-r\fR option), the loading line displays the proportion
of available memory that has been used.
(Patches used for previous songs are purged from memory when
necessary.)
Lyrics and other midi text messages are in yellow.
.TP
.I line 4
Midi file being played or about to be played.  Just after the file name,
\fB[GM]\fR, \fB[GS]\fR, or \fB[XG]\fR may be shown, which is the
synthesizer type, if that was specified in the midi file.  After that,
as screen space permits, a title, copyright, and author may be shown.
.TP
.I line 5
Elapsed time for the current song and the total time it will take to play it.
You can fast forward or rewind with the right or left arrow keys.
Key signature, time signature, and tempo are shown in the middle of the line.
At the right is the master volume, which will be adjusted by some
midi songs, or you can adjust it yourself with the up and down arrow keys.
You can use the clipping rate as a guide to how far you want to turn
up the volume.
.TP
.I line 7
The \fBCh\fR\ means midi channel number and is a label for the 16 numbers
below it, referring to the 16 midi channels.
To the right is a voices bar indicating how many simultaneous notes are
being played, i.e., the current polyphony.
The very left part of the voices bar is shown with yellow \fB+\fR\ marks
and indicates how full the Alsa output buffer is.  (If the buffer gets
too low, that means \fIgt\fR\ can't produce output fast enough, and you
may anticipate dropouts.)
Sometimes the bar will have a green middle part -- this shows the number
of notes that were actually in the music.  The blue part of the bar
indicates notes added for reverberation, and the magenta part shows
notes added for various other effects (chorus, stereo, or tutti).
.TP
.I \ 
A \fB<\fR mark on the voices bar shows where the voices ceiling
has been set.
The ceiling is the target maximum polyphony, i.e., number of simultaneously
sounding notes, that \fIgt\fR\ tries to remain below.
The number can be adjusted up or down with the shifted right and
left arrow keys.
Higher polyphony gives better sound quality but means more work for the cpu.
The default ceiling is 128, and the default absolute maximum is 256.
.TP
.I \ 
To the right of the voices bar are labels for the columns below.
The labels are
\fBBnk\fR\ for midi bank number ('0' is not shown; percussion banks
are shown below in yellow, XG variation bank numbers in cyan,
and the XG sfx bank in magenta),
\fBPrg\fR\ for midi program number,
\fBVol\fR\ for the midi volume controller,
\fBExp\fR\ for the expression controller,
\fBPan\fR\ for the left-right panning controller,
\fBS\fR\ for the sustain pedal (also shows portamento, sostenuto, legato, and soft pedal),
\fBB\fR\ for pitch bend (also shows modulation wheel with \fB*\fR).
\fBb\fR\ for brightness,
\fBR\fR\ for reverberation,
\fBC\fR\ for chorus depth,
\fBc\fR\ for celeste effect, and
\fBX\fR\ for miscellaneous controllers (some not implemented).
.TP
.I \ 
Though they are displayed, the legato and soft pedal controllers are
not yet implemented.  You can click with the mouse on the \fBR\fR,
\fBC\fR, or \fBc\fR labels to toggle reverberation, chorus effect,
or celeste effect on or off.  (For XG songs, celeste effect is
actually variation send, and the \fBc\fR column is shown
with a \fBV\fR instead.)
.TP
.I lines 9-24
These 16 lines show events on the 16 basic midi channels.
\fBGt\fR\ can play on up to 64 channels, for midi files that have
port commands to play on several synthesizers, but there is only
room to show the first 16 in full on the display.  Notes from
higher channels do show up, though, and are shown in cyan.
After the number of the midi channel is the name of the patch
chosen with the midi program command.
The name given here is the name for the patch given in the
configuration file, for non-percussion channels.
For a percussion channel, it's the drumset name.
If there is no name, that means there was
no program command given, and the default Grand Piano
program is being used, or the default drumset 0, for a
percussion channel.  Or, for a drumset, the absence of any
name may be because no name for the drumset was given in the
configuration file.
Drum kits are shown in yellow, and
XG rhythm sfx kits are shown in magenta.
.TP
.I \ 
In the middle area of the midi channel display the notes
are shown.  Lower notes are to the left and higher to
the right.  There isn't room to show very high or very
low notes, so these are clipped.
A digit from 1-9 indicates the note velocity.
At the onset of the note, if it's playing a stereo patch,
it's shown in magenta, otherwise it's shown in red for a
melodic note and yellow for a percussion note.  The decay
and release phases of a note are shown in green, and the
sustain phase in blue.
.TP
.I \ 
After that is the midi bank number in use on the channel,
from 000 to 127, which for percussion channels is shown in yellow.
The 000 for melodic bank 0 is left implicit.
Numbers in cyan are for XG variation banks.
The XG sfx bank is shown as magenta \fBsfx\fR (if your configuration
does not supply an sfx bank, but you do have a bank 120, bank
120 is used for the sfx bank).
Numbers shown in blue are XG model exclusive or VL patches.
After this come the midi program number and
current values for some midi controllers.
.TP
.I bottom line
Shown here are labels for the function keys.
Function keys \fBF2\fR, \fBF3\fR, and \fBF4\fR
are toggles to switch interpolation and filtering mode.
The choices are not independent.
\fBF3\fR switches between c-spline and Lagrange interpolation
methods, but either choice is non-linear (key \fBF2\fR),
and choosing Lagrange interpolation switches the low pass
filter off (key \fBF4\fR) (because a filter is not yet
implemented for Lagrange interpolation).
.TP
.I \ 
The \fBHelp\fR and
\fBMixer\fR keys bring up subwindows.  In the \fBMixer\fR window,
you can adjust speaker balance by mouse-clicking to the left
or right of the speaker letters.  Small letter \fBl\fR and
\fBr\fR stand for the left and right rear speakers.
.TP
.I lines 26 on
If there is room in the display window, below the midi channel
display, the current play list of midi files is shown.
You can select a new song to play by clicking in the list.
To the right of the playlist there may be some tracing
messages concerning XG effects if verbose mode was
requested with \fB-inv\fR or \fB-invv\fR.
.P
.SH OPTIONS
The following command line options are accepted by version 0.1 of
\fIgt\fR:
.TP
.B \-h
Help.  This shows a one-page summary of the options being described
here.  The path name of the current default configuration file
is also shown, and, if you have set up alternate patch sets
with \fBif\fR statements in your configuration file, the names
of these alternate patch sets are also shown (they can be chosen
with the command line option \fB-#\fInumber\fR).
.TP
.B \-v
Copyright statement from Tuukko Toivonen.
.TP
.BI \-o " filename"
Place output on \fIfilename\fP.
Assumes output mode ``w'' was selected with the \fB\-Ow\fP
option. The special filename ``\-'' causes output to be placed on
stdout.
.TP
.BI \-O " mode"
Selects the output mode from the compiled-in alternatives.  \fImode\fP
must begin with one of the supported output mode identifiers.  Run
\fIgt\fR\ with the \fB\-h\fP option to see a list.  The following
identifier should be available in all versions:
.RS
.TP
.B \-Ow
Generate RIFF WAVE format output.  If output is directed to a
non-seekable file, or if \fIgt\fR\ is interrupted before closing the
file, the file header will contain 0xFFFFFFFF in the RIFF and data
block length fields.  The popular sound conversion utility \fIsox\fP
is able to read such malformed files, so you can pipe data directly to
sox for on\-the\-fly conversion to other formats.
.TP
.B "Format options"
Option characters may be added immediately after the mode identifier
to change the output format.  The following options are recognized:
.RS
.LP
.TP
.B 8
8-bit sample width
.TP
.B 1
16-bit sample width
.TP
.B l
Linear encoding
.TP
.B U
uLaw (8-bit) encoding
.TP
.B M
Monophonic
.TP
.B S
Stereo
.TP
.B q
Quadraphonic
.TP
.B s
Signed output
.TP
.B u
Unsigned output
.TP
.B x
Byte-swapped output
.RE
.LP
Note that some options have no effect on some modes.  For example, you
cannot generate a byte-swapped RIFF WAVE file, or force uLaw output on
a Linux PCM device.
.RE
.LP
.TP
.BI \-s " frequency"
Sets the resampling frequency.  Not all sound devices are capable of
all frequencies -- an approximate frequency may be selected, depending
on the implementation.
.TP
.B \-a
Turns on antialiasing. Samples are run through a lowpass filter before
playing, which reduces aliasing noise at low resampling frequencies.
(With the sampling rate set to the standard 44,100 samples per second,
there's no point to using this.)
.TP
.B \-k " number"
Select interpolation algorithm for resampling: 0 for linear interpolation,
1 for cspline interpolation, 2 for LaGrange interpolation, 3 for cspline
with filter.
.TP
.B \-b " number"
Substitute bank \fInumber\fR instruments for bank 0 instruments, provided
that the substitute instruments exist.  I use this for auditioning new
patches.  The \fInumber\fR argument is the raw index, which will reference
sfx, vl, or mu100 banks if the number is greater than 127.
.TP
.B \-r " number"
Set maximum of ram in megabytes to use up keeping patches from previously
played midi files.  This should presumably be less than your total ram
plus disk cache size.  The default is 60 megabytes.  It probably doesn't
matter unless you're using big sf2 soundfont patchsets.
.TP
.B \-F
Toggles fast loading mode.  With fast loading, only the first velocity
layer is loaded in extended GUS patches.  It's lots faster -- quality suffers.
.TP
.B \-f
Toggles fast envelopes. Some MIDI files sound better when notes decay
slower -- it gives the impression of reverb, which \fIgt\fR\ doesn't
currently fully support.
.TP
.B \-d
Sets "dry" mode.  After notes are released, their decay is governed by
the patch data rather than the volume envelope.  This is economical of
polyphony, but for some instruments, typically vibraphone, ocarina,
and mandolin, notes may be terminated too suddenly.  Non-dry, or "wet"
mode is the default.
.TP
.BI \-S " separation"
Tunes surround sound separation.  Lower values give more separation.
For 5.1 surround, the default is 64.  For 4.0 surround, the default
is 95.
.TP
.BI \-p " voices"
Sets polyphony (maximum number of simultaneous voices) to
\fIvoices\fP.
.TP
.BI \-A " amplification"
Multiplies the master volume by \fIamplification\fP%.
.TP
.BI \-X " curve"
With the value 0, the midi expression controller affects the volume
linearly.  With 1 (the default) or 2, it affects volume exponentially.
Values 3, 4, or 5 use tables specific to GM, GS, and XG.
.TP
.BI \-V " curve"
With the value 0, the midi volume controller affects the volume
linearly.  With 1 (the default) or 2, it affects volume exponentially.
Values 3, 4, or 5 use tables specific to GM, GS, and XG.
.TP
.BI \-C " ratio"
Sets the ratio of sampling and control frequencies.  This determines how
often envelopes are recalculated -- small ratios yield better quality
but use more CPU time.
.TP
.BI \-# " number"
Selects patchset when the configuration file has been set up
appropriately.  See the FILES section below under \fBif\fP and
\fBelse\fP for how to do this.
.TP
.BI \-L " directory"
Adds \fIdirectory\fP to the library path.  Patch, configuration, and
MIDI files are searched along this path.  Directories added last will
be searched first.  Note that the current directory is always searched
first before the library path.
.TP
.BI \-c " file"
Reads an extra configuration file.
.TP
.BI \-I " number"
Uses the program \fInumber\fP as the default instrument.  Any Program
Change events in MIDI files will override this option.
.TP
.BI \-D " channel"
Marks \fIchannel\fP as a drum channel.  
If \fIchannel\fP is negative, channel \-\fIchannel\fP is marked as an
instrumental channel.
If \fIchannel\fP is 0, all channels are marked as instrumental.
(Sysex dumps in GS or XG midi files may mark channels as drums
and will override this flag.)
.TP 
.BI \-Q " channel"
Causes \fIchannel\fP to be quiet. 
If \fIchannel\fP is negative, channel \-\fIchannel\fP is turned back on. 
If \fIchannel\fP is 0, all channels are turned on.
.TP
.BI \-U
Instructs \fIgt\fR\ to unload all instruments from memory between
MIDI files.  This can reduce memory requirements when playing many
files in succession.
.TP
.BI \-i " interface"
Selects the user interface from the compiled-in alternatives.
\fIinterface\fP must begin with one of the supported interface
identifiers.  Run \fIgt\fR\ with the \fB\-h\fP option to see a list.
The following identifiers may be available:
.RS
.TP
.B \-id
The dumb interface -- plays files in sequence, prints messages
according to verbosity level.  The trace mode shows the current and
total playing time.
.TP
.B \-in
The ncurses full\-screen interface with interactive controls.
.TP
.B "Interface options"
Option characters may be added immediately after the interface
identifier.  The following options are recognized:
.RS
.TP
.B v
Increases verbosity.  This option is cumulative.
.TP
.B q
Decreases verbosity.  This option is cumulative.
.TP
.B t
Toggles trace mode.  Trace mode is the default for the ncurses
interface, so \fBt\fR turns it off.  Trace mode is not very useful
for the dumb interface.  The ncurses display in trace mode displays
events in midi time.  That is, midi events, like note onsets,
are displayed approximately at the time you hear them, though \fIgt\fR
is working a second or so ahead in the song, calculating data to
send to the output driver.  So midi time is a little behind
real time.  However, the status of midi controllers is shown in
real time, so in the display, the controllers will change slightly
before you can hear their effects.
.RE
.RE
.LP
.TP
.TP
.BI \-B " fragments"
For the Linux sound driver, selects the number of buffer fragments.
Increasing the number of fragments may reduce
choppiness when many processes are running.
Specify a
\fIfragments\fP of 0 to use the maximum number of fragments available.
The maximum number available is the default, and it's probably
not useful to change that.
.P
.SH FILES
\fIgt\fR\ looks for the configuration file \fItimidity.cfg\fP at
startup, before processing any options.  If it can't be accessed, and
the library path is changed with a \fB\-L\fP option on the command
line, then the default file will be sought again along the new library
path after processing all options, unless another configuration file was
specified with the \fB\-c\fP option. 
.P
Configuration files define the mapping of MIDI programs to instrument
files.  Multiple files may be specified, but statements in later ones
will not override earlier ones.  The following statements can be used in a
configuration file:
.TP
.BI \-p " voices"
Sets polyphony (maximum number of simultaneous voices) to
\fIvoices\fP.
.TP
.BI \-A " amplification"
Multiplies the master volume by \fIamplification\fP%.
.TP
.BI \-X " curve"
With the value 0, the midi expression controller affects the volume
linearly.  With 1 (the default) or 2, it affects volume exponentially.
.TP
.BI \-V " curve"
With the value 0, the midi volume controller affects the volume
linearly.  With 1 (the default) or 2, it affects volume exponentially.
.TP
.BI \-C " ratio"
Sets the ratio of sampling and control frequencies.  This determines how
often envelopes are recalculated -- small ratios yield better quality
but use more CPU time.
.TP
.BI \-s " frequency"
Sets the resampling frequency.  Not all sound devices are capable of
all frequencies -- an approximate frequency may be selected, depending
on the implementation.
.TP
.B \-k " number"
Select interpolation algorithm for resampling: 0 for linear interpolation,
1 for cspline interpolation, 2 for LaGrange interpolation, 3 for
cspline interpolation with low-pass filtering.
.TP
.B \-r " number"
Set maximum of ram in megabytes to use up keeping patches from previously
played midi files.  This should presumably be less than your total ram
plus disk cache size.  The default is 60 megabytes.  It probably doesn't
matter unless you're using big sf2 soundfont patchsets.
.TP
.BI \-O " mode"
Same as corresponding commandline option.
.TP
.BI dir " directory"
Adds \fIdirectory\fP to the search path in the same manner as the
\fB\-L\fP command line option.
.TP
.BI source " file"
Reads another configuration file, then continues processing the
current one.
.TP
.BI soundfont " file"
Loads a soundfont.  Unlike the following \fIsf2\fR command, this
offers no way to modify banks or presets inside the soundfont.
But it's easy to use.
.TP
.BI sf2 " file [option]"
Reads the parameters and waveforms in an AWE\-compatible SoundFont
file.  Both ".sbk" and ".sf2" SoundFonts can be used.  Preceding patch
mappings must list all patches that are to be loaded from the
file, and the preceding \fBbank\fP/\fBdrumset\fP keywords must
be followed by \fBsf2\fP or \fBsbk\fP (which are equivalent).
The options allowed are:
.RS
.TP
\fIbanknumber\fP
The bank number given in the first preceding
"bank"/"drumset" statement is to be used in place of
the bank \fIbanknumber\fP given in the SoundFont itself.
.RE
.TP
.BI if " number"
This makes the next \fIsource\fR or \fIsoundfont\fR command in the
configure file conditional on the number being the same as a
number supplied to \fIgt\fR as the patchset number, with,
e.g., the "-#n" command line option.  Also, if this appears
in the main config file \fBtimidity.cfg\fR, the name given
with the following conditional command becomes the name
of the patchset.
.TP
.BI bank " number [option] [[#N ]name]"
Selects the tone bank to modify.  Patch mappings that follow will
affect this tone bank.
The options allowed are \fBsf2\fP and \fBsbk\fP, which were described above.
The optional name is for the sake of the display interface, so the
bank can be shown with a meaningful name instead of just a number.
The name assigned can be preceded by "#N ", for compatibility with
Timidity++, which otherwise complains about the extra name argument.
.TP
.BI drumset " number [option] [[#N ]name]"
Selects the drum set to modify.  Patch mappings that follow will affect
this drum set.
The options allowed are \fBsf2\fP and \fBsbk\fP, which were described above.
As for the bank statement described above, the name is for display.
.TP
.BI sfx
Selects the XG non-rhythm SFX bank to modify.
Patch mappings that follow will affect this tone bank.
.TP
.BI bankxg number
Selects XG banks 1-16.  These have to be kept separate from the
banks 1-16 used for GM/GS midis, because they don't have the
same types of instruments.
.TP
.BI drumsfx number
Selects any of the 128 XG rhythm SFX banks (numbered 0-127) to modify.
Patch mappings that follow will affect these drum banks.
(Older XG midis use only 0 and 1 banks, but now there are also
banks 16 (Techno Kit K/S), 17 (Techno Kit Hi), 18 (Techno Kit Lo),
32 (Sakura Kit), and 33 (Small Latin Kit).
.TP
.BI mu100 number
Selects an XG MU100 model specific bank, where \fInumber\fR is a
multiple of 8.
.TP
.BI vl number
Selects an XG VL bank, where \fInumber\fR is 0 or 1.  (This is not
for the VL-XG banks 112-119, which are treated as ordinary banks.)
.TP
.I "number file [options]"
Specifies that the the MIDI program \fInumber\fP in the current tone
bank or drum set should be played using the patch \fIfile\fP.
\fIoptions\fP may be any of the following:
.RS
.TP
\fBamp=\fP\fIamplification\fP
Amplifies the instrument's volume by \fIamplification\fP percent.
.TP
\fBnote=\fP\fInote\fP
Specifies a fixed MIDI note to use when playing the instrument.
If \fInote\fP is 0, the instrument will be played at whatever note
the Note On event triggering it has. For percussion instruments, if no
value is specified in the configuration file, the default in the patch
file will be used.
.TP
\fBtuning=\fP\fIcents\fP
Changes the pitch of the instrument. \fIcents\fP is a signed quantity in
units of 1/100th of a semitone, so, e.g., specify "+1200" to go up
an octave.  The number must begin with a "+" or a "-".
(Not yet implemented for soundfonts.)
.TP
\fBpan=\fP\fIpanning\fP
Sets the instrument's default panning. 
\fIpanning\fP may be \fBleft\fP, \fBright\fP, \fBcenter\fP, or an
integer between -100 and 100, designating full left and full right
respectively. 
If no value is specified, the default in the patch file will be used. 
Note that panning controls in MIDI files will override this value.
.TP
\fBcutoff=\fP\fIHz\fP
Sets the initial cutoff frequency for the low pass filter used in
filter interpolation.
.TP
\fBkeep=\fP{\fBloop\fP|\fBenv\fP|\fBsustain\fP}
Strangely shaped envelopes are removed
automatically from melodic instruments in GUS patches. \fBkeep\fP can be used
to prevent stripping envelope or loop data.  (Stripping envelopes was
originally the default for \fItimidity\fR, but in this version it's not,
except for GUS percussion patches.  So these options are seldom useful.)
.TP
\fBstrip=\fP{\fBloop\fP|\fBenv\fP|\fBtail\fP|\fBsustain\fP}
Force removal of loop or envelope information from all patches in the
instrument, or strip the tail, i.e. all data after the loop. Some
third-party instruments have garbage after the loop, as evidenced by a
clicking noise whenever the instrument is played, so adding the
\fBstrip=tail\fP option will markedly improve sound quality.
The \fBstrip=sustain\fP option prevents notes from being held
until released.
.RE
.LP
.P
\fBNOTE:\fP Whenever any filename ends in one of the compiled\-in
compression identifiers, such as \fI.gz\fP, or \fI.sht\fP, \fIgt\fR
will pipe the file through the appropriate decompressor.  MIDI files
often compress very well, so the ability to handle compressed files
can be useful.
.P
The special filename ``\-'' can be used on the command line to
indicate that a MIDI file should be read from stdin.
.P
.SH COPYRIGHT
Copyright (C) 1995 Tuukka Toivonen.
.br
See AUTHORS below for additional copyrights.
.P
gt/TiMidity is free software; you can redistribute it
and/or modify it under the terms of the \fIGNU General Public
License\fP as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.
.P
TiMidity is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
\fIGNU General Public License\fP for more details.
.SH AVAILABILITY
The latest release of the original version is available on the TiMidity Home Page,
URL \fIhttp://www.clinet.fi/~toivonen/timidity/\fP.  (But the
original version is no longer being maintained -- see
URL \fIhttp://http://www.cgs.fi/~tt/discontinued.html\fP.)
The present modified version is available at
URL \fIftp://ling.lll.hawaii.edu/pub/greg/gt-0.3.tar.gz\fP.
.SH BUGS
8-bit and low-rate output sounds worse than it should.
.P
Eats more CPU time than a small CPU-time-eating animal.
.SH AUTHORS
Tuukka Toivonen <toivonen@clinet.fi>
.br
Surround sound, reading extended GUS patches implemented
by Greg Lee.
.br
HP\-UX audio code, X-Motif interface, icons and antialiasing filter by
Vincent Pagel <pagel@loria.fr>
.br
Tcl/Tk interface and AWE SoundFont support by Takashi
Iwai <iwai@dragon.mm.t.u-tokyo.ac.jp>
.br
Windows 95/NT audio code by Davide Moretti <dmoretti@iper.net>
.br
DEC audio code by Chi Ming HUNG <cmhung@insti.physics.sunysb.edu>
.br
S\-Lang user interface by Riccardo Facchetti <riccardo@cdc8g5.cdc.polimi.it>
.br
IW patchset support, karaoke, AWE/XG enhancements, much reworking of the code
by Greg Lee <lee@hawaii.edu>, <greg@ling.lll.hawaii.edu>
.br
KDE user interface "KMidi"
Copyright (C) 1997 Bernd Johannes Wuebben <wuebben@math.cornell.edu>
.br
Effects filter by Nicolas Witczak <witczak@geocities.fr>, see
URL \fIhttp://www.geocities.com/SiliconValley/Lab/6307/\fP).
.br
Portamento, mod wheel, and other enhancements from TiMidity++
Copyright (C) 1999 Masanao Izumo <mo@goice.co.jp>.  See
URL \fIhttp://www.goice.co.jp/member/mo/hack-progs/timidity.html\fP.
.br
alsa driver Copyright (C) 1999 Masanao Izumo <mo@goice.co.jp>
.br
bsd20 driver Written by Yamate Keiichiro <keiich-y@is.aist-nara.ac.jp>
.br
esd driver by Avatar <avatar@deva.net>
.br
hpux_d driver Copyright 1997 Lawrence T. Hoff
.br
nas driver Copyright (C) 1999 Michael Haardt <michael@moria.de>
.br
XAW Interface from Tomokazu Harada <harada@prince.pe.u-tokyo.ac.jp>
and Yoshishige Arai <ryo2@on.rim.or.jp>
.br
GTK+ interface by Glenn Trigg 29 Oct 1998
.br
The autoconf script is (C)Copyright 1998 by Hiroshi Takekawa <t80679@hongo.ecc.u-tokyo.ac.jp>,
modified for automake by Isaku Yamahata <yamahata@kusm.kyoto-u.ac.jp>,
modified for automake by Masanao Izumo <mo@goice.co.jp> (1998.11).
.br
The m4 autoconf definitions: Configure paths for ESD
by Manish Singh 98-9-30, stolen back from Frank Belew,
stolen from Manish Singh, Shamelessly stolen from Owen Taylor.
.br
Configure Paths for Alsa by
Christopher Lansdown (lansdoct@cs.alfred.edu), 29/10/1998,
modified for TiMidity++ by Isaku Yamahata(yamahata@kusm.kyoto-u.ac.jp),
16/12/1998.
