; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve,+neon < %s | FileCheck %s

; Inserting an element from the bottom 128-bits of an SVE type into a NEON vector should use INS (element) to
; avoid pointless FMOV trips.

; --------- extraction from nxv16i8

define <8 x i8> @test_lane0_nxv16i8(<8 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: test_lane0_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.b[0], v1.b[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 16 x i8> %b, i32 0
    %d = insertelement <8 x i8> %a, i8 %c, i32 0
    ret <8 x i8> %d
}

define <8 x i8> @test_lane15_nxv16i8(<8 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: test_lane15_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.b[7], v1.b[15]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 16 x i8> %b, i32 15
    %d = insertelement <8 x i8> %a, i8 %c, i32 7
    ret <8 x i8> %d
}

define <16 x i8> @test_q_lane0_nxv16i8(<16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: test_q_lane0_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.b[0], v1.b[0]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 16 x i8> %b, i32 0
    %d = insertelement <16 x i8> %a, i8 %c, i32 0
    ret <16 x i8> %d
}

define <16 x i8> @test_q_lane15_nxv16i8(<16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: test_q_lane15_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.b[15], v1.b[15]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 16 x i8> %b, i32 15
    %d = insertelement <16 x i8> %a, i8 %c, i32 15
    ret <16 x i8> %d
}

; (negative test) Extracted element is not within Vn
define <16 x i8> @test_q_lane16_nxv16i8(<16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: test_q_lane16_nxv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z1.b, z1.b[16]
; CHECK-NEXT:    fmov w8, s1
; CHECK-NEXT:    mov v0.b[15], w8
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 16 x i8> %b, i32 16
    %d = insertelement <16 x i8> %a, i8 %c, i32 15
    ret <16 x i8> %d
}

; --------- extraction from nxv8f16

define <4 x half> @test_lane0_nxv8f16(<4 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: test_lane0_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.h[0], v1.h[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x half> %b, i32 0
    %d = insertelement <4 x half> %a, half %c, i32 0
    ret <4 x half> %d
}

define <4 x half> @test_lane7_nxv8f16(<4 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: test_lane7_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.h[3], v1.h[7]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x half> %b, i32 7
    %d = insertelement <4 x half> %a, half %c, i32 3
    ret <4 x half> %d
}

define <8 x half> @test_q_lane0_nxv8f16(<8 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: test_q_lane0_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.h[0], v1.h[0]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x half> %b, i32 0
    %d = insertelement <8 x half> %a, half %c, i32 0
    ret <8 x half> %d
}

define <8 x half> @test_q_lane7_nxv8f16(<8 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: test_q_lane7_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.h[7], v1.h[7]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x half> %b, i32 7
    %d = insertelement <8 x half> %a, half %c, i32 7
    ret <8 x half> %d
}

; (negative test) Extracted element is not within Vn
define <8 x half> @test_q_lane8_nxv8f16(<8 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: test_q_lane8_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z1.h, z1.h[8]
; CHECK-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x half> %b, i32 8
    %d = insertelement <8 x half> %a, half %c, i32 7
    ret <8 x half> %d
}

; --------- extraction from nxv8bf16

define <4 x bfloat> @test_lane0_nxv8bf16(<4 x bfloat> %a, <vscale x 8 x bfloat> %b) {
; CHECK-LABEL: test_lane0_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.h[0], v1.h[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x bfloat> %b, i32 0
    %d = insertelement <4 x bfloat> %a, bfloat %c, i32 0
    ret <4 x bfloat> %d
}

define <4 x bfloat> @test_lane7_nxv8bf16(<4 x bfloat> %a, <vscale x 8 x bfloat> %b) {
; CHECK-LABEL: test_lane7_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.h[3], v1.h[7]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x bfloat> %b, i32 7
    %d = insertelement <4 x bfloat> %a, bfloat %c, i32 3
    ret <4 x bfloat> %d
}

define <8 x bfloat> @test_q_lane0_nxv8bf16(<8 x bfloat> %a, <vscale x 8 x bfloat> %b) {
; CHECK-LABEL: test_q_lane0_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.h[0], v1.h[0]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x bfloat> %b, i32 0
    %d = insertelement <8 x bfloat> %a, bfloat %c, i32 0
    ret <8 x bfloat> %d
}

define <8 x bfloat> @test_q_lane7_nxv8bf16(<8 x bfloat> %a, <vscale x 8 x bfloat> %b) {
; CHECK-LABEL: test_q_lane7_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.h[7], v1.h[7]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x bfloat> %b, i32 7
    %d = insertelement <8 x bfloat> %a, bfloat %c, i32 7
    ret <8 x bfloat> %d
}

; (negative test) Extracted element is not within Vn
define <8 x bfloat> @test_q_lane8_nxv8bf16(<8 x bfloat> %a, <vscale x 8 x bfloat> %b) {
; CHECK-LABEL: test_q_lane8_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z1.h, z1.h[8]
; CHECK-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x bfloat> %b, i32 8
    %d = insertelement <8 x bfloat> %a, bfloat %c, i32 7
    ret <8 x bfloat> %d
}

; --------- extraction from nxv8i16

define <4 x i16> @test_lane0_nxv8i16(<4 x i16> %a, <vscale x 8 x i16> %b) {
; CHECK-LABEL: test_lane0_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.h[0], v1.h[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x i16> %b, i32 0
    %d = insertelement <4 x i16> %a, i16 %c, i32 0
    ret <4 x i16> %d
}

define <4 x i16> @test_lane7_nxv8i16(<4 x i16> %a, <vscale x 8 x i16> %b) {
; CHECK-LABEL: test_lane7_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.h[3], v1.h[7]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x i16> %b, i32 7
    %d = insertelement <4 x i16> %a, i16 %c, i32 3
    ret <4 x i16> %d
}

define <8 x i16> @test_q_lane0_nxv8i16(<8 x i16> %a, <vscale x 8 x i16> %b) {
; CHECK-LABEL: test_q_lane0_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.h[0], v1.h[0]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x i16> %b, i32 0
    %d = insertelement <8 x i16> %a, i16 %c, i32 0
    ret <8 x i16> %d
}

define <8 x i16> @test_q_lane7_nxv8i16(<8 x i16> %a, <vscale x 8 x i16> %b) {
; CHECK-LABEL: test_q_lane7_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.h[7], v1.h[7]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x i16> %b, i32 7
    %d = insertelement <8 x i16> %a, i16 %c, i32 7
    ret <8 x i16> %d
}

; (negative test) Extracted element is not within Vn
define <8 x i16> @test_q_lane8_nxv8i16(<8 x i16> %a, <vscale x 8 x i16> %b) {
; CHECK-LABEL: test_q_lane8_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z1.h, z1.h[8]
; CHECK-NEXT:    fmov w8, s1
; CHECK-NEXT:    mov v0.h[7], w8
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 8 x i16> %b, i32 8
    %d = insertelement <8 x i16> %a, i16 %c, i32 7
    ret <8 x i16> %d
}

; --------- extraction from nxv4f32

define <2 x float> @test_lane0_nxv4f32(<2 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: test_lane0_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.s[0], v1.s[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 4 x float> %b, i32 0
    %d = insertelement <2 x float> %a, float %c, i32 0
    ret <2 x float> %d
}

define <2 x float> @test_lane3_nxv4f32(<2 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: test_lane3_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.s[1], v1.s[3]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 4 x float> %b, i32 3
    %d = insertelement <2 x float> %a, float %c, i32 1
    ret <2 x float> %d
}

define <4 x float> @test_q_lane0_nxv4f32(<4 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: test_q_lane0_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.s[0], v1.s[0]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 4 x float> %b, i32 0
    %d = insertelement <4 x float> %a, float %c, i32 0
    ret <4 x float> %d
}

define <4 x float> @test_q_lane3_nxv4f32(<4 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: test_q_lane3_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.s[3], v1.s[3]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 4 x float> %b, i32 3
    %d = insertelement <4 x float> %a, float %c, i32 3
    ret <4 x float> %d
}

; (negative test) Extracted element is not within Vn
define <4 x float> @test_q_lane4_nxv4f32(<4 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: test_q_lane4_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z1.s, z1.s[4]
; CHECK-NEXT:    mov v0.s[3], v1.s[0]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 4 x float> %b, i32 4
    %d = insertelement <4 x float> %a, float %c, i32 3
    ret <4 x float> %d
}

; --------- extraction from nxv4i32

define <2 x i32> @test_lane0_nxv4i32(<2 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: test_lane0_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.s[0], v1.s[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 4 x i32> %b, i32 0
    %d = insertelement <2 x i32> %a, i32 %c, i32 0
    ret <2 x i32> %d
}

define <2 x i32> @test_lane3_nxv4i32(<2 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: test_lane3_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.s[1], v1.s[3]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 4 x i32> %b, i32 3
    %d = insertelement <2 x i32> %a, i32 %c, i32 1
    ret <2 x i32> %d
}

define <4 x i32> @test_q_lane0_nxv4i32(<4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: test_q_lane0_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.s[0], v1.s[0]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 4 x i32> %b, i32 0
    %d = insertelement <4 x i32> %a, i32 %c, i32 0
    ret <4 x i32> %d
}

define <4 x i32> @test_q_lane3_nxv4i32(<4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: test_q_lane3_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.s[3], v1.s[3]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 4 x i32> %b, i32 3
    %d = insertelement <4 x i32> %a, i32 %c, i32 3
    ret <4 x i32> %d
}

; (negative test) Extracted element is not within Vn
define <4 x i32> @test_q_lane4_nxv4i32(<4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: test_q_lane4_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z1.s, z1.s[4]
; CHECK-NEXT:    fmov w8, s1
; CHECK-NEXT:    mov v0.s[3], w8
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 4 x i32> %b, i32 4
    %d = insertelement <4 x i32> %a, i32 %c, i32 3
    ret <4 x i32> %d
}

; --------- extraction from nxv2f64

define <1 x double> @test_lane0_nxv2f64(<1 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: test_lane0_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.d[0], v1.d[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 2 x double> %b, i32 0
    %d = insertelement <1 x double> %a, double %c, i32 0
    ret <1 x double> %d
}

define <1 x double> @test_lane1_nxv2f64(<1 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: test_lane1_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.d[0], v1.d[1]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 2 x double> %b, i32 1
    %d = insertelement <1 x double> %a, double %c, i32 0
    ret <1 x double> %d
}

define <2 x double> @test_q_lane0_nxv2f64(<2 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: test_q_lane0_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.d[0], v1.d[0]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 2 x double> %b, i32 0
    %d = insertelement <2 x double> %a, double %c, i32 0
    ret <2 x double> %d
}

define <2 x double> @test_q_lane1_nxv2f64(<2 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: test_q_lane1_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.d[1], v1.d[1]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 2 x double> %b, i32 1
    %d = insertelement <2 x double> %a, double %c, i32 1
    ret <2 x double> %d
}

; (negative test) Extracted element is not within Vn
define <2 x double> @test_q_lane2_nxv2f64(<2 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: test_q_lane2_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z1.d, z1.d[2]
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 2 x double> %b, i32 2
    %d = insertelement <2 x double> %a, double %c, i32 1
    ret <2 x double> %d
}

; --------- extraction from nxv2i64

define <1 x i64> @test_lane0_nxv2i64(<1 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: test_lane0_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.d[0], v1.d[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 2 x i64> %b, i32 0
    %d = insertelement <1 x i64> %a, i64 %c, i32 0
    ret <1 x i64> %d
}

define <1 x i64> @test_lane1_nxv2i64(<1 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: test_lane1_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.d[0], v1.d[1]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 2 x i64> %b, i32 1
    %d = insertelement <1 x i64> %a, i64 %c, i32 0
    ret <1 x i64> %d
}

define <2 x i64> @test_q_lane0_nxv2i64(<2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: test_q_lane0_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.d[0], v1.d[0]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 2 x i64> %b, i32 0
    %d = insertelement <2 x i64> %a, i64 %c, i32 0
    ret <2 x i64> %d
}

define <2 x i64> @test_q_lane1_nxv2i64(<2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: test_q_lane1_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.d[1], v1.d[1]
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 2 x i64> %b, i32 1
    %d = insertelement <2 x i64> %a, i64 %c, i32 1
    ret <2 x i64> %d
}

; (negative test) Extracted element is not within Vn
define <2 x i64> @test_q_lane2_nxv2i64(<2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: test_q_lane2_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z1.d, z1.d[2]
; CHECK-NEXT:    fmov x8, d1
; CHECK-NEXT:    mov v0.d[1], x8
; CHECK-NEXT:    ret
    %c = extractelement <vscale x 2 x i64> %b, i32 2
    %d = insertelement <2 x i64> %a, i64 %c, i32 1
    ret <2 x i64> %d
}
