; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

;
; insertelement
;

; i8
define <4 x i8> @insertelement_v4i8(<4 x i8> %op1) {
; CHECK-LABEL: insertelement_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    index z1.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.h, p0/z, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v4i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    str w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <4 x i8> %op1, i8 5, i64 3
    ret <4 x i8> %r
}

define <8 x i8> @insertelement_v8i8(<8 x i8> %op1) {
; CHECK-LABEL: insertelement_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7 // =0x7
; CHECK-NEXT:    index z1.b, #0, #1
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    mov z2.b, w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.b, p0/z, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p0/m, w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <8 x i8> %op1, i8 5, i64 7
    ret <8 x i8> %r
}

define <16 x i8> @insertelement_v16i8(<16 x i8> %op1) {
; CHECK-LABEL: insertelement_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #15 // =0xf
; CHECK-NEXT:    index z1.b, #0, #1
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    mov z2.b, w8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.b, p0/z, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p0/m, w8
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <16 x i8> %op1, i8 5, i64 15
    ret <16 x i8> %r
}

define <32 x i8> @insertelement_v32i8(<32 x i8> %op1) {
; CHECK-LABEL: insertelement_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #15 // =0xf
; CHECK-NEXT:    index z2.b, #0, #1
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    mov z3.b, w8
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.b, p0/z, z2.b, z3.b
; CHECK-NEXT:    mov z1.b, p0/m, w8
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #48]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    str q1, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <32 x i8> %op1, i8 5, i64 31
    ret <32 x i8> %r
}

; i16
define <2 x i16> @insertelement_v2i16(<2 x i16> %op1) {
; CHECK-LABEL: insertelement_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    index z1.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.s, p0/z, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v2i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr w9, [sp]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    stp w9, w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <2 x i16> %op1, i16 5, i64 1
    ret <2 x i16> %r
}

define <4 x i16> @insertelement_v4i16(<4 x i16> %op1) {
; CHECK-LABEL: insertelement_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    index z1.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.h, p0/z, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    str w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <4 x i16> %op1, i16 5, i64 3
    ret <4 x i16> %r
}

define <8 x i16> @insertelement_v8i16(<8 x i16> %op1) {
; CHECK-LABEL: insertelement_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7 // =0x7
; CHECK-NEXT:    index z1.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.h, p0/z, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, w8
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <8 x i16> %op1, i16 5, i64 7
    ret <8 x i16> %r
}

define <16 x i16> @insertelement_v16i16(<16 x i16> %op1) {
; CHECK-LABEL: insertelement_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7 // =0x7
; CHECK-NEXT:    index z2.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z3.h, w8
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.h, p0/z, z2.h, z3.h
; CHECK-NEXT:    mov z1.h, p0/m, w8
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #48]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str q1, [sp, #16]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <16 x i16> %op1, i16 5, i64 15
    ret <16 x i16> %r
}

;i32
define <2 x i32> @insertelement_v2i32(<2 x i32> %op1) {
; CHECK-LABEL: insertelement_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    index z1.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.s, p0/z, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr w9, [sp]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    stp w9, w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <2 x i32> %op1, i32 5, i64 1
    ret <2 x i32> %r
}

define <4 x i32> @insertelement_v4i32(<4 x i32> %op1) {
; CHECK-LABEL: insertelement_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    index z1.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.s, p0/z, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, w8
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    stp w9, w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <4 x i32> %op1, i32 5, i64 3
    ret <4 x i32> %r
}

define <8 x i32> @insertelement_v8i32(ptr %a) {
; CHECK-LABEL: insertelement_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    index z0.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, z1.s
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mov z1.s, p0/m, w8
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    ldp q0, q2, [x0]
; NONEON-NOSVE-NEXT:    str w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q2, q1, [sp]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #8]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    stp w9, w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %op1 = load <8 x i32>, ptr %a
    %r = insertelement <8 x i32> %op1, i32 5, i64 7
    ret <8 x i32> %r
}

;i64
define <1 x i64> @insertelement_v1i64(<1 x i64> %op1) {
; CHECK-LABEL: insertelement_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z0.d, #5 // =0x5
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    str x8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <1 x i64> %op1, i64 5, i64 0
    ret <1 x i64> %r
}

define <2 x i64> @insertelement_v2i64(<2 x i64> %op1) {
; CHECK-LABEL: insertelement_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    index z1.d, #0, #1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z2.d, x8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.d, p0/z, z1.d, z2.d
; CHECK-NEXT:    mov z0.d, p0/m, x8
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    str x8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x9, [sp]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    stp x9, x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <2 x i64> %op1, i64 5, i64 1
    ret <2 x i64> %r
}

define <4 x i64> @insertelement_v4i64(ptr %a) {
; CHECK-LABEL: insertelement_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    index z0.d, #0, #1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z1.d, x8
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.d, p0/z, z0.d, z1.d
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mov z1.d, p0/m, x8
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    mov w8, #5 // =0x5
; NONEON-NOSVE-NEXT:    ldp q0, q2, [x0]
; NONEON-NOSVE-NEXT:    str x8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q2, q1, [sp]
; NONEON-NOSVE-NEXT:    ldr x9, [sp]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    stp x9, x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %op1 = load <4 x i64>, ptr %a
    %r = insertelement <4 x i64> %op1, i64 5, i64 3
    ret <4 x i64> %r
}

;f16
define <2 x half> @insertelement_v2f16(<2 x half> %op1) {
; CHECK-LABEL: insertelement_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov h1, #5.00000000
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    zip1 z0.h, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v2f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    adrp x8, .LCPI14_0
; NONEON-NOSVE-NEXT:    ldr h1, [sp]
; NONEON-NOSVE-NEXT:    ldr h0, [x8, :lo12:.LCPI14_0]
; NONEON-NOSVE-NEXT:    str h1, [sp, #8]
; NONEON-NOSVE-NEXT:    str h0, [sp, #10]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <2 x half> %op1, half 5.0, i64 1
    ret <2 x half> %r
}

define <4 x half> @insertelement_v4f16(<4 x half> %op1) {
; CHECK-LABEL: insertelement_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    index z1.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    cmpeq p0.h, p0/z, z1.h, z2.h
; CHECK-NEXT:    fmov h1, #5.00000000
; CHECK-NEXT:    mov z0.h, p0/m, h1
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    adrp x8, .LCPI15_0
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    ldr h1, [x8, :lo12:.LCPI15_0]
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    str h1, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    str w8, [sp, #16]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #4]
; NONEON-NOSVE-NEXT:    str h0, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #8]
; NONEON-NOSVE-NEXT:    str h0, [sp, #22]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <4 x half> %op1, half 5.0, i64 3
    ret <4 x half> %r
}

define <8 x half> @insertelement_v8f16(<8 x half> %op1) {
; CHECK-LABEL: insertelement_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7 // =0x7
; CHECK-NEXT:    index z1.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    cmpeq p0.h, p0/z, z1.h, z2.h
; CHECK-NEXT:    fmov h1, #5.00000000
; CHECK-NEXT:    mov z0.h, p0/m, h1
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    adrp x8, .LCPI16_0
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    ldr h1, [x8, :lo12:.LCPI16_0]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str h1, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #12]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    str h0, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #16]
; NONEON-NOSVE-NEXT:    str h0, [sp, #46]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <8 x half> %op1, half 5.0, i64 7
    ret <8 x half> %r
}

define <16 x half> @insertelement_v16f16(ptr %a) {
; CHECK-LABEL: insertelement_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7 // =0x7
; CHECK-NEXT:    index z0.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    fmov h2, #5.00000000
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, z1.h
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mov z1.h, p0/m, h2
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    adrp x8, .LCPI17_0
; NONEON-NOSVE-NEXT:    ldp q0, q2, [x0]
; NONEON-NOSVE-NEXT:    ldr h1, [x8, :lo12:.LCPI17_0]
; NONEON-NOSVE-NEXT:    str h1, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q2, q1, [sp]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str h1, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #16]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    str h1, [sp, #46]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %op1 = load <16 x half>, ptr %a
    %r = insertelement <16 x half> %op1, half 5.0, i64 15
    ret <16 x half> %r
}

;f32
define <2 x float> @insertelement_v2f32(<2 x float> %op1) {
; CHECK-LABEL: insertelement_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    index z1.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    cmpeq p0.s, p0/z, z1.s, z2.s
; CHECK-NEXT:    fmov s1, #5.00000000
; CHECK-NEXT:    mov z0.s, p0/m, s1
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    mov w8, #1084227584 // =0x40a00000
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr s1, [sp]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #8]
; NONEON-NOSVE-NEXT:    stp s1, s0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <2 x float> %op1, float 5.0, i64 1
    ret <2 x float> %r
}

define <4 x float> @insertelement_v4f32(<4 x float> %op1) {
; CHECK-LABEL: insertelement_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    index z1.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    cmpeq p0.s, p0/z, z1.s, z2.s
; CHECK-NEXT:    fmov s1, #5.00000000
; CHECK-NEXT:    mov z0.s, p0/m, s1
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    mov w8, #1084227584 // =0x40a00000
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr s1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #16]
; NONEON-NOSVE-NEXT:    stp s1, s0, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <4 x float> %op1, float 5.0, i64 3
    ret <4 x float> %r
}

define <8 x float> @insertelement_v8f32(ptr %a) {
; CHECK-LABEL: insertelement_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    index z0.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    fmov s2, #5.00000000
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, z1.s
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mov z1.s, p0/m, s2
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    mov w8, #1084227584 // =0x40a00000
; NONEON-NOSVE-NEXT:    ldr q1, [x0, #16]
; NONEON-NOSVE-NEXT:    str w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp]
; NONEON-NOSVE-NEXT:    ldr s1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #16]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    stp s1, s0, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %op1 = load <8 x float>, ptr %a
    %r = insertelement <8 x float> %op1, float 5.0, i64 7
    ret <8 x float> %r
}

;f64
define <1 x double> @insertelement_v1f64(<1 x double> %op1) {
; CHECK-LABEL: insertelement_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov d0, #5.00000000
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v1f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    mov x8, #4617315517961601024 // =0x4014000000000000
; NONEON-NOSVE-NEXT:    str x8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <1 x double> %op1, double 5.0, i64 0
    ret <1 x double> %r
}

define <2 x double> @insertelement_v2f64(<2 x double> %op1) {
; CHECK-LABEL: insertelement_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    index z1.d, #0, #1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z2.d, x8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    cmpeq p0.d, p0/z, z1.d, z2.d
; CHECK-NEXT:    fmov d1, #5.00000000
; CHECK-NEXT:    mov z0.d, p0/m, d1
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    mov x8, #4617315517961601024 // =0x4014000000000000
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    str x8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr d1, [sp]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #16]
; NONEON-NOSVE-NEXT:    stp d1, d0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %r = insertelement <2 x double> %op1, double 5.0, i64 1
    ret <2 x double> %r
}

define <4 x double> @insertelement_v4f64(ptr %a) {
; CHECK-LABEL: insertelement_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    index z0.d, #0, #1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z1.d, x8
; CHECK-NEXT:    fmov d2, #5.00000000
; CHECK-NEXT:    cmpeq p0.d, p0/z, z0.d, z1.d
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mov z1.d, p0/m, d2
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: insertelement_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    mov x8, #4617315517961601024 // =0x4014000000000000
; NONEON-NOSVE-NEXT:    ldr q1, [x0, #16]
; NONEON-NOSVE-NEXT:    str x8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp]
; NONEON-NOSVE-NEXT:    ldr d1, [sp]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #16]
; NONEON-NOSVE-NEXT:    stp d1, d0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
    %op1 = load <4 x double>, ptr %a
    %r = insertelement <4 x double> %op1, double 5.0, i64 3
    ret <4 x double> %r
}
