/* pocl_export.h: macros for symbol visibility

   Copyright (c) 2021 pocl developers

   Permission is hereby granted, free of charge, to any person obtaining a copy
   of this software and associated documentation files (the "Software"), to
   deal in the Software without restriction, including without limitation the
   rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
   sell copies of the Software, and to permit persons to whom the Software is
   furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
   IN THE SOFTWARE.
*/

#ifndef POCL_EXPORT_H
#define POCL_EXPORT_H

#if defined(__GNUC__) && (__GNUC__ > 4 || __GNUC__ == 4 && __GNUC_MINOR__ >= 1)
#  define POCL_EXPORT __attribute__ ((visibility ("default")))
#elif defined(_MSC_VER)
#  if defined(EXPORT_POCL_LIB)
#    define POCL_EXPORT __declspec (dllexport)
#  elif defined(IMPORT_POCL_LIB)
#    define POCL_EXPORT __declspec (dllimport)
#  else
#    define POCL_EXPORT
#  endif
#else
#  define POCL_EXPORT
#  error dont know how to define POCL_EXPORT
#endif

#endif
