/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSRule.h"

#include "CSSRule.h"
#include "CSSStyleSheet.h"
#include "JSCSSRule.h"
#include "JSCSSStyleSheet.h"
#include "KURL.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSRuleTableValues[] =
{
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleType), (intptr_t)0, NoIntrinsic },
    { "cssText", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleCssText), (intptr_t)setJSCSSRuleCssText, NoIntrinsic },
    { "parentStyleSheet", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleParentStyleSheet), (intptr_t)0, NoIntrinsic },
    { "parentRule", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleParentRule), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSRuleTable = { 17, 15, JSCSSRuleTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCSSRuleConstructorTableValues[] =
{
    { "UNKNOWN_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleUNKNOWN_RULE), (intptr_t)0, NoIntrinsic },
    { "STYLE_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleSTYLE_RULE), (intptr_t)0, NoIntrinsic },
    { "CHARSET_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleCHARSET_RULE), (intptr_t)0, NoIntrinsic },
    { "IMPORT_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleIMPORT_RULE), (intptr_t)0, NoIntrinsic },
    { "MEDIA_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleMEDIA_RULE), (intptr_t)0, NoIntrinsic },
    { "FONT_FACE_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleFONT_FACE_RULE), (intptr_t)0, NoIntrinsic },
    { "PAGE_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRulePAGE_RULE), (intptr_t)0, NoIntrinsic },
    { "WEBKIT_KEYFRAMES_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleWEBKIT_KEYFRAMES_RULE), (intptr_t)0, NoIntrinsic },
    { "WEBKIT_KEYFRAME_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleWEBKIT_KEYFRAME_RULE), (intptr_t)0, NoIntrinsic },
    { "WEBKIT_REGION_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleWEBKIT_REGION_RULE), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSRuleConstructorTable = { 34, 31, JSCSSRuleConstructorTableValues, 0 };

COMPILE_ASSERT(0 == CSSRule::UNKNOWN_RULE, CSSRuleEnumUNKNOWN_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == CSSRule::STYLE_RULE, CSSRuleEnumSTYLE_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == CSSRule::CHARSET_RULE, CSSRuleEnumCHARSET_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == CSSRule::IMPORT_RULE, CSSRuleEnumIMPORT_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == CSSRule::MEDIA_RULE, CSSRuleEnumMEDIA_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == CSSRule::FONT_FACE_RULE, CSSRuleEnumFONT_FACE_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == CSSRule::PAGE_RULE, CSSRuleEnumPAGE_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(7 == CSSRule::WEBKIT_KEYFRAMES_RULE, CSSRuleEnumWEBKIT_KEYFRAMES_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == CSSRule::WEBKIT_KEYFRAME_RULE, CSSRuleEnumWEBKIT_KEYFRAME_RULEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(16 == CSSRule::WEBKIT_REGION_RULE, CSSRuleEnumWEBKIT_REGION_RULEIsWrongUseDoNotCheckConstants);

const ClassInfo JSCSSRuleConstructor::s_info = { "CSSRuleConstructor", &Base::s_info, &JSCSSRuleConstructorTable, 0, CREATE_METHOD_TABLE(JSCSSRuleConstructor) };

JSCSSRuleConstructor::JSCSSRuleConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCSSRuleConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCSSRulePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCSSRuleConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSRuleConstructor, JSDOMWrapper>(exec, &JSCSSRuleConstructorTable, jsCast<JSCSSRuleConstructor*>(cell), propertyName, slot);
}

bool JSCSSRuleConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSRuleConstructor, JSDOMWrapper>(exec, &JSCSSRuleConstructorTable, jsCast<JSCSSRuleConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSRulePrototypeTableValues[] =
{
    { "UNKNOWN_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleUNKNOWN_RULE), (intptr_t)0, NoIntrinsic },
    { "STYLE_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleSTYLE_RULE), (intptr_t)0, NoIntrinsic },
    { "CHARSET_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleCHARSET_RULE), (intptr_t)0, NoIntrinsic },
    { "IMPORT_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleIMPORT_RULE), (intptr_t)0, NoIntrinsic },
    { "MEDIA_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleMEDIA_RULE), (intptr_t)0, NoIntrinsic },
    { "FONT_FACE_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleFONT_FACE_RULE), (intptr_t)0, NoIntrinsic },
    { "PAGE_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRulePAGE_RULE), (intptr_t)0, NoIntrinsic },
    { "WEBKIT_KEYFRAMES_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleWEBKIT_KEYFRAMES_RULE), (intptr_t)0, NoIntrinsic },
    { "WEBKIT_KEYFRAME_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleWEBKIT_KEYFRAME_RULE), (intptr_t)0, NoIntrinsic },
    { "WEBKIT_REGION_RULE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleWEBKIT_REGION_RULE), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSRulePrototypeTable = { 34, 31, JSCSSRulePrototypeTableValues, 0 };
const ClassInfo JSCSSRulePrototype::s_info = { "CSSRulePrototype", &Base::s_info, &JSCSSRulePrototypeTable, 0, CREATE_METHOD_TABLE(JSCSSRulePrototype) };

JSObject* JSCSSRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSRule>(exec, globalObject);
}

bool JSCSSRulePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSRulePrototype* thisObject = jsCast<JSCSSRulePrototype*>(cell);
    return getStaticValueSlot<JSCSSRulePrototype, JSObject>(exec, &JSCSSRulePrototypeTable, thisObject, propertyName, slot);
}

bool JSCSSRulePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSRulePrototype* thisObject = jsCast<JSCSSRulePrototype*>(object);
    return getStaticValueDescriptor<JSCSSRulePrototype, JSObject>(exec, &JSCSSRulePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSCSSRule::s_info = { "CSSRule", &Base::s_info, &JSCSSRuleTable, 0 , CREATE_METHOD_TABLE(JSCSSRule) };

JSCSSRule::JSCSSRule(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSRule> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSCSSRule::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCSSRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCSSRulePrototype::create(exec->globalData(), globalObject, JSCSSRulePrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSCSSRule::destroy(JSC::JSCell* cell)
{
    JSCSSRule* thisObject = static_cast<JSCSSRule*>(cell);
    thisObject->JSCSSRule::~JSCSSRule();
}

JSCSSRule::~JSCSSRule()
{
    releaseImplIfNotNull();
}

bool JSCSSRule::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSRule* thisObject = jsCast<JSCSSRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCSSRule, Base>(exec, &JSCSSRuleTable, thisObject, propertyName, slot);
}

bool JSCSSRule::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSRule* thisObject = jsCast<JSCSSRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCSSRule, Base>(exec, &JSCSSRuleTable, thisObject, propertyName, descriptor);
}

JSValue jsCSSRuleType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSRule* castedThis = jsCast<JSCSSRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSRule* impl = static_cast<CSSRule*>(castedThis->impl());
    JSValue result = jsNumber(impl->type());
    return result;
}


JSValue jsCSSRuleCssText(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSRule* castedThis = jsCast<JSCSSRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSRule* impl = static_cast<CSSRule*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->cssText());
    return result;
}


JSValue jsCSSRuleParentStyleSheet(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSRule* castedThis = jsCast<JSCSSRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSRule* impl = static_cast<CSSRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->parentStyleSheet()));
    return result;
}


JSValue jsCSSRuleParentRule(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSRule* castedThis = jsCast<JSCSSRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSRule* impl = static_cast<CSSRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->parentRule()));
    return result;
}


JSValue jsCSSRuleConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSRule* domObject = jsCast<JSCSSRule*>(asObject(slotBase));
    return JSCSSRule::getConstructor(exec, domObject->globalObject());
}

void JSCSSRule::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSCSSRule* thisObject = jsCast<JSCSSRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSCSSRule, Base>(exec, propertyName, value, &JSCSSRuleTable, thisObject, slot);
}

void setJSCSSRuleCssText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCSSRule* castedThis = jsCast<JSCSSRule*>(thisObject);
    CSSRule* impl = static_cast<CSSRule*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setCssText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


JSValue JSCSSRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSRuleConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsCSSRuleUNKNOWN_RULE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsCSSRuleSTYLE_RULE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsCSSRuleCHARSET_RULE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsCSSRuleIMPORT_RULE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsCSSRuleMEDIA_RULE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsCSSRuleFONT_FACE_RULE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(5));
}

JSValue jsCSSRulePAGE_RULE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(6));
}

JSValue jsCSSRuleWEBKIT_KEYFRAMES_RULE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(7));
}

JSValue jsCSSRuleWEBKIT_KEYFRAME_RULE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(8));
}

JSValue jsCSSRuleWEBKIT_REGION_RULE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(16));
}

static inline bool isObservable(JSCSSRule* jsCSSRule)
{
    if (jsCSSRule->hasCustomProperties())
        return true;
    return false;
}

bool JSCSSRuleOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSCSSRule* jsCSSRule = jsCast<JSCSSRule*>(handle.get().asCell());
    if (!isObservable(jsCSSRule))
        return false;
    void* root = WebCore::root(jsCSSRule->impl());
    return visitor.containsOpaqueRoot(root);
}

void JSCSSRuleOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSCSSRule* jsCSSRule = jsCast<JSCSSRule*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCSSRule->impl(), jsCSSRule);
    jsCSSRule->releaseImpl();
}

CSSRule* toCSSRule(JSC::JSValue value)
{
    return value.inherits(&JSCSSRule::s_info) ? jsCast<JSCSSRule*>(asObject(value))->impl() : 0;
}

}
