/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLFramebuffer.h"

#include "WebGLFramebuffer.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebGLFramebufferTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLFramebufferConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLFramebufferTable = { 2, 1, JSWebGLFramebufferTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebGLFramebufferConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLFramebufferConstructorTable = { 1, 0, JSWebGLFramebufferConstructorTableValues, 0 };
const ClassInfo JSWebGLFramebufferConstructor::s_info = { "WebGLFramebufferConstructor", &Base::s_info, &JSWebGLFramebufferConstructorTable, 0, CREATE_METHOD_TABLE(JSWebGLFramebufferConstructor) };

JSWebGLFramebufferConstructor::JSWebGLFramebufferConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebGLFramebufferConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebGLFramebufferPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebGLFramebufferConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLFramebufferConstructor, JSDOMWrapper>(exec, &JSWebGLFramebufferConstructorTable, jsCast<JSWebGLFramebufferConstructor*>(cell), propertyName, slot);
}

bool JSWebGLFramebufferConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLFramebufferConstructor, JSDOMWrapper>(exec, &JSWebGLFramebufferConstructorTable, jsCast<JSWebGLFramebufferConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebGLFramebufferPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLFramebufferPrototypeTable = { 1, 0, JSWebGLFramebufferPrototypeTableValues, 0 };
const ClassInfo JSWebGLFramebufferPrototype::s_info = { "WebGLFramebufferPrototype", &Base::s_info, &JSWebGLFramebufferPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebGLFramebufferPrototype) };

JSObject* JSWebGLFramebufferPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLFramebuffer>(exec, globalObject);
}

const ClassInfo JSWebGLFramebuffer::s_info = { "WebGLFramebuffer", &Base::s_info, &JSWebGLFramebufferTable, 0 , CREATE_METHOD_TABLE(JSWebGLFramebuffer) };

JSWebGLFramebuffer::JSWebGLFramebuffer(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLFramebuffer> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebGLFramebuffer::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLFramebuffer::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLFramebufferPrototype::create(exec->globalData(), globalObject, JSWebGLFramebufferPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSWebGLFramebuffer::destroy(JSC::JSCell* cell)
{
    JSWebGLFramebuffer* thisObject = static_cast<JSWebGLFramebuffer*>(cell);
    thisObject->JSWebGLFramebuffer::~JSWebGLFramebuffer();
}

JSWebGLFramebuffer::~JSWebGLFramebuffer()
{
    releaseImplIfNotNull();
}

bool JSWebGLFramebuffer::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebGLFramebuffer* thisObject = jsCast<JSWebGLFramebuffer*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebGLFramebuffer, Base>(exec, &JSWebGLFramebufferTable, thisObject, propertyName, slot);
}

bool JSWebGLFramebuffer::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebGLFramebuffer* thisObject = jsCast<JSWebGLFramebuffer*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebGLFramebuffer, Base>(exec, &JSWebGLFramebufferTable, thisObject, propertyName, descriptor);
}

JSValue jsWebGLFramebufferConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLFramebuffer* domObject = jsCast<JSWebGLFramebuffer*>(asObject(slotBase));
    return JSWebGLFramebuffer::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebGLFramebuffer::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLFramebufferConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSWebGLFramebuffer* jsWebGLFramebuffer)
{
    if (jsWebGLFramebuffer->hasCustomProperties())
        return true;
    return false;
}

bool JSWebGLFramebufferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebGLFramebuffer* jsWebGLFramebuffer = jsCast<JSWebGLFramebuffer*>(handle.get().asCell());
    if (!isObservable(jsWebGLFramebuffer))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLFramebufferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebGLFramebuffer* jsWebGLFramebuffer = jsCast<JSWebGLFramebuffer*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLFramebuffer->impl(), jsWebGLFramebuffer);
    jsWebGLFramebuffer->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLFramebuffer* impl)
{
    return wrap<JSWebGLFramebuffer>(exec, globalObject, impl);
}

WebGLFramebuffer* toWebGLFramebuffer(JSC::JSValue value)
{
    return value.inherits(&JSWebGLFramebuffer::s_info) ? jsCast<JSWebGLFramebuffer*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
