/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDOMMimeType.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMMimeTypePrivate.h"
#include "WebKitDOMDOMPluginPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_DOM_MIME_TYPE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_DOM_MIME_TYPE, WebKitDOMDOMMimeTypePrivate)

typedef struct _WebKitDOMDOMMimeTypePrivate {
    RefPtr<WebCore::DOMMimeType> coreObject;
} WebKitDOMDOMMimeTypePrivate;

namespace WebKit {

WebKitDOMDOMMimeType* kit(WebCore::DOMMimeType* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DOM_MIME_TYPE(ret);

    return wrapDOMMimeType(obj);
}

WebCore::DOMMimeType* core(WebKitDOMDOMMimeType* request)
{
    return request ? static_cast<WebCore::DOMMimeType*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDOMMimeType* wrapDOMMimeType(WebCore::DOMMimeType* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOM_MIME_TYPE(g_object_new(WEBKIT_TYPE_DOM_DOM_MIME_TYPE, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMDOMMimeType, webkit_dom_dom_mime_type, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_TYPE,
    PROP_SUFFIXES,
    PROP_DESCRIPTION,
    PROP_ENABLED_PLUGIN,
};

static void webkit_dom_dom_mime_type_finalize(GObject* object)
{
    WebKitDOMDOMMimeTypePrivate* priv = WEBKIT_DOM_DOM_MIME_TYPE_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMDOMMimeTypePrivate();
    G_OBJECT_CLASS(webkit_dom_dom_mime_type_parent_class)->finalize(object);
}

static void webkit_dom_dom_mime_type_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDOMMimeType* self = WEBKIT_DOM_DOM_MIME_TYPE(object);
    WebCore::DOMMimeType* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->type()));
        break;
    }
    case PROP_SUFFIXES: {
        g_value_take_string(value, convertToUTF8String(coreSelf->suffixes()));
        break;
    }
    case PROP_DESCRIPTION: {
        g_value_take_string(value, convertToUTF8String(coreSelf->description()));
        break;
    }
    case PROP_ENABLED_PLUGIN: {
        RefPtr<WebCore::DOMPlugin> ptr = coreSelf->enabledPlugin();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_dom_mime_type_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_dom_mime_type_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMDOMMimeTypePrivate* priv = WEBKIT_DOM_DOM_MIME_TYPE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::DOMMimeType*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_dom_mime_type_class_init(WebKitDOMDOMMimeTypeClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMDOMMimeTypePrivate));
    gobjectClass->constructor = webkit_dom_dom_mime_type_constructor;
    gobjectClass->finalize = webkit_dom_dom_mime_type_finalize;
    gobjectClass->get_property = webkit_dom_dom_mime_type_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "dom_mime_type_type", /* short description */
                                                           "read-only  gchar* DOMMimeType.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SUFFIXES,
                                    g_param_spec_string("suffixes", /* name */
                                                           "dom_mime_type_suffixes", /* short description */
                                                           "read-only  gchar* DOMMimeType.suffixes", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DESCRIPTION,
                                    g_param_spec_string("description", /* name */
                                                           "dom_mime_type_description", /* short description */
                                                           "read-only  gchar* DOMMimeType.description", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ENABLED_PLUGIN,
                                    g_param_spec_object("enabled-plugin", /* name */
                                                           "dom_mime_type_enabled-plugin", /* short description */
                                                           "read-only  WebKitDOMDOMPlugin* DOMMimeType.enabled-plugin", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_PLUGIN, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_dom_mime_type_init(WebKitDOMDOMMimeType* request)
{
    WebKitDOMDOMMimeTypePrivate* priv = WEBKIT_DOM_DOM_MIME_TYPE_GET_PRIVATE(request);
    new (priv) WebKitDOMDOMMimeTypePrivate();
}

gchar*
webkit_dom_dom_mime_type_get_suffixes(WebKitDOMDOMMimeType* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_MIME_TYPE(self), 0);
    WebCore::DOMMimeType* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->suffixes());
    return result;
}

gchar*
webkit_dom_dom_mime_type_get_description(WebKitDOMDOMMimeType* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_MIME_TYPE(self), 0);
    WebCore::DOMMimeType* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->description());
    return result;
}

WebKitDOMDOMPlugin*
webkit_dom_dom_mime_type_get_enabled_plugin(WebKitDOMDOMMimeType* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_MIME_TYPE(self), 0);
    WebCore::DOMMimeType* item = WebKit::core(self);
    RefPtr<WebCore::DOMPlugin> gobjectResult = WTF::getPtr(item->enabledPlugin());
    return WebKit::kit(gobjectResult.get());
}

