/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLFormElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLCollectionPrivate.h"
#include "WebKitDOMHTMLFormElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLFormElement* kit(WebCore::HTMLFormElement* obj)
{
    return WEBKIT_DOM_HTML_FORM_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLFormElement* core(WebKitDOMHTMLFormElement* request)
{
    return request ? static_cast<WebCore::HTMLFormElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLFormElement* wrapHTMLFormElement(WebCore::HTMLFormElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_FORM_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_FORM_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLFormElement, webkit_dom_html_form_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_ACCEPT_CHARSET,
    PROP_ACTION,
    PROP_AUTOCOMPLETE,
    PROP_ENCTYPE,
    PROP_ENCODING,
    PROP_METHOD,
    PROP_NAME,
    PROP_NO_VALIDATE,
    PROP_TARGET,
    PROP_ELEMENTS,
    PROP_LENGTH,
};

static void webkit_dom_html_form_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLFormElement* self = WEBKIT_DOM_HTML_FORM_ELEMENT(object);
    WebCore::HTMLFormElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ACCEPT_CHARSET: {
        coreSelf->setAttribute(WebCore::HTMLNames::accept_charsetAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ACTION: {
        coreSelf->setAttribute(WebCore::HTMLNames::actionAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_AUTOCOMPLETE: {
        coreSelf->setAttribute(WebCore::HTMLNames::autocompleteAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ENCTYPE: {
        coreSelf->setEnctype(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ENCODING: {
        coreSelf->setEncoding(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_METHOD: {
        coreSelf->setMethod(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NO_VALIDATE: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::novalidateAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_TARGET: {
        coreSelf->setAttribute(WebCore::HTMLNames::targetAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_form_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLFormElement* self = WEBKIT_DOM_HTML_FORM_ELEMENT(object);
    WebCore::HTMLFormElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ACCEPT_CHARSET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::accept_charsetAttr)));
        break;
    }
    case PROP_ACTION: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::actionAttr)));
        break;
    }
    case PROP_AUTOCOMPLETE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::autocompleteAttr)));
        break;
    }
    case PROP_ENCTYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->enctype()));
        break;
    }
    case PROP_ENCODING: {
        g_value_take_string(value, convertToUTF8String(coreSelf->encoding()));
        break;
    }
    case PROP_METHOD: {
        g_value_take_string(value, convertToUTF8String(coreSelf->method()));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_NO_VALIDATE: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::novalidateAttr));
        break;
    }
    case PROP_TARGET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::targetAttr)));
        break;
    }
    case PROP_ELEMENTS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->elements();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_LENGTH: {
        g_value_set_long(value, coreSelf->length());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_form_element_class_init(WebKitDOMHTMLFormElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_form_element_set_property;
    gobjectClass->get_property = webkit_dom_html_form_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ACCEPT_CHARSET,
                                    g_param_spec_string("accept-charset", /* name */
                                                           "html_form_element_accept-charset", /* short description */
                                                           "read-write  gchar* HTMLFormElement.accept-charset", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ACTION,
                                    g_param_spec_string("action", /* name */
                                                           "html_form_element_action", /* short description */
                                                           "read-write  gchar* HTMLFormElement.action", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_AUTOCOMPLETE,
                                    g_param_spec_string("autocomplete", /* name */
                                                           "html_form_element_autocomplete", /* short description */
                                                           "read-write  gchar* HTMLFormElement.autocomplete", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ENCTYPE,
                                    g_param_spec_string("enctype", /* name */
                                                           "html_form_element_enctype", /* short description */
                                                           "read-write  gchar* HTMLFormElement.enctype", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ENCODING,
                                    g_param_spec_string("encoding", /* name */
                                                           "html_form_element_encoding", /* short description */
                                                           "read-write  gchar* HTMLFormElement.encoding", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_METHOD,
                                    g_param_spec_string("method", /* name */
                                                           "html_form_element_method", /* short description */
                                                           "read-write  gchar* HTMLFormElement.method", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_form_element_name", /* short description */
                                                           "read-write  gchar* HTMLFormElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NO_VALIDATE,
                                    g_param_spec_boolean("no-validate", /* name */
                                                           "html_form_element_no-validate", /* short description */
                                                           "read-write  gboolean HTMLFormElement.no-validate", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TARGET,
                                    g_param_spec_string("target", /* name */
                                                           "html_form_element_target", /* short description */
                                                           "read-write  gchar* HTMLFormElement.target", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ELEMENTS,
                                    g_param_spec_object("elements", /* name */
                                                           "html_form_element_elements", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* HTMLFormElement.elements", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_long("length", /* name */
                                                           "html_form_element_length", /* short description */
                                                           "read-only  glong HTMLFormElement.length", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_form_element_init(WebKitDOMHTMLFormElement* request)
{
}

void
webkit_dom_html_form_element_submit(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self));
    WebCore::HTMLFormElement* item = WebKit::core(self);
    item->submit();
}

void
webkit_dom_html_form_element_reset(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self));
    WebCore::HTMLFormElement* item = WebKit::core(self);
    item->reset();
}

gboolean
webkit_dom_html_form_element_check_validity(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self), FALSE);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    gboolean result = item->checkValidity();
    return result;
}

gchar*
webkit_dom_html_form_element_get_accept_charset(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self), 0);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::accept_charsetAttr));
    return result;
}

void
webkit_dom_html_form_element_set_accept_charset(WebKitDOMHTMLFormElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::accept_charsetAttr, convertedValue);
}

gchar*
webkit_dom_html_form_element_get_action(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self), 0);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::actionAttr));
    return result;
}

void
webkit_dom_html_form_element_set_action(WebKitDOMHTMLFormElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::actionAttr, convertedValue);
}

gchar*
webkit_dom_html_form_element_get_autocomplete(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self), 0);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::autocompleteAttr));
    return result;
}

void
webkit_dom_html_form_element_set_autocomplete(WebKitDOMHTMLFormElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::autocompleteAttr, convertedValue);
}

gchar*
webkit_dom_html_form_element_get_enctype(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self), 0);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->enctype());
    return result;
}

void
webkit_dom_html_form_element_set_enctype(WebKitDOMHTMLFormElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setEnctype(convertedValue);
}

gchar*
webkit_dom_html_form_element_get_encoding(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self), 0);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->encoding());
    return result;
}

void
webkit_dom_html_form_element_set_encoding(WebKitDOMHTMLFormElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setEncoding(convertedValue);
}

gchar*
webkit_dom_html_form_element_get_method(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self), 0);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->method());
    return result;
}

void
webkit_dom_html_form_element_set_method(WebKitDOMHTMLFormElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setMethod(convertedValue);
}

gchar*
webkit_dom_html_form_element_get_name(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self), 0);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_form_element_set_name(WebKitDOMHTMLFormElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gboolean
webkit_dom_html_form_element_get_no_validate(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self), FALSE);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::novalidateAttr);
    return result;
}

void
webkit_dom_html_form_element_set_no_validate(WebKitDOMHTMLFormElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self));
    WebCore::HTMLFormElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::novalidateAttr, value);
}

gchar*
webkit_dom_html_form_element_get_target(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self), 0);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::targetAttr));
    return result;
}

void
webkit_dom_html_form_element_set_target(WebKitDOMHTMLFormElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::targetAttr, convertedValue);
}

WebKitDOMHTMLCollection*
webkit_dom_html_form_element_get_elements(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self), 0);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->elements());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_html_form_element_get_length(WebKitDOMHTMLFormElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FORM_ELEMENT(self), 0);
    WebCore::HTMLFormElement* item = WebKit::core(self);
    glong result = item->length();
    return result;
}

