/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMWebKitNamedFlow.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "GObjectEventListener.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMEventTarget.h"
#include "WebKitDOMNodeListPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMWebKitNamedFlowPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_WEBKIT_NAMED_FLOW_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_WEBKIT_NAMED_FLOW, WebKitDOMWebKitNamedFlowPrivate)

typedef struct _WebKitDOMWebKitNamedFlowPrivate {
    RefPtr<WebCore::WebKitNamedFlow> coreObject;
} WebKitDOMWebKitNamedFlowPrivate;

namespace WebKit {

WebKitDOMWebKitNamedFlow* kit(WebCore::WebKitNamedFlow* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_WEBKIT_NAMED_FLOW(ret);

    return wrapWebKitNamedFlow(obj);
}

WebCore::WebKitNamedFlow* core(WebKitDOMWebKitNamedFlow* request)
{
    return request ? static_cast<WebCore::WebKitNamedFlow*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMWebKitNamedFlow* wrapWebKitNamedFlow(WebCore::WebKitNamedFlow* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_WEBKIT_NAMED_FLOW(g_object_new(WEBKIT_TYPE_DOM_WEBKIT_NAMED_FLOW, "core-object", coreObject, NULL));
}

} // namespace WebKit

static void webkit_dom_webkit_named_flow_dispatch_event(WebKitDOMEventTarget* target, WebKitDOMEvent* event, GError** error)
{
    WebCore::Event* coreEvent = WebKit::core(event);
    WebCore::WebKitNamedFlow* coreTarget = static_cast<WebCore::WebKitNamedFlow*>(WEBKIT_DOM_OBJECT(target)->coreObject);

    WebCore::ExceptionCode ec = 0;
    coreTarget->dispatchEvent(coreEvent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription description(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), description.code, description.name);
    }
}

static gboolean webkit_dom_webkit_named_flow_add_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble, gpointer userData)
{
    WebCore::WebKitNamedFlow* coreTarget = static_cast<WebCore::WebKitNamedFlow*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::addEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble, userData);
}

static gboolean webkit_dom_webkit_named_flow_remove_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble)
{
    WebCore::WebKitNamedFlow* coreTarget = static_cast<WebCore::WebKitNamedFlow*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::removeEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble);
}

static void webkit_dom_event_target_init(WebKitDOMEventTargetIface* iface)
{
    iface->dispatch_event = webkit_dom_webkit_named_flow_dispatch_event;
    iface->add_event_listener = webkit_dom_webkit_named_flow_add_event_listener;
    iface->remove_event_listener = webkit_dom_webkit_named_flow_remove_event_listener;
}

G_DEFINE_TYPE_WITH_CODE(WebKitDOMWebKitNamedFlow, webkit_dom_webkit_named_flow, WEBKIT_TYPE_DOM_OBJECT, G_IMPLEMENT_INTERFACE(WEBKIT_TYPE_DOM_EVENT_TARGET, webkit_dom_event_target_init))

enum {
    PROP_0,
    PROP_NAME,
    PROP_OVERSET,
    PROP_FIRST_EMPTY_REGION_INDEX,
};

static void webkit_dom_webkit_named_flow_finalize(GObject* object)
{
    WebKitDOMWebKitNamedFlowPrivate* priv = WEBKIT_DOM_WEBKIT_NAMED_FLOW_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMWebKitNamedFlowPrivate();
    G_OBJECT_CLASS(webkit_dom_webkit_named_flow_parent_class)->finalize(object);
}

static void webkit_dom_webkit_named_flow_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMWebKitNamedFlow* self = WEBKIT_DOM_WEBKIT_NAMED_FLOW(object);
    WebCore::WebKitNamedFlow* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->name()));
        break;
    }
    case PROP_OVERSET: {
        g_value_set_boolean(value, coreSelf->overset());
        break;
    }
    case PROP_FIRST_EMPTY_REGION_INDEX: {
        g_value_set_long(value, coreSelf->firstEmptyRegionIndex());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_webkit_named_flow_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_webkit_named_flow_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMWebKitNamedFlowPrivate* priv = WEBKIT_DOM_WEBKIT_NAMED_FLOW_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::WebKitNamedFlow*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_webkit_named_flow_class_init(WebKitDOMWebKitNamedFlowClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMWebKitNamedFlowPrivate));
    gobjectClass->constructor = webkit_dom_webkit_named_flow_constructor;
    gobjectClass->finalize = webkit_dom_webkit_named_flow_finalize;
    gobjectClass->get_property = webkit_dom_webkit_named_flow_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "web_kit_named_flow_name", /* short description */
                                                           "read-only  gchar* WebKitNamedFlow.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OVERSET,
                                    g_param_spec_boolean("overset", /* name */
                                                           "web_kit_named_flow_overset", /* short description */
                                                           "read-only  gboolean WebKitNamedFlow.overset", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FIRST_EMPTY_REGION_INDEX,
                                    g_param_spec_long("first-empty-region-index", /* name */
                                                           "web_kit_named_flow_first-empty-region-index", /* short description */
                                                           "read-only  glong WebKitNamedFlow.first-empty-region-index", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_webkit_named_flow_init(WebKitDOMWebKitNamedFlow* request)
{
    WebKitDOMWebKitNamedFlowPrivate* priv = WEBKIT_DOM_WEBKIT_NAMED_FLOW_GET_PRIVATE(request);
    new (priv) WebKitDOMWebKitNamedFlowPrivate();
}

WebKitDOMNodeList*
webkit_dom_webkit_named_flow_get_regions_by_content(WebKitDOMWebKitNamedFlow* self, WebKitDOMNode* contentNode)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_WEBKIT_NAMED_FLOW(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(contentNode), 0);
    WebCore::WebKitNamedFlow* item = WebKit::core(self);
    WebCore::Node* convertedContentNode = WebKit::core(contentNode);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getRegionsByContent(convertedContentNode));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNodeList*
webkit_dom_webkit_named_flow_get_regions(WebKitDOMWebKitNamedFlow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_WEBKIT_NAMED_FLOW(self), 0);
    WebCore::WebKitNamedFlow* item = WebKit::core(self);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getRegions());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNodeList*
webkit_dom_webkit_named_flow_get_content(WebKitDOMWebKitNamedFlow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_WEBKIT_NAMED_FLOW(self), 0);
    WebCore::WebKitNamedFlow* item = WebKit::core(self);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->getContent());
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_webkit_named_flow_dispatch_event(WebKitDOMWebKitNamedFlow* self, WebKitDOMEvent* event, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_WEBKIT_NAMED_FLOW(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(event), FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::WebKitNamedFlow* item = WebKit::core(self);
    WebCore::Event* convertedEvent = WebKit::core(event);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->dispatchEvent(convertedEvent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

gchar*
webkit_dom_webkit_named_flow_get_name(WebKitDOMWebKitNamedFlow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_WEBKIT_NAMED_FLOW(self), 0);
    WebCore::WebKitNamedFlow* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->name());
    return result;
}

gboolean
webkit_dom_webkit_named_flow_get_overset(WebKitDOMWebKitNamedFlow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_WEBKIT_NAMED_FLOW(self), FALSE);
    WebCore::WebKitNamedFlow* item = WebKit::core(self);
    gboolean result = item->overset();
    return result;
}

glong
webkit_dom_webkit_named_flow_get_first_empty_region_index(WebKitDOMWebKitNamedFlow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_WEBKIT_NAMED_FLOW(self), 0);
    WebCore::WebKitNamedFlow* item = WebKit::core(self);
    glong result = item->firstEmptyRegionIndex();
    return result;
}

