/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSScreen.h"

#include "Screen.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSScreenTableValues[] =
{
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenHeight), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenWidth), (intptr_t)0, NoIntrinsic },
    { "colorDepth", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenColorDepth), (intptr_t)0, NoIntrinsic },
    { "pixelDepth", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenPixelDepth), (intptr_t)0, NoIntrinsic },
    { "availLeft", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenAvailLeft), (intptr_t)0, NoIntrinsic },
    { "availTop", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenAvailTop), (intptr_t)0, NoIntrinsic },
    { "availHeight", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenAvailHeight), (intptr_t)0, NoIntrinsic },
    { "availWidth", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScreenAvailWidth), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSScreenTable = { 18, 15, JSScreenTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSScreenPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSScreenPrototypeTable = { 1, 0, JSScreenPrototypeTableValues, 0 };
const ClassInfo JSScreenPrototype::s_info = { "ScreenPrototype", &Base::s_info, &JSScreenPrototypeTable, 0, CREATE_METHOD_TABLE(JSScreenPrototype) };

JSObject* JSScreenPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSScreen>(exec, globalObject);
}

const ClassInfo JSScreen::s_info = { "Screen", &Base::s_info, &JSScreenTable, 0 , CREATE_METHOD_TABLE(JSScreen) };

JSScreen::JSScreen(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Screen> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSScreen::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSScreen::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSScreenPrototype::create(exec->globalData(), globalObject, JSScreenPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSScreen::destroy(JSC::JSCell* cell)
{
    JSScreen* thisObject = static_cast<JSScreen*>(cell);
    thisObject->JSScreen::~JSScreen();
}

JSScreen::~JSScreen()
{
    releaseImplIfNotNull();
}

bool JSScreen::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSScreen* thisObject = jsCast<JSScreen*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSScreen, Base>(exec, &JSScreenTable, thisObject, propertyName, slot);
}

bool JSScreen::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSScreen* thisObject = jsCast<JSScreen*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSScreen, Base>(exec, &JSScreenTable, thisObject, propertyName, descriptor);
}

JSValue jsScreenHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScreen* castedThis = jsCast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* impl = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(impl->height());
    return result;
}


JSValue jsScreenWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScreen* castedThis = jsCast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* impl = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(impl->width());
    return result;
}


JSValue jsScreenColorDepth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScreen* castedThis = jsCast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* impl = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(impl->colorDepth());
    return result;
}


JSValue jsScreenPixelDepth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScreen* castedThis = jsCast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* impl = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(impl->pixelDepth());
    return result;
}


JSValue jsScreenAvailLeft(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScreen* castedThis = jsCast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* impl = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(impl->availLeft());
    return result;
}


JSValue jsScreenAvailTop(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScreen* castedThis = jsCast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* impl = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(impl->availTop());
    return result;
}


JSValue jsScreenAvailHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScreen* castedThis = jsCast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* impl = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(impl->availHeight());
    return result;
}


JSValue jsScreenAvailWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScreen* castedThis = jsCast<JSScreen*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Screen* impl = static_cast<Screen*>(castedThis->impl());
    JSValue result = jsNumber(impl->availWidth());
    return result;
}


static inline bool isObservable(JSScreen* jsScreen)
{
    if (jsScreen->hasCustomProperties())
        return true;
    return false;
}

bool JSScreenOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSScreen* jsScreen = jsCast<JSScreen*>(handle.get().asCell());
    if (!isObservable(jsScreen))
        return false;
    Frame* root = jsScreen->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSScreenOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSScreen* jsScreen = jsCast<JSScreen*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsScreen->impl(), jsScreen);
    jsScreen->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Screen* impl)
{
    return wrap<JSScreen>(exec, globalObject, impl);
}

Screen* toScreen(JSC::JSValue value)
{
    return value.inherits(&JSScreen::s_info) ? jsCast<JSScreen*>(asObject(value))->impl() : 0;
}

}
