/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDOMStringMap.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMStringMapPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_DOM_STRING_MAP_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_DOM_STRING_MAP, WebKitDOMDOMStringMapPrivate)

typedef struct _WebKitDOMDOMStringMapPrivate {
    RefPtr<WebCore::DOMStringMap> coreObject;
} WebKitDOMDOMStringMapPrivate;

namespace WebKit {

WebKitDOMDOMStringMap* kit(WebCore::DOMStringMap* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DOM_STRING_MAP(ret);

    return wrapDOMStringMap(obj);
}

WebCore::DOMStringMap* core(WebKitDOMDOMStringMap* request)
{
    return request ? static_cast<WebCore::DOMStringMap*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDOMStringMap* wrapDOMStringMap(WebCore::DOMStringMap* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOM_STRING_MAP(g_object_new(WEBKIT_TYPE_DOM_DOM_STRING_MAP, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMDOMStringMap, webkit_dom_dom_string_map, WEBKIT_TYPE_DOM_OBJECT)

static void webkit_dom_dom_string_map_finalize(GObject* object)
{
    WebKitDOMDOMStringMapPrivate* priv = WEBKIT_DOM_DOM_STRING_MAP_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMDOMStringMapPrivate();
    G_OBJECT_CLASS(webkit_dom_dom_string_map_parent_class)->finalize(object);
}

static GObject* webkit_dom_dom_string_map_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_dom_string_map_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMDOMStringMapPrivate* priv = WEBKIT_DOM_DOM_STRING_MAP_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::DOMStringMap*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_dom_string_map_class_init(WebKitDOMDOMStringMapClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMDOMStringMapPrivate));
    gobjectClass->constructor = webkit_dom_dom_string_map_constructor;
    gobjectClass->finalize = webkit_dom_dom_string_map_finalize;
}

static void webkit_dom_dom_string_map_init(WebKitDOMDOMStringMap* request)
{
    WebKitDOMDOMStringMapPrivate* priv = WEBKIT_DOM_DOM_STRING_MAP_GET_PRIVATE(request);
    new (priv) WebKitDOMDOMStringMapPrivate();
}

