/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLModElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLModElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLModElement* kit(WebCore::HTMLModElement* obj)
{
    return WEBKIT_DOM_HTML_MOD_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLModElement* core(WebKitDOMHTMLModElement* request)
{
    return request ? static_cast<WebCore::HTMLModElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLModElement* wrapHTMLModElement(WebCore::HTMLModElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_MOD_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_MOD_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLModElement, webkit_dom_html_mod_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_CITE,
    PROP_DATE_TIME,
};

static void webkit_dom_html_mod_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLModElement* self = WEBKIT_DOM_HTML_MOD_ELEMENT(object);
    WebCore::HTMLModElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_CITE: {
        coreSelf->setAttribute(WebCore::HTMLNames::citeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DATE_TIME: {
        coreSelf->setAttribute(WebCore::HTMLNames::datetimeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_mod_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLModElement* self = WEBKIT_DOM_HTML_MOD_ELEMENT(object);
    WebCore::HTMLModElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_CITE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::citeAttr)));
        break;
    }
    case PROP_DATE_TIME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::datetimeAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_mod_element_class_init(WebKitDOMHTMLModElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_mod_element_set_property;
    gobjectClass->get_property = webkit_dom_html_mod_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_CITE,
                                    g_param_spec_string("cite", /* name */
                                                           "html_mod_element_cite", /* short description */
                                                           "read-write  gchar* HTMLModElement.cite", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DATE_TIME,
                                    g_param_spec_string("date-time", /* name */
                                                           "html_mod_element_date-time", /* short description */
                                                           "read-write  gchar* HTMLModElement.date-time", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_mod_element_init(WebKitDOMHTMLModElement* request)
{
}

gchar*
webkit_dom_html_mod_element_get_cite(WebKitDOMHTMLModElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MOD_ELEMENT(self), 0);
    WebCore::HTMLModElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::citeAttr));
    return result;
}

void
webkit_dom_html_mod_element_set_cite(WebKitDOMHTMLModElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MOD_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLModElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::citeAttr, convertedValue);
}

gchar*
webkit_dom_html_mod_element_get_date_time(WebKitDOMHTMLModElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_MOD_ELEMENT(self), 0);
    WebCore::HTMLModElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::datetimeAttr));
    return result;
}

void
webkit_dom_html_mod_element_set_date_time(WebKitDOMHTMLModElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_MOD_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLModElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::datetimeAttr, convertedValue);
}

