/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WORKERS)

#include "JSWorkerContext.h"

#include "DOMFileSystemSync.h"
#include "Database.h"
#include "DatabaseSync.h"
#include "EntrySync.h"
#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSArrayBuffer.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSDataView.h"
#include "JSDatabaseCallback.h"
#include "JSEntryCallback.h"
#include "JSErrorCallback.h"
#include "JSErrorHandler.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSEventSource.h"
#include "JSFileReader.h"
#include "JSFileReaderSync.h"
#include "JSFileSystemCallback.h"
#include "JSFloat32Array.h"
#include "JSFloat64Array.h"
#include "JSInt16Array.h"
#include "JSInt32Array.h"
#include "JSInt8Array.h"
#include "JSMessageChannel.h"
#include "JSMessageEvent.h"
#include "JSUint16Array.h"
#include "JSUint32Array.h"
#include "JSUint8Array.h"
#include "JSWorkerContext.h"
#include "JSWorkerLocation.h"
#include "JSWorkerNavigator.h"
#include "JSXMLHttpRequest.h"
#include "WorkerContext.h"
#include "WorkerContextFileSystem.h"
#include "WorkerContextIndexedDatabase.h"
#include "WorkerContextWebDatabase.h"
#include "WorkerLocation.h"
#include "WorkerNavigator.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

#if ENABLE(BLOB)
#include "JSDOMURL.h"
#endif

#if ENABLE(FILE_SYSTEM)
#include "JSDOMFileSystemSync.h"
#include "JSEntrySync.h"
#include "JSFileError.h"
#include "JSFileException.h"
#endif

#if ENABLE(INDEXED_DATABASE)
#include "IDBFactory.h"
#include "JSIDBCursor.h"
#include "JSIDBCursorWithValue.h"
#include "JSIDBDatabase.h"
#include "JSIDBFactory.h"
#include "JSIDBIndex.h"
#include "JSIDBKeyRange.h"
#include "JSIDBObjectStore.h"
#include "JSIDBOpenDBRequest.h"
#include "JSIDBRequest.h"
#include "JSIDBTransaction.h"
#include "JSIDBVersionChangeEvent.h"
#endif

#if ENABLE(SQL_DATABASE)
#include "JSDatabase.h"
#include "JSDatabaseSync.h"
#endif

#if ENABLE(WEB_SOCKETS)
#include "JSWebSocket.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWorkerContextTableValues[] =
{
    { "self", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextSelf), (intptr_t)setJSWorkerContextSelf, NoIntrinsic },
    { "location", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextLocation), (intptr_t)setJSWorkerContextLocation, NoIntrinsic },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextOnerror), (intptr_t)setJSWorkerContextOnerror, NoIntrinsic },
    { "navigator", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextNavigator), (intptr_t)setJSWorkerContextNavigator, NoIntrinsic },
    { "MessageEvent", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextMessageEventConstructor), (intptr_t)setJSWorkerContextMessageEventConstructor, NoIntrinsic },
    { "WorkerLocation", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextWorkerLocationConstructor), (intptr_t)setJSWorkerContextWorkerLocationConstructor, NoIntrinsic },
    { "MessageChannel", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextMessageChannelConstructor), (intptr_t)setJSWorkerContextMessageChannelConstructor, NoIntrinsic },
    { "EventSource", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextEventSourceConstructor), (intptr_t)setJSWorkerContextEventSourceConstructor, NoIntrinsic },
    { "XMLHttpRequest", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextXMLHttpRequestConstructor), (intptr_t)setJSWorkerContextXMLHttpRequestConstructor, NoIntrinsic },
    { "Blob", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextBlobConstructor), (intptr_t)setJSWorkerContextBlobConstructor, NoIntrinsic },
    { "FileReader", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextFileReaderConstructor), (intptr_t)setJSWorkerContextFileReaderConstructor, NoIntrinsic },
    { "FileReaderSync", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextFileReaderSyncConstructor), (intptr_t)setJSWorkerContextFileReaderSyncConstructor, NoIntrinsic },
#if ENABLE(BLOB)
    { "URL", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextURLConstructor), (intptr_t)setJSWorkerContextURLConstructor, NoIntrinsic },
#endif
#if ENABLE(BLOB)
    { "webkitURL", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextWebkitURLConstructor), (intptr_t)setJSWorkerContextWebkitURLConstructor, NoIntrinsic },
#endif
    { "ArrayBuffer", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextArrayBufferConstructor), (intptr_t)setJSWorkerContextArrayBufferConstructor, NoIntrinsic },
    { "Int8Array", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextInt8ArrayConstructor), (intptr_t)setJSWorkerContextInt8ArrayConstructor, NoIntrinsic },
    { "Uint8Array", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextUint8ArrayConstructor), (intptr_t)setJSWorkerContextUint8ArrayConstructor, NoIntrinsic },
    { "Uint8ClampedArray", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextUint8ClampedArrayConstructor), (intptr_t)setJSWorkerContextUint8ClampedArrayConstructor, NoIntrinsic },
    { "Int16Array", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextInt16ArrayConstructor), (intptr_t)setJSWorkerContextInt16ArrayConstructor, NoIntrinsic },
    { "Uint16Array", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextUint16ArrayConstructor), (intptr_t)setJSWorkerContextUint16ArrayConstructor, NoIntrinsic },
    { "Int32Array", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextInt32ArrayConstructor), (intptr_t)setJSWorkerContextInt32ArrayConstructor, NoIntrinsic },
    { "Uint32Array", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextUint32ArrayConstructor), (intptr_t)setJSWorkerContextUint32ArrayConstructor, NoIntrinsic },
    { "Float32Array", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextFloat32ArrayConstructor), (intptr_t)setJSWorkerContextFloat32ArrayConstructor, NoIntrinsic },
    { "Float64Array", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextFloat64ArrayConstructor), (intptr_t)setJSWorkerContextFloat64ArrayConstructor, NoIntrinsic },
    { "DataView", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextDataViewConstructor), (intptr_t)setJSWorkerContextDataViewConstructor, NoIntrinsic },
#if ENABLE(FILE_SYSTEM)
    { "FileError", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextFileErrorConstructor), (intptr_t)setJSWorkerContextFileErrorConstructor, NoIntrinsic },
#endif
#if ENABLE(FILE_SYSTEM)
    { "FileException", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextFileExceptionConstructor), (intptr_t)setJSWorkerContextFileExceptionConstructor, NoIntrinsic },
#endif
#if ENABLE(WEB_SOCKETS)
    { "WebSocket", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextWebSocketConstructor), (intptr_t)setJSWorkerContextWebSocketConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIndexedDB", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextWebkitIndexedDB), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBCursor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextWebkitIDBCursorConstructor), (intptr_t)setJSWorkerContextWebkitIDBCursorConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBDatabase", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextWebkitIDBDatabaseConstructor), (intptr_t)setJSWorkerContextWebkitIDBDatabaseConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBFactory", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextWebkitIDBFactoryConstructor), (intptr_t)setJSWorkerContextWebkitIDBFactoryConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBIndex", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextWebkitIDBIndexConstructor), (intptr_t)setJSWorkerContextWebkitIDBIndexConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBKeyRange", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextWebkitIDBKeyRangeConstructor), (intptr_t)setJSWorkerContextWebkitIDBKeyRangeConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBObjectStore", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextWebkitIDBObjectStoreConstructor), (intptr_t)setJSWorkerContextWebkitIDBObjectStoreConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBRequest", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextWebkitIDBRequestConstructor), (intptr_t)setJSWorkerContextWebkitIDBRequestConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIDBTransaction", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextWebkitIDBTransactionConstructor), (intptr_t)setJSWorkerContextWebkitIDBTransactionConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "indexedDB", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextIndexedDB), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBCursor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextIDBCursorConstructor), (intptr_t)setJSWorkerContextIDBCursorConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBCursorWithValue", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextIDBCursorWithValueConstructor), (intptr_t)setJSWorkerContextIDBCursorWithValueConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBDatabase", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextIDBDatabaseConstructor), (intptr_t)setJSWorkerContextIDBDatabaseConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBFactory", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextIDBFactoryConstructor), (intptr_t)setJSWorkerContextIDBFactoryConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBIndex", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextIDBIndexConstructor), (intptr_t)setJSWorkerContextIDBIndexConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBKeyRange", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextIDBKeyRangeConstructor), (intptr_t)setJSWorkerContextIDBKeyRangeConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBObjectStore", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextIDBObjectStoreConstructor), (intptr_t)setJSWorkerContextIDBObjectStoreConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBOpenDBRequest", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextIDBOpenDBRequestConstructor), (intptr_t)setJSWorkerContextIDBOpenDBRequestConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBRequest", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextIDBRequestConstructor), (intptr_t)setJSWorkerContextIDBRequestConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBTransaction", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextIDBTransactionConstructor), (intptr_t)setJSWorkerContextIDBTransactionConstructor, NoIntrinsic },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBVersionChangeEvent", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextIDBVersionChangeEventConstructor), (intptr_t)setJSWorkerContextIDBVersionChangeEventConstructor, NoIntrinsic },
#endif
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWorkerContextTable = { 137, 127, JSWorkerContextTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSWorkerContextPrototypeTableValues[] =
{
#if ENABLE(FILE_SYSTEM)
    { "TEMPORARY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextTEMPORARY), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(FILE_SYSTEM)
    { "PERSISTENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerContextPERSISTENT), (intptr_t)0, NoIntrinsic },
#endif
    { "close", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionClose), (intptr_t)0, NoIntrinsic },
    { "importScripts", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionImportScripts), (intptr_t)0, NoIntrinsic },
    { "setTimeout", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionSetTimeout), (intptr_t)2, NoIntrinsic },
    { "clearTimeout", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionClearTimeout), (intptr_t)1, NoIntrinsic },
    { "setInterval", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionSetInterval), (intptr_t)2, NoIntrinsic },
    { "clearInterval", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionClearInterval), (intptr_t)1, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionAddEventListener), (intptr_t)3, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionRemoveEventListener), (intptr_t)3, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
#if ENABLE(FILE_SYSTEM)
    { "webkitRequestFileSystem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionWebkitRequestFileSystem), (intptr_t)4, NoIntrinsic },
#endif
#if ENABLE(FILE_SYSTEM)
    { "webkitRequestFileSystemSync", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionWebkitRequestFileSystemSync), (intptr_t)2, NoIntrinsic },
#endif
#if ENABLE(FILE_SYSTEM)
    { "webkitResolveLocalFileSystemURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionWebkitResolveLocalFileSystemURL), (intptr_t)3, NoIntrinsic },
#endif
#if ENABLE(FILE_SYSTEM)
    { "webkitResolveLocalFileSystemSyncURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionWebkitResolveLocalFileSystemSyncURL), (intptr_t)1, NoIntrinsic },
#endif
#if ENABLE(SQL_DATABASE)
    { "openDatabase", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionOpenDatabase), (intptr_t)5, NoIntrinsic },
#endif
#if ENABLE(SQL_DATABASE)
    { "openDatabaseSync", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWorkerContextPrototypeFunctionOpenDatabaseSync), (intptr_t)5, NoIntrinsic },
#endif
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWorkerContextPrototypeTable = { 68, 63, JSWorkerContextPrototypeTableValues, 0 };
static const HashTable* getJSWorkerContextPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWorkerContextPrototypeTable);
}

const ClassInfo JSWorkerContextPrototype::s_info = { "WorkerContextPrototype", &Base::s_info, 0, getJSWorkerContextPrototypeTable, CREATE_METHOD_TABLE(JSWorkerContextPrototype) };

bool JSWorkerContextPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWorkerContextPrototype* thisObject = jsCast<JSWorkerContextPrototype*>(cell);
    return getStaticPropertySlot<JSWorkerContextPrototype, JSObject>(exec, getJSWorkerContextPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSWorkerContextPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWorkerContextPrototype* thisObject = jsCast<JSWorkerContextPrototype*>(object);
    return getStaticPropertyDescriptor<JSWorkerContextPrototype, JSObject>(exec, getJSWorkerContextPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSWorkerContextTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWorkerContextTable);
}

const ClassInfo JSWorkerContext::s_info = { "WorkerContext", &Base::s_info, 0, getJSWorkerContextTable , CREATE_METHOD_TABLE(JSWorkerContext) };

JSWorkerContext::JSWorkerContext(JSGlobalData& globalData, Structure* structure, PassRefPtr<WorkerContext> impl)
    : JSWorkerContextBase(globalData, structure, impl)
{
}

bool JSWorkerContext::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWorkerContext* thisObject = jsCast<JSWorkerContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSWorkerContext, Base>(exec, getJSWorkerContextTable(exec), thisObject, propertyName, slot);
}

bool JSWorkerContext::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWorkerContext* thisObject = jsCast<JSWorkerContext*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->getOwnPropertyDescriptorDelegate(exec, propertyName, descriptor))
        return true;
    return getStaticValueDescriptor<JSWorkerContext, Base>(exec, getJSWorkerContextTable(exec), thisObject, propertyName, descriptor);
}

bool JSWorkerContext::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSWorkerContext* thisObject = jsCast<JSWorkerContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    PropertyName propertyName = Identifier::from(exec, index);
    if (thisObject->getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsWorkerContextSelf(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->self()));
    return result;
}


JSValue jsWorkerContextLocation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->location()));
    return result;
}


JSValue jsWorkerContextOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsWorkerContextNavigator(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->navigator()));
    return result;
}


JSValue jsWorkerContextMessageEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSMessageEvent::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextWorkerLocationConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSWorkerLocation::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextMessageChannelConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return castedThis->messageChannel(exec);
}


JSValue jsWorkerContextEventSourceConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return castedThis->eventSource(exec);
}


JSValue jsWorkerContextXMLHttpRequestConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return castedThis->xmlHttpRequest(exec);
}


JSValue jsWorkerContextBlobConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSBlob::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextFileReaderConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSFileReader::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextFileReaderSyncConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSFileReaderSync::getConstructor(exec, castedThis->globalObject());
}


#if ENABLE(BLOB)
JSValue jsWorkerContextURLConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSDOMURL::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(BLOB)
JSValue jsWorkerContextWebkitURLConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSDOMURL::getConstructor(exec, castedThis->globalObject());
}

#endif

JSValue jsWorkerContextArrayBufferConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSArrayBuffer::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextInt8ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSInt8Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextUint8ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSUint8Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextUint8ClampedArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSUint8Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextInt16ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSInt16Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextUint16ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSUint16Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextInt32ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSInt32Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextUint32ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSUint32Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextFloat32ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSFloat32Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextFloat64ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSFloat64Array::getConstructor(exec, castedThis->globalObject());
}


JSValue jsWorkerContextDataViewConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSDataView::getConstructor(exec, castedThis->globalObject());
}


#if ENABLE(FILE_SYSTEM)
JSValue jsWorkerContextFileErrorConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSFileError::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(FILE_SYSTEM)
JSValue jsWorkerContextFileExceptionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSFileException::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(WEB_SOCKETS)
JSValue jsWorkerContextWebSocketConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return castedThis->webSocket(exec);
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextWebkitIndexedDB(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerContextIndexedDatabase::indexedDB(impl)));
    return result;
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextWebkitIDBCursorConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBCursor::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextWebkitIDBDatabaseConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBDatabase::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextWebkitIDBFactoryConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBFactory::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextWebkitIDBIndexConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBIndex::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextWebkitIDBKeyRangeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBKeyRange::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextWebkitIDBObjectStoreConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBObjectStore::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextWebkitIDBRequestConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBRequest::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextWebkitIDBTransactionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBTransaction::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextIndexedDB(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerContextIndexedDatabase::indexedDB(impl)));
    return result;
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextIDBCursorConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBCursor::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextIDBCursorWithValueConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBCursorWithValue::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextIDBDatabaseConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBDatabase::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextIDBFactoryConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBFactory::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextIDBIndexConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBIndex::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextIDBKeyRangeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBKeyRange::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextIDBObjectStoreConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBObjectStore::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextIDBOpenDBRequestConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBOpenDBRequest::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextIDBRequestConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBRequest::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextIDBTransactionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBTransaction::getConstructor(exec, castedThis->globalObject());
}

#endif

#if ENABLE(INDEXED_DATABASE)
JSValue jsWorkerContextIDBVersionChangeEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(asObject(slotBase));
    return JSIDBVersionChangeEvent::getConstructor(exec, castedThis->globalObject());
}

#endif

void JSWorkerContext::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSWorkerContext* thisObject = jsCast<JSWorkerContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSWorkerContext, Base>(exec, propertyName, value, getJSWorkerContextTable(exec), thisObject, slot);
}

void setJSWorkerContextSelf(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in object
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "self"), value);
}


void setJSWorkerContextLocation(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in object
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "location"), value);
}


void setJSWorkerContextOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSWorkerContext* castedThis = jsCast<JSWorkerContext*>(thisObject);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    impl->setOnerror(createJSErrorHandler(exec, value, thisObject));
}


void setJSWorkerContextNavigator(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in object
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "navigator"), value);
}


void setJSWorkerContextMessageEventConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "MessageEvent"), value);
}


void setJSWorkerContextWorkerLocationConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "WorkerLocation"), value);
}


void setJSWorkerContextMessageChannelConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "MessageChannel"), value);
}


void setJSWorkerContextEventSourceConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "EventSource"), value);
}


void setJSWorkerContextXMLHttpRequestConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "XMLHttpRequest"), value);
}


void setJSWorkerContextBlobConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "Blob"), value);
}


void setJSWorkerContextFileReaderConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "FileReader"), value);
}


void setJSWorkerContextFileReaderSyncConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "FileReaderSync"), value);
}


#if ENABLE(BLOB)
void setJSWorkerContextURLConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "URL"), value);
}

#endif

#if ENABLE(BLOB)
void setJSWorkerContextWebkitURLConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "webkitURL"), value);
}

#endif

void setJSWorkerContextArrayBufferConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "ArrayBuffer"), value);
}


void setJSWorkerContextInt8ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "Int8Array"), value);
}


void setJSWorkerContextUint8ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "Uint8Array"), value);
}


void setJSWorkerContextUint8ClampedArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "Uint8ClampedArray"), value);
}


void setJSWorkerContextInt16ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "Int16Array"), value);
}


void setJSWorkerContextUint16ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "Uint16Array"), value);
}


void setJSWorkerContextInt32ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "Int32Array"), value);
}


void setJSWorkerContextUint32ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "Uint32Array"), value);
}


void setJSWorkerContextFloat32ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "Float32Array"), value);
}


void setJSWorkerContextFloat64ArrayConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "Float64Array"), value);
}


void setJSWorkerContextDataViewConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "DataView"), value);
}


#if ENABLE(FILE_SYSTEM)
void setJSWorkerContextFileErrorConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "FileError"), value);
}

#endif

#if ENABLE(FILE_SYSTEM)
void setJSWorkerContextFileExceptionConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "FileException"), value);
}

#endif

#if ENABLE(WEB_SOCKETS)
void setJSWorkerContextWebSocketConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "WebSocket"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextWebkitIDBCursorConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "webkitIDBCursor"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextWebkitIDBDatabaseConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "webkitIDBDatabase"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextWebkitIDBFactoryConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "webkitIDBFactory"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextWebkitIDBIndexConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "webkitIDBIndex"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextWebkitIDBKeyRangeConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "webkitIDBKeyRange"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextWebkitIDBObjectStoreConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "webkitIDBObjectStore"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextWebkitIDBRequestConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "webkitIDBRequest"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextWebkitIDBTransactionConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "webkitIDBTransaction"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextIDBCursorConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "IDBCursor"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextIDBCursorWithValueConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "IDBCursorWithValue"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextIDBDatabaseConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "IDBDatabase"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextIDBFactoryConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "IDBFactory"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextIDBIndexConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "IDBIndex"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextIDBKeyRangeConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "IDBKeyRange"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextIDBObjectStoreConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "IDBObjectStore"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextIDBOpenDBRequestConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "IDBOpenDBRequest"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextIDBRequestConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "IDBRequest"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextIDBTransactionConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "IDBTransaction"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE)
void setJSWorkerContextIDBVersionChangeEventConstructor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    // Shadowing a built-in constructor
    jsCast<JSWorkerContext*>(thisObject)->putDirect(exec->globalData(), Identifier(exec, "IDBVersionChangeEvent"), value);
}

#endif

EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionClose(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    impl->close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionImportScripts(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    return JSValue::encode(castedThis->importScripts(exec));
}

EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionSetTimeout(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    return JSValue::encode(castedThis->setTimeout(exec));
}

EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionClearTimeout(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    int handle(exec->argument(0).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->clearTimeout(handle);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionSetInterval(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    return JSValue::encode(castedThis->setInterval(exec));
}

EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionClearInterval(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    int handle(exec->argument(0).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->clearInterval(handle);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#if ENABLE(FILE_SYSTEM)
EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionWebkitRequestFileSystem(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned short type(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    long long size(static_cast<long long>(exec->argument(1).toInteger(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<FileSystemCallback> successCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        successCallback = JSFileSystemCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 3 && !exec->argument(3).isUndefinedOrNull()) {
        if (!exec->argument(3).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSErrorCallback::create(asObject(exec->argument(3)), castedThis->globalObject());
    }
    WorkerContextFileSystem::webkitRequestFileSystem(impl, type, size, successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(FILE_SYSTEM)
EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionWebkitRequestFileSystemSync(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned short type(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    long long size(static_cast<long long>(exec->argument(1).toInteger(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerContextFileSystem::webkitRequestFileSystemSync(impl, type, size, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#endif

#if ENABLE(FILE_SYSTEM)
EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionWebkitResolveLocalFileSystemURL(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (exec->argumentCount() <= 1 || !exec->argument(1).isFunction())
        return throwVMTypeError(exec);
    RefPtr<EntryCallback> successCallback = JSEntryCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSErrorCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    WorkerContextFileSystem::webkitResolveLocalFileSystemURL(impl, url, successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(FILE_SYSTEM)
EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionWebkitResolveLocalFileSystemSyncURL(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerContextFileSystem::webkitResolveLocalFileSystemSyncURL(impl, url, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#endif

#if ENABLE(SQL_DATABASE)
EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionOpenDatabase(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    if (exec->argumentCount() < 4)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& version(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& displayName(exec->argument(2).isEmpty() ? String() : exec->argument(2).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned estimatedSize(exec->argument(3).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<DatabaseCallback> creationCallback;
    if (exec->argumentCount() > 4 && !exec->argument(4).isUndefinedOrNull()) {
        if (!exec->argument(4).isFunction())
            return throwVMTypeError(exec);
        creationCallback = JSDatabaseCallback::create(asObject(exec->argument(4)), castedThis->globalObject());
    }

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerContextWebDatabase::openDatabase(impl, name, version, displayName, estimatedSize, creationCallback, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#endif

#if ENABLE(SQL_DATABASE)
EncodedJSValue JSC_HOST_CALL jsWorkerContextPrototypeFunctionOpenDatabaseSync(ExecState* exec)
{
    JSWorkerContext* castedThis = toJSWorkerContext(exec->hostThisValue().toThisObject(exec));
    if (!castedThis)
        return throwVMTypeError(exec);
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWorkerContext::s_info);
    WorkerContext* impl = static_cast<WorkerContext*>(castedThis->impl());
    if (exec->argumentCount() < 4)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& version(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& displayName(exec->argument(2).isEmpty() ? String() : exec->argument(2).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned estimatedSize(exec->argument(3).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<DatabaseCallback> creationCallback;
    if (exec->argumentCount() > 4 && !exec->argument(4).isUndefinedOrNull()) {
        if (!exec->argument(4).isFunction())
            return throwVMTypeError(exec);
        creationCallback = JSDatabaseCallback::create(asObject(exec->argument(4)), castedThis->globalObject());
    }

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(WorkerContextWebDatabase::openDatabaseSync(impl, name, version, displayName, estimatedSize, creationCallback, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#endif

// Constant getters

#if ENABLE(FILE_SYSTEM)
JSValue jsWorkerContextTEMPORARY(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

#endif
#if ENABLE(FILE_SYSTEM)
JSValue jsWorkerContextPERSISTENT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

#endif

}

#endif // ENABLE(WORKERS)
