/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLScriptElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLScriptElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLScriptElement* kit(WebCore::HTMLScriptElement* obj)
{
    return WEBKIT_DOM_HTML_SCRIPT_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLScriptElement* core(WebKitDOMHTMLScriptElement* request)
{
    return request ? static_cast<WebCore::HTMLScriptElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLScriptElement* wrapHTMLScriptElement(WebCore::HTMLScriptElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_SCRIPT_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_SCRIPT_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLScriptElement, webkit_dom_html_script_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_TEXT,
    PROP_HTML_FOR,
    PROP_EVENT,
    PROP_CHARSET,
    PROP_ASYNC,
    PROP_DEFER,
    PROP_SRC,
    PROP_TYPE,
    PROP_CROSS_ORIGIN,
    PROP_NONCE,
};

static void webkit_dom_html_script_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLScriptElement* self = WEBKIT_DOM_HTML_SCRIPT_ELEMENT(object);
    WebCore::HTMLScriptElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_TEXT: {
        coreSelf->setText(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HTML_FOR: {
        coreSelf->setAttribute(WebCore::HTMLNames::forAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_EVENT: {
        coreSelf->setAttribute(WebCore::HTMLNames::eventAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CHARSET: {
        coreSelf->setAttribute(WebCore::HTMLNames::charsetAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ASYNC: {
        coreSelf->setAsync((g_value_get_boolean(value)));
        break;
    }
    case PROP_DEFER: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::deferAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_SRC: {
        coreSelf->setAttribute(WebCore::HTMLNames::srcAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TYPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::typeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CROSS_ORIGIN: {
        coreSelf->setAttribute(WebCore::HTMLNames::crossoriginAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NONCE: {
#if ENABLE(CSP_NEXT)
        coreSelf->setAttribute(WebCore::HTMLNames::nonceAttr, WTF::String::fromUTF8(g_value_get_string(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
#endif /* ENABLE(CSP_NEXT) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_script_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLScriptElement* self = WEBKIT_DOM_HTML_SCRIPT_ELEMENT(object);
    WebCore::HTMLScriptElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_TEXT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->text()));
        break;
    }
    case PROP_HTML_FOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::forAttr)));
        break;
    }
    case PROP_EVENT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::eventAttr)));
        break;
    }
    case PROP_CHARSET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::charsetAttr)));
        break;
    }
    case PROP_ASYNC: {
        g_value_set_boolean(value, coreSelf->async());
        break;
    }
    case PROP_DEFER: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::deferAttr));
        break;
    }
    case PROP_SRC: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::srcAttr)));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::typeAttr)));
        break;
    }
    case PROP_CROSS_ORIGIN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::crossoriginAttr)));
        break;
    }
    case PROP_NONCE: {
#if ENABLE(CSP_NEXT)
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::nonceAttr)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
#endif /* ENABLE(CSP_NEXT) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_script_element_class_init(WebKitDOMHTMLScriptElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_script_element_set_property;
    gobjectClass->get_property = webkit_dom_html_script_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_TEXT,
                                    g_param_spec_string("text", /* name */
                                                           "html_script_element_text", /* short description */
                                                           "read-write  gchar* HTMLScriptElement.text", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HTML_FOR,
                                    g_param_spec_string("html-for", /* name */
                                                           "html_script_element_html-for", /* short description */
                                                           "read-write  gchar* HTMLScriptElement.html-for", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_EVENT,
                                    g_param_spec_string("event", /* name */
                                                           "html_script_element_event", /* short description */
                                                           "read-write  gchar* HTMLScriptElement.event", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CHARSET,
                                    g_param_spec_string("charset", /* name */
                                                           "html_script_element_charset", /* short description */
                                                           "read-write  gchar* HTMLScriptElement.charset", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ASYNC,
                                    g_param_spec_boolean("async", /* name */
                                                           "html_script_element_async", /* short description */
                                                           "read-write  gboolean HTMLScriptElement.async", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DEFER,
                                    g_param_spec_boolean("defer", /* name */
                                                           "html_script_element_defer", /* short description */
                                                           "read-write  gboolean HTMLScriptElement.defer", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SRC,
                                    g_param_spec_string("src", /* name */
                                                           "html_script_element_src", /* short description */
                                                           "read-write  gchar* HTMLScriptElement.src", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_script_element_type", /* short description */
                                                           "read-write  gchar* HTMLScriptElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CROSS_ORIGIN,
                                    g_param_spec_string("cross-origin", /* name */
                                                           "html_script_element_cross-origin", /* short description */
                                                           "read-write  gchar* HTMLScriptElement.cross-origin", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NONCE,
                                    g_param_spec_string("nonce", /* name */
                                                           "html_script_element_nonce", /* short description */
                                                           "read-write  gchar* HTMLScriptElement.nonce", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_script_element_init(WebKitDOMHTMLScriptElement* request)
{
}

gchar*
webkit_dom_html_script_element_get_text(WebKitDOMHTMLScriptElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self), 0);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->text());
    return result;
}

void
webkit_dom_html_script_element_set_text(WebKitDOMHTMLScriptElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setText(convertedValue);
}

gchar*
webkit_dom_html_script_element_get_html_for(WebKitDOMHTMLScriptElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self), 0);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::forAttr));
    return result;
}

void
webkit_dom_html_script_element_set_html_for(WebKitDOMHTMLScriptElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::forAttr, convertedValue);
}

gchar*
webkit_dom_html_script_element_get_event(WebKitDOMHTMLScriptElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self), 0);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::eventAttr));
    return result;
}

void
webkit_dom_html_script_element_set_event(WebKitDOMHTMLScriptElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::eventAttr, convertedValue);
}

gchar*
webkit_dom_html_script_element_get_charset(WebKitDOMHTMLScriptElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self), 0);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::charsetAttr));
    return result;
}

void
webkit_dom_html_script_element_set_charset(WebKitDOMHTMLScriptElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::charsetAttr, convertedValue);
}

gboolean
webkit_dom_html_script_element_get_async(WebKitDOMHTMLScriptElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self), FALSE);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    gboolean result = item->async();
    return result;
}

void
webkit_dom_html_script_element_set_async(WebKitDOMHTMLScriptElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self));
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    item->setAsync(value);
}

gboolean
webkit_dom_html_script_element_get_defer(WebKitDOMHTMLScriptElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self), FALSE);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::deferAttr);
    return result;
}

void
webkit_dom_html_script_element_set_defer(WebKitDOMHTMLScriptElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self));
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::deferAttr, value);
}

gchar*
webkit_dom_html_script_element_get_src(WebKitDOMHTMLScriptElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self), 0);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}

void
webkit_dom_html_script_element_set_src(WebKitDOMHTMLScriptElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::srcAttr, convertedValue);
}

gchar*
webkit_dom_html_script_element_get_cross_origin(WebKitDOMHTMLScriptElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self), 0);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::crossoriginAttr));
    return result;
}

void
webkit_dom_html_script_element_set_cross_origin(WebKitDOMHTMLScriptElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::crossoriginAttr, convertedValue);
}

gchar*
webkit_dom_html_script_element_get_nonce(WebKitDOMHTMLScriptElement* self)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self), 0);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::nonceAttr));
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
    return 0;
#endif /* ENABLE(CSP_NEXT) */
}

void
webkit_dom_html_script_element_set_nonce(WebKitDOMHTMLScriptElement* self, const gchar* value)
{
#if ENABLE(CSP_NEXT)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_SCRIPT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLScriptElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nonceAttr, convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Csp Next")
#endif /* ENABLE(CSP_NEXT) */
}

