/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMNavigator.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "NavigatorContentUtils.h"
#include "NavigatorGamepad.h"
#include "NavigatorGeolocation.h"
#include "WebKitDOMDOMMimeTypeArrayPrivate.h"
#include "WebKitDOMDOMPluginArrayPrivate.h"
#include "WebKitDOMGamepadListPrivate.h"
#include "WebKitDOMGeolocationPrivate.h"
#include "WebKitDOMNavigatorPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_NAVIGATOR_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_NAVIGATOR, WebKitDOMNavigatorPrivate)

typedef struct _WebKitDOMNavigatorPrivate {
    RefPtr<WebCore::Navigator> coreObject;
} WebKitDOMNavigatorPrivate;

namespace WebKit {

WebKitDOMNavigator* kit(WebCore::Navigator* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_NAVIGATOR(ret);

    return wrapNavigator(obj);
}

WebCore::Navigator* core(WebKitDOMNavigator* request)
{
    return request ? static_cast<WebCore::Navigator*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMNavigator* wrapNavigator(WebCore::Navigator* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_NAVIGATOR(g_object_new(WEBKIT_TYPE_DOM_NAVIGATOR, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMNavigator, webkit_dom_navigator, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_APP_CODE_NAME,
    PROP_APP_NAME,
    PROP_APP_VERSION,
    PROP_LANGUAGE,
    PROP_USER_AGENT,
    PROP_PLATFORM,
    PROP_PLUGINS,
    PROP_MIME_TYPES,
    PROP_PRODUCT,
    PROP_PRODUCT_SUB,
    PROP_VENDOR,
    PROP_VENDOR_SUB,
    PROP_COOKIE_ENABLED,
    PROP_ON_LINE,
    PROP_GEOLOCATION,
};

static void webkit_dom_navigator_finalize(GObject* object)
{
    WebKitDOMNavigatorPrivate* priv = WEBKIT_DOM_NAVIGATOR_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMNavigatorPrivate();
    G_OBJECT_CLASS(webkit_dom_navigator_parent_class)->finalize(object);
}

static void webkit_dom_navigator_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMNavigator* self = WEBKIT_DOM_NAVIGATOR(object);
    WebCore::Navigator* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_APP_CODE_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->appCodeName()));
        break;
    }
    case PROP_APP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->appName()));
        break;
    }
    case PROP_APP_VERSION: {
        g_value_take_string(value, convertToUTF8String(coreSelf->appVersion()));
        break;
    }
    case PROP_LANGUAGE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->language()));
        break;
    }
    case PROP_USER_AGENT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->userAgent()));
        break;
    }
    case PROP_PLATFORM: {
        g_value_take_string(value, convertToUTF8String(coreSelf->platform()));
        break;
    }
    case PROP_PLUGINS: {
        RefPtr<WebCore::DOMPluginArray> ptr = coreSelf->plugins();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_MIME_TYPES: {
        RefPtr<WebCore::DOMMimeTypeArray> ptr = coreSelf->mimeTypes();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_PRODUCT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->product()));
        break;
    }
    case PROP_PRODUCT_SUB: {
        g_value_take_string(value, convertToUTF8String(coreSelf->productSub()));
        break;
    }
    case PROP_VENDOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->vendor()));
        break;
    }
    case PROP_VENDOR_SUB: {
        g_value_take_string(value, convertToUTF8String(coreSelf->vendorSub()));
        break;
    }
    case PROP_COOKIE_ENABLED: {
        g_value_set_boolean(value, coreSelf->cookieEnabled());
        break;
    }
    case PROP_ON_LINE: {
        g_value_set_boolean(value, coreSelf->onLine());
        break;
    }
    case PROP_GEOLOCATION: {
#if ENABLE(GEOLOCATION)
        RefPtr<WebCore::Geolocation> ptr = WebCore::NavigatorGeolocation::geolocation(coreSelf);
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Geolocation")
#endif /* ENABLE(GEOLOCATION) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_navigator_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_navigator_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMNavigatorPrivate* priv = WEBKIT_DOM_NAVIGATOR_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::Navigator*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_navigator_class_init(WebKitDOMNavigatorClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMNavigatorPrivate));
    gobjectClass->constructor = webkit_dom_navigator_constructor;
    gobjectClass->finalize = webkit_dom_navigator_finalize;
    gobjectClass->get_property = webkit_dom_navigator_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_APP_CODE_NAME,
                                    g_param_spec_string("app-code-name", /* name */
                                                           "navigator_app-code-name", /* short description */
                                                           "read-only  gchar* Navigator.app-code-name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_APP_NAME,
                                    g_param_spec_string("app-name", /* name */
                                                           "navigator_app-name", /* short description */
                                                           "read-only  gchar* Navigator.app-name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_APP_VERSION,
                                    g_param_spec_string("app-version", /* name */
                                                           "navigator_app-version", /* short description */
                                                           "read-only  gchar* Navigator.app-version", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LANGUAGE,
                                    g_param_spec_string("language", /* name */
                                                           "navigator_language", /* short description */
                                                           "read-only  gchar* Navigator.language", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_USER_AGENT,
                                    g_param_spec_string("user-agent", /* name */
                                                           "navigator_user-agent", /* short description */
                                                           "read-only  gchar* Navigator.user-agent", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PLATFORM,
                                    g_param_spec_string("platform", /* name */
                                                           "navigator_platform", /* short description */
                                                           "read-only  gchar* Navigator.platform", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PLUGINS,
                                    g_param_spec_object("plugins", /* name */
                                                           "navigator_plugins", /* short description */
                                                           "read-only  WebKitDOMDOMPluginArray* Navigator.plugins", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_PLUGIN_ARRAY, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MIME_TYPES,
                                    g_param_spec_object("mime-types", /* name */
                                                           "navigator_mime-types", /* short description */
                                                           "read-only  WebKitDOMDOMMimeTypeArray* Navigator.mime-types", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_MIME_TYPE_ARRAY, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PRODUCT,
                                    g_param_spec_string("product", /* name */
                                                           "navigator_product", /* short description */
                                                           "read-only  gchar* Navigator.product", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PRODUCT_SUB,
                                    g_param_spec_string("product-sub", /* name */
                                                           "navigator_product-sub", /* short description */
                                                           "read-only  gchar* Navigator.product-sub", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VENDOR,
                                    g_param_spec_string("vendor", /* name */
                                                           "navigator_vendor", /* short description */
                                                           "read-only  gchar* Navigator.vendor", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VENDOR_SUB,
                                    g_param_spec_string("vendor-sub", /* name */
                                                           "navigator_vendor-sub", /* short description */
                                                           "read-only  gchar* Navigator.vendor-sub", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_COOKIE_ENABLED,
                                    g_param_spec_boolean("cookie-enabled", /* name */
                                                           "navigator_cookie-enabled", /* short description */
                                                           "read-only  gboolean Navigator.cookie-enabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ON_LINE,
                                    g_param_spec_boolean("on-line", /* name */
                                                           "navigator_on-line", /* short description */
                                                           "read-only  gboolean Navigator.on-line", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_GEOLOCATION,
                                    g_param_spec_object("geolocation", /* name */
                                                           "navigator_geolocation", /* short description */
                                                           "read-only  WebKitDOMGeolocation* Navigator.geolocation", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_GEOLOCATION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_navigator_init(WebKitDOMNavigator* request)
{
    WebKitDOMNavigatorPrivate* priv = WEBKIT_DOM_NAVIGATOR_GET_PRIVATE(request);
    new (priv) WebKitDOMNavigatorPrivate();
}

gboolean
webkit_dom_navigator_java_enabled(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), FALSE);
    WebCore::Navigator* item = WebKit::core(self);
    gboolean result = item->javaEnabled();
    return result;
}

void
webkit_dom_navigator_get_storage_updates(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self));
    WebCore::Navigator* item = WebKit::core(self);
    item->getStorageUpdates();
}

void
webkit_dom_navigator_register_protocol_handler(WebKitDOMNavigator* self, const gchar* scheme, const gchar* url, const gchar* title, GError** error)
{
#if ENABLE(NAVIGATOR_CONTENT_UTILS)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self));
    g_return_if_fail(scheme);
    g_return_if_fail(url);
    g_return_if_fail(title);
    g_return_if_fail(!error || !*error);
    WebCore::Navigator* item = WebKit::core(self);
    WTF::String convertedScheme = WTF::String::fromUTF8(scheme);
    WTF::String convertedUrl = WTF::String::fromUTF8(url);
    WTF::String convertedTitle = WTF::String::fromUTF8(title);
    WebCore::ExceptionCode ec = 0;
    WebCore::NavigatorContentUtils::registerProtocolHandler(item, convertedScheme, convertedUrl, convertedTitle, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Navigator Content Utils")
#endif /* ENABLE(NAVIGATOR_CONTENT_UTILS) */
}

gchar*
webkit_dom_navigator_is_protocol_handler_registered(WebKitDOMNavigator* self, const gchar* scheme, const gchar* url, GError** error)
{
#if ENABLE(CUSTOM_SCHEME_HANDLER) && ENABLE(NAVIGATOR_CONTENT_UTILS)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    g_return_val_if_fail(scheme, 0);
    g_return_val_if_fail(url, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Navigator* item = WebKit::core(self);
    WTF::String convertedScheme = WTF::String::fromUTF8(scheme);
    WTF::String convertedUrl = WTF::String::fromUTF8(url);
    WebCore::ExceptionCode ec = 0;
    gchar* result = convertToUTF8String(WebCore::NavigatorContentUtils::isProtocolHandlerRegistered(item, convertedScheme, convertedUrl, ec));
    return result;
#else
#if !ENABLE(NAVIGATOR_CONTENT_UTILS)
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Navigator Content Utils")
#endif
#if !ENABLE(CUSTOM_SCHEME_HANDLER)
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Custom Scheme Handler")
#endif
    return 0;
#endif /* ENABLE(CUSTOM_SCHEME_HANDLER) && ENABLE(NAVIGATOR_CONTENT_UTILS) */
}

void
webkit_dom_navigator_unregister_protocol_handler(WebKitDOMNavigator* self, const gchar* scheme, const gchar* url, GError** error)
{
#if ENABLE(CUSTOM_SCHEME_HANDLER) && ENABLE(NAVIGATOR_CONTENT_UTILS)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self));
    g_return_if_fail(scheme);
    g_return_if_fail(url);
    g_return_if_fail(!error || !*error);
    WebCore::Navigator* item = WebKit::core(self);
    WTF::String convertedScheme = WTF::String::fromUTF8(scheme);
    WTF::String convertedUrl = WTF::String::fromUTF8(url);
    WebCore::ExceptionCode ec = 0;
    WebCore::NavigatorContentUtils::unregisterProtocolHandler(item, convertedScheme, convertedUrl, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
#if !ENABLE(NAVIGATOR_CONTENT_UTILS)
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Navigator Content Utils")
#endif
#if !ENABLE(CUSTOM_SCHEME_HANDLER)
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Custom Scheme Handler")
#endif
#endif /* ENABLE(CUSTOM_SCHEME_HANDLER) && ENABLE(NAVIGATOR_CONTENT_UTILS) */
}

WebKitDOMGamepadList*
webkit_dom_navigator_webkit_get_gamepads(WebKitDOMNavigator* self)
{
#if ENABLE(GAMEPAD)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    RefPtr<WebCore::GamepadList> gobjectResult = WTF::getPtr(WebCore::NavigatorGamepad::webkitGetGamepads(item));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Gamepad")
    return 0;
#endif /* ENABLE(GAMEPAD) */
}

gchar*
webkit_dom_navigator_get_app_code_name(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->appCodeName());
    return result;
}

gchar*
webkit_dom_navigator_get_app_name(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->appName());
    return result;
}

gchar*
webkit_dom_navigator_get_app_version(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->appVersion());
    return result;
}

gchar*
webkit_dom_navigator_get_language(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->language());
    return result;
}

gchar*
webkit_dom_navigator_get_user_agent(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->userAgent());
    return result;
}

gchar*
webkit_dom_navigator_get_platform(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->platform());
    return result;
}

WebKitDOMDOMPluginArray*
webkit_dom_navigator_get_plugins(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    RefPtr<WebCore::DOMPluginArray> gobjectResult = WTF::getPtr(item->plugins());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDOMMimeTypeArray*
webkit_dom_navigator_get_mime_types(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    RefPtr<WebCore::DOMMimeTypeArray> gobjectResult = WTF::getPtr(item->mimeTypes());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_navigator_get_product(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->product());
    return result;
}

gchar*
webkit_dom_navigator_get_product_sub(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->productSub());
    return result;
}

gchar*
webkit_dom_navigator_get_vendor(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->vendor());
    return result;
}

gchar*
webkit_dom_navigator_get_vendor_sub(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->vendorSub());
    return result;
}

gboolean
webkit_dom_navigator_get_cookie_enabled(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), FALSE);
    WebCore::Navigator* item = WebKit::core(self);
    gboolean result = item->cookieEnabled();
    return result;
}

gboolean
webkit_dom_navigator_get_on_line(WebKitDOMNavigator* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), FALSE);
    WebCore::Navigator* item = WebKit::core(self);
    gboolean result = item->onLine();
    return result;
}

WebKitDOMGeolocation*
webkit_dom_navigator_get_geolocation(WebKitDOMNavigator* self)
{
#if ENABLE(GEOLOCATION)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_NAVIGATOR(self), 0);
    WebCore::Navigator* item = WebKit::core(self);
    RefPtr<WebCore::Geolocation> gobjectResult = WTF::getPtr(WebCore::NavigatorGeolocation::geolocation(item));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Geolocation")
    return 0;
#endif /* ENABLE(GEOLOCATION) */
}

