/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLLegendElement.h"

#include "HTMLFormElement.h"
#include "HTMLLegendElement.h"
#include "HTMLNames.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLLegendElementTableValues[] =
{
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLegendElementForm), (intptr_t)0, NoIntrinsic },
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLegendElementAlign), (intptr_t)setJSHTMLLegendElementAlign, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLLegendElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLLegendElementTable = { 9, 7, JSHTMLLegendElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLLegendElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLLegendElementConstructorTable = { 1, 0, JSHTMLLegendElementConstructorTableValues, 0 };
const ClassInfo JSHTMLLegendElementConstructor::s_info = { "HTMLLegendElementConstructor", &Base::s_info, &JSHTMLLegendElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLLegendElementConstructor) };

JSHTMLLegendElementConstructor::JSHTMLLegendElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLLegendElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLLegendElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLLegendElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLegendElementConstructor, JSDOMWrapper>(exec, &JSHTMLLegendElementConstructorTable, jsCast<JSHTMLLegendElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLLegendElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLLegendElementConstructor, JSDOMWrapper>(exec, &JSHTMLLegendElementConstructorTable, jsCast<JSHTMLLegendElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLLegendElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLLegendElementPrototypeTable = { 1, 0, JSHTMLLegendElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLLegendElementPrototype::s_info = { "HTMLLegendElementPrototype", &Base::s_info, &JSHTMLLegendElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLLegendElementPrototype) };

JSObject* JSHTMLLegendElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLLegendElement>(exec, globalObject);
}

const ClassInfo JSHTMLLegendElement::s_info = { "HTMLLegendElement", &Base::s_info, &JSHTMLLegendElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLLegendElement) };

JSHTMLLegendElement::JSHTMLLegendElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLLegendElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLLegendElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLLegendElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLLegendElementPrototype::create(exec->globalData(), globalObject, JSHTMLLegendElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLLegendElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLLegendElement* thisObject = jsCast<JSHTMLLegendElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLLegendElement, Base>(exec, &JSHTMLLegendElementTable, thisObject, propertyName, slot);
}

bool JSHTMLLegendElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLLegendElement* thisObject = jsCast<JSHTMLLegendElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLLegendElement, Base>(exec, &JSHTMLLegendElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLLegendElementForm(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLLegendElement* castedThis = jsCast<JSHTMLLegendElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLegendElement* impl = static_cast<HTMLLegendElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->form()));
    return result;
}


JSValue jsHTMLLegendElementAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLLegendElement* castedThis = jsCast<JSHTMLLegendElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLLegendElement* impl = static_cast<HTMLLegendElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


JSValue jsHTMLLegendElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLLegendElement* domObject = jsCast<JSHTMLLegendElement*>(asObject(slotBase));
    return JSHTMLLegendElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLLegendElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLLegendElement* thisObject = jsCast<JSHTMLLegendElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLLegendElement, Base>(exec, propertyName, value, &JSHTMLLegendElementTable, thisObject, slot);
}

void setJSHTMLLegendElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLLegendElement* castedThis = jsCast<JSHTMLLegendElement*>(thisObject);
    HTMLLegendElement* impl = static_cast<HTMLLegendElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::alignAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLLegendElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLLegendElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
