/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMStorageInfo.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMStorageInfoPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_STORAGE_INFO_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_STORAGE_INFO, WebKitDOMStorageInfoPrivate)

typedef struct _WebKitDOMStorageInfoPrivate {
#if ENABLE(QUOTA)
    RefPtr<WebCore::StorageInfo> coreObject;
#endif // ENABLE(QUOTA)
} WebKitDOMStorageInfoPrivate;

#if ENABLE(QUOTA)

namespace WebKit {

WebKitDOMStorageInfo* kit(WebCore::StorageInfo* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_STORAGE_INFO(ret);

    return wrapStorageInfo(obj);
}

WebCore::StorageInfo* core(WebKitDOMStorageInfo* request)
{
    return request ? static_cast<WebCore::StorageInfo*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMStorageInfo* wrapStorageInfo(WebCore::StorageInfo* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_STORAGE_INFO(g_object_new(WEBKIT_TYPE_DOM_STORAGE_INFO, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(QUOTA)

G_DEFINE_TYPE(WebKitDOMStorageInfo, webkit_dom_storage_info, WEBKIT_TYPE_DOM_OBJECT)

static void webkit_dom_storage_info_finalize(GObject* object)
{
    WebKitDOMStorageInfoPrivate* priv = WEBKIT_DOM_STORAGE_INFO_GET_PRIVATE(object);
#if ENABLE(QUOTA)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(QUOTA)
    priv->~WebKitDOMStorageInfoPrivate();
    G_OBJECT_CLASS(webkit_dom_storage_info_parent_class)->finalize(object);
}

static GObject* webkit_dom_storage_info_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_storage_info_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(QUOTA)
    WebKitDOMStorageInfoPrivate* priv = WEBKIT_DOM_STORAGE_INFO_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::StorageInfo*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(QUOTA)
    return object;
}

static void webkit_dom_storage_info_class_init(WebKitDOMStorageInfoClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMStorageInfoPrivate));
    gobjectClass->constructor = webkit_dom_storage_info_constructor;
    gobjectClass->finalize = webkit_dom_storage_info_finalize;
}

static void webkit_dom_storage_info_init(WebKitDOMStorageInfo* request)
{
    WebKitDOMStorageInfoPrivate* priv = WEBKIT_DOM_STORAGE_INFO_GET_PRIVATE(request);
    new (priv) WebKitDOMStorageInfoPrivate();
}

