/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMUIEvent.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMWindowPrivate.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMUIEventPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMUIEvent* kit(WebCore::UIEvent* obj)
{
    return WEBKIT_DOM_UI_EVENT(kit(static_cast<WebCore::Event*>(obj)));
}

WebCore::UIEvent* core(WebKitDOMUIEvent* request)
{
    return request ? static_cast<WebCore::UIEvent*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMUIEvent* wrapUIEvent(WebCore::UIEvent* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_UI_EVENT(g_object_new(WEBKIT_TYPE_DOM_UI_EVENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMUIEvent, webkit_dom_ui_event, WEBKIT_TYPE_DOM_EVENT)

enum {
    PROP_0,
    PROP_VIEW,
    PROP_DETAIL,
    PROP_KEY_CODE,
    PROP_CHAR_CODE,
    PROP_LAYER_X,
    PROP_LAYER_Y,
    PROP_PAGE_X,
    PROP_PAGE_Y,
    PROP_WHICH,
};

static void webkit_dom_ui_event_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMUIEvent* self = WEBKIT_DOM_UI_EVENT(object);
    WebCore::UIEvent* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_VIEW: {
        RefPtr<WebCore::DOMWindow> ptr = coreSelf->view();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_DETAIL: {
        g_value_set_long(value, coreSelf->detail());
        break;
    }
    case PROP_KEY_CODE: {
        g_value_set_long(value, coreSelf->keyCode());
        break;
    }
    case PROP_CHAR_CODE: {
        g_value_set_long(value, coreSelf->charCode());
        break;
    }
    case PROP_LAYER_X: {
        g_value_set_long(value, coreSelf->layerX());
        break;
    }
    case PROP_LAYER_Y: {
        g_value_set_long(value, coreSelf->layerY());
        break;
    }
    case PROP_PAGE_X: {
        g_value_set_long(value, coreSelf->pageX());
        break;
    }
    case PROP_PAGE_Y: {
        g_value_set_long(value, coreSelf->pageY());
        break;
    }
    case PROP_WHICH: {
        g_value_set_long(value, coreSelf->which());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_ui_event_class_init(WebKitDOMUIEventClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->get_property = webkit_dom_ui_event_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_VIEW,
                                    g_param_spec_object("view", /* name */
                                                           "ui_event_view", /* short description */
                                                           "read-only  WebKitDOMDOMWindow* UIEvent.view", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_WINDOW, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DETAIL,
                                    g_param_spec_long("detail", /* name */
                                                           "ui_event_detail", /* short description */
                                                           "read-only  glong UIEvent.detail", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_KEY_CODE,
                                    g_param_spec_long("key-code", /* name */
                                                           "ui_event_key-code", /* short description */
                                                           "read-only  glong UIEvent.key-code", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CHAR_CODE,
                                    g_param_spec_long("char-code", /* name */
                                                           "ui_event_char-code", /* short description */
                                                           "read-only  glong UIEvent.char-code", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LAYER_X,
                                    g_param_spec_long("layer-x", /* name */
                                                           "ui_event_layer-x", /* short description */
                                                           "read-only  glong UIEvent.layer-x", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LAYER_Y,
                                    g_param_spec_long("layer-y", /* name */
                                                           "ui_event_layer-y", /* short description */
                                                           "read-only  glong UIEvent.layer-y", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PAGE_X,
                                    g_param_spec_long("page-x", /* name */
                                                           "ui_event_page-x", /* short description */
                                                           "read-only  glong UIEvent.page-x", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PAGE_Y,
                                    g_param_spec_long("page-y", /* name */
                                                           "ui_event_page-y", /* short description */
                                                           "read-only  glong UIEvent.page-y", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WHICH,
                                    g_param_spec_long("which", /* name */
                                                           "ui_event_which", /* short description */
                                                           "read-only  glong UIEvent.which", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_ui_event_init(WebKitDOMUIEvent* request)
{
}

void
webkit_dom_ui_event_init_ui_event(WebKitDOMUIEvent* self, const gchar* type, gboolean canBubble, gboolean cancelable, WebKitDOMDOMWindow* view, glong detail)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_UI_EVENT(self));
    g_return_if_fail(type);
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(view));
    WebCore::UIEvent* item = WebKit::core(self);
    WTF::String convertedType = WTF::String::fromUTF8(type);
    WebCore::DOMWindow* convertedView = WebKit::core(view);
    item->initUIEvent(convertedType, canBubble, cancelable, convertedView, detail);
}

WebKitDOMDOMWindow*
webkit_dom_ui_event_get_view(WebKitDOMUIEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_UI_EVENT(self), 0);
    WebCore::UIEvent* item = WebKit::core(self);
    RefPtr<WebCore::DOMWindow> gobjectResult = WTF::getPtr(item->view());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_ui_event_get_detail(WebKitDOMUIEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_UI_EVENT(self), 0);
    WebCore::UIEvent* item = WebKit::core(self);
    glong result = item->detail();
    return result;
}

glong
webkit_dom_ui_event_get_key_code(WebKitDOMUIEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_UI_EVENT(self), 0);
    WebCore::UIEvent* item = WebKit::core(self);
    glong result = item->keyCode();
    return result;
}

glong
webkit_dom_ui_event_get_char_code(WebKitDOMUIEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_UI_EVENT(self), 0);
    WebCore::UIEvent* item = WebKit::core(self);
    glong result = item->charCode();
    return result;
}

glong
webkit_dom_ui_event_get_layer_x(WebKitDOMUIEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_UI_EVENT(self), 0);
    WebCore::UIEvent* item = WebKit::core(self);
    glong result = item->layerX();
    return result;
}

glong
webkit_dom_ui_event_get_layer_y(WebKitDOMUIEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_UI_EVENT(self), 0);
    WebCore::UIEvent* item = WebKit::core(self);
    glong result = item->layerY();
    return result;
}

glong
webkit_dom_ui_event_get_page_x(WebKitDOMUIEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_UI_EVENT(self), 0);
    WebCore::UIEvent* item = WebKit::core(self);
    glong result = item->pageX();
    return result;
}

glong
webkit_dom_ui_event_get_page_y(WebKitDOMUIEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_UI_EVENT(self), 0);
    WebCore::UIEvent* item = WebKit::core(self);
    glong result = item->pageY();
    return result;
}

glong
webkit_dom_ui_event_get_which(WebKitDOMUIEvent* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_UI_EVENT(self), 0);
    WebCore::UIEvent* item = WebKit::core(self);
    glong result = item->which();
    return result;
}

