#! @Chunk fan1
#!
#! Below we define the same fan in two different ways:
#!
#& @BeginLatexOnly
#& \begin{center}
#& \tikzset{every picture/.style={line width=0.75pt}} %set default line width to 0.75pt        
#& \begin{tikzpicture}[x=0.75pt,y=0.75pt,yscale=-1,xscale=1]
#& %uncomment if require: \path (0,262.3333282470703); %set diagram left start at 0, and has height of 262.3333282470703
#& %Shape: Polygon [id:ds6612253311691634] 
#& \draw  [fill={rgb, 255:red, 80; green, 227; blue, 194 }  ,fill opacity=1 ][dash pattern={on 0.84pt off 2.51pt}] (340.83,136.37) -- (315.33,213.67) -- (267.33,111.67) -- cycle ;
#& %Shape: Polygon [id:ds17896105849118338] 
#& \draw  [color={rgb, 255:red, 188; green, 78; blue, 78 }  ,draw opacity=1 ][fill={rgb, 255:red, 219; green, 137; blue, 137 }  ,fill opacity=1 ][dash pattern={on 0.84pt off 2.51pt}][line width=0.75]  (391.33,110.67) -- (342.07,135.33) -- (367.33,84.67) -- cycle ;
#& %Shape: Polygon [id:ds9377202331719324] 
#& \draw  [color={rgb, 255:red, 126; green, 211; blue, 33 }  ,draw opacity=1 ][fill={rgb, 255:red, 126; green, 211; blue, 33 }  ,fill opacity=1 ][dash pattern={on 0.84pt off 2.51pt}] (362.33,157.67) -- (383.33,115.67) -- (340.83,136.37) -- cycle ;
#& %Shape: Axis 2D [id:dp551581169805739] 
#& \draw [line width=1.5]  (162.33,136.37) -- (520,136.37)(340.83,10) -- (340.83,257.67) (513,131.37) -- (520,136.37) -- (513,141.37) (335.83,17) -- (340.83,10) -- (345.83,17) (374.83,131.37) -- (374.83,141.37)(408.83,131.37) -- (408.83,141.37)(442.83,131.37) -- (442.83,141.37)(476.83,131.37) -- (476.83,141.37)(306.83,131.37) -- (306.83,141.37)(272.83,131.37) -- (272.83,141.37)(238.83,131.37) -- (238.83,141.37)(204.83,131.37) -- (204.83,141.37)(170.83,131.37) -- (170.83,141.37)(335.83,102.37) -- (345.83,102.37)(335.83,68.37) -- (345.83,68.37)(335.83,34.37) -- (345.83,34.37)(335.83,170.37) -- (345.83,170.37)(335.83,204.37) -- (345.83,204.37)(335.83,238.37) -- (345.83,238.37) ;
#& \draw   (381.83,148.37) node[anchor=east, scale=0.75]{1} (415.83,148.37) node[anchor=east, scale=0.75]{2} (449.83,148.37) node[anchor=east, scale=0.75]{3} (483.83,148.37) node[anchor=east, scale=0.75]{4} (313.83,148.37) node[anchor=east, scale=0.75]{-1} (279.83,148.37) node[anchor=east, scale=0.75]{-2} (245.83,148.37) node[anchor=east, scale=0.75]{-3} (211.83,148.37) node[anchor=east, scale=0.75]{-4} (177.83,148.37) node[anchor=east, scale=0.75]{-5} (337.83,102.37) node[anchor=east, scale=0.75]{1} (337.83,68.37) node[anchor=east, scale=0.75]{2} (337.83,34.37) node[anchor=east, scale=0.75]{3} (337.83,170.37) node[anchor=east, scale=0.75]{-1} (337.83,204.37) node[anchor=east, scale=0.75]{-2} (337.83,238.37) node[anchor=east, scale=0.75]{-3} ;
#& %Straight Lines [id:da6632529312694321] 
#& \draw [color={rgb, 255:red, 113; green, 4; blue, 8 }  ,draw opacity=1 ][line width=1.5]    (341.07,136.33) -- (372.56,71.83) ;
#& \draw [shift={(373.87,69.13)}, rotate = 476.02] [color={rgb, 255:red, 113; green, 4; blue, 8 }  ,draw opacity=1 ][line width=1.5]    (14.21,-4.28) .. controls (9.04,-1.82) and (4.3,-0.39) .. (0,0) .. controls (4.3,0.39) and (9.04,1.82) .. (14.21,4.28)   ;
#& %Straight Lines [id:da3064069475522061] 
#& \draw [color={rgb, 255:red, 96; green, 4; blue, 4 }  ,draw opacity=1 ][line width=1.5]    (341.07,136.33) -- (406.04,104.65) ;
#& \draw [shift={(408.73,103.33)}, rotate = 514] [color={rgb, 255:red, 96; green, 4; blue, 4 }  ,draw opacity=1 ][line width=1.5]    (14.21,-4.28) .. controls (9.04,-1.82) and (4.3,-0.39) .. (0,0) .. controls (4.3,0.39) and (9.04,1.82) .. (14.21,4.28)   ;
#& %Straight Lines [id:da4070906928525613] 
#& \draw [color={rgb, 255:red, 86; green, 3; blue, 3 }  ,draw opacity=1 ][line width=1.5]    (340.83,136.37) -- (372.24,168.52) ;
#& \draw [shift={(374.33,170.67)}, rotate = 225.68] [color={rgb, 255:red, 86; green, 3; blue, 3 }  ,draw opacity=1 ][line width=1.5]    (14.21,-4.28) .. controls (9.04,-1.82) and (4.3,-0.39) .. (0,0) .. controls (4.3,0.39) and (9.04,1.82) .. (14.21,4.28)   ;
#& %Straight Lines [id:da13260708459990989] 
#& \draw [color={rgb, 255:red, 83; green, 5; blue, 5 }  ,draw opacity=1 ][line width=1.5]    (340.83,136.37) -- (241.18,103.6) ;
#& \draw [shift={(238.33,102.67)}, rotate = 378.2] [color={rgb, 255:red, 83; green, 5; blue, 5 }  ,draw opacity=1 ][line width=1.5]    (14.21,-4.28) .. controls (9.04,-1.82) and (4.3,-0.39) .. (0,0) .. controls (4.3,0.39) and (9.04,1.82) .. (14.21,4.28)   ;
#& %Straight Lines [id:da6381035199305363] 
#& \draw [color={rgb, 255:red, 79; green, 4; blue, 4 }  ,draw opacity=1 ][line width=1.5]    (341.07,136.33) -- (307.3,235.83) ;
#& \draw [shift={(306.33,238.67)}, rotate = 288.75] [color={rgb, 255:red, 79; green, 4; blue, 4 }  ,draw opacity=1 ][line width=1.5]    (14.21,-4.28) .. controls (9.04,-1.82) and (4.3,-0.39) .. (0,0) .. controls (4.3,0.39) and (9.04,1.82) .. (14.21,4.28)   ;
#& \end{tikzpicture}
#& \end{center}
#& @EndLatexOnly
#!  @Example
F1 := Fan( [ [ [ 2, 1 ], [ 1, 2 ] ], [ [ 2, 1 ], [ 1, -1 ] ],
             [ [ -3, 1 ], [ -1, -3 ] ] ] );
#! <A fan in |R^2>             
F2 := Fan( [ [ 2, 1 ], [ 1, 2 ], [ -3, 1 ], [ -1, -3 ], [ 1, -1 ] ], 
        [ [ 1, 2 ], [ 1, 5 ], [ 3, 4 ] ] );
#! <A fan in |R^2>
rays1 := RayGenerators( F1 );
#! [ [ -3, 1 ], [ -1, -3 ], [ 1, -1 ], [ 1, 2 ], [ 2, 1 ] ]
rays2 := RayGenerators( F2 );
#! [ [ -3, 1 ], [ -1, -3 ], [ 1, -1 ], [ 1, 2 ], [ 2, 1 ] ]
RaysInMaximalCones( F1 );
#! [ [ 0, 0, 0, 1, 1 ], [ 0, 0, 1, 0, 1 ], [ 1, 1, 0, 0, 0 ] ]
RaysInMaximalCones( F2 );
#! [ [ 0, 0, 0, 1, 1 ], [ 0, 0, 1, 0, 1 ], [ 1, 1, 0, 0, 0 ] ]
RaysInAllCones( F1 );
#! [ [ 0, 0, 0, 0, 0 ], [ 0, 0, 0, 1, 1 ], [ 0, 0, 0, 0, 1 ], 
#!  [ 0, 0, 0, 1, 0 ], [ 0, 0, 1, 0, 1 ], [ 0, 0, 1, 0, 0 ], 
#!  [ 1, 1, 0, 0, 0 ], [ 0, 1, 0, 0, 0 ], [ 1, 0, 0, 0, 0 ] ]
FVector( F1 );
#! [ 5, 3 ]
IsComplete( F1 );
#! false
IsSimplicial( F1 );
#! true
IsNormalFan( F1 );
#! false
IsRegularFan( F1 );
#! false
P1 := Polytope( [ [ 1 ], [ -1 ] ] );
#! <A polytope in |R^1>
P1 := NormalFan( P1 );
#! <A complete fan in |R^1>
RayGenerators( P1 );
#! [ [ -1 ], [ 1 ] ]
P3 := P1 * P1 * P1;
#! <A fan in |R^3>
RayGenerators( P3 );
#! [ [ -1, 0, 0 ], [ 0, -1, 0 ], [ 0, 0, -1 ], [ 0, 0, 1 ], [ 0, 1, 0 ], 
#!   [ 1, 0, 0 ] ]
RaysInMaximalCones( P3 );
#! [ [ 0, 0, 0, 1, 1, 1 ], [ 0, 0, 1, 0, 1, 1 ], [ 0, 1, 0, 1, 0, 1 ], 
#!   [ 0, 1, 1, 0, 0, 1 ], [ 1, 0, 0, 1, 1, 0 ], [ 1, 0, 1, 0, 1, 0 ], 
#!   [ 1, 1, 0, 1, 0, 0 ], [ 1, 1, 1, 0, 0, 0 ] ]
RaysInAllCones( P3 );
#! [ [ 0, 0, 0, 0, 0, 0 ], [ 0, 0, 0, 1, 1, 1 ], [ 0, 0, 0, 1, 1, 0 ], 
#!   [ 0, 0, 0, 1, 0, 0 ], [ 0, 0, 0, 0, 1, 0 ], [ 0, 0, 0, 1, 0, 1 ], 
#!   [ 0, 0, 0, 0, 0, 1 ], [ 0, 0, 0, 0, 1, 1 ], [ 0, 0, 1, 0, 1, 1 ], 
#!   [ 0, 0, 1, 0, 1, 0 ], [ 0, 0, 1, 0, 0, 0 ], [ 0, 0, 1, 0, 0, 1 ], 
#!   [ 0, 1, 0, 1, 0, 1 ], [ 0, 1, 0, 1, 0, 0 ], [ 0, 1, 0, 0, 0, 0 ], 
#!   [ 0, 1, 0, 0, 0, 1 ], [ 0, 1, 1, 0, 0, 1 ], [ 0, 1, 1, 0, 0, 0 ], 
#!   [ 1, 0, 0, 1, 1, 0 ], [ 1, 0, 0, 1, 0, 0 ], [ 1, 0, 0, 0, 0, 0 ], 
#!   [ 1, 0, 0, 0, 1, 0 ], [ 1, 0, 1, 0, 1, 0 ], [ 1, 0, 1, 0, 0, 0 ], 
#!   [ 1, 1, 0, 1, 0, 0 ], [ 1, 1, 0, 0, 0, 0 ], [ 1, 1, 1, 0, 0, 0 ] ]
IsNormalFan( P3 );
#! true
Dimension( P3 );
#! 3
PrimitiveCollections( P3 );
#! [ [ 4, 3 ], [ 5, 2 ], [ 6, 1 ] ]

#! @EndExample
#! @EndChunk

#! @Chunk fan2
#! The following is an example for a fan that is complete but not normal.
#! @Example
rays := [ [ 1, 0, 0 ], [ -1, 0, 0 ], [ 0, 1, 0 ], [ 0, -1, 0 ], 
[ 0, 0, 1 ], [ 0, 0, -1 ], [ 2, 1, 1 ], [ 1, 2, 1 ], [ 1, 1, 2 ], 
[ 1, 1, 1 ] ];;
cones := [ [ 1, 3, 6 ], [ 1, 4, 6 ], [ 1, 4, 5 ], [ 2, 3, 6 ], 
[ 2, 4, 6 ], [ 2, 3, 5 ], [ 2, 4, 5 ], [ 1, 5, 9 ], [ 3, 5, 8 ], 
[ 1, 3, 7 ], [ 1, 7, 9 ], [ 5, 8, 9 ], [ 3, 7, 8 ], [ 7, 9, 10 ], 
[ 8, 9, 10 ], [ 7, 8, 10 ] ];;
F := Fan( rays, cones );
#! <A fan in |R^3>
IsComplete( F );
#! true
IsNormalFan( F );
#! false
PrimitiveCollections( F );
#! [ [ 7, 1 ], [ 7, 2 ], [ 7, 3 ], [ 7, 4 ], [ 7, 5 ], [ 7, 6 ], 
#!   [ 9, 1 ], [ 9, 2 ], [ 9, 3 ], [ 9, 6 ], [ 10, 1 ], [ 10, 2 ], 
#!   [ 10, 3 ], [ 10, 4 ], [ 8, 1 ], [ 8, 2 ], [ 8, 3 ], [ 8, 5 ], 
#!   [ 6, 1 ], [ 5, 2 ], [ 4, 3 ], [ 9, 10, 8 ], [ 5, 6, 4 ] ]

#! @EndExample
#! @EndChunk

#! @Chunk fan3
#! The above methods construct fans from so-called triangulations.
#! For a given list $R$ of lists of integers, a triangulation is a fan
#! whose ray generators are contained in the given list $R$.
#!
#! A regular triangulation is such a fan, for which all cones are strictly convex.
#! It is called a fine triangulation, iff all elements of $R$ are ray generators of this fan.
#!
#! Above we present two method which make this approach available in NConvex via the package TopcomInterface,
#! which in turn rests on the program Topcom. Consequently, these methods are only available if the
#! package TopcomInterface is available. They compute either all of the fine and regular triangulations
#! or merely just a single such triangulation.
#!
#! As an example inspired from toric geometry, let us use the ray generators of the fan of the resolved
#! conifold (i.e. the total space of the bundle
#& @BeginLatexOnly
#& \mathcal{O}_{\mathbb{P}^2}(-1) \oplus \mathcal{O}_{\mathbb{P}^2}(-1)
#& @EndLatexOnly
#! ). This space is known to allow for two different triangulations.

#! The code below reproduces this feature.
#! @InsertCode triangulations_code

#! @EndChunk

#! @Chunk fan4
#! A star subdivision is a certain way of extending a fan. In toric geometry, its applications
#! include blowups of varieties. The following examples correspond to blowups of the origin of 
#! the 2-dimensional and 3-dimensional affine space, respectively.

#! @Example
rays := [ [ 1,0 ], [ 0,1 ] ];;
max_cones := [ [1,2] ];;
fan_affine2 := Fan( rays, max_cones );;
fan_blowup_affine2 := StarSubdivisionOfIthMaximalCone( fan_affine2, 1 );
#! <A fan in |R^2>
Length( RaysInMaximalCones( fan_blowup_affine2 ) );
#! 2
rays := [ [ 1,0,0 ], [ 0,1,0 ], [0,0,1] ];;
max_cones := [ [1,2,3] ];;
fan_affine3 := Fan( rays, max_cones );;
fan_blowup_affine3 := StarSubdivisionOfIthMaximalCone( fan_affine3, 1 );
#! <A fan in |R^3>
Length( RaysInMaximalCones( fan_blowup_affine3 ) );
#! 3
#! @EndExample
#! @EndChunk

#! @BeginCode triangulations_code
gap> rays := [ [ 1, 0, 1 ], [ 1, 1, 0 ], [ 0, 0, -1 ], [ 0, -1, 0 ] ];;
gap> all_triangulations := FansFromTriangulation( rays );
[ <A fan in |R^3>, <A fan in |R^3> ]
gap> one_triangulation := FanFromTriangulation( rays );
<A fan in |R^3>
#! @EndCode
