/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.util;

import grails.config.Config;
import grails.core.GrailsApplication;
import grails.util.GrailsStringUtils;
import grails.util.GrailsWebUtil;
import grails.web.mime.MimeType;
import grails.web.servlet.mvc.GrailsParameterMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.servlet.view.CompositeViewResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;
import org.springframework.web.util.UrlPathHelper;

public class WebUtils
extends org.springframework.web.util.WebUtils {
    public static final char SLASH = '/';
    public static final String ENABLE_FILE_EXTENSIONS = "grails.mime.file.extensions";
    public static final String DISPATCH_ACTION_PARAMETER = "_action_";
    public static final String SEND_ALLOW_HEADER_FOR_INVALID_HTTP_METHOD = "grails.http.invalid.method.allow.header";
    public static final String LAYOUT_ATTRIBUTE = "org.grails.layout.name";
    public static final String RENDERING_VIEW = "org.grails.rendering.view";
    public static final String GRAILS_DISPATCH_EXTENSION = ".dispatch";
    public static final String GRAILS_SERVLET_PATH = "/grails";
    public static final String EXCEPTION_ATTRIBUTE = "exception";
    public static final String ASYNC_REQUEST_URI_ATTRIBUTE = "javax.servlet.async.request_uri";

    public static ViewResolver lookupViewResolver(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return WebUtils.lookupViewResolver((ApplicationContext)wac);
    }

    public static ViewResolver lookupViewResolver(ApplicationContext wac) {
        final CompositeViewResolver viewResolver = (CompositeViewResolver)wac.getBean("compositeViewResolver", CompositeViewResolver.class);
        return new ViewResolver(){

            public View resolveViewName(String viewName, Locale locale) throws Exception {
                return viewResolver.resolveView(viewName, locale);
            }
        };
    }

    public static HandlerInterceptor[] lookupHandlerInterceptors(ServletContext servletContext) {
        WebRequestInterceptor[] webRequestInterceptors;
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        ArrayList<Object> allHandlerInterceptors = new ArrayList<Object>();
        for (WebRequestInterceptor webRequestInterceptor : webRequestInterceptors = WebUtils.lookupWebRequestInterceptors(servletContext)) {
            allHandlerInterceptors.add(new WebRequestHandlerInterceptorAdapter(webRequestInterceptor));
        }
        Collection handlerInterceptors = wac.getBeansOfType(HandlerInterceptor.class).values();
        allHandlerInterceptors.addAll(handlerInterceptors);
        return allHandlerInterceptors.toArray(new HandlerInterceptor[allHandlerInterceptors.size()]);
    }

    public static WebRequestInterceptor[] lookupWebRequestInterceptors(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        Collection webRequestInterceptors = wac.getBeansOfType(WebRequestInterceptor.class).values();
        return webRequestInterceptors.toArray(new WebRequestInterceptor[webRequestInterceptors.size()]);
    }

    public static String getRequestURIForGrailsDispatchURI(HttpServletRequest request) {
        UrlPathHelper pathHelper = new UrlPathHelper();
        if (request.getRequestURI().endsWith(GRAILS_DISPATCH_EXTENSION)) {
            String path = pathHelper.getPathWithinApplication(request);
            if (path.startsWith(GRAILS_SERVLET_PATH)) {
                path = path.substring(GRAILS_SERVLET_PATH.length(), path.length());
            }
            return path.substring(0, path.length() - GRAILS_DISPATCH_EXTENSION.length());
        }
        return pathHelper.getPathWithinApplication(request);
    }

    public static GrailsApplication lookupApplication(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return (GrailsApplication)wac.getBean("grailsApplication");
    }

    public static GrailsApplication findApplication(ServletContext servletContext) {
        ApplicationContext wac = WebUtils.findApplicationContext(servletContext);
        if (wac != null) {
            return (GrailsApplication)wac.getBean("grailsApplication");
        }
        return null;
    }

    public static ApplicationContext findApplicationContext(ServletContext servletContext) {
        if (servletContext == null) {
            return ContextLoader.getCurrentWebApplicationContext();
        }
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
    }

    public static View resolveView(HttpServletRequest request, String viewName, String controllerName, ViewResolver viewResolver) throws Exception {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup(request);
        Locale locale = webRequest != null ? webRequest.getLocale() : Locale.getDefault();
        return viewResolver.resolveViewName(WebUtils.addViewPrefix(viewName, controllerName), locale);
    }

    @Deprecated
    public static String addViewPrefix(String viewName) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        return WebUtils.addViewPrefix(viewName, webRequest != null ? webRequest.getControllerName() : null);
    }

    public static String addViewPrefix(String viewName, String controllerName) {
        if (!viewName.startsWith(String.valueOf('/'))) {
            if (viewName.startsWith("redirect:") || viewName.startsWith("forward:")) {
                return viewName;
            }
            StringBuilder buf = new StringBuilder();
            buf.append('/');
            if (controllerName != null) {
                buf.append(controllerName).append('/');
            }
            buf.append(viewName);
            return buf.toString();
        }
        return viewName;
    }

    public static Map<String, Object> exposeRequestAttributesAndReturnOldValues(HttpServletRequest request, Map<String, ?> attributes) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Assert.notNull(attributes, (String)"Attributes Map must not be null");
        HashMap<String, Object> originalValues = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : attributes.entrySet()) {
            String name = entry.getKey();
            Object current = request.getAttribute(name);
            request.setAttribute(name, entry.getValue());
            if (current == null) continue;
            originalValues.put(name, current);
        }
        return originalValues;
    }

    public static void cleanupIncludeRequestAttributes(HttpServletRequest request, Map<String, Object> toRestore) {
        request.removeAttribute("javax.servlet.include.request_uri");
        request.removeAttribute("javax.servlet.include.context_path");
        request.removeAttribute("javax.servlet.include.servlet_path");
        request.removeAttribute("javax.servlet.include.path_info");
        request.removeAttribute("javax.servlet.include.query_string");
        for (Map.Entry<String, Object> entry : toRestore.entrySet()) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public static void exposeIncludeRequestAttributes(HttpServletRequest request) {
        WebUtils.exposeRequestAttributeIfNotPresent((ServletRequest)request, "javax.servlet.include.request_uri", request.getRequestURI());
        WebUtils.exposeRequestAttributeIfNotPresent((ServletRequest)request, "javax.servlet.include.context_path", request.getContextPath());
        WebUtils.exposeRequestAttributeIfNotPresent((ServletRequest)request, "javax.servlet.include.servlet_path", request.getServletPath());
        WebUtils.exposeRequestAttributeIfNotPresent((ServletRequest)request, "javax.servlet.include.path_info", request.getPathInfo());
        WebUtils.exposeRequestAttributeIfNotPresent((ServletRequest)request, "javax.servlet.include.query_string", request.getQueryString());
    }

    private static void exposeRequestAttributeIfNotPresent(ServletRequest request, String name, Object value) {
        if (request.getAttribute(name) == null) {
            request.setAttribute(name, value);
        }
    }

    public static Map<String, Object> fromQueryString(String queryString) {
        String[] pairs;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (queryString.startsWith("?")) {
            queryString = queryString.substring(1);
        }
        for (String pair : pairs = queryString.split("&")) {
            int i = pair.indexOf(61);
            if (i <= -1) continue;
            try {
                String name = URLDecoder.decode(pair.substring(0, i), "UTF-8");
                String value = URLDecoder.decode(pair.substring(i + 1, pair.length()), "UTF-8");
                Object current = result.get(name);
                if (current instanceof List) {
                    ((List)current).add(value);
                    continue;
                }
                if (current != null) {
                    ArrayList<Object> multi = new ArrayList<Object>();
                    multi.add(current);
                    multi.add(value);
                    result.put(name, multi);
                    continue;
                }
                result.put(name, value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toQueryString(Map params, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        StringBuilder queryString = new StringBuilder("?");
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            boolean hasMore = i.hasNext();
            boolean wasAppended = WebUtils.appendEntry(entry, queryString, encoding, "");
            if (!hasMore || !wasAppended) continue;
            queryString.append('&');
        }
        return queryString.toString();
    }

    public static String toQueryString(Map parameters) throws UnsupportedEncodingException {
        return WebUtils.toQueryString(parameters, "UTF-8");
    }

    private static boolean appendEntry(Map.Entry entry, StringBuilder queryString, String encoding, String path) throws UnsupportedEncodingException {
        String name = entry.getKey().toString();
        Object value = entry.getValue();
        if (name.indexOf(".") > -1 && value instanceof GrailsParameterMap) {
            return false;
        }
        if (value == null) {
            value = "";
        } else if (value instanceof GrailsParameterMap) {
            GrailsParameterMap child = (GrailsParameterMap)value;
            Set nestedEntrySet = child.entrySet();
            Iterator i = nestedEntrySet.iterator();
            while (i.hasNext()) {
                Map.Entry childEntry = (Map.Entry)i.next();
                WebUtils.appendEntry(childEntry, queryString, encoding, entry.getKey().toString() + ".");
                boolean hasMore = i.hasNext();
                if (!hasMore) continue;
                queryString.append('&');
            }
        } else {
            queryString.append(URLEncoder.encode(path + name, encoding)).append('=').append(URLEncoder.encode(value.toString(), encoding));
        }
        return true;
    }

    public static String getFormatFromURI(String uri) {
        return WebUtils.getFormatFromURI(uri, MimeType.getConfiguredMimeTypes());
    }

    public static String getFormatFromURI(String uri, MimeType[] mimeTypes) {
        String lastToken;
        if (uri.endsWith("/")) {
            return null;
        }
        int idx = uri.lastIndexOf(47);
        if (idx > -1 && (idx = (lastToken = uri.substring(idx + 1, uri.length())).lastIndexOf(46)) > -1 && idx != lastToken.length() - 1) {
            String extension = lastToken.substring(idx + 1, lastToken.length());
            if (mimeTypes != null) {
                for (MimeType mimeType : mimeTypes) {
                    if (!mimeType.getExtension().equals(extension)) continue;
                    return extension;
                }
            }
        }
        return null;
    }

    public static boolean areFileExtensionsEnabled() {
        Config config = GrailsWebUtil.currentApplication().getConfig();
        return (Boolean)config.getProperty(ENABLE_FILE_EXTENSIONS, Boolean.class, (Object)true);
    }

    public static GrailsWebRequest retrieveGrailsWebRequest() {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        if (attributes instanceof GrailsWebRequest) {
            return (GrailsWebRequest)attributes;
        }
        return null;
    }

    public static void storeGrailsWebRequest(GrailsWebRequest webRequest) {
        RequestContextHolder.setRequestAttributes((RequestAttributes)webRequest);
        webRequest.getRequest().setAttribute("org.grails.WEB_REQUEST", (Object)webRequest);
    }

    public static void clearGrailsWebRequest() {
        RequestAttributes reqAttrs = RequestContextHolder.getRequestAttributes();
        if (reqAttrs != null) {
            GrailsWebRequest webRequest = (GrailsWebRequest)reqAttrs;
            webRequest.getRequest().removeAttribute("org.grails.WEB_REQUEST");
            RequestContextHolder.resetRequestAttributes();
        }
    }

    public static String getForwardURI(HttpServletRequest request) {
        String result = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (GrailsStringUtils.isBlank((String)result)) {
            result = request.getRequestURI();
        }
        return result;
    }

    public static boolean isForward(HttpServletRequest request) {
        return request.getAttribute("javax.servlet.forward.request_uri") != null;
    }

    public static boolean isAsync(HttpServletRequest request) {
        return request.getAttribute(ASYNC_REQUEST_URI_ATTRIBUTE) != null;
    }

    public static boolean isError(HttpServletRequest request) {
        return request.getAttribute("javax.servlet.error.status_code") != null;
    }

    public static boolean isInclude(HttpServletRequest request) {
        return request.getAttribute("javax.servlet.include.request_uri") != null;
    }

    public static boolean isForwardOrInclude(HttpServletRequest request) {
        return WebUtils.isForward(request) || WebUtils.isInclude(request);
    }
}

