# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class Video(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'uuid': 'str',
        'is_live': 'bool',
        'created_at': 'datetime',
        'published_at': 'datetime',
        'updated_at': 'datetime',
        'originally_published_at': 'datetime',
        'category': 'VideoConstantNumber',
        'licence': 'VideoConstantNumber',
        'language': 'VideoConstantString',
        'privacy': 'VideoPrivacyConstant',
        'description': 'str',
        'duration': 'int',
        'is_local': 'bool',
        'name': 'str',
        'thumbnail_path': 'str',
        'preview_path': 'str',
        'embed_path': 'str',
        'views': 'int',
        'likes': 'int',
        'dislikes': 'int',
        'nsfw': 'bool',
        'wait_transcoding': 'bool',
        'state': 'VideoStateConstant',
        'scheduled_update': 'VideoScheduledUpdate',
        'blacklisted': 'bool',
        'blacklisted_reason': 'str',
        'account': 'AccountSummary',
        'channel': 'VideoChannelSummary',
        'user_history': 'VideoUserHistory'
    }

    attribute_map = {
        'id': 'id',
        'uuid': 'uuid',
        'is_live': 'isLive',
        'created_at': 'createdAt',
        'published_at': 'publishedAt',
        'updated_at': 'updatedAt',
        'originally_published_at': 'originallyPublishedAt',
        'category': 'category',
        'licence': 'licence',
        'language': 'language',
        'privacy': 'privacy',
        'description': 'description',
        'duration': 'duration',
        'is_local': 'isLocal',
        'name': 'name',
        'thumbnail_path': 'thumbnailPath',
        'preview_path': 'previewPath',
        'embed_path': 'embedPath',
        'views': 'views',
        'likes': 'likes',
        'dislikes': 'dislikes',
        'nsfw': 'nsfw',
        'wait_transcoding': 'waitTranscoding',
        'state': 'state',
        'scheduled_update': 'scheduledUpdate',
        'blacklisted': 'blacklisted',
        'blacklisted_reason': 'blacklistedReason',
        'account': 'account',
        'channel': 'channel',
        'user_history': 'userHistory'
    }

    def __init__(self, id=None, uuid=None, is_live=None, created_at=None, published_at=None, updated_at=None, originally_published_at=None, category=None, licence=None, language=None, privacy=None, description=None, duration=None, is_local=None, name=None, thumbnail_path=None, preview_path=None, embed_path=None, views=None, likes=None, dislikes=None, nsfw=None, wait_transcoding=None, state=None, scheduled_update=None, blacklisted=None, blacklisted_reason=None, account=None, channel=None, user_history=None, local_vars_configuration=None):  # noqa: E501
        """Video - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._uuid = None
        self._is_live = None
        self._created_at = None
        self._published_at = None
        self._updated_at = None
        self._originally_published_at = None
        self._category = None
        self._licence = None
        self._language = None
        self._privacy = None
        self._description = None
        self._duration = None
        self._is_local = None
        self._name = None
        self._thumbnail_path = None
        self._preview_path = None
        self._embed_path = None
        self._views = None
        self._likes = None
        self._dislikes = None
        self._nsfw = None
        self._wait_transcoding = None
        self._state = None
        self._scheduled_update = None
        self._blacklisted = None
        self._blacklisted_reason = None
        self._account = None
        self._channel = None
        self._user_history = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if uuid is not None:
            self.uuid = uuid
        if is_live is not None:
            self.is_live = is_live
        if created_at is not None:
            self.created_at = created_at
        if published_at is not None:
            self.published_at = published_at
        if updated_at is not None:
            self.updated_at = updated_at
        if originally_published_at is not None:
            self.originally_published_at = originally_published_at
        if category is not None:
            self.category = category
        if licence is not None:
            self.licence = licence
        if language is not None:
            self.language = language
        if privacy is not None:
            self.privacy = privacy
        if description is not None:
            self.description = description
        if duration is not None:
            self.duration = duration
        if is_local is not None:
            self.is_local = is_local
        if name is not None:
            self.name = name
        if thumbnail_path is not None:
            self.thumbnail_path = thumbnail_path
        if preview_path is not None:
            self.preview_path = preview_path
        if embed_path is not None:
            self.embed_path = embed_path
        if views is not None:
            self.views = views
        if likes is not None:
            self.likes = likes
        if dislikes is not None:
            self.dislikes = dislikes
        if nsfw is not None:
            self.nsfw = nsfw
        self.wait_transcoding = wait_transcoding
        if state is not None:
            self.state = state
        self.scheduled_update = scheduled_update
        self.blacklisted = blacklisted
        self.blacklisted_reason = blacklisted_reason
        if account is not None:
            self.account = account
        if channel is not None:
            self.channel = channel
        self.user_history = user_history

    @property
    def id(self):
        """Gets the id of this Video.  # noqa: E501


        :return: The id of this Video.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Video.


        :param id: The id of this Video.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def uuid(self):
        """Gets the uuid of this Video.  # noqa: E501


        :return: The uuid of this Video.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this Video.


        :param uuid: The uuid of this Video.  # noqa: E501
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def is_live(self):
        """Gets the is_live of this Video.  # noqa: E501


        :return: The is_live of this Video.  # noqa: E501
        :rtype: bool
        """
        return self._is_live

    @is_live.setter
    def is_live(self, is_live):
        """Sets the is_live of this Video.


        :param is_live: The is_live of this Video.  # noqa: E501
        :type is_live: bool
        """

        self._is_live = is_live

    @property
    def created_at(self):
        """Gets the created_at of this Video.  # noqa: E501


        :return: The created_at of this Video.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Video.


        :param created_at: The created_at of this Video.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def published_at(self):
        """Gets the published_at of this Video.  # noqa: E501


        :return: The published_at of this Video.  # noqa: E501
        :rtype: datetime
        """
        return self._published_at

    @published_at.setter
    def published_at(self, published_at):
        """Sets the published_at of this Video.


        :param published_at: The published_at of this Video.  # noqa: E501
        :type published_at: datetime
        """

        self._published_at = published_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Video.  # noqa: E501


        :return: The updated_at of this Video.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Video.


        :param updated_at: The updated_at of this Video.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    @property
    def originally_published_at(self):
        """Gets the originally_published_at of this Video.  # noqa: E501


        :return: The originally_published_at of this Video.  # noqa: E501
        :rtype: datetime
        """
        return self._originally_published_at

    @originally_published_at.setter
    def originally_published_at(self, originally_published_at):
        """Sets the originally_published_at of this Video.


        :param originally_published_at: The originally_published_at of this Video.  # noqa: E501
        :type originally_published_at: datetime
        """

        self._originally_published_at = originally_published_at

    @property
    def category(self):
        """Gets the category of this Video.  # noqa: E501


        :return: The category of this Video.  # noqa: E501
        :rtype: VideoConstantNumber
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this Video.


        :param category: The category of this Video.  # noqa: E501
        :type category: VideoConstantNumber
        """

        self._category = category

    @property
    def licence(self):
        """Gets the licence of this Video.  # noqa: E501


        :return: The licence of this Video.  # noqa: E501
        :rtype: VideoConstantNumber
        """
        return self._licence

    @licence.setter
    def licence(self, licence):
        """Sets the licence of this Video.


        :param licence: The licence of this Video.  # noqa: E501
        :type licence: VideoConstantNumber
        """

        self._licence = licence

    @property
    def language(self):
        """Gets the language of this Video.  # noqa: E501


        :return: The language of this Video.  # noqa: E501
        :rtype: VideoConstantString
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this Video.


        :param language: The language of this Video.  # noqa: E501
        :type language: VideoConstantString
        """

        self._language = language

    @property
    def privacy(self):
        """Gets the privacy of this Video.  # noqa: E501


        :return: The privacy of this Video.  # noqa: E501
        :rtype: VideoPrivacyConstant
        """
        return self._privacy

    @privacy.setter
    def privacy(self, privacy):
        """Sets the privacy of this Video.


        :param privacy: The privacy of this Video.  # noqa: E501
        :type privacy: VideoPrivacyConstant
        """

        self._privacy = privacy

    @property
    def description(self):
        """Gets the description of this Video.  # noqa: E501


        :return: The description of this Video.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Video.


        :param description: The description of this Video.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def duration(self):
        """Gets the duration of this Video.  # noqa: E501


        :return: The duration of this Video.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this Video.


        :param duration: The duration of this Video.  # noqa: E501
        :type duration: int
        """

        self._duration = duration

    @property
    def is_local(self):
        """Gets the is_local of this Video.  # noqa: E501


        :return: The is_local of this Video.  # noqa: E501
        :rtype: bool
        """
        return self._is_local

    @is_local.setter
    def is_local(self, is_local):
        """Sets the is_local of this Video.


        :param is_local: The is_local of this Video.  # noqa: E501
        :type is_local: bool
        """

        self._is_local = is_local

    @property
    def name(self):
        """Gets the name of this Video.  # noqa: E501


        :return: The name of this Video.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Video.


        :param name: The name of this Video.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def thumbnail_path(self):
        """Gets the thumbnail_path of this Video.  # noqa: E501


        :return: The thumbnail_path of this Video.  # noqa: E501
        :rtype: str
        """
        return self._thumbnail_path

    @thumbnail_path.setter
    def thumbnail_path(self, thumbnail_path):
        """Sets the thumbnail_path of this Video.


        :param thumbnail_path: The thumbnail_path of this Video.  # noqa: E501
        :type thumbnail_path: str
        """

        self._thumbnail_path = thumbnail_path

    @property
    def preview_path(self):
        """Gets the preview_path of this Video.  # noqa: E501


        :return: The preview_path of this Video.  # noqa: E501
        :rtype: str
        """
        return self._preview_path

    @preview_path.setter
    def preview_path(self, preview_path):
        """Sets the preview_path of this Video.


        :param preview_path: The preview_path of this Video.  # noqa: E501
        :type preview_path: str
        """

        self._preview_path = preview_path

    @property
    def embed_path(self):
        """Gets the embed_path of this Video.  # noqa: E501


        :return: The embed_path of this Video.  # noqa: E501
        :rtype: str
        """
        return self._embed_path

    @embed_path.setter
    def embed_path(self, embed_path):
        """Sets the embed_path of this Video.


        :param embed_path: The embed_path of this Video.  # noqa: E501
        :type embed_path: str
        """

        self._embed_path = embed_path

    @property
    def views(self):
        """Gets the views of this Video.  # noqa: E501


        :return: The views of this Video.  # noqa: E501
        :rtype: int
        """
        return self._views

    @views.setter
    def views(self, views):
        """Sets the views of this Video.


        :param views: The views of this Video.  # noqa: E501
        :type views: int
        """

        self._views = views

    @property
    def likes(self):
        """Gets the likes of this Video.  # noqa: E501


        :return: The likes of this Video.  # noqa: E501
        :rtype: int
        """
        return self._likes

    @likes.setter
    def likes(self, likes):
        """Sets the likes of this Video.


        :param likes: The likes of this Video.  # noqa: E501
        :type likes: int
        """

        self._likes = likes

    @property
    def dislikes(self):
        """Gets the dislikes of this Video.  # noqa: E501


        :return: The dislikes of this Video.  # noqa: E501
        :rtype: int
        """
        return self._dislikes

    @dislikes.setter
    def dislikes(self, dislikes):
        """Sets the dislikes of this Video.


        :param dislikes: The dislikes of this Video.  # noqa: E501
        :type dislikes: int
        """

        self._dislikes = dislikes

    @property
    def nsfw(self):
        """Gets the nsfw of this Video.  # noqa: E501


        :return: The nsfw of this Video.  # noqa: E501
        :rtype: bool
        """
        return self._nsfw

    @nsfw.setter
    def nsfw(self, nsfw):
        """Sets the nsfw of this Video.


        :param nsfw: The nsfw of this Video.  # noqa: E501
        :type nsfw: bool
        """

        self._nsfw = nsfw

    @property
    def wait_transcoding(self):
        """Gets the wait_transcoding of this Video.  # noqa: E501


        :return: The wait_transcoding of this Video.  # noqa: E501
        :rtype: bool
        """
        return self._wait_transcoding

    @wait_transcoding.setter
    def wait_transcoding(self, wait_transcoding):
        """Sets the wait_transcoding of this Video.


        :param wait_transcoding: The wait_transcoding of this Video.  # noqa: E501
        :type wait_transcoding: bool
        """

        self._wait_transcoding = wait_transcoding

    @property
    def state(self):
        """Gets the state of this Video.  # noqa: E501


        :return: The state of this Video.  # noqa: E501
        :rtype: VideoStateConstant
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Video.


        :param state: The state of this Video.  # noqa: E501
        :type state: VideoStateConstant
        """

        self._state = state

    @property
    def scheduled_update(self):
        """Gets the scheduled_update of this Video.  # noqa: E501


        :return: The scheduled_update of this Video.  # noqa: E501
        :rtype: VideoScheduledUpdate
        """
        return self._scheduled_update

    @scheduled_update.setter
    def scheduled_update(self, scheduled_update):
        """Sets the scheduled_update of this Video.


        :param scheduled_update: The scheduled_update of this Video.  # noqa: E501
        :type scheduled_update: VideoScheduledUpdate
        """

        self._scheduled_update = scheduled_update

    @property
    def blacklisted(self):
        """Gets the blacklisted of this Video.  # noqa: E501


        :return: The blacklisted of this Video.  # noqa: E501
        :rtype: bool
        """
        return self._blacklisted

    @blacklisted.setter
    def blacklisted(self, blacklisted):
        """Sets the blacklisted of this Video.


        :param blacklisted: The blacklisted of this Video.  # noqa: E501
        :type blacklisted: bool
        """

        self._blacklisted = blacklisted

    @property
    def blacklisted_reason(self):
        """Gets the blacklisted_reason of this Video.  # noqa: E501


        :return: The blacklisted_reason of this Video.  # noqa: E501
        :rtype: str
        """
        return self._blacklisted_reason

    @blacklisted_reason.setter
    def blacklisted_reason(self, blacklisted_reason):
        """Sets the blacklisted_reason of this Video.


        :param blacklisted_reason: The blacklisted_reason of this Video.  # noqa: E501
        :type blacklisted_reason: str
        """

        self._blacklisted_reason = blacklisted_reason

    @property
    def account(self):
        """Gets the account of this Video.  # noqa: E501


        :return: The account of this Video.  # noqa: E501
        :rtype: AccountSummary
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this Video.


        :param account: The account of this Video.  # noqa: E501
        :type account: AccountSummary
        """

        self._account = account

    @property
    def channel(self):
        """Gets the channel of this Video.  # noqa: E501


        :return: The channel of this Video.  # noqa: E501
        :rtype: VideoChannelSummary
        """
        return self._channel

    @channel.setter
    def channel(self, channel):
        """Sets the channel of this Video.


        :param channel: The channel of this Video.  # noqa: E501
        :type channel: VideoChannelSummary
        """

        self._channel = channel

    @property
    def user_history(self):
        """Gets the user_history of this Video.  # noqa: E501


        :return: The user_history of this Video.  # noqa: E501
        :rtype: VideoUserHistory
        """
        return self._user_history

    @user_history.setter
    def user_history(self, user_history):
        """Sets the user_history of this Video.


        :param user_history: The user_history of this Video.  # noqa: E501
        :type user_history: VideoUserHistory
        """

        self._user_history = user_history

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Video):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Video):
            return True

        return self.to_dict() != other.to_dict()
