/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.WireFormat;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.RouteDataObject;
import net.osmand.util.MapUtils;
import net.osmand.util.OpeningHoursParser;
import org.apache.commons.logging.Log;

public class BinaryMapRouteReaderAdapter {
    protected static final Log LOG = PlatformUtil.getLog(BinaryMapRouteReaderAdapter.class);
    private static final int SHIFT_COORDINATES = 4;
    private CodedInputStream codedIS;
    private final BinaryMapIndexReader map;

    protected BinaryMapRouteReaderAdapter(BinaryMapIndexReader map) {
        this.codedIS = map.codedIS;
        this.map = map;
    }

    private void skipUnknownField(int t) throws IOException {
        this.map.skipUnknownField(t);
    }

    private int readInt() throws IOException {
        return this.map.readInt();
    }

    protected void readRouteIndex(RouteRegion region) throws IOException {
        int routeEncodingRule = 1;
        block7: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 1: {
                    region.name = this.codedIS.readString();
                    continue block7;
                }
                case 2: {
                    int len = this.codedIS.readInt32();
                    int oldLimit = this.codedIS.pushLimit(len);
                    this.readRouteEncodingRule(region, routeEncodingRule++);
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    this.codedIS.popLimit(oldLimit);
                    continue block7;
                }
                case 3: 
                case 4: {
                    RouteSubregion subregion = new RouteSubregion(region);
                    subregion.length = this.readInt();
                    subregion.filePointer = this.codedIS.getTotalBytesRead();
                    int oldLimit = this.codedIS.pushLimit(subregion.length);
                    this.readRouteTree(subregion, null, 0, true);
                    if (tag == 3) {
                        region.subregions.add(subregion);
                    } else {
                        region.basesubregions.add(subregion);
                    }
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    this.codedIS.popLimit(oldLimit);
                    continue block7;
                }
                case 5: {
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private RouteDataObject readRouteDataObject(RouteRegion reg, int pleftx, int ptopy) throws IOException {
        RouteDataObject o = new RouteDataObject(reg);
        TIntArrayList pointsX = new TIntArrayList();
        TIntArrayList pointsY = new TIntArrayList();
        TIntArrayList types = new TIntArrayList();
        ArrayList<TIntArrayList> globalpointTypes = new ArrayList<TIntArrayList>();
        ArrayList<TIntArrayList> globalpointNames = new ArrayList<TIntArrayList>();
        block9: while (true) {
            int ts = this.codedIS.readTag();
            int tags = WireFormat.getTagFieldNumber(ts);
            switch (tags) {
                case 0: {
                    TIntArrayList l;
                    int k;
                    o.pointsX = pointsX.toArray();
                    o.pointsY = pointsY.toArray();
                    o.types = types.toArray();
                    if (globalpointTypes.size() > 0) {
                        o.pointTypes = new int[globalpointTypes.size()][];
                        for (k = 0; k < o.pointTypes.length; ++k) {
                            l = (TIntArrayList)globalpointTypes.get(k);
                            if (l == null) continue;
                            o.pointTypes[k] = l.toArray();
                        }
                    }
                    if (globalpointNames.size() > 0) {
                        o.pointNames = new String[globalpointNames.size()][];
                        o.pointNameTypes = new int[globalpointNames.size()][];
                        for (k = 0; k < o.pointNames.length; ++k) {
                            l = (TIntArrayList)globalpointNames.get(k);
                            if (l == null) continue;
                            o.pointNameTypes[k] = new int[l.size() / 2];
                            o.pointNames[k] = new String[l.size() / 2];
                            for (int ik = 0; ik < l.size(); ik += 2) {
                                o.pointNameTypes[k][ik / 2] = l.get(ik);
                                o.pointNames[k][ik / 2] = (char)l.get(ik + 1) + "";
                            }
                        }
                    }
                    return o;
                }
                case 7: {
                    int len = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(len);
                    while (this.codedIS.getBytesUntilLimit() > 0) {
                        types.add(this.codedIS.readRawVarint32());
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block9;
                }
                case 14: {
                    o.names = new TIntObjectHashMap();
                    int sizeL = this.codedIS.readRawVarint32();
                    int old = this.codedIS.pushLimit(sizeL);
                    TIntArrayList list = new TIntArrayList();
                    while (this.codedIS.getBytesUntilLimit() > 0) {
                        int stag = this.codedIS.readRawVarint32();
                        int pId = this.codedIS.readRawVarint32();
                        o.names.put(stag, (Object)((char)pId + ""));
                        list.add(stag);
                    }
                    o.nameIds = list.toArray();
                    this.codedIS.popLimit(old);
                    continue block9;
                }
                case 1: {
                    int len = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(len);
                    int px = pleftx >> 4;
                    int py = ptopy >> 4;
                    while (this.codedIS.getBytesUntilLimit() > 0) {
                        int x = this.codedIS.readSInt32() + px;
                        int y = this.codedIS.readSInt32() + py;
                        pointsX.add(x << 4);
                        pointsY.add(y << 4);
                        px = x;
                        py = y;
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block9;
                }
                case 5: {
                    int pointInd;
                    int len = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(len);
                    while (this.codedIS.getBytesUntilLimit() > 0) {
                        pointInd = this.codedIS.readRawVarint32();
                        int pointNameType = this.codedIS.readRawVarint32();
                        int nameInd = this.codedIS.readRawVarint32();
                        while (pointInd >= globalpointNames.size()) {
                            globalpointNames.add(null);
                        }
                        if (globalpointNames.get(pointInd) == null) {
                            TIntArrayList pointTypes = new TIntArrayList();
                            globalpointNames.set(pointInd, pointTypes);
                        }
                        ((TIntArrayList)globalpointNames.get(pointInd)).add(pointNameType);
                        ((TIntArrayList)globalpointNames.get(pointInd)).add(nameInd);
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block9;
                }
                case 4: {
                    int pointInd;
                    int len = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(len);
                    while (this.codedIS.getBytesUntilLimit() > 0) {
                        pointInd = this.codedIS.readRawVarint32();
                        TIntArrayList pointTypes = new TIntArrayList();
                        int lens = this.codedIS.readRawVarint32();
                        int oldLimits = this.codedIS.pushLimit(lens);
                        while (this.codedIS.getBytesUntilLimit() > 0) {
                            pointTypes.add(this.codedIS.readRawVarint32());
                        }
                        this.codedIS.popLimit(oldLimits);
                        while (pointInd >= globalpointTypes.size()) {
                            globalpointTypes.add(null);
                        }
                        globalpointTypes.set(pointInd, pointTypes);
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block9;
                }
                case 12: {
                    o.id = this.codedIS.readInt32();
                    continue block9;
                }
            }
            this.skipUnknownField(ts);
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void readRouteTreeData(RouteSubregion routeTree, TLongArrayList idTables, TLongObjectHashMap<TLongArrayList> restrictions) throws IOException {
        routeTree.dataObjects = new ArrayList<RouteDataObject>();
        idTables.clear();
        restrictions.clear();
        List<String> stringTable = null;
        block17: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    TLongObjectIterator it = restrictions.iterator();
                    while (it.hasNext()) {
                        it.advance();
                        int from = (int)it.key();
                        RouteDataObject fromr = routeTree.dataObjects.get(from);
                        fromr.restrictions = new long[((TLongArrayList)it.value()).size()];
                        for (int k = 0; k < fromr.restrictions.length; ++k) {
                            long valto;
                            int to = (int)(((TLongArrayList)it.value()).get(k) >> 3);
                            fromr.restrictions[k] = valto = idTables.get(to) << 3 | ((TLongArrayList)it.value()).get(k) & 7L;
                        }
                    }
                    for (RouteDataObject o : routeTree.dataObjects) {
                        if (o == null) continue;
                        if (o.id < (long)idTables.size()) {
                            o.id = idTables.get((int)o.id);
                        }
                        if (o.names != null && stringTable != null) {
                            Object keys = o.names.keys();
                            for (int j = 0; j < ((int[])keys).length; ++j) {
                                o.names.put(keys[j], (Object)stringTable.get(((String)o.names.get(keys[j])).charAt(0)));
                            }
                        }
                        if (o.pointNames == null || stringTable == null) continue;
                        for (int ar : (Object)o.pointNames) {
                            if (ar == null) continue;
                            for (int j = 0; j < ((int)ar).length; ++j) {
                                ar[j] = stringTable.get(ar[j].charAt(0));
                            }
                        }
                    }
                    return;
                }
                case 6: {
                    int length = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length);
                    RouteDataObject obj = this.readRouteDataObject(routeTree.routeReg, routeTree.left, routeTree.top);
                    while (obj.id >= (long)routeTree.dataObjects.size()) {
                        routeTree.dataObjects.add(null);
                    }
                    routeTree.dataObjects.set((int)obj.id, obj);
                    this.codedIS.popLimit(oldLimit);
                    continue block17;
                }
                case 5: {
                    long routeId = 0L;
                    int length = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length);
                    block25: while (true) {
                        int ts = this.codedIS.readTag();
                        int tags = WireFormat.getTagFieldNumber(ts);
                        switch (tags) {
                            case 0: {
                                break block25;
                            }
                            case 1: {
                                idTables.add(routeId += this.codedIS.readSInt64());
                                continue block25;
                            }
                            default: {
                                this.skipUnknownField(ts);
                                continue block25;
                            }
                        }
                        break;
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block17;
                }
                case 7: {
                    int length = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length);
                    long from = 0L;
                    long to = 0L;
                    long type = 0L;
                    block26: while (true) {
                        int ts = this.codedIS.readTag();
                        int tags = WireFormat.getTagFieldNumber(ts);
                        switch (tags) {
                            case 0: {
                                break block26;
                            }
                            case 2: {
                                from = this.codedIS.readInt32();
                                continue block26;
                            }
                            case 3: {
                                to = this.codedIS.readInt32();
                                continue block26;
                            }
                            case 1: {
                                type = this.codedIS.readInt32();
                                continue block26;
                            }
                            default: {
                                this.skipUnknownField(ts);
                                continue block26;
                            }
                        }
                        break;
                    }
                    if (!restrictions.containsKey(from)) {
                        restrictions.put(from, (Object)new TLongArrayList());
                    }
                    ((TLongArrayList)restrictions.get(from)).add((to << 3) + type);
                    this.codedIS.popLimit(oldLimit);
                    continue block17;
                }
                case 8: {
                    int length = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length);
                    stringTable = this.map.readStringTable();
                    this.codedIS.popLimit(oldLimit);
                    continue block17;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readRouteEncodingRule(RouteRegion index, int id2) throws IOException {
        String tags = null;
        String val = null;
        block6: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    index.initRouteEncodingRule(id2, tags, val);
                    return;
                }
                case 5: {
                    val = this.codedIS.readString().intern();
                    continue block6;
                }
                case 3: {
                    tags = this.codedIS.readString().intern();
                    continue block6;
                }
                case 7: {
                    id2 = this.codedIS.readUInt32();
                    continue block6;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private RouteSubregion readRouteTree(RouteSubregion thisTree, RouteSubregion parentTree, int depth, boolean readCoordinates) throws IOException {
        boolean readChildren;
        boolean bl = readChildren = depth != 0;
        if (readChildren) {
            thisTree.subregions = new ArrayList<RouteSubregion>();
        }
        ++thisTree.routeReg.regionsRead;
        block9: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return thisTree;
                }
                case 1: {
                    int i = this.codedIS.readSInt32();
                    if (!readCoordinates) continue block9;
                    thisTree.left = i + (parentTree != null ? parentTree.left : 0);
                    continue block9;
                }
                case 2: {
                    int i = this.codedIS.readSInt32();
                    if (!readCoordinates) continue block9;
                    thisTree.right = i + (parentTree != null ? parentTree.right : 0);
                    continue block9;
                }
                case 3: {
                    int i = this.codedIS.readSInt32();
                    if (!readCoordinates) continue block9;
                    thisTree.top = i + (parentTree != null ? parentTree.top : 0);
                    continue block9;
                }
                case 4: {
                    int i = this.codedIS.readSInt32();
                    if (!readCoordinates) continue block9;
                    thisTree.bottom = i + (parentTree != null ? parentTree.bottom : 0);
                    continue block9;
                }
                case 5: {
                    thisTree.shiftToData = this.readInt();
                    if (readChildren) continue block9;
                    thisTree.subregions = new ArrayList<RouteSubregion>();
                    readChildren = true;
                    continue block9;
                }
                case 7: {
                    if (readChildren) {
                        RouteSubregion subregion = new RouteSubregion(thisTree.routeReg);
                        subregion.length = this.readInt();
                        subregion.filePointer = this.codedIS.getTotalBytesRead();
                        int oldLimit = this.codedIS.pushLimit(subregion.length);
                        this.readRouteTree(subregion, thisTree, depth - 1, true);
                        thisTree.subregions.add(subregion);
                        this.codedIS.popLimit(oldLimit);
                        this.codedIS.seek(subregion.filePointer + subregion.length);
                        continue block9;
                    }
                    this.codedIS.seek(thisTree.filePointer + thisTree.length);
                    continue block9;
                }
            }
            this.skipUnknownField(t);
        }
    }

    public void initRouteTypesIfNeeded(BinaryMapIndexReader.SearchRequest<?> req, List<RouteSubregion> list) throws IOException {
        for (RouteSubregion rs : list) {
            if (!req.intersects(rs.left, rs.top, rs.right, rs.bottom)) continue;
            this.initRouteRegion(rs.routeReg);
        }
    }

    public void initRouteRegion(RouteRegion routeReg) throws IOException, InvalidProtocolBufferException {
        if (routeReg.routeEncodingRules.isEmpty()) {
            this.codedIS.seek(routeReg.filePointer);
            int oldLimit = this.codedIS.pushLimit(routeReg.length);
            this.readRouteIndex(routeReg);
            this.codedIS.popLimit(oldLimit);
        }
    }

    public List<RouteDataObject> loadRouteRegionData(RouteSubregion rs) throws IOException {
        TLongArrayList idMap = new TLongArrayList();
        TLongObjectHashMap restrictionMap = new TLongObjectHashMap();
        if (rs.dataObjects == null) {
            this.codedIS.seek(rs.filePointer + rs.shiftToData);
            int limit = this.codedIS.readRawVarint32();
            int oldLimit = this.codedIS.pushLimit(limit);
            this.readRouteTreeData(rs, idMap, (TLongObjectHashMap<TLongArrayList>)restrictionMap);
            this.codedIS.popLimit(oldLimit);
        }
        List<RouteDataObject> res = rs.dataObjects;
        rs.dataObjects = null;
        return res;
    }

    public void loadRouteRegionData(List<RouteSubregion> toLoad, ResultMatcher<RouteDataObject> matcher) throws IOException {
        Collections.sort(toLoad, new Comparator<RouteSubregion>(){

            @Override
            public int compare(RouteSubregion o1, RouteSubregion o2) {
                int p1 = o1.filePointer + o1.shiftToData;
                int p2 = o2.filePointer + o2.shiftToData;
                return p1 == p2 ? 0 : (p1 < p2 ? -1 : 1);
            }
        });
        TLongArrayList idMap = new TLongArrayList();
        TLongObjectHashMap restrictionMap = new TLongObjectHashMap();
        for (RouteSubregion rs : toLoad) {
            if (rs.dataObjects == null) {
                this.codedIS.seek(rs.filePointer + rs.shiftToData);
                int limit = this.codedIS.readRawVarint32();
                int oldLimit = this.codedIS.pushLimit(limit);
                this.readRouteTreeData(rs, idMap, (TLongObjectHashMap<TLongArrayList>)restrictionMap);
                this.codedIS.popLimit(oldLimit);
            }
            for (RouteDataObject ro : rs.dataObjects) {
                if (ro == null) continue;
                matcher.publish(ro);
            }
            rs.dataObjects = null;
        }
    }

    public List<RouteSubregion> searchRouteRegionTree(BinaryMapIndexReader.SearchRequest<?> req, List<RouteSubregion> list, List<RouteSubregion> toLoad) throws IOException {
        for (RouteSubregion rs : list) {
            if (!req.intersects(rs.left, rs.top, rs.right, rs.bottom)) continue;
            if (rs.subregions == null) {
                this.codedIS.seek(rs.filePointer);
                int old = this.codedIS.pushLimit(rs.length);
                this.readRouteTree(rs, null, req.contains(rs.left, rs.top, rs.right, rs.bottom) ? -1 : 1, false);
                this.codedIS.popLimit(old);
            }
            this.searchRouteRegionTree(req, rs.subregions, toLoad);
            if (rs.shiftToData == 0) continue;
            toLoad.add(rs);
        }
        return toLoad;
    }

    public List<RouteSubregion> loadInteresectedPoints(BinaryMapIndexReader.SearchRequest<RouteDataObject> req, List<RouteSubregion> list, List<RouteSubregion> toLoad) throws IOException {
        for (RouteSubregion rs : list) {
            if (!req.intersects(rs.left, rs.top, rs.right, rs.bottom)) continue;
            if (rs.subregions == null) {
                this.codedIS.seek(rs.filePointer);
                int old = this.codedIS.pushLimit(rs.length);
                this.readRouteTree(rs, null, req.contains(rs.left, rs.top, rs.right, rs.bottom) ? -1 : 1, false);
                this.codedIS.popLimit(old);
            }
            this.searchRouteRegionTree(req, rs.subregions, toLoad);
            if (rs.shiftToData == 0) continue;
            toLoad.add(rs);
        }
        return toLoad;
    }

    public static class RouteSubregion {
        private static final int INT_SIZE = 4;
        public final RouteRegion routeReg;
        public int length;
        public int filePointer;
        public int left;
        public int right;
        public int top;
        public int bottom;
        public int shiftToData;
        public List<RouteSubregion> subregions = null;
        public List<RouteDataObject> dataObjects = null;

        public RouteSubregion(RouteSubregion copy) {
            this.routeReg = copy.routeReg;
            this.left = copy.left;
            this.right = copy.right;
            this.top = copy.top;
            this.bottom = copy.bottom;
            this.filePointer = copy.filePointer;
            this.length = copy.length;
        }

        public RouteSubregion(RouteRegion routeReg) {
            this.routeReg = routeReg;
        }

        public int getEstimatedSize() {
            int shallow = 40;
            if (this.subregions != null) {
                shallow += 8;
                for (RouteSubregion s : this.subregions) {
                    shallow += s.getEstimatedSize();
                }
            }
            return shallow;
        }

        public int countSubregions() {
            int cnt = 1;
            if (this.subregions != null) {
                for (RouteSubregion s : this.subregions) {
                    cnt += s.countSubregions();
                }
            }
            return cnt;
        }
    }

    public static class RouteRegion
    extends BinaryIndexPart {
        public int regionsRead;
        List<RouteSubregion> subregions = new ArrayList<RouteSubregion>();
        List<RouteSubregion> basesubregions = new ArrayList<RouteSubregion>();
        List<RouteTypeRule> routeEncodingRules = new ArrayList<RouteTypeRule>();
        int nameTypeRule = -1;
        int refTypeRule = -1;
        int destinationTypeRule = -1;
        int destinationRefTypeRule = -1;

        public RouteTypeRule quickGetEncodingRule(int id2) {
            return this.routeEncodingRules.get(id2);
        }

        private void initRouteEncodingRule(int id2, String tags, String val) {
            while (this.routeEncodingRules.size() <= id2) {
                this.routeEncodingRules.add(null);
            }
            this.routeEncodingRules.set(id2, new RouteTypeRule(tags, val));
            if (tags.equals("name")) {
                this.nameTypeRule = id2;
            } else if (tags.equals("ref")) {
                this.refTypeRule = id2;
            } else if (tags.equals("destination")) {
                this.destinationTypeRule = id2;
            } else if (tags.equals("destination:ref")) {
                this.destinationRefTypeRule = id2;
            }
        }

        public List<RouteSubregion> getSubregions() {
            return this.subregions;
        }

        public List<RouteSubregion> getBaseSubregions() {
            return this.basesubregions;
        }

        public double getLeftLongitude() {
            double l = 180.0;
            for (RouteSubregion s : this.subregions) {
                l = Math.min(l, MapUtils.get31LongitudeX(s.left));
            }
            return l;
        }

        public double getRightLongitude() {
            double l = -180.0;
            for (RouteSubregion s : this.subregions) {
                l = Math.max(l, MapUtils.get31LongitudeX(s.right));
            }
            return l;
        }

        public double getBottomLatitude() {
            double l = 90.0;
            for (RouteSubregion s : this.subregions) {
                l = Math.min(l, MapUtils.get31LatitudeY(s.bottom));
            }
            return l;
        }

        public double getTopLatitude() {
            double l = -90.0;
            for (RouteSubregion s : this.subregions) {
                l = Math.max(l, MapUtils.get31LatitudeY(s.top));
            }
            return l;
        }

        public boolean contains(int x31, int y31) {
            for (RouteSubregion s : this.subregions) {
                if (s.left > x31 || s.right < x31 || s.top > y31 || s.bottom < y31) continue;
                return true;
            }
            return false;
        }
    }

    public static class RouteTypeRule {
        private static final int ACCESS = 1;
        private static final int ONEWAY = 2;
        private static final int HIGHWAY_TYPE = 3;
        private static final int MAXSPEED = 4;
        private static final int ROUNDABOUT = 5;
        public static final int TRAFFIC_SIGNALS = 6;
        public static final int RAILWAY_CROSSING = 7;
        private static final int LANES = 8;
        private final String t;
        private final String v;
        private int intValue;
        private float floatValue;
        private int type;
        private List<RouteTypeCondition> conditions = null;
        private int forward;

        public RouteTypeRule(String t, String v) {
            this.t = t.intern();
            if ("true".equals(v)) {
                v = "yes";
            }
            if ("false".equals(v)) {
                v = "no";
            }
            this.v = v == null ? null : v.intern();
            try {
                this.analyze();
            }
            catch (RuntimeException e) {
                System.err.println("Error analyzing tag/value = " + t + "/" + v);
                throw e;
            }
        }

        public int isForward() {
            return this.forward;
        }

        public String getTag() {
            return this.t;
        }

        public String getValue() {
            return this.v;
        }

        public boolean roundabout() {
            return this.type == 5;
        }

        public int getType() {
            return this.type;
        }

        public boolean conditional() {
            return this.conditions != null;
        }

        public int onewayDirection() {
            if (this.type == 2) {
                return this.intValue;
            }
            return 0;
        }

        public float maxSpeed() {
            if (this.type == 4) {
                if (this.conditions != null) {
                    Calendar i = Calendar.getInstance();
                    i.setTimeInMillis(System.currentTimeMillis());
                    for (RouteTypeCondition c : this.conditions) {
                        if (c.hours == null || !c.hours.isOpenedForTime(i)) continue;
                        return c.floatValue;
                    }
                }
                return this.floatValue;
            }
            return -1.0f;
        }

        public int lanes() {
            if (this.type == 8) {
                return this.intValue;
            }
            return -1;
        }

        public String highwayRoad() {
            if (this.type == 3) {
                return this.v;
            }
            return null;
        }

        private void analyze() {
            if (this.t.equalsIgnoreCase("oneway")) {
                this.type = 2;
                this.intValue = "-1".equals(this.v) || "reverse".equals(this.v) ? -1 : ("1".equals(this.v) || "yes".equals(this.v) ? 1 : 0);
            } else if (this.t.equalsIgnoreCase("highway") && "traffic_signals".equals(this.v)) {
                this.type = 6;
            } else if (this.t.equalsIgnoreCase("railway") && ("crossing".equals(this.v) || "level_crossing".equals(this.v))) {
                this.type = 7;
            } else if (this.t.equalsIgnoreCase("roundabout") && this.v != null) {
                this.type = 5;
            } else if (this.t.equalsIgnoreCase("junction") && "roundabout".equalsIgnoreCase(this.v)) {
                this.type = 5;
            } else if (this.t.equalsIgnoreCase("highway") && this.v != null) {
                this.type = 3;
            } else if (this.t.startsWith("access") && this.v != null) {
                this.type = 1;
            } else if (this.t.equalsIgnoreCase("maxspeed:conditional") && this.v != null) {
                String[] cts;
                this.conditions = new ArrayList<RouteTypeCondition>();
                for (String c : cts = this.v.split(";")) {
                    int ch = c.indexOf(64);
                    if (ch <= 0) continue;
                    RouteTypeCondition cond = new RouteTypeCondition();
                    cond.floatValue = RouteDataObject.parseSpeed(c.substring(0, ch), 0.0f);
                    cond.condition = c.substring(ch + 1).trim();
                    if (cond.condition.startsWith("(") && cond.condition.endsWith(")")) {
                        cond.condition = cond.condition.substring(1, cond.condition.length() - 1).trim();
                    }
                    cond.hours = OpeningHoursParser.parseOpenedHours(cond.condition);
                    this.conditions.add(cond);
                }
                this.type = 4;
            } else if (this.t.equalsIgnoreCase("maxspeed") && this.v != null) {
                this.type = 4;
                this.floatValue = RouteDataObject.parseSpeed(this.v, 0.0f);
            } else if (this.t.equalsIgnoreCase("maxspeed:forward") && this.v != null) {
                this.type = 4;
                this.forward = 1;
                this.floatValue = RouteDataObject.parseSpeed(this.v, 0.0f);
            } else if (this.t.equalsIgnoreCase("maxspeed:backward") && this.v != null) {
                this.type = 4;
                this.forward = -1;
                this.floatValue = RouteDataObject.parseSpeed(this.v, 0.0f);
            } else if (this.t.equalsIgnoreCase("lanes") && this.v != null) {
                int i;
                this.intValue = -1;
                this.type = 8;
                for (i = 0; i < this.v.length() && Character.isDigit(this.v.charAt(i)); ++i) {
                }
                if (i > 0) {
                    this.intValue = Integer.parseInt(this.v.substring(0, i));
                }
            }
        }
    }

    private static class RouteTypeCondition {
        String condition = "";
        OpeningHoursParser.OpeningHours hours = null;
        float floatValue;

        private RouteTypeCondition() {
        }
    }
}

