/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.RouteTableAssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateRouteTableResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AssociateRouteTableResponse> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(AssociateRouteTableResponse.getter(AssociateRouteTableResponse::associationId)).setter(AssociateRouteTableResponse.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<RouteTableAssociationState> ASSOCIATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssociationState").getter(AssociateRouteTableResponse.getter(AssociateRouteTableResponse::associationState)).setter(AssociateRouteTableResponse.setter(Builder::associationState)).constructor(RouteTableAssociationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationState").unmarshallLocationName("associationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, ASSOCIATION_STATE_FIELD));
    private final String associationId;
    private final RouteTableAssociationState associationState;

    private AssociateRouteTableResponse(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.associationState = builder.associationState;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final RouteTableAssociationState associationState() {
        return this.associationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateRouteTableResponse)) {
            return false;
        }
        AssociateRouteTableResponse other = (AssociateRouteTableResponse)((Object)obj);
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.associationState(), other.associationState());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateRouteTableResponse").add("AssociationId", (Object)this.associationId()).add("AssociationState", (Object)this.associationState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "AssociationState": {
                return Optional.ofNullable(clazz.cast(this.associationState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateRouteTableResponse, T> g) {
        return obj -> g.apply((AssociateRouteTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String associationId;
        private RouteTableAssociationState associationState;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateRouteTableResponse model) {
            super(model);
            this.associationId(model.associationId);
            this.associationState(model.associationState);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final RouteTableAssociationState.Builder getAssociationState() {
            return this.associationState != null ? this.associationState.toBuilder() : null;
        }

        public final void setAssociationState(RouteTableAssociationState.BuilderImpl associationState) {
            this.associationState = associationState != null ? associationState.build() : null;
        }

        @Override
        public final Builder associationState(RouteTableAssociationState associationState) {
            this.associationState = associationState;
            return this;
        }

        @Override
        public AssociateRouteTableResponse build() {
            return new AssociateRouteTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateRouteTableResponse> {
        public Builder associationId(String var1);

        public Builder associationState(RouteTableAssociationState var1);

        default public Builder associationState(Consumer<RouteTableAssociationState.Builder> associationState) {
            return this.associationState((RouteTableAssociationState)((RouteTableAssociationState.Builder)RouteTableAssociationState.builder().applyMutation(associationState)).build());
        }
    }
}

