/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpoint;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVerifiedAccessEndpointsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVerifiedAccessEndpointsResponse> {
    private static final SdkField<List<VerifiedAccessEndpoint>> VERIFIED_ACCESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VerifiedAccessEndpoints").getter(DescribeVerifiedAccessEndpointsResponse.getter(DescribeVerifiedAccessEndpointsResponse::verifiedAccessEndpoints)).setter(DescribeVerifiedAccessEndpointsResponse.setter(Builder::verifiedAccessEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessEndpointSet").unmarshallLocationName("verifiedAccessEndpointSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VerifiedAccessEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVerifiedAccessEndpointsResponse.getter(DescribeVerifiedAccessEndpointsResponse::nextToken)).setter(DescribeVerifiedAccessEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_ENDPOINTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<VerifiedAccessEndpoint> verifiedAccessEndpoints;
    private final String nextToken;

    private DescribeVerifiedAccessEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessEndpoints = builder.verifiedAccessEndpoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVerifiedAccessEndpoints() {
        return this.verifiedAccessEndpoints != null && !(this.verifiedAccessEndpoints instanceof SdkAutoConstructList);
    }

    public final List<VerifiedAccessEndpoint> verifiedAccessEndpoints() {
        return this.verifiedAccessEndpoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVerifiedAccessEndpoints() ? this.verifiedAccessEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVerifiedAccessEndpointsResponse)) {
            return false;
        }
        DescribeVerifiedAccessEndpointsResponse other = (DescribeVerifiedAccessEndpointsResponse)((Object)obj);
        return this.hasVerifiedAccessEndpoints() == other.hasVerifiedAccessEndpoints() && Objects.equals(this.verifiedAccessEndpoints(), other.verifiedAccessEndpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVerifiedAccessEndpointsResponse").add("VerifiedAccessEndpoints", this.hasVerifiedAccessEndpoints() ? this.verifiedAccessEndpoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessEndpoints": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessEndpoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVerifiedAccessEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeVerifiedAccessEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VerifiedAccessEndpoint> verifiedAccessEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVerifiedAccessEndpointsResponse model) {
            super(model);
            this.verifiedAccessEndpoints(model.verifiedAccessEndpoints);
            this.nextToken(model.nextToken);
        }

        public final List<VerifiedAccessEndpoint.Builder> getVerifiedAccessEndpoints() {
            List<VerifiedAccessEndpoint.Builder> result = VerifiedAccessEndpointListCopier.copyToBuilder(this.verifiedAccessEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVerifiedAccessEndpoints(Collection<VerifiedAccessEndpoint.BuilderImpl> verifiedAccessEndpoints) {
            this.verifiedAccessEndpoints = VerifiedAccessEndpointListCopier.copyFromBuilder(verifiedAccessEndpoints);
        }

        @Override
        public final Builder verifiedAccessEndpoints(Collection<VerifiedAccessEndpoint> verifiedAccessEndpoints) {
            this.verifiedAccessEndpoints = VerifiedAccessEndpointListCopier.copy(verifiedAccessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessEndpoints(VerifiedAccessEndpoint ... verifiedAccessEndpoints) {
            this.verifiedAccessEndpoints(Arrays.asList(verifiedAccessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessEndpoints(Consumer<VerifiedAccessEndpoint.Builder> ... verifiedAccessEndpoints) {
            this.verifiedAccessEndpoints(Stream.of(verifiedAccessEndpoints).map(c -> (VerifiedAccessEndpoint)((VerifiedAccessEndpoint.Builder)VerifiedAccessEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVerifiedAccessEndpointsResponse build() {
            return new DescribeVerifiedAccessEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVerifiedAccessEndpointsResponse> {
        public Builder verifiedAccessEndpoints(Collection<VerifiedAccessEndpoint> var1);

        public Builder verifiedAccessEndpoints(VerifiedAccessEndpoint ... var1);

        public Builder verifiedAccessEndpoints(Consumer<VerifiedAccessEndpoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

