/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DiskImageDetail;
import software.amazon.awssdk.services.ec2.model.VolumeDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiskImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DiskImage> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DiskImage.getter(DiskImage::description)).setter(DiskImage.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<DiskImageDetail> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Image").getter(DiskImage.getter(DiskImage::image)).setter(DiskImage.setter(Builder::image)).constructor(DiskImageDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").unmarshallLocationName("Image").build()}).build();
    private static final SdkField<VolumeDetail> VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Volume").getter(DiskImage.getter(DiskImage::volume)).setter(DiskImage.setter(Builder::volume)).constructor(VolumeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volume").unmarshallLocationName("Volume").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, IMAGE_FIELD, VOLUME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final DiskImageDetail image;
    private final VolumeDetail volume;

    private DiskImage(BuilderImpl builder) {
        this.description = builder.description;
        this.image = builder.image;
        this.volume = builder.volume;
    }

    public final String description() {
        return this.description;
    }

    public final DiskImageDetail image() {
        return this.image;
    }

    public final VolumeDetail volume() {
        return this.volume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.volume());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskImage)) {
            return false;
        }
        DiskImage other = (DiskImage)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.volume(), other.volume());
    }

    public final String toString() {
        return ToString.builder((String)"DiskImage").add("Description", (Object)this.description()).add("Image", (Object)this.image()).add("Volume", (Object)this.volume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "Volume": {
                return Optional.ofNullable(clazz.cast(this.volume()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiskImage, T> g) {
        return obj -> g.apply((DiskImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private DiskImageDetail image;
        private VolumeDetail volume;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskImage model) {
            this.description(model.description);
            this.image(model.image);
            this.volume(model.volume);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DiskImageDetail.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(DiskImageDetail.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(DiskImageDetail image) {
            this.image = image;
            return this;
        }

        public final VolumeDetail.Builder getVolume() {
            return this.volume != null ? this.volume.toBuilder() : null;
        }

        public final void setVolume(VolumeDetail.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        @Override
        public final Builder volume(VolumeDetail volume) {
            this.volume = volume;
            return this;
        }

        public DiskImage build() {
            return new DiskImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DiskImage> {
        public Builder description(String var1);

        public Builder image(DiskImageDetail var1);

        default public Builder image(Consumer<DiskImageDetail.Builder> image) {
            return this.image((DiskImageDetail)((DiskImageDetail.Builder)DiskImageDetail.builder().applyMutation(image)).build());
        }

        public Builder volume(VolumeDetail var1);

        default public Builder volume(Consumer<VolumeDetail.Builder> volume) {
            return this.volume((VolumeDetail)((VolumeDetail.Builder)VolumeDetail.builder().applyMutation(volume)).build());
        }
    }
}

