/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Purchase;
import software.amazon.awssdk.services.ec2.model.PurchaseSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHostReservationPurchasePreviewResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetHostReservationPurchasePreviewResponse> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(GetHostReservationPurchasePreviewResponse.getter(GetHostReservationPurchasePreviewResponse::currencyCodeAsString)).setter(GetHostReservationPurchasePreviewResponse.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").unmarshallLocationName("currencyCode").build()}).build();
    private static final SdkField<List<Purchase>> PURCHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Purchase").getter(GetHostReservationPurchasePreviewResponse.getter(GetHostReservationPurchasePreviewResponse::purchase)).setter(GetHostReservationPurchasePreviewResponse.setter(Builder::purchase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Purchase").unmarshallLocationName("purchase").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Purchase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> TOTAL_HOURLY_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalHourlyPrice").getter(GetHostReservationPurchasePreviewResponse.getter(GetHostReservationPurchasePreviewResponse::totalHourlyPrice)).setter(GetHostReservationPurchasePreviewResponse.setter(Builder::totalHourlyPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalHourlyPrice").unmarshallLocationName("totalHourlyPrice").build()}).build();
    private static final SdkField<String> TOTAL_UPFRONT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalUpfrontPrice").getter(GetHostReservationPurchasePreviewResponse.getter(GetHostReservationPurchasePreviewResponse::totalUpfrontPrice)).setter(GetHostReservationPurchasePreviewResponse.setter(Builder::totalUpfrontPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalUpfrontPrice").unmarshallLocationName("totalUpfrontPrice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD, PURCHASE_FIELD, TOTAL_HOURLY_PRICE_FIELD, TOTAL_UPFRONT_PRICE_FIELD));
    private final String currencyCode;
    private final List<Purchase> purchase;
    private final String totalHourlyPrice;
    private final String totalUpfrontPrice;

    private GetHostReservationPurchasePreviewResponse(BuilderImpl builder) {
        super(builder);
        this.currencyCode = builder.currencyCode;
        this.purchase = builder.purchase;
        this.totalHourlyPrice = builder.totalHourlyPrice;
        this.totalUpfrontPrice = builder.totalUpfrontPrice;
    }

    public final CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public final String currencyCodeAsString() {
        return this.currencyCode;
    }

    public final boolean hasPurchase() {
        return this.purchase != null && !(this.purchase instanceof SdkAutoConstructList);
    }

    public final List<Purchase> purchase() {
        return this.purchase;
    }

    public final String totalHourlyPrice() {
        return this.totalHourlyPrice;
    }

    public final String totalUpfrontPrice() {
        return this.totalUpfrontPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPurchase() ? this.purchase() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalHourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalUpfrontPrice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostReservationPurchasePreviewResponse)) {
            return false;
        }
        GetHostReservationPurchasePreviewResponse other = (GetHostReservationPurchasePreviewResponse)((Object)obj);
        return Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && this.hasPurchase() == other.hasPurchase() && Objects.equals(this.purchase(), other.purchase()) && Objects.equals(this.totalHourlyPrice(), other.totalHourlyPrice()) && Objects.equals(this.totalUpfrontPrice(), other.totalUpfrontPrice());
    }

    public final String toString() {
        return ToString.builder((String)"GetHostReservationPurchasePreviewResponse").add("CurrencyCode", (Object)this.currencyCodeAsString()).add("Purchase", this.hasPurchase() ? this.purchase() : null).add("TotalHourlyPrice", (Object)this.totalHourlyPrice()).add("TotalUpfrontPrice", (Object)this.totalUpfrontPrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCodeAsString()));
            }
            case "Purchase": {
                return Optional.ofNullable(clazz.cast(this.purchase()));
            }
            case "TotalHourlyPrice": {
                return Optional.ofNullable(clazz.cast(this.totalHourlyPrice()));
            }
            case "TotalUpfrontPrice": {
                return Optional.ofNullable(clazz.cast(this.totalUpfrontPrice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHostReservationPurchasePreviewResponse, T> g) {
        return obj -> g.apply((GetHostReservationPurchasePreviewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String currencyCode;
        private List<Purchase> purchase = DefaultSdkAutoConstructList.getInstance();
        private String totalHourlyPrice;
        private String totalUpfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostReservationPurchasePreviewResponse model) {
            super(model);
            this.currencyCode(model.currencyCode);
            this.purchase(model.purchase);
            this.totalHourlyPrice(model.totalHourlyPrice);
            this.totalUpfrontPrice(model.totalUpfrontPrice);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final List<Purchase.Builder> getPurchase() {
            List<Purchase.Builder> result = PurchaseSetCopier.copyToBuilder(this.purchase);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPurchase(Collection<Purchase.BuilderImpl> purchase) {
            this.purchase = PurchaseSetCopier.copyFromBuilder(purchase);
        }

        @Override
        public final Builder purchase(Collection<Purchase> purchase) {
            this.purchase = PurchaseSetCopier.copy(purchase);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Purchase ... purchase) {
            this.purchase(Arrays.asList(purchase));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Consumer<Purchase.Builder> ... purchase) {
            this.purchase(Stream.of(purchase).map(c -> (Purchase)((Purchase.Builder)Purchase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTotalHourlyPrice() {
            return this.totalHourlyPrice;
        }

        public final void setTotalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
        }

        @Override
        public final Builder totalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
            return this;
        }

        public final String getTotalUpfrontPrice() {
            return this.totalUpfrontPrice;
        }

        public final void setTotalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
        }

        @Override
        public final Builder totalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
            return this;
        }

        @Override
        public GetHostReservationPurchasePreviewResponse build() {
            return new GetHostReservationPurchasePreviewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetHostReservationPurchasePreviewResponse> {
        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder purchase(Collection<Purchase> var1);

        public Builder purchase(Purchase ... var1);

        public Builder purchase(Consumer<Purchase.Builder> ... var1);

        public Builder totalHourlyPrice(String var1);

        public Builder totalUpfrontPrice(String var1);
    }
}

