/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.PrefixList;

public class DescribePrefixListsPublisher
implements SdkPublisher<DescribePrefixListsResponse> {
    private final Ec2AsyncClient client;
    private final DescribePrefixListsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePrefixListsPublisher(Ec2AsyncClient client, DescribePrefixListsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePrefixListsPublisher(Ec2AsyncClient client, DescribePrefixListsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePrefixListsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePrefixListsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PrefixList> prefixLists() {
        Function<DescribePrefixListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.prefixLists() != null) {
                return response.prefixLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribePrefixListsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribePrefixListsResponseFetcher
    implements AsyncPageFetcher<DescribePrefixListsResponse> {
        private DescribePrefixListsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePrefixListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePrefixListsResponse> nextPage(DescribePrefixListsResponse previousPage) {
            if (previousPage == null) {
                return DescribePrefixListsPublisher.this.client.describePrefixLists(DescribePrefixListsPublisher.this.firstRequest);
            }
            return DescribePrefixListsPublisher.this.client.describePrefixLists((DescribePrefixListsRequest)((Object)DescribePrefixListsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

