/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.jobscheduler;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.geospatial.annotation.VisibleForTesting;
import org.opensearch.geospatial.ip2geo.action.PutDatasourceRequest;
import org.opensearch.geospatial.ip2geo.common.DatasourceManifest;
import org.opensearch.geospatial.ip2geo.common.DatasourceState;
import org.opensearch.geospatial.ip2geo.jobscheduler.DatasourceTask;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;

public class Datasource
implements Writeable,
ScheduledJobParameter {
    public static final String IP2GEO_DATA_INDEX_NAME_PREFIX = ".geospatial-ip2geo-data";
    private static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    private static final ParseField ENABLED_FIELD = new ParseField("update_enabled", new String[0]);
    private static final ParseField LAST_UPDATE_TIME_FIELD = new ParseField("last_update_time", new String[0]);
    private static final ParseField LAST_UPDATE_TIME_FIELD_READABLE = new ParseField("last_update_time_field", new String[0]);
    private static final ParseField USER_SCHEDULE_FIELD = new ParseField("user_schedule", new String[0]);
    private static final ParseField SYSTEM_SCHEDULE_FIELD = new ParseField("system_schedule", new String[0]);
    private static final ParseField TASK_FIELD = new ParseField("task", new String[0]);
    private static final ParseField ENABLED_TIME_FIELD = new ParseField("enabled_time", new String[0]);
    private static final ParseField ENABLED_TIME_FIELD_READABLE = new ParseField("enabled_time_field", new String[0]);
    private static final ParseField ENDPOINT_FIELD = new ParseField("endpoint", new String[0]);
    private static final ParseField STATE_FIELD = new ParseField("state", new String[0]);
    private static final ParseField CURRENT_INDEX_FIELD = new ParseField("current_index", new String[0]);
    private static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final ParseField DATABASE_FIELD = new ParseField("database", new String[0]);
    private static final ParseField UPDATE_STATS_FIELD = new ParseField("update_stats", new String[0]);
    private String name;
    private Instant lastUpdateTime;
    private Instant enabledTime;
    private boolean isEnabled;
    private IntervalSchedule userSchedule;
    private IntervalSchedule systemSchedule;
    private DatasourceTask task;
    private String endpoint;
    private DatasourceState state;
    private String currentIndex;
    private List<String> indices;
    private Database database;
    private UpdateStats updateStats;
    public static final ConstructingObjectParser<Datasource, Void> PARSER = new ConstructingObjectParser("datasource_metadata", true, args -> {
        String name = (String)args[0];
        Instant lastUpdateTime = Instant.ofEpochMilli((Long)args[1]);
        Instant enabledTime = args[2] == null ? null : Instant.ofEpochMilli((Long)args[2]);
        boolean isEnabled = (Boolean)args[3];
        IntervalSchedule userSchedule = (IntervalSchedule)args[4];
        IntervalSchedule systemSchedule = (IntervalSchedule)args[5];
        DatasourceTask task = DatasourceTask.valueOf((String)args[6]);
        String endpoint = (String)args[7];
        DatasourceState state = DatasourceState.valueOf((String)args[8]);
        String currentIndex = (String)args[9];
        List indices = (List)args[10];
        Database database = (Database)args[11];
        UpdateStats updateStats = (UpdateStats)args[12];
        Datasource parameter = new Datasource(name, lastUpdateTime, enabledTime, isEnabled, userSchedule, systemSchedule, task, endpoint, state, currentIndex, indices, database, updateStats);
        return parameter;
    });

    @VisibleForTesting
    public Datasource() {
        this(null, null, null);
    }

    public Datasource(String name, IntervalSchedule schedule, String endpoint) {
        this(name, Instant.now().truncatedTo(ChronoUnit.MILLIS), null, false, schedule, schedule, DatasourceTask.ALL, endpoint, DatasourceState.CREATING, null, new ArrayList<String>(), new Database(), new UpdateStats());
    }

    public Datasource(StreamInput in) throws IOException {
        this.name = in.readString();
        this.lastUpdateTime = Datasource.toInstant(in.readVLong());
        this.enabledTime = Datasource.toInstant(in.readOptionalVLong());
        this.isEnabled = in.readBoolean();
        this.userSchedule = new IntervalSchedule(in);
        this.systemSchedule = new IntervalSchedule(in);
        this.task = DatasourceTask.valueOf(in.readString());
        this.endpoint = in.readString();
        this.state = DatasourceState.valueOf(in.readString());
        this.currentIndex = in.readOptionalString();
        this.indices = in.readStringList();
        this.database = new Database(in);
        this.updateStats = new UpdateStats(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVLong(this.lastUpdateTime.toEpochMilli());
        out.writeOptionalVLong(this.enabledTime == null ? null : Long.valueOf(this.enabledTime.toEpochMilli()));
        out.writeBoolean(this.isEnabled);
        this.userSchedule.writeTo(out);
        this.systemSchedule.writeTo(out);
        out.writeString(this.task.name());
        out.writeString(this.endpoint);
        out.writeString(this.state.name());
        out.writeOptionalString(this.currentIndex);
        out.writeStringCollection(this.indices);
        this.database.writeTo(out);
        this.updateStats.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        builder.timeField(LAST_UPDATE_TIME_FIELD.getPreferredName(), LAST_UPDATE_TIME_FIELD_READABLE.getPreferredName(), this.lastUpdateTime.toEpochMilli());
        if (this.enabledTime != null) {
            builder.timeField(ENABLED_TIME_FIELD.getPreferredName(), ENABLED_TIME_FIELD_READABLE.getPreferredName(), this.enabledTime.toEpochMilli());
        }
        builder.field(ENABLED_FIELD.getPreferredName(), this.isEnabled);
        builder.field(USER_SCHEDULE_FIELD.getPreferredName(), (ToXContent)this.userSchedule);
        builder.field(SYSTEM_SCHEDULE_FIELD.getPreferredName(), (ToXContent)this.systemSchedule);
        builder.field(TASK_FIELD.getPreferredName(), this.task.name());
        builder.field(ENDPOINT_FIELD.getPreferredName(), this.endpoint);
        builder.field(STATE_FIELD.getPreferredName(), this.state.name());
        if (this.currentIndex != null) {
            builder.field(CURRENT_INDEX_FIELD.getPreferredName(), this.currentIndex);
        }
        builder.field(INDICES_FIELD.getPreferredName(), this.indices);
        builder.field(DATABASE_FIELD.getPreferredName(), (ToXContent)this.database);
        builder.field(UPDATE_STATS_FIELD.getPreferredName(), (ToXContent)this.updateStats);
        builder.endObject();
        return builder;
    }

    public String getName() {
        return this.name;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Instant getEnabledTime() {
        return this.enabledTime;
    }

    public IntervalSchedule getSchedule() {
        return this.systemSchedule;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Long getLockDurationSeconds() {
        return 300L;
    }

    public void enable() {
        if (this.isEnabled) {
            return;
        }
        this.enabledTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.isEnabled = true;
    }

    public void disable() {
        this.enabledTime = null;
        this.isEnabled = false;
    }

    public String currentIndexName() {
        if (this.isExpired()) {
            return null;
        }
        return this.currentIndex;
    }

    public String newIndexName(String suffix) {
        return String.format(Locale.ROOT, "%s.%s.%s", IP2GEO_DATA_INDEX_NAME_PREFIX, this.name, suffix);
    }

    public void resetDatabase() {
        this.database.setUpdatedAt(null);
        this.database.setSha256Hash(null);
    }

    public boolean isExpired() {
        return this.willExpire(Instant.now());
    }

    public boolean willExpire(Instant instant) {
        if (this.database.validForInDays == null) {
            return false;
        }
        return instant.isAfter(this.expirationDay());
    }

    public Instant expirationDay() {
        if (this.database.validForInDays == null) {
            return Instant.MAX;
        }
        return this.lastCheckedAt().plus((long)this.database.validForInDays, ChronoUnit.DAYS);
    }

    private Instant lastCheckedAt() {
        Instant lastCheckedAt = this.updateStats.lastSkippedAt == null ? this.updateStats.lastSucceededAt : (this.updateStats.lastSucceededAt.isBefore(this.updateStats.lastSkippedAt) ? this.updateStats.lastSkippedAt : this.updateStats.lastSucceededAt);
        return lastCheckedAt;
    }

    public void setDatabase(DatasourceManifest datasourceManifest, List<String> fields) {
        this.database.setProvider(datasourceManifest.getProvider());
        this.database.setSha256Hash(datasourceManifest.getSha256Hash());
        this.database.setUpdatedAt(Instant.ofEpochMilli(datasourceManifest.getUpdatedAt()));
        this.database.setValidForInDays(datasourceManifest.getValidForInDays());
        this.database.setFields(fields);
    }

    public boolean isCompatible(List<String> fields) {
        if (this.database.fields == null) {
            return true;
        }
        if (fields.size() < this.database.fields.size()) {
            return false;
        }
        HashSet<String> fieldsSet = new HashSet<String>(fields);
        for (String field : this.database.fields) {
            if (fieldsSet.contains(field)) continue;
            return false;
        }
        return true;
    }

    private static Instant toInstant(Long epochMilli) {
        return epochMilli == null ? null : Instant.ofEpochMilli(epochMilli);
    }

    @Generated
    public IntervalSchedule getUserSchedule() {
        return this.userSchedule;
    }

    @Generated
    public IntervalSchedule getSystemSchedule() {
        return this.systemSchedule;
    }

    @Generated
    public DatasourceTask getTask() {
        return this.task;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public DatasourceState getState() {
        return this.state;
    }

    @Generated
    public List<String> getIndices() {
        return this.indices;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public UpdateStats getUpdateStats() {
        return this.updateStats;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Generated
    public void setEnabledTime(Instant enabledTime) {
        this.enabledTime = enabledTime;
    }

    @Generated
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Generated
    public void setUserSchedule(IntervalSchedule userSchedule) {
        this.userSchedule = userSchedule;
    }

    @Generated
    public void setSystemSchedule(IntervalSchedule systemSchedule) {
        this.systemSchedule = systemSchedule;
    }

    @Generated
    public void setTask(DatasourceTask task) {
        this.task = task;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setState(DatasourceState state) {
        this.state = state;
    }

    @Generated
    public void setCurrentIndex(String currentIndex) {
        this.currentIndex = currentIndex;
    }

    @Generated
    public void setIndices(List<String> indices) {
        this.indices = indices;
    }

    @Generated
    public void setDatabase(Database database) {
        this.database = database;
    }

    @Generated
    public void setUpdateStats(UpdateStats updateStats) {
        this.updateStats = updateStats;
    }

    @Generated
    public String toString() {
        return "Datasource(name=" + this.getName() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", enabledTime=" + this.getEnabledTime() + ", isEnabled=" + this.isEnabled() + ", userSchedule=" + this.getUserSchedule() + ", systemSchedule=" + this.getSystemSchedule() + ", task=" + this.getTask() + ", endpoint=" + this.getEndpoint() + ", state=" + this.getState() + ", currentIndex=" + this.currentIndex + ", indices=" + this.getIndices() + ", database=" + this.getDatabase() + ", updateStats=" + this.getUpdateStats() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Datasource)) {
            return false;
        }
        Datasource other = (Datasource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Instant this$lastUpdateTime = this.getLastUpdateTime();
        Instant other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        Instant this$enabledTime = this.getEnabledTime();
        Instant other$enabledTime = other.getEnabledTime();
        if (this$enabledTime == null ? other$enabledTime != null : !((Object)this$enabledTime).equals(other$enabledTime)) {
            return false;
        }
        IntervalSchedule this$userSchedule = this.getUserSchedule();
        IntervalSchedule other$userSchedule = other.getUserSchedule();
        if (this$userSchedule == null ? other$userSchedule != null : !this$userSchedule.equals(other$userSchedule)) {
            return false;
        }
        IntervalSchedule this$systemSchedule = this.getSystemSchedule();
        IntervalSchedule other$systemSchedule = other.getSystemSchedule();
        if (this$systemSchedule == null ? other$systemSchedule != null : !this$systemSchedule.equals(other$systemSchedule)) {
            return false;
        }
        DatasourceTask this$task = this.getTask();
        DatasourceTask other$task = other.getTask();
        if (this$task == null ? other$task != null : !((Object)((Object)this$task)).equals((Object)other$task)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        DatasourceState this$state = this.getState();
        DatasourceState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$currentIndex = this.currentIndex;
        String other$currentIndex = other.currentIndex;
        if (this$currentIndex == null ? other$currentIndex != null : !this$currentIndex.equals(other$currentIndex)) {
            return false;
        }
        List<String> this$indices = this.getIndices();
        List<String> other$indices = other.getIndices();
        if (this$indices == null ? other$indices != null : !((Object)this$indices).equals(other$indices)) {
            return false;
        }
        Database this$database = this.getDatabase();
        Database other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !((Object)this$database).equals(other$database)) {
            return false;
        }
        UpdateStats this$updateStats = this.getUpdateStats();
        UpdateStats other$updateStats = other.getUpdateStats();
        return !(this$updateStats == null ? other$updateStats != null : !((Object)this$updateStats).equals(other$updateStats));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Datasource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Instant $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        Instant $enabledTime = this.getEnabledTime();
        result = result * 59 + ($enabledTime == null ? 43 : ((Object)$enabledTime).hashCode());
        IntervalSchedule $userSchedule = this.getUserSchedule();
        result = result * 59 + ($userSchedule == null ? 43 : $userSchedule.hashCode());
        IntervalSchedule $systemSchedule = this.getSystemSchedule();
        result = result * 59 + ($systemSchedule == null ? 43 : $systemSchedule.hashCode());
        DatasourceTask $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : ((Object)((Object)$task)).hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        DatasourceState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $currentIndex = this.currentIndex;
        result = result * 59 + ($currentIndex == null ? 43 : $currentIndex.hashCode());
        List<String> $indices = this.getIndices();
        result = result * 59 + ($indices == null ? 43 : ((Object)$indices).hashCode());
        Database $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : ((Object)$database).hashCode());
        UpdateStats $updateStats = this.getUpdateStats();
        result = result * 59 + ($updateStats == null ? 43 : ((Object)$updateStats).hashCode());
        return result;
    }

    @Generated
    public Datasource(String name, Instant lastUpdateTime, Instant enabledTime, boolean isEnabled, IntervalSchedule userSchedule, IntervalSchedule systemSchedule, DatasourceTask task, String endpoint, DatasourceState state, String currentIndex, List<String> indices, Database database, UpdateStats updateStats) {
        this.name = name;
        this.lastUpdateTime = lastUpdateTime;
        this.enabledTime = enabledTime;
        this.isEnabled = isEnabled;
        this.userSchedule = userSchedule;
        this.systemSchedule = systemSchedule;
        this.task = task;
        this.endpoint = endpoint;
        this.state = state;
        this.currentIndex = currentIndex;
        this.indices = indices;
        this.database = database;
        this.updateStats = updateStats;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), LAST_UPDATE_TIME_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), ENABLED_TIME_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ScheduleParser.parse((XContentParser)p), USER_SCHEDULE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ScheduleParser.parse((XContentParser)p), SYSTEM_SCHEDULE_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TASK_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ENDPOINT_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), STATE_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), CURRENT_INDEX_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INDICES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), Database.PARSER, DATABASE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), UpdateStats.PARSER, UPDATE_STATS_FIELD);
    }

    public static class Builder {
        public static Datasource build(PutDatasourceRequest request) {
            String id = request.getName();
            IntervalSchedule schedule = new IntervalSchedule(Instant.now().truncatedTo(ChronoUnit.MILLIS), (int)request.getUpdateInterval().days(), ChronoUnit.DAYS);
            String endpoint = request.getEndpoint();
            return new Datasource(id, schedule, endpoint);
        }
    }

    public static class UpdateStats
    implements Writeable,
    ToXContent {
        private static final ParseField LAST_SUCCEEDED_AT_FIELD = new ParseField("last_succeeded_at_in_epoch_millis", new String[0]);
        private static final ParseField LAST_SUCCEEDED_AT_FIELD_READABLE = new ParseField("last_succeeded_at", new String[0]);
        private static final ParseField LAST_PROCESSING_TIME_IN_MILLIS_FIELD = new ParseField("last_processing_time_in_millis", new String[0]);
        private static final ParseField LAST_FAILED_AT_FIELD = new ParseField("last_failed_at_in_epoch_millis", new String[0]);
        private static final ParseField LAST_FAILED_AT_FIELD_READABLE = new ParseField("last_failed_at", new String[0]);
        private static final ParseField LAST_SKIPPED_AT = new ParseField("last_skipped_at_in_epoch_millis", new String[0]);
        private static final ParseField LAST_SKIPPED_AT_READABLE = new ParseField("last_skipped_at", new String[0]);
        private Instant lastSucceededAt;
        private Long lastProcessingTimeInMillis;
        private Instant lastFailedAt;
        private Instant lastSkippedAt;
        private static final ConstructingObjectParser<UpdateStats, Void> PARSER = new ConstructingObjectParser("datasource_metadata_update_stats", true, args -> {
            Instant lastSucceededAt = args[0] == null ? null : Instant.ofEpochMilli((Long)args[0]);
            Long lastProcessingTimeInMillis = (Long)args[1];
            Instant lastFailedAt = args[2] == null ? null : Instant.ofEpochMilli((Long)args[2]);
            Instant lastSkippedAt = args[3] == null ? null : Instant.ofEpochMilli((Long)args[3]);
            return new UpdateStats(lastSucceededAt, lastProcessingTimeInMillis, lastFailedAt, lastSkippedAt);
        });

        public UpdateStats(StreamInput in) throws IOException {
            this.lastSucceededAt = Datasource.toInstant(in.readOptionalVLong());
            this.lastProcessingTimeInMillis = in.readOptionalVLong();
            this.lastFailedAt = Datasource.toInstant(in.readOptionalVLong());
            this.lastSkippedAt = Datasource.toInstant(in.readOptionalVLong());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalVLong(this.lastSucceededAt == null ? null : Long.valueOf(this.lastSucceededAt.toEpochMilli()));
            out.writeOptionalVLong(this.lastProcessingTimeInMillis);
            out.writeOptionalVLong(this.lastFailedAt == null ? null : Long.valueOf(this.lastFailedAt.toEpochMilli()));
            out.writeOptionalVLong(this.lastSkippedAt == null ? null : Long.valueOf(this.lastSkippedAt.toEpochMilli()));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.lastSucceededAt != null) {
                builder.timeField(LAST_SUCCEEDED_AT_FIELD.getPreferredName(), LAST_SUCCEEDED_AT_FIELD_READABLE.getPreferredName(), this.lastSucceededAt.toEpochMilli());
            }
            if (this.lastProcessingTimeInMillis != null) {
                builder.field(LAST_PROCESSING_TIME_IN_MILLIS_FIELD.getPreferredName(), this.lastProcessingTimeInMillis);
            }
            if (this.lastFailedAt != null) {
                builder.timeField(LAST_FAILED_AT_FIELD.getPreferredName(), LAST_FAILED_AT_FIELD_READABLE.getPreferredName(), this.lastFailedAt.toEpochMilli());
            }
            if (this.lastSkippedAt != null) {
                builder.timeField(LAST_SKIPPED_AT.getPreferredName(), LAST_SKIPPED_AT_READABLE.getPreferredName(), this.lastSkippedAt.toEpochMilli());
            }
            builder.endObject();
            return builder;
        }

        @Generated
        public Instant getLastSucceededAt() {
            return this.lastSucceededAt;
        }

        @Generated
        public Long getLastProcessingTimeInMillis() {
            return this.lastProcessingTimeInMillis;
        }

        @Generated
        public Instant getLastFailedAt() {
            return this.lastFailedAt;
        }

        @Generated
        public Instant getLastSkippedAt() {
            return this.lastSkippedAt;
        }

        @Generated
        public void setLastSucceededAt(Instant lastSucceededAt) {
            this.lastSucceededAt = lastSucceededAt;
        }

        @Generated
        public void setLastProcessingTimeInMillis(Long lastProcessingTimeInMillis) {
            this.lastProcessingTimeInMillis = lastProcessingTimeInMillis;
        }

        @Generated
        public void setLastFailedAt(Instant lastFailedAt) {
            this.lastFailedAt = lastFailedAt;
        }

        @Generated
        public void setLastSkippedAt(Instant lastSkippedAt) {
            this.lastSkippedAt = lastSkippedAt;
        }

        @Generated
        public String toString() {
            return "Datasource.UpdateStats(lastSucceededAt=" + this.getLastSucceededAt() + ", lastProcessingTimeInMillis=" + this.getLastProcessingTimeInMillis() + ", lastFailedAt=" + this.getLastFailedAt() + ", lastSkippedAt=" + this.getLastSkippedAt() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateStats)) {
                return false;
            }
            UpdateStats other = (UpdateStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$lastProcessingTimeInMillis = this.getLastProcessingTimeInMillis();
            Long other$lastProcessingTimeInMillis = other.getLastProcessingTimeInMillis();
            if (this$lastProcessingTimeInMillis == null ? other$lastProcessingTimeInMillis != null : !((Object)this$lastProcessingTimeInMillis).equals(other$lastProcessingTimeInMillis)) {
                return false;
            }
            Instant this$lastSucceededAt = this.getLastSucceededAt();
            Instant other$lastSucceededAt = other.getLastSucceededAt();
            if (this$lastSucceededAt == null ? other$lastSucceededAt != null : !((Object)this$lastSucceededAt).equals(other$lastSucceededAt)) {
                return false;
            }
            Instant this$lastFailedAt = this.getLastFailedAt();
            Instant other$lastFailedAt = other.getLastFailedAt();
            if (this$lastFailedAt == null ? other$lastFailedAt != null : !((Object)this$lastFailedAt).equals(other$lastFailedAt)) {
                return false;
            }
            Instant this$lastSkippedAt = this.getLastSkippedAt();
            Instant other$lastSkippedAt = other.getLastSkippedAt();
            return !(this$lastSkippedAt == null ? other$lastSkippedAt != null : !((Object)this$lastSkippedAt).equals(other$lastSkippedAt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UpdateStats;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $lastProcessingTimeInMillis = this.getLastProcessingTimeInMillis();
            result = result * 59 + ($lastProcessingTimeInMillis == null ? 43 : ((Object)$lastProcessingTimeInMillis).hashCode());
            Instant $lastSucceededAt = this.getLastSucceededAt();
            result = result * 59 + ($lastSucceededAt == null ? 43 : ((Object)$lastSucceededAt).hashCode());
            Instant $lastFailedAt = this.getLastFailedAt();
            result = result * 59 + ($lastFailedAt == null ? 43 : ((Object)$lastFailedAt).hashCode());
            Instant $lastSkippedAt = this.getLastSkippedAt();
            result = result * 59 + ($lastSkippedAt == null ? 43 : ((Object)$lastSkippedAt).hashCode());
            return result;
        }

        @Generated
        private UpdateStats(Instant lastSucceededAt, Long lastProcessingTimeInMillis, Instant lastFailedAt, Instant lastSkippedAt) {
            this.lastSucceededAt = lastSucceededAt;
            this.lastProcessingTimeInMillis = lastProcessingTimeInMillis;
            this.lastFailedAt = lastFailedAt;
            this.lastSkippedAt = lastSkippedAt;
        }

        @Generated
        private UpdateStats() {
        }

        static {
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LAST_SUCCEEDED_AT_FIELD);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LAST_PROCESSING_TIME_IN_MILLIS_FIELD);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LAST_FAILED_AT_FIELD);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LAST_SKIPPED_AT);
        }
    }

    public static class Database
    implements Writeable,
    ToXContent {
        private static final ParseField PROVIDER_FIELD = new ParseField("provider", new String[0]);
        private static final ParseField SHA256_HASH_FIELD = new ParseField("sha256_hash", new String[0]);
        private static final ParseField UPDATED_AT_FIELD = new ParseField("updated_at_in_epoch_millis", new String[0]);
        private static final ParseField UPDATED_AT_FIELD_READABLE = new ParseField("updated_at", new String[0]);
        private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
        private static final ParseField VALID_FOR_IN_DAYS_FIELD = new ParseField("valid_for_in_days", new String[0]);
        private String provider;
        private String sha256Hash;
        private Instant updatedAt;
        private Long validForInDays;
        private List<String> fields;
        private static final ConstructingObjectParser<Database, Void> PARSER = new ConstructingObjectParser("datasource_metadata_database", true, args -> {
            String provider = (String)args[0];
            String sha256Hash = (String)args[1];
            Instant updatedAt = args[2] == null ? null : Instant.ofEpochMilli((Long)args[2]);
            Long validForInDays = (Long)args[3];
            List fields = (List)args[4];
            return new Database(provider, sha256Hash, updatedAt, validForInDays, fields);
        });

        public Database(StreamInput in) throws IOException {
            this.provider = in.readOptionalString();
            this.sha256Hash = in.readOptionalString();
            this.updatedAt = Datasource.toInstant(in.readOptionalVLong());
            this.validForInDays = in.readOptionalVLong();
            this.fields = in.readOptionalStringList();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.provider);
            out.writeOptionalString(this.sha256Hash);
            out.writeOptionalVLong(this.updatedAt == null ? null : Long.valueOf(this.updatedAt.toEpochMilli()));
            out.writeOptionalVLong(this.validForInDays);
            out.writeOptionalStringCollection(this.fields);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.provider != null) {
                builder.field(PROVIDER_FIELD.getPreferredName(), this.provider);
            }
            if (this.sha256Hash != null) {
                builder.field(SHA256_HASH_FIELD.getPreferredName(), this.sha256Hash);
            }
            if (this.updatedAt != null) {
                builder.timeField(UPDATED_AT_FIELD.getPreferredName(), UPDATED_AT_FIELD_READABLE.getPreferredName(), this.updatedAt.toEpochMilli());
            }
            if (this.validForInDays != null) {
                builder.field(VALID_FOR_IN_DAYS_FIELD.getPreferredName(), this.validForInDays);
            }
            if (this.fields != null) {
                builder.startArray(FIELDS_FIELD.getPreferredName());
                for (String field : this.fields) {
                    builder.value(field);
                }
                builder.endArray();
            }
            builder.endObject();
            return builder;
        }

        @Generated
        public String getProvider() {
            return this.provider;
        }

        @Generated
        public String getSha256Hash() {
            return this.sha256Hash;
        }

        @Generated
        public Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Generated
        public Long getValidForInDays() {
            return this.validForInDays;
        }

        @Generated
        public List<String> getFields() {
            return this.fields;
        }

        @Generated
        public void setProvider(String provider) {
            this.provider = provider;
        }

        @Generated
        public void setSha256Hash(String sha256Hash) {
            this.sha256Hash = sha256Hash;
        }

        @Generated
        public void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Generated
        public void setValidForInDays(Long validForInDays) {
            this.validForInDays = validForInDays;
        }

        @Generated
        public void setFields(List<String> fields) {
            this.fields = fields;
        }

        @Generated
        public String toString() {
            return "Datasource.Database(provider=" + this.getProvider() + ", sha256Hash=" + this.getSha256Hash() + ", updatedAt=" + this.getUpdatedAt() + ", validForInDays=" + this.getValidForInDays() + ", fields=" + this.getFields() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Database)) {
                return false;
            }
            Database other = (Database)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$validForInDays = this.getValidForInDays();
            Long other$validForInDays = other.getValidForInDays();
            if (this$validForInDays == null ? other$validForInDays != null : !((Object)this$validForInDays).equals(other$validForInDays)) {
                return false;
            }
            String this$provider = this.getProvider();
            String other$provider = other.getProvider();
            if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
                return false;
            }
            String this$sha256Hash = this.getSha256Hash();
            String other$sha256Hash = other.getSha256Hash();
            if (this$sha256Hash == null ? other$sha256Hash != null : !this$sha256Hash.equals(other$sha256Hash)) {
                return false;
            }
            Instant this$updatedAt = this.getUpdatedAt();
            Instant other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            List<String> this$fields = this.getFields();
            List<String> other$fields = other.getFields();
            return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Database;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $validForInDays = this.getValidForInDays();
            result = result * 59 + ($validForInDays == null ? 43 : ((Object)$validForInDays).hashCode());
            String $provider = this.getProvider();
            result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
            String $sha256Hash = this.getSha256Hash();
            result = result * 59 + ($sha256Hash == null ? 43 : $sha256Hash.hashCode());
            Instant $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            List<String> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            return result;
        }

        @Generated
        private Database(String provider, String sha256Hash, Instant updatedAt, Long validForInDays, List<String> fields) {
            this.provider = provider;
            this.sha256Hash = sha256Hash;
            this.updatedAt = updatedAt;
            this.validForInDays = validForInDays;
            this.fields = fields;
        }

        @Generated
        private Database() {
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), PROVIDER_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), SHA256_HASH_FIELD);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), UPDATED_AT_FIELD);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), VALID_FOR_IN_DAYS_FIELD);
            PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), FIELDS_FIELD);
        }
    }
}

