/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXFontText;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.latex.AlignHStyle;
import com.dickimawbooks.texparserlib.latex.AlignVStyle;
import com.dickimawbooks.texparserlib.latex.Angle;
import com.dickimawbooks.texparserlib.latex.BorderStyle;
import com.dickimawbooks.texparserlib.latex.EndFrameBox;
import com.dickimawbooks.texparserlib.latex.FloatBoxStyle;
import com.dickimawbooks.texparserlib.latex.StartFrameBox;
import java.awt.Color;
import java.io.IOException;

public class FrameBox
extends ControlSequence {
    protected String id;
    protected TeXDimension currentWidth = null;
    protected TeXDimension currentHeight = null;
    protected TeXDimension currentBorderWidth = null;
    protected TeXDimension currentInnerMargin = null;
    protected TeXDimension currentBorderRadius = null;
    protected TeXDimension currentOuterMarginLeft = null;
    protected TeXDimension currentOuterMarginRight = null;
    protected TeXDimension currentOuterMarginTop = null;
    protected TeXDimension currentOuterMarginBottom = null;
    protected Color currentBorderColor = null;
    protected Color currentFgColor = null;
    protected Color currentBgColor = null;
    protected BorderStyle style = BorderStyle.SOLID;
    protected AlignHStyle halign = AlignHStyle.DEFAULT;
    protected AlignVStyle valign = AlignVStyle.DEFAULT;
    protected FloatBoxStyle floatStyle = FloatBoxStyle.NONE;
    protected Angle currentAngle = null;
    protected TeXFontText textFont = null;
    protected TeXObject prefix = null;
    protected TeXObject suffix = null;
    protected boolean isInline = true;
    protected boolean isMultiLine = true;
    protected boolean isChangeable = true;
    public static final byte BORDER_NONE = 0;
    public static final byte BORDER_SOLID = 1;
    public static final byte BORDER_DOUBLE = 2;
    public static final byte ALIGN_DEFAULT = 0;
    public static final byte ALIGN_LEFT = 1;
    public static final byte ALIGN_CENTER = 2;
    public static final byte ALIGN_RIGHT = 3;
    public static final byte ALIGN_TOP = 1;
    public static final byte ALIGN_MIDDLE = 2;
    public static final byte ALIGN_BOTTOM = 3;
    public static final byte ALIGN_BASE = 4;

    public FrameBox() {
        this("fbox", BorderStyle.SOLID, AlignHStyle.DEFAULT, AlignVStyle.DEFAULT, true);
    }

    public FrameBox(String string) {
        this(string, BorderStyle.SOLID, AlignHStyle.DEFAULT, AlignVStyle.DEFAULT, true);
    }

    @Deprecated
    public FrameBox(String string, byte by, byte by2, byte by3, boolean bl) {
        this(string, by, by2, by3, bl, null, null);
    }

    public FrameBox(String string, BorderStyle borderStyle, AlignHStyle alignHStyle, AlignVStyle alignVStyle, boolean bl) {
        this(string, borderStyle, alignHStyle, alignVStyle, bl, null, null);
    }

    @Deprecated
    public FrameBox(String string, byte by, byte by2, byte by3, boolean bl, TeXDimension teXDimension, TeXDimension teXDimension2) {
        this(string, by, by2, by3, bl, false, teXDimension, teXDimension2);
    }

    public FrameBox(String string, BorderStyle borderStyle, AlignHStyle alignHStyle, AlignVStyle alignVStyle, boolean bl, TeXDimension teXDimension, TeXDimension teXDimension2) {
        this(string, borderStyle, alignHStyle, alignVStyle, bl, false, teXDimension, teXDimension2);
    }

    @Deprecated
    public FrameBox(String string, byte by, byte by2, byte by3, boolean bl, boolean bl2, TeXDimension teXDimension, TeXDimension teXDimension2) {
        super(string);
        this.setStyle(by);
        this.setHAlign(by2);
        this.setVAlign(by3);
        this.setIsInLine(bl);
        this.setIsMultiLine(bl2);
        this.currentBorderWidth = teXDimension;
        this.currentInnerMargin = teXDimension2;
        this.id = string;
    }

    public FrameBox(String string, BorderStyle borderStyle, AlignHStyle alignHStyle, AlignVStyle alignVStyle, boolean bl, boolean bl2, TeXDimension teXDimension, TeXDimension teXDimension2) {
        super(string);
        this.setStyle(borderStyle);
        this.setHAlign(alignHStyle);
        this.setVAlign(alignVStyle);
        this.setIsInLine(bl);
        this.setIsMultiLine(bl2);
        this.currentBorderWidth = teXDimension;
        this.currentInnerMargin = teXDimension2;
        this.id = string;
    }

    public FrameBox createBox() {
        return new FrameBox(this.getName());
    }

    @Override
    public Object clone() {
        FrameBox frameBox = this.createBox();
        this.copySettingsInto(frameBox);
        return frameBox;
    }

    protected void copySettingsInto(FrameBox frameBox) {
        frameBox.isChangeable = this.isChangeable;
        frameBox.id = this.id;
        frameBox.isInline = this.isInline;
        frameBox.isMultiLine = this.isMultiLine;
        frameBox.style = this.style;
        frameBox.halign = this.halign;
        frameBox.valign = this.valign;
        frameBox.currentAngle = this.currentAngle;
        frameBox.floatStyle = this.floatStyle;
        frameBox.currentBorderWidth = this.currentBorderWidth == null ? null : (TeXDimension)this.currentBorderWidth.clone();
        frameBox.currentInnerMargin = this.currentInnerMargin == null ? null : (TeXDimension)this.currentInnerMargin.clone();
        frameBox.currentOuterMarginLeft = this.currentOuterMarginLeft == null ? null : (TeXDimension)this.currentOuterMarginLeft.clone();
        frameBox.currentOuterMarginRight = this.currentOuterMarginRight == null ? null : (TeXDimension)this.currentOuterMarginRight.clone();
        frameBox.currentOuterMarginTop = this.currentOuterMarginTop == null ? null : (TeXDimension)this.currentOuterMarginTop.clone();
        frameBox.currentOuterMarginBottom = this.currentOuterMarginBottom == null ? null : (TeXDimension)this.currentOuterMarginBottom.clone();
        frameBox.currentBorderRadius = this.currentBorderRadius == null ? null : (TeXDimension)this.currentBorderRadius.clone();
        frameBox.currentWidth = this.currentWidth == null ? null : (TeXDimension)this.currentWidth.clone();
        frameBox.currentHeight = this.currentHeight == null ? null : (TeXDimension)this.currentHeight.clone();
        frameBox.currentBorderColor = this.currentBorderColor;
        frameBox.currentFgColor = this.currentFgColor;
        frameBox.currentBgColor = this.currentBgColor;
        frameBox.textFont = this.textFont;
        frameBox.prefix = this.prefix;
        frameBox.suffix = this.suffix;
    }

    public void setPrefix(TeXObject teXObject) {
        this.prefix = teXObject;
    }

    public void setSuffix(TeXObject teXObject) {
        this.suffix = teXObject;
    }

    public boolean isStyleChangeable() {
        return this.isChangeable;
    }

    public void fixStyle() {
        this.isChangeable = false;
    }

    public boolean isInLine() {
        return this.isInline;
    }

    public void setIsInLine(boolean bl) {
        if (this.isChangeable) {
            this.isInline = bl;
        }
    }

    public boolean isMultiLine() {
        return this.isMultiLine;
    }

    public void setIsMultiLine(boolean bl) {
        if (this.isChangeable) {
            this.isMultiLine = bl;
        }
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public BorderStyle getStyle() {
        return this.style;
    }

    public void setStyle(byte by) {
        switch (by) {
            case 0: {
                this.style = BorderStyle.NONE;
                break;
            }
            case 1: {
                this.style = BorderStyle.SOLID;
                break;
            }
            case 2: {
                this.style = BorderStyle.DOUBLE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid style " + by);
            }
        }
    }

    public void setStyle(BorderStyle borderStyle) {
        if (this.isChangeable) {
            this.style = borderStyle;
        }
    }

    public AlignHStyle getHAlign() {
        return this.halign;
    }

    public void setHAlign(AlignHStyle alignHStyle) {
        if (this.isChangeable) {
            this.halign = alignHStyle;
        }
    }

    @Deprecated
    public void setHAlign(byte by) {
        if (this.isChangeable) {
            switch (by) {
                case 0: {
                    this.halign = AlignHStyle.DEFAULT;
                    break;
                }
                case 1: {
                    this.halign = AlignHStyle.LEFT;
                    break;
                }
                case 2: {
                    this.halign = AlignHStyle.CENTER;
                    break;
                }
                case 3: {
                    this.halign = AlignHStyle.RIGHT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid horizontal alignment " + by);
                }
            }
        }
    }

    public AlignVStyle getVAlign() {
        return this.valign;
    }

    public void setVAlign(AlignVStyle alignVStyle) {
        if (this.isChangeable) {
            this.valign = alignVStyle;
        }
    }

    @Deprecated
    public void setVAlign(byte by) {
        if (this.isChangeable) {
            switch (by) {
                case 0: {
                    this.valign = AlignVStyle.DEFAULT;
                    break;
                }
                case 1: {
                    this.valign = AlignVStyle.TOP;
                    break;
                }
                case 2: {
                    this.valign = AlignVStyle.MIDDLE;
                    break;
                }
                case 3: {
                    this.valign = AlignVStyle.BOTTOM;
                    break;
                }
                case 4: {
                    this.valign = AlignVStyle.BASE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid vertical alignment " + by);
                }
            }
        }
    }

    public void setBorderColor(Color color) {
        if (this.isChangeable) {
            this.currentBorderColor = color;
        }
    }

    public void setForegroundColor(Color color) {
        if (this.isChangeable) {
            this.currentFgColor = color;
        }
    }

    public void setBackgroundColor(Color color) {
        if (this.isChangeable) {
            this.currentBgColor = color;
        }
    }

    public Color getBorderColor(TeXParser teXParser) throws IOException {
        return this.currentBorderColor;
    }

    public Color getForegroundColor(TeXParser teXParser) throws IOException {
        return this.currentFgColor;
    }

    public Color getBackgroundColor(TeXParser teXParser) throws IOException {
        return this.currentBgColor;
    }

    public TeXDimension getBorderWidth(TeXParser teXParser) throws IOException {
        if (this.isChangeable) {
            return this.currentBorderWidth == null ? teXParser.getDimenRegister("fboxrule") : this.currentBorderWidth;
        }
        return this.currentBorderWidth;
    }

    public void setBorderWidth(TeXDimension teXDimension) {
        if (this.isChangeable) {
            this.currentBorderWidth = teXDimension;
        }
    }

    public void setBorderRadius(TeXDimension teXDimension) {
        if (this.isChangeable) {
            this.currentBorderRadius = teXDimension;
        }
    }

    public TeXDimension getBorderRadius(TeXParser teXParser) throws IOException {
        return this.currentBorderRadius;
    }

    public TeXDimension getInnerMargin(TeXParser teXParser) throws IOException {
        if (this.isChangeable) {
            return this.currentInnerMargin == null ? teXParser.getDimenRegister("fboxsep") : this.currentInnerMargin;
        }
        return this.currentInnerMargin;
    }

    public void setInnerMargin(TeXDimension teXDimension) {
        if (this.isChangeable) {
            this.currentInnerMargin = teXDimension;
        }
    }

    public TeXDimension getOuterMarginLeft(TeXParser teXParser) throws IOException {
        return this.currentOuterMarginLeft;
    }

    public TeXDimension getOuterMarginRight(TeXParser teXParser) throws IOException {
        return this.currentOuterMarginRight;
    }

    public TeXDimension getOuterMarginTop(TeXParser teXParser) throws IOException {
        return this.currentOuterMarginTop;
    }

    public TeXDimension getOuterMarginBottom(TeXParser teXParser) throws IOException {
        return this.currentOuterMarginBottom;
    }

    public void setOuterMarginLeft(TeXDimension teXDimension) {
        if (this.isChangeable) {
            this.currentOuterMarginLeft = teXDimension;
        }
    }

    public void setOuterMarginRight(TeXDimension teXDimension) {
        if (this.isChangeable) {
            this.currentOuterMarginRight = teXDimension;
        }
    }

    public void setOuterMarginTop(TeXDimension teXDimension) {
        if (this.isChangeable) {
            this.currentOuterMarginTop = teXDimension;
        }
    }

    public void setOuterMarginBottom(TeXDimension teXDimension) {
        if (this.isChangeable) {
            this.currentOuterMarginBottom = teXDimension;
        }
    }

    public TeXDimension getWidth(TeXParser teXParser) throws IOException {
        return this.currentWidth;
    }

    public void setWidth(TeXDimension teXDimension) {
        if (this.isChangeable) {
            this.currentWidth = teXDimension;
        }
    }

    public TeXDimension getHeight(TeXParser teXParser) throws IOException {
        return this.currentHeight;
    }

    public void setHeight(TeXDimension teXDimension) {
        if (this.isChangeable) {
            this.currentHeight = teXDimension;
        }
    }

    public Angle getAngle(TeXParser teXParser) throws IOException {
        return this.currentAngle;
    }

    public void setAngle(Angle angle) {
        if (this.isChangeable) {
            this.currentAngle = angle;
        }
    }

    public TeXFontText getTextFont() {
        return this.textFont;
    }

    public void setTextFont(TeXFontText teXFontText) {
        this.textFont = teXFontText;
    }

    public FloatBoxStyle getFloatStyle() {
        return this.floatStyle;
    }

    public void setFloatStyle(FloatBoxStyle floatBoxStyle) {
        this.floatStyle = floatBoxStyle;
    }

    protected void popSettings(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.popOptArg(teXParser, teXObjectList);
        String string = null;
        if (teXObject != null) {
            if (!(teXObject instanceof TeXDimension) && (teXObject = TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList)) instanceof TeXObjectList) {
                teXObject = ((TeXObjectList)teXObject).popDimension(teXParser);
            }
            string = this.popOptLabelString(teXParser, teXObjectList);
        }
        if (string != null) {
            String string2 = string.trim();
            if (string2.equals("c")) {
                this.halign = AlignHStyle.CENTER;
            } else if (string2.equals("l")) {
                this.halign = AlignHStyle.LEFT;
            } else if (string2.equals("r")) {
                this.halign = AlignHStyle.RIGHT;
            } else {
                teXParser.warningMessage("latex.illegal.argtype", string2);
            }
        }
        if (teXObject instanceof TeXDimension) {
            this.currentWidth = (TeXDimension)teXObject;
        }
    }

    protected TeXObject popContents(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.popArg(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        TeXObject teXObject2;
        FrameBox frameBox = this;
        if (this.isChangeable) {
            teXObject2 = this.currentWidth;
            teXObject = this.currentHeight;
            AlignHStyle alignHStyle = this.halign;
            AlignVStyle alignVStyle = this.valign;
            FloatBoxStyle floatBoxStyle = this.floatStyle;
            Color color = this.currentBorderColor;
            Color color2 = this.currentFgColor;
            Color color3 = this.currentBgColor;
            TeXDimension teXDimension = this.currentBorderWidth;
            TeXDimension teXDimension2 = this.currentInnerMargin;
            TeXDimension teXDimension3 = this.currentBorderRadius;
            Angle angle = this.currentAngle;
            this.popSettings(teXParser, teXObjectList);
            frameBox = (FrameBox)this.clone();
            this.currentWidth = teXObject2;
            this.currentHeight = teXObject;
            this.currentBorderColor = color;
            this.currentFgColor = color2;
            this.currentBgColor = color3;
            this.currentBorderWidth = teXDimension;
            this.currentBorderRadius = teXDimension3;
            this.currentInnerMargin = teXDimension2;
            this.halign = alignHStyle;
            this.valign = alignVStyle;
            this.floatStyle = floatBoxStyle;
            this.currentAngle = angle;
        }
        teXObject2 = this.popContents(teXParser, teXObjectList);
        teXObject = teXParser.getListener().createStack();
        ((TeXObjectList)teXObject).add(new StartFrameBox(frameBox));
        if (this.prefix != null) {
            ((TeXObjectList)teXObject).add((TeXObject)this.prefix.clone(), true);
        }
        ((TeXObjectList)teXObject).add(teXObject2, true);
        if (this.suffix != null) {
            ((TeXObjectList)teXObject).add((TeXObject)this.suffix.clone(), true);
        }
        ((TeXObjectList)teXObject).add(new EndFrameBox(frameBox));
        TeXParserUtils.process(teXObject, teXParser, teXObjectList);
    }

    public void applyToSettings(TeXSettings teXSettings) {
        if (this.currentFgColor != null) {
            teXSettings.setFgColor(this.currentFgColor);
        }
        if (this.currentBgColor != null) {
            teXSettings.setBgColor(this.currentBgColor);
        }
        if (this.textFont != null) {
            teXSettings.setFont(this.textFont);
        }
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,id=%s,width=%s,height=%s,borderwidth=%s,innermargin=%s,borderradius=%s,outermarginleft=%s,outermarginright=%s,outermargintop=%s,outermarginbottom=%s,bordercol=%s,fg=%s,bg=%s,borderstyle=%s,halign=%s,valign=%s,float=%s,angle=%s,font=%s,prefix=%s,suffix=%s,inline=%s,multiline=%s,changeable=%s]", new Object[]{this.getClass().getSimpleName(), this.getName(), this.id, this.currentWidth, this.currentHeight, this.currentBorderWidth, this.currentInnerMargin, this.currentBorderRadius, this.currentOuterMarginLeft, this.currentOuterMarginRight, this.currentOuterMarginTop, this.currentOuterMarginBottom, this.currentBorderColor, this.currentFgColor, this.currentBgColor, this.style, this.halign, this.valign, this.floatStyle, this.currentAngle, this.textFont, this.prefix, this.suffix, this.isInline, this.isMultiLine, this.isChangeable});
    }
}

