/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.color;

import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.TextBlockCommand;
import com.dickimawbooks.texparserlib.latex.color.ColorDeclaration;
import com.dickimawbooks.texparserlib.latex.color.DefineColor;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.io.IOException;
import java.util.HashMap;

public class ColorSty
extends LaTeXSty {
    private HashMap<String, Color> definedColors;
    public static final String UNSUPPORTED_COLOR = "color.unsupported";
    public static final String INVALID_SPECS = "color.invalid.specs";
    public static final String UNKNOWN = "color.unknown";

    public ColorSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        this(keyValList, "color", laTeXParserListener, bl);
    }

    public ColorSty(KeyValList keyValList, String string, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, string, laTeXParserListener, bl);
        this.initColors();
    }

    private void initColors() {
        this.definedColors = new HashMap();
        this.putColor("black", Color.BLACK);
        this.putColor("blue", Color.BLUE);
        this.putColor("cyan", Color.CYAN);
        this.putColor("gray", Color.GRAY);
        this.putColor("green", Color.GREEN);
        this.putColor("magenta", Color.MAGENTA);
        this.putColor("orange", Color.ORANGE);
        this.putColor("pink", Color.PINK);
        this.putColor("red", Color.RED);
        this.putColor("white", Color.WHITE);
        this.putColor("yellow", Color.YELLOW);
        this.putColor("brown", new Color(0.75f, 0.5f, 0.25f));
        this.putColor("lime", new Color(0.75f, 1.0f, 0.0f));
        this.putColor("purple", new Color(0.75f, 0.0f, 0.25f));
        this.putColor("teal", new Color(0.0f, 0.5f, 0.5f));
        this.putColor("violet", new Color(0.5f, 0.0f, 0.5f));
        this.putColor("olive", new Color(0.5f, 0.5f, 0.0f));
        this.putColor("darkgray", new Color(0.25f, 0.25f, 0.25f));
        this.putColor("lightgray", new Color(0.75f, 0.75f, 0.75f));
    }

    public void putColor(String string, Color color) {
        this.definedColors.put(string, color);
    }

    @Override
    public void addDefinitions() {
        this.addDeclaration(new ColorDeclaration(this), "textcolor");
        this.registerControlSequence(new ColorDeclaration(this, "pagecolor", false));
        this.registerControlSequence(new DefineColor(this));
    }

    protected void addDeclaration(Declaration declaration, String string) {
        this.registerControlSequence(declaration);
        this.registerControlSequence(new TextBlockCommand(string, declaration));
    }

    public Color getColor(TeXParser teXParser, String string, String string2) throws IOException {
        return this.getColor(teXParser, string, string2, true);
    }

    public Color getColor(TeXParser teXParser, String string, String string2, boolean bl) throws IOException {
        if (bl) {
            int n = string2.lastIndexOf("!!");
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            boolean bl2 = false;
            if (string2.startsWith("-")) {
                bl2 = true;
                for (int i = 1; i < string2.length(); ++i) {
                    if (string2.charAt(i) == '-') continue;
                    if (i % 2 == 1) {
                        bl2 = false;
                    }
                    string2 = string2.substring(i + 1);
                    break;
                }
            }
            String[] stringArray = string2.split("!");
            Color color = this.getColor(teXParser, string, stringArray[0], false);
            if (bl2) {
                color = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
            }
            float f = (float)color.getRed() / 255.0f;
            float f2 = (float)color.getGreen() / 255.0f;
            float f3 = (float)color.getBlue() / 255.0f;
            for (int i = 1; i < stringArray.length; i += 2) {
                try {
                    float f4 = Float.parseFloat(stringArray[i]) * 0.01f;
                    f *= f4;
                    f2 *= f4;
                    f3 *= f4;
                    color = this.getColor(teXParser, string, stringArray[i + 1], false);
                    f4 = 1.0f - f4;
                    f = 0.5f * (f + f4 * (float)color.getRed() / 255.0f);
                    f2 = 0.5f * (f2 + f4 * (float)color.getGreen() / 255.0f);
                    f3 = 0.5f * (f3 + f4 * (float)color.getBlue() / 255.0f);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new LaTeXSyntaxException(numberFormatException, teXParser, INVALID_SPECS, string2, string);
                }
            }
            return new Color(f, f2, f3);
        }
        String[] stringArray = string.split("/");
        string = stringArray[0];
        String[] stringArray2 = string2.split("/");
        string2 = stringArray2[0];
        if (string.equals("named")) {
            Color color = this.definedColors.get(string2);
            if (color == null) {
                throw new LaTeXSyntaxException(teXParser, UNKNOWN, string2);
            }
            return color;
        }
        if (string.equals("rgb")) {
            String[] stringArray3 = string2.split(",", 3);
            if (stringArray3.length != 3) {
                throw new LaTeXSyntaxException(teXParser, INVALID_SPECS, string2, string);
            }
            try {
                float f = Float.parseFloat(stringArray3[0]);
                float f5 = Float.parseFloat(stringArray3[1]);
                float f6 = Float.parseFloat(stringArray3[2]);
                return new Color(f, f5, f6);
            }
            catch (NumberFormatException numberFormatException) {
                throw new LaTeXSyntaxException(numberFormatException, teXParser, INVALID_SPECS, string2, string);
            }
        }
        if (string.equals("gray")) {
            try {
                float f = Float.parseFloat(string2);
                return new Color(ColorSpace.getInstance(1003), new float[]{f}, 1.0f);
            }
            catch (NumberFormatException numberFormatException) {
                throw new LaTeXSyntaxException(numberFormatException, teXParser, INVALID_SPECS, string2, string);
            }
        }
        throw new LaTeXSyntaxException(teXParser, UNSUPPORTED_COLOR, string, string2);
    }
}

