/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.mfirstuc;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.mfirstuc.CapitaliseFmtWords;
import com.dickimawbooks.texparserlib.latex.mfirstuc.CapitaliseWords;
import com.dickimawbooks.texparserlib.latex.mfirstuc.GlsMakeFirstUc;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MFUaddmap;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MFUblocker;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MFUclear;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MFUexcl;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MFUhyphencapword;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MFUnocap;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MFUsentencecase;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MFUskippunc;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MFUwordbreak;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MakeFirstUc;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import java.io.IOException;

public class MfirstucSty
extends LaTeXSty {
    public static final String EXCLUSION_TL = "l_text_case_exclude_arg_tl";
    public static final String BLOCKER_TL = "l__mfirstuc_blocker_tl";
    public static final String MAPPINGS_PROP = "l__mfirstuc_mappings_prop";

    public MfirstucSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "mfirstuc", laTeXParserListener, bl);
    }

    @Override
    public void addDefinitions() {
        LaTeXParserListener laTeXParserListener = this.getListener();
        NewIf.createConditional(true, this.getParser(), "ifMFUhyphen", false);
        this.registerControlSequence(new MFUsentencecase(this));
        this.registerControlSequence(new GlsMakeFirstUc());
        this.registerControlSequence(new GlsMakeFirstUc("mfugrabfirstuc", 2));
        this.registerControlSequence(new MakeFirstUc(this));
        this.registerControlSequence(new MakeFirstUc("xmakefirstuc", 1, this));
        this.registerControlSequence(new MakeFirstUc("emakefirstuc", 2, this));
        this.registerControlSequence(new CapitaliseWords(this));
        this.registerControlSequence(new CapitaliseWords(this, "xcapitalisewords", 1));
        this.registerControlSequence(new CapitaliseWords(this, "ecapitalisewords", 2));
        this.registerControlSequence(new CapitaliseFmtWords(this));
        this.registerControlSequence(new MakeFirstUc("MFUcapword", this));
        this.registerControlSequence(new MFUhyphencapword());
        this.registerControlSequence(new MFUnocap(this));
        this.registerControlSequence(new MFUnocap(this, "gMFUnocap", true));
        this.registerControlSequence(new MFUclear(this));
        this.registerControlSequence(new MFUskippunc());
        this.registerControlSequence(new MFUwordbreak());
        this.registerControlSequence(new MFUexcl(this));
        this.registerControlSequence(new MFUblocker(this));
        this.registerControlSequence(new MFUaddmap(this));
        this.addExclusion("MFUskippunc");
        this.addExclusion("NoCaseChange");
        this.addExclusion("ensuremath");
    }

    @Override
    public void processOption(String string, TeXObject teXObject) throws IOException {
        if (string.equals("expanded")) {
            this.registerControlSequence(new GlsMakeFirstUc(1));
        } else if (string.equals("unexpanded")) {
            this.registerControlSequence(new GlsMakeFirstUc(0));
        } else if (string.equals("grabfirst")) {
            this.registerControlSequence(new GlsMakeFirstUc(2));
        }
    }

    public void addException(String string) {
        this.addException(this.getListener().createString(string), false);
    }

    public void addException(TeXObject teXObject, boolean bl) {
        ControlSequence controlSequence = this.getParser().getControlSequence("@mfu@nocaplist");
        TeXObjectList teXObjectList = controlSequence instanceof GenericCommand ? ((GenericCommand)controlSequence).getDefinition() : new TeXObjectList();
        teXObjectList.add((TeXObject)teXObject.clone());
        this.getParser().putControlSequence(!bl, new GenericCommand("@mfu@nocaplist", null, teXObjectList));
    }

    public void clearExceptions() {
        this.clearExceptions(false);
    }

    public void clearExceptions(boolean bl) {
        this.getParser().putControlSequence(!bl, new GenericCommand("@mfu@nocaplist"));
    }

    public boolean isException(TeXObject teXObject) {
        ControlSequence controlSequence = this.getParser().getControlSequence("@mfu@nocaplist");
        TeXObjectList teXObjectList = controlSequence instanceof GenericCommand ? ((GenericCommand)controlSequence).getDefinition() : new TeXObjectList();
        return teXObjectList.contains(teXObject);
    }

    public boolean isExclusion(String string) {
        ControlSequence controlSequence = this.getParser().getControlSequence(EXCLUSION_TL);
        if (controlSequence instanceof GenericCommand) {
            TeXObjectList teXObjectList = ((GenericCommand)controlSequence).getDefinition();
            for (int i = 0; i < teXObjectList.size(); ++i) {
                TeXObject teXObject = (TeXObject)teXObjectList.get(i);
                if (!(teXObject instanceof ControlSequence) || !((ControlSequence)teXObject).getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public void addExclusion(String string) {
        ControlSequence controlSequence = this.getParser().getControlSequence(EXCLUSION_TL);
        if (controlSequence instanceof GenericCommand) {
            TeXObjectList teXObjectList = ((GenericCommand)controlSequence).getDefinition();
            teXObjectList.add(new TeXCsRef(string));
        } else {
            controlSequence = new GenericCommand(true, EXCLUSION_TL, null, new TeXCsRef(string));
            this.getParser().putControlSequence(true, controlSequence);
        }
    }

    public boolean isBlocker(String string) {
        ControlSequence controlSequence = this.getParser().getControlSequence(BLOCKER_TL);
        if (controlSequence instanceof GenericCommand) {
            TeXObjectList teXObjectList = ((GenericCommand)controlSequence).getDefinition();
            for (int i = 0; i < teXObjectList.size(); ++i) {
                TeXObject teXObject = (TeXObject)teXObjectList.get(i);
                if (!(teXObject instanceof ControlSequence) || !((ControlSequence)teXObject).getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public void addBlocker(String string) {
        ControlSequence controlSequence = this.getParser().getControlSequence(BLOCKER_TL);
        if (controlSequence instanceof GenericCommand) {
            TeXObjectList teXObjectList = ((GenericCommand)controlSequence).getDefinition();
            teXObjectList.add(new TeXCsRef(string));
        } else {
            controlSequence = new GenericCommand(true, BLOCKER_TL, null, new TeXCsRef(string));
            this.getParser().putControlSequence(true, controlSequence);
        }
    }

    public TeXObject getMapping(String string) {
        TeXObjectList teXObjectList;
        TeXObject teXObject;
        ControlSequence controlSequence = this.getParser().getControlSequence(MAPPINGS_PROP);
        if (controlSequence instanceof GenericCommand && (teXObject = (TeXObject)(teXObjectList = ((GenericCommand)controlSequence).getDefinition()).firstElement()) instanceof KeyValList) {
            return (TeXObject)((KeyValList)teXObject).get(string);
        }
        return null;
    }

    public void addMapping(String string, String string2) {
        this.addMapping(string, new TeXCsRef(string2));
    }

    public void addMapping(String string, TeXObject teXObject) {
        KeyValList keyValList;
        ControlSequence controlSequence = this.getParser().getControlSequence(MAPPINGS_PROP);
        if (controlSequence instanceof GenericCommand) {
            TeXObjectList teXObjectList = ((GenericCommand)controlSequence).getDefinition();
            TeXObject teXObject2 = (TeXObject)teXObjectList.firstElement();
            if (teXObject2 instanceof KeyValList) {
                keyValList = (KeyValList)teXObject2;
            } else {
                this.getParser().debugMessage(8, "KeyValList expected as definition of " + controlSequence);
                keyValList = new KeyValList();
                controlSequence = new GenericCommand(true, MAPPINGS_PROP, null, keyValList);
                this.getParser().putControlSequence(true, controlSequence);
            }
        } else {
            if (controlSequence != null) {
                this.getParser().debugMessage(8, "KeyValList expected as definition of " + controlSequence);
            }
            keyValList = new KeyValList();
            controlSequence = new GenericCommand(true, MAPPINGS_PROP, null, keyValList);
            this.getParser().putControlSequence(true, controlSequence);
        }
        keyValList.put(string, teXObject);
    }
}

