/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axistitlepainters;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisTitlePainter;
import info.monitorenter.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class AxisTitlePainterDefault
implements IAxisTitlePainter {
    public int getHeight(IAxis axis, Graphics g2d) {
        int result = 0;
        IAxis.AxisTitle axisTitle = axis.getAxisTitle();
        String title = axisTitle.getTitle();
        if (!StringUtil.isEmpty(title)) {
            Rectangle2D bounds = g2d.getFontMetrics().getStringBounds(title, g2d);
            int dimension = axis.getDimension();
            switch (dimension) {
                case 1: {
                    result = (int)bounds.getHeight();
                    break;
                }
                case 2: {
                    boolean supportsRotation = g2d instanceof Graphics2D;
                    if (supportsRotation) {
                        result = (int)bounds.getWidth();
                        break;
                    }
                    result = (int)bounds.getHeight();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Given axis.getDimension() is neither Chart2D.X nor Chart2D.Y!");
                }
            }
        }
        return result;
    }

    public int getWidth(IAxis axis, Graphics g2d) {
        int result = 0;
        IAxis.AxisTitle axisTitle = axis.getAxisTitle();
        String title = axisTitle.getTitle();
        if (!StringUtil.isEmpty(title)) {
            Font backUpFont = g2d.getFont();
            Font titleFont = axisTitle.getTitleFont();
            if (titleFont != null) {
                g2d.setFont(titleFont);
            }
            Rectangle2D bounds = g2d.getFontMetrics().getStringBounds(title, g2d);
            int dimension = axis.getDimension();
            switch (dimension) {
                case 1: {
                    result = (int)bounds.getWidth();
                    break;
                }
                case 2: {
                    boolean supportsRotation = g2d instanceof Graphics2D;
                    if (supportsRotation) {
                        result = (int)bounds.getHeight();
                        break;
                    }
                    result = (int)bounds.getWidth();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Given axis.getDimension() is neither Chart2D.X nor Chart2D.Y!");
                }
            }
            if (titleFont != null) {
                g2d.setFont(backUpFont);
            }
        }
        return result;
    }

    public void paintTitle(IAxis axis, Graphics g) {
        IAxis.AxisTitle axisTitle = axis.getAxisTitle();
        String title = axisTitle.getTitle();
        Font titleFont = axisTitle.getTitleFont();
        Font backUpFont = g.getFont();
        Color titleColor = axisTitle.getTitleColor();
        Color backUpColor = g.getColor();
        if (titleFont != null) {
            g.setFont(titleFont);
        }
        if (titleColor != backUpColor && titleColor != null) {
            g.setColor(titleColor);
        }
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(title, g);
        Chart2D chart = axis.getAccessor().getChart();
        int dimension = axis.getDimension();
        int position = axis.getAxisPosition();
        block0 : switch (dimension) {
            case 1: {
                switch (position) {
                    case 32: {
                        int startX = chart.getXChartStart();
                        int endX = chart.getXChartEnd();
                        double xspace = bounds.getWidth();
                        int titleStartX = (int)((double)(endX - startX) / 2.0 - xspace / 2.0);
                        g.drawString(title, titleStartX, axis.getPixelYBottom() - 4);
                        break block0;
                    }
                    case 16: {
                        int startX = chart.getXChartStart();
                        int endX = chart.getXChartEnd();
                        double xspace = bounds.getWidth();
                        int titleStartX = (int)((double)(endX - startX) / 2.0 - xspace / 2.0);
                        g.drawString(title, titleStartX, axis.getPixelYTop() + chart.getFontMetrics(chart.getFont()).getHeight());
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (position) {
                    case 4: {
                        boolean supportsRotation = g instanceof Graphics2D;
                        if (supportsRotation) {
                            Graphics2D g2d = (Graphics2D)g;
                            int startY = chart.getYChartStart();
                            int endY = chart.getYChartEnd();
                            double yspace = bounds.getWidth();
                            int titleStartY = (int)((double)(startY - endY) / 2.0 + yspace / 2.0);
                            AffineTransform tr = g2d.getTransform();
                            AffineTransform at = g2d.getDeviceConfiguration().getDefaultTransform();
                            at.translate(axis.getPixelXLeft() + chart.getFontMetrics(chart.getFont()).getHeight(), titleStartY);
                            at.rotate(-1.5707963267948966);
                            g2d.setTransform(at);
                            g2d.drawString(title, 0, 0);
                            g2d.setTransform(tr);
                            break block0;
                        }
                        int startY = chart.getYChartStart();
                        int endY = chart.getYChartEnd();
                        double yspace = bounds.getWidth();
                        int titleStartY = (int)((double)(startY - endY) / 2.0 + yspace / 2.0);
                        int titleStartX = axis.getPixelXLeft() + chart.getFontMetrics(chart.getFont()).getHeight();
                        g.drawString(title, titleStartX, titleStartY);
                        break block0;
                    }
                    case 8: {
                        boolean supportsRotation = g instanceof Graphics2D;
                        if (supportsRotation) {
                            Graphics2D g2d = (Graphics2D)g;
                            int startY = chart.getYChartStart();
                            int endY = chart.getYChartEnd();
                            double yspace = bounds.getWidth();
                            int titleStartY = (int)((double)(startY - endY) / 2.0 + yspace / 2.0);
                            int chartLabelFontWidth = chart.getFontMetrics(chart.getFont()).charWidth('0');
                            int xShiftPosition = chart.getAxisTickPainter().getMajorTickLength();
                            AffineTransform tr = g2d.getTransform();
                            AffineTransform at = g2d.getDeviceConfiguration().getDefaultTransform();
                            at.translate(chart.getXChartEnd() + (xShiftPosition += axis.getFormatter().getMaxAmountChars() * chartLabelFontWidth), titleStartY);
                            at.rotate(-1.5707963267948966);
                            g2d.setTransform(at);
                            g2d.drawString(title, 0, 0);
                            g2d.setTransform(tr);
                            break block0;
                        }
                        int startY = chart.getYChartStart();
                        int endY = chart.getYChartEnd();
                        double yspace = bounds.getWidth();
                        int titleStartY = (int)((double)(startY - endY) / 2.0 + yspace / 2.0);
                        int chartLabelFontWidth = chart.getFontMetrics(chart.getFont()).charWidth('0');
                        int xShiftPosition = chart.getAxisTickPainter().getMajorTickLength();
                        int titleStartX = (xShiftPosition += axis.getFormatter().getMaxAmountChars() * chartLabelFontWidth) + chart.getXChartEnd();
                        g.drawString(title, titleStartX, titleStartY);
                        break block0;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Given axis.getDimension() is neither Chart2D.X nor Chart2D.Y!");
            }
        }
        if (titleFont != null) {
            g.setFont(backUpFont);
        }
        if (titleColor != backUpColor && titleColor != null) {
            g.setColor(backUpColor);
        }
    }
}

