/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.Channel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import jnr.constants.platform.Sock;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.common.IRubyWarnings;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.RubySocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.Sockaddr;

@JRubyClass(name={"Socket"}, parent="BasicSocket", include={"Socket::Constants"})
public class RubyServerSocket
extends RubySocket {
    static void createServerSocket(ThreadContext context, RubyClass Socket2) {
        Define.defineClass(context, "ServerSocket", Socket2, RubyServerSocket::new).defineMethods(context, RubyServerSocket.class);
    }

    public RubyServerSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @Override
    @JRubyMethod(name={"listen"})
    public IRubyObject listen(ThreadContext context, IRubyObject backlog) {
        context.runtime.getWarnings().warnOnce(IRubyWarnings.ID.LISTEN_SERVER_SOCKET, "pass backlog to #bind instead of #listen (https://github.com/jruby/jruby/wiki/ServerSocket)");
        return Convert.asFixnum(context, 0);
    }

    @Override
    @JRubyMethod(notImplemented=true)
    public IRubyObject connect_nonblock(ThreadContext context, IRubyObject arg2) {
        throw SocketUtils.sockerr(context.runtime, "server socket cannot connect");
    }

    @Override
    @JRubyMethod(notImplemented=true)
    public IRubyObject connect(ThreadContext context, IRubyObject arg2) {
        throw SocketUtils.sockerr(context.runtime, "server socket cannot connect");
    }

    @Override
    @JRubyMethod
    public IRubyObject bind(ThreadContext context, IRubyObject addr2) {
        return this.bind(context, addr2, RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod
    public IRubyObject bind(ThreadContext context, IRubyObject addr2, IRubyObject backlog) {
        InetSocketAddress iaddr;
        if (addr2 instanceof Addrinfo) {
            Addrinfo addrInfo = (Addrinfo)addr2;
            if (!addrInfo.ip_p(context).isTrue()) {
                throw Error.typeError(context, "not an INET or INET6 address: " + String.valueOf(addrInfo));
            }
            iaddr = new InetSocketAddress(addrInfo.getInetAddress().getHostAddress(), addrInfo.getPort());
        } else {
            iaddr = Sockaddr.addressFromSockaddr_in(context, addr2);
        }
        this.doBind(context, this.getChannel(), iaddr, Convert.toInt(context, backlog));
        return Convert.asFixnum(context, 0);
    }

    @Override
    @JRubyMethod
    public IRubyObject accept(ThreadContext context) {
        return RubyServerSocket.doAccept(this, context, true);
    }

    @JRubyMethod
    public IRubyObject accept_nonblock(ThreadContext context) {
        return this.accept_nonblock(context, context.nil);
    }

    @JRubyMethod
    public IRubyObject accept_nonblock(ThreadContext context, IRubyObject opts) {
        return RubyServerSocket.doAcceptNonblock(this, context, RubyServerSocket.extractExceptionArg(context, opts));
    }

    @Override
    protected ChannelFD initChannelFD(Ruby runtime2) {
        try {
            if (this.soType != Sock.SOCK_STREAM) {
                throw Error.argumentError(runtime2.getCurrentContext(), "unsupported server socket type '" + String.valueOf(this.soType) + "'");
            }
            return RubyServerSocket.newChannelFD(runtime2, ServerSocketChannel.open());
        }
        catch (IOException e) {
            throw RubyServerSocket.sockerr(runtime2, "initialize: " + String.valueOf(e), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject doAcceptNonblock(RubySocket sock, ThreadContext context, boolean ex) {
        try {
            Channel channel = sock.getChannel();
            if (!(channel instanceof SelectableChannel)) {
                throw context.runtime.newErrnoENOPROTOOPTError();
            }
            SelectableChannel selectable = (SelectableChannel)channel;
            Object object = selectable.blockingLock();
            synchronized (object) {
                boolean oldBlocking = selectable.isBlocking();
                try {
                    selectable.configureBlocking(false);
                    IRubyObject socket2 = RubyServerSocket.doAccept(sock, context, ex);
                    if (!(socket2 instanceof RubySocket)) {
                        IRubyObject iRubyObject = socket2;
                        return iRubyObject;
                    }
                    SocketChannel socketChannel = (SocketChannel)((RubySocket)socket2).getChannel();
                    InetSocketAddress addr2 = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
                    RubyArray<?> rubyArray = Create.newArray(context, socket2, Sockaddr.packSockaddrFromAddress(context, addr2));
                    return rubyArray;
                }
                finally {
                    selectable.configureBlocking(oldBlocking);
                }
            }
        }
        catch (IOException e) {
            throw RubyServerSocket.sockerr(context.runtime, e.getLocalizedMessage(), e);
        }
    }

    public static IRubyObject doAccept(RubySocket sock, ThreadContext context, boolean ex) {
        Ruby runtime2 = context.runtime;
        Channel channel = sock.getChannel();
        try {
            if (channel instanceof ServerSocketChannel) {
                ServerSocketChannel serverChannel = (ServerSocketChannel)sock.getChannel();
                SocketChannel socket2 = serverChannel.accept();
                if (socket2 == null) {
                    if (!ex) {
                        return Convert.asSymbol(context, "wait_readable");
                    }
                    throw runtime2.newErrnoEAGAINReadableError("accept(2) would block");
                }
                RubySocket rubySocket = new RubySocket(runtime2, Access.getClass(context, "Socket"));
                rubySocket.initFromServer(runtime2, sock, socket2);
                return Create.newArray(context, (IRubyObject)rubySocket, (IRubyObject)new Addrinfo(runtime2, Access.getClass(context, "Addrinfo"), socket2.getRemoteAddress()));
            }
            throw runtime2.newErrnoENOPROTOOPTError();
        }
        catch (IllegalBlockingModeException e) {
            if (!ex) {
                return Convert.asSymbol(context, "wait_readable");
            }
            throw runtime2.newErrnoEAGAINReadableError("accept(2) would block");
        }
        catch (IOException e) {
            throw RubyServerSocket.sockerr(runtime2, e.getLocalizedMessage(), e);
        }
    }

    private void doBind(ThreadContext context, Channel channel, InetSocketAddress iaddr, int backlog) {
        Ruby runtime2 = context.runtime;
        try {
            if (!(channel instanceof ServerSocketChannel)) {
                throw runtime2.newErrnoENOPROTOOPTError();
            }
            ServerSocket socket2 = ((ServerSocketChannel)channel).socket();
            socket2.bind(iaddr, backlog);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime2, "bind(2): unknown host");
        }
        catch (SocketException e) {
            throw RubyServerSocket.buildSocketException(runtime2, e, "bind(2)", iaddr);
        }
        catch (IOException e) {
            throw RubyServerSocket.sockerr(runtime2, "bind(2): name or service not known", e);
        }
        catch (IllegalArgumentException e) {
            throw RubyServerSocket.sockerr(runtime2, e.getMessage(), e);
        }
    }
}

