/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.ling.WordLemmaTag;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.process.Morpha;
import edu.stanford.nlp.util.Function;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Morphology
implements Function {
    private static final boolean DEBUG = false;
    private Morpha lexer;
    private static Morpha staticLexer;

    public Morphology() {
        this.lexer = new Morpha(System.in);
    }

    public Morphology(Reader in) {
        this.lexer = new Morpha(in);
    }

    public Morphology(String filename) {
        try {
            this.lexer = new Morpha(new FileReader(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Word next() throws IOException {
        String nx = this.lexer.next();
        if (nx == null) {
            return null;
        }
        return new Word(nx);
    }

    static boolean isProper(String posTag) {
        return posTag.equals("NNP") || posTag.equals("NNPS") || posTag.equals("NP");
    }

    public Word stem(Word w) {
        try {
            this.lexer.yyreset(new StringReader(w.value()));
            this.lexer.yybegin(6);
            String wordRes = this.lexer.next();
            return new Word(wordRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return w;
        }
    }

    public String stem(String word) {
        try {
            this.lexer.yyreset(new StringReader(word));
            this.lexer.yybegin(6);
            String wordRes = this.lexer.next();
            return wordRes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return word;
        }
    }

    public WordTag stem(WordTag wT) {
        return this.stem(wT.word(), wT.tag());
    }

    public WordTag stem(String word, String tag) {
        return Morphology.stem(word, tag, this.lexer, this.lexer.option(1));
    }

    public void stem(CoreLabel label) {
        this.stem(label, CoreAnnotations.LemmaAnnotation.class);
    }

    public void stem(CoreLabel label, Class<? extends CoreAnnotation<String>> ann) {
        WordTag wt = Morphology.stem(label.word(), label.tag(), this.lexer, this.lexer.option(1));
        label.set(ann, wt.word());
    }

    public static WordTag stem(String word, String tag, Morpha lexer, boolean lowercase) {
        boolean wordHasForbiddenChar = word.indexOf(95) >= 0 || word.indexOf(32) >= 0;
        String quotedWord = word;
        if (wordHasForbiddenChar) {
            try {
                quotedWord = quotedWord.replaceAll("_", "\u0960");
                quotedWord = quotedWord.replaceAll(" ", "\u0961");
            }
            catch (Exception e) {
                System.err.println("stem: Didn't work");
            }
        }
        String wordtag = quotedWord + "_" + tag;
        try {
            lexer.setOption(1, lowercase);
            lexer.yyreset(new StringReader(wordtag));
            lexer.yybegin(8);
            String wordRes = lexer.next();
            lexer.next();
            if (wordHasForbiddenChar) {
                try {
                    wordRes = wordRes.replaceAll("\u0960", "_");
                    wordRes = wordRes.replaceAll("\u0961", " ");
                }
                catch (Exception e) {
                    System.err.println("stem: Didn't work");
                }
            }
            return new WordTag(wordRes, tag);
        }
        catch (Throwable e) {
            System.err.println("Morphology.stem() had error on word " + word + "/" + tag);
            return new WordTag(word, tag);
        }
    }

    private static synchronized void initStaticLexer() {
        if (staticLexer == null) {
            staticLexer = new Morpha(System.in);
        }
    }

    public static WordTag stemStatic(String word, String tag) {
        Morphology.initStaticLexer();
        return Morphology.stem(word, tag, staticLexer, staticLexer.option(1));
    }

    public static WordTag stemStatic(String word, String tag, boolean lowercase) {
        Morphology.initStaticLexer();
        return Morphology.stem(word, tag, staticLexer, lowercase);
    }

    public static synchronized WordTag stemStaticSynchronized(String word, String tag) {
        return Morphology.stemStatic(word, tag);
    }

    public static synchronized WordTag stemStaticSynchronized(String word, String tag, boolean lowercase) {
        return Morphology.stemStatic(word, tag, lowercase);
    }

    public static WordTag stemStatic(WordTag wT) {
        return Morphology.stemStatic(wT.word(), wT.tag());
    }

    public Object apply(Object in) {
        if (in instanceof WordTag) {
            return this.stem((WordTag)in);
        }
        if (in instanceof Word) {
            return this.stem((Word)in);
        }
        return in;
    }

    public WordLemmaTag lemmatize(WordTag wT) {
        String tag = wT.tag();
        String word = wT.word();
        String lemma = this.stem(wT).word();
        return new WordLemmaTag(word, lemma, tag);
    }

    public static WordLemmaTag lemmatizeStatic(WordTag wT) {
        String tag = wT.tag();
        String word = wT.word();
        String lemma = Morphology.stemStatic(wT).word();
        return new WordLemmaTag(word, lemma, tag);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("java Morphology [-rebuildVerbTable file|-stem word+|file+]");
        } else if (args.length == 2 && args[0].equals("-rebuildVerbTable")) {
            String verbs = IOUtils.slurpFile(args[1]);
            String[] words = verbs.split("\\s+");
            System.out.print(" private static String[] verbStems = new String[] { ");
            for (int i = 0; i < words.length; ++i) {
                System.out.print("\"" + words[i] + "\"");
                if (i == words.length - 1) continue;
                System.out.print(", ");
                if (i % 5 != 0) continue;
                System.out.println();
                System.out.print("    ");
            }
            System.out.println(" };");
        } else if (args[0].equals("-stem")) {
            for (int i = 1; i < args.length; ++i) {
                System.out.println(args[i] + " --> " + Morphology.stemStatic(WordTag.valueOf(args[i])));
            }
        } else {
            for (String arg : args) {
                Word next;
                Morphology morph = new Morphology(arg);
                while ((next = morph.next()) != null) {
                    System.out.print(next);
                    System.out.print(" ");
                }
            }
        }
    }
}

