/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import ai.djl.util.ZipUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;

public final class TarUtils {
    private TarUtils() {
    }

    public static void untar(InputStream is, Path dir, boolean gzip) throws IOException {
        BufferedInputStream bis = gzip ? new GzipCompressorInputStream((InputStream)new BufferedInputStream(is)) : new BufferedInputStream(is);
        bis = CloseShieldInputStream.wrap((InputStream)bis);
        try (TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)bis);){
            TarArchiveEntry entry;
            while ((entry = tis.getNextEntry()) != null) {
                String entryName = entry.getName();
                ZipUtils.validateArchiveEntry(entryName, dir);
                Path file = dir.resolve(entryName).toAbsolutePath();
                if (entry.isDirectory()) {
                    Files.createDirectories(file, new FileAttribute[0]);
                    continue;
                }
                Path parentFile = file.getParent();
                if (parentFile == null) {
                    throw new AssertionError((Object)("Parent path should never be null: " + file));
                }
                Files.createDirectories(parentFile, new FileAttribute[0]);
                Files.copy((InputStream)tis, file, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }
}

