/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.navigation;

import com.google.common.base.Preconditions;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.annotation.Nonnull;
import javax.swing.Icon;
import org.protege.editor.owl.ui.renderer.OWLSystemColors;

public class NavIcon
implements Icon {
    private static final int WIDTH = 18;
    private static final int HEIGHT = 18;
    private static final BasicStroke STROKE = new BasicStroke(2.0f, 1, 1);
    @Nonnull
    private final Direction direction;

    public NavIcon(@Nonnull Direction direction) {
        this.direction = (Direction)((Object)Preconditions.checkNotNull((Object)((Object)direction)));
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (c.isEnabled()) {
            g.setColor(OWLSystemColors.getForegroundColor());
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(STROKE);
        g2.translate(x, y);
        int rightOffset = this.direction == Direction.BACK ? 3 : -3;
        int leftOffset = this.direction == Direction.BACK ? -4 : 4;
        int xCentre = this.getIconWidth() / 2;
        int[] xPoints = new int[]{xCentre + rightOffset, xCentre + leftOffset, xCentre + rightOffset};
        int[] yPoints = new int[]{3, this.getIconHeight() / 2, this.getIconHeight() - 3};
        g2.drawPolyline(xPoints, yPoints, 3);
        g2.translate(-x, -y);
    }

    @Override
    public int getIconWidth() {
        return 18;
    }

    @Override
    public int getIconHeight() {
        return 18;
    }

    public static enum Direction {
        BACK,
        FORWARD;

    }
}

