/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.InitParams;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestHandlers {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrCore core;
    final PluginBag<SolrRequestHandler> handlers;

    public static String normalize(String p) {
        if (p == null) {
            return "";
        }
        if (p.endsWith("/") && p.length() > 1) {
            return p.substring(0, p.length() - 1);
        }
        return p;
    }

    public RequestHandlers(SolrCore core) {
        this.core = core;
        this.handlers = new PluginBag<SolrRequestHandler>(SolrRequestHandler.class, core, true);
    }

    public SolrRequestHandler get(String handlerName) {
        return this.handlers.get(RequestHandlers.normalize(handlerName));
    }

    public SolrRequestHandler register(String handlerName, SolrRequestHandler handler) {
        String norm = RequestHandlers.normalize(handlerName);
        if (handler == null) {
            return this.handlers.remove(norm);
        }
        return this.handlers.put(norm, handler);
    }

    public PluginBag<SolrRequestHandler> getRequestHandlers() {
        return this.handlers;
    }

    void initHandlersFromConfig(SolrConfig config) {
        List<PluginInfo> implicits = this.core.getImplicitHandlers();
        LinkedHashMap<String, PluginInfo> infoMap = new LinkedHashMap<String, PluginInfo>();
        for (PluginInfo info : implicits) {
            infoMap.put(info.name, info);
        }
        for (PluginInfo info : config.getPluginInfos(SolrRequestHandler.class.getName())) {
            infoMap.put(info.name, info);
        }
        ArrayList infos = new ArrayList(infoMap.values());
        ArrayList<PluginInfo> modifiedInfos = new ArrayList<PluginInfo>();
        for (PluginInfo info : infos) {
            modifiedInfos.add(this.applyInitParams(config, info));
        }
        this.handlers.init(Collections.emptyMap(), this.core, modifiedInfos);
        this.handlers.alias(this.handlers.getDefault(), "");
        if (log.isDebugEnabled()) {
            log.debug("Registered paths: {}", (Object)StrUtils.join(new ArrayList<String>(this.handlers.keySet()), (char)','));
        }
        if (this.handlers.get("") == null && !this.handlers.alias("/select", "") && this.handlers.get("") == null && !this.handlers.alias("standard", "")) {
            log.warn("no default request handler is registered (either '/select' or 'standard')");
        }
    }

    private PluginInfo applyInitParams(SolrConfig config, PluginInfo info) {
        ArrayList<InitParams> ags = new ArrayList<InitParams>();
        String p = info.attributes.get("initParams");
        if (p != null) {
            for (String arg : StrUtils.splitSmart((String)p, (char)',')) {
                if (config.getInitParams().containsKey(arg)) {
                    ags.add(config.getInitParams().get(arg));
                    continue;
                }
                log.warn("INVALID paramSet {} in requestHandler {}", (Object)arg, (Object)info);
            }
        }
        for (InitParams args : config.getInitParams().values()) {
            if (!args.matchPath(info.name)) continue;
            ags.add(args);
        }
        if (!ags.isEmpty()) {
            info = info.copy();
            for (InitParams initParam : ags) {
                initParam.apply(info);
            }
        }
        return info;
    }

    public void close() {
        this.handlers.close();
    }
}

