/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.endpoint.ReplicationBackupApis;
import org.apache.solr.client.api.model.ReplicationBackupRequestBody;
import org.apache.solr.client.api.model.ReplicationBackupResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotBackupAPI
extends JerseyResource
implements ReplicationBackupApis {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrCore solrCore;
    private final ReplicationHandler.ReplicationHandlerConfig replicationHandlerConfig;

    @Inject
    public SnapshotBackupAPI(SolrCore solrCore, ReplicationHandler.ReplicationHandlerConfig replicationHandlerConfig) {
        this.solrCore = solrCore;
        this.replicationHandlerConfig = replicationHandlerConfig;
    }

    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public ReplicationBackupResponse createBackup(@RequestBody ReplicationBackupRequestBody backupReplicationPayload) {
        this.ensureRequiredRequestBodyProvided(backupReplicationPayload);
        return this.doBackup(backupReplicationPayload);
    }

    private ReplicationBackupResponse doBackup(ReplicationBackupRequestBody backupReplicationPayload) {
        ReplicationBackupResponse response = this.instantiateJerseyResponse(ReplicationBackupResponse.class);
        int numberToKeep = backupReplicationPayload.numberToKeep;
        int numberBackupsToKeep = this.replicationHandlerConfig.getNumberBackupsToKeep();
        String location = backupReplicationPayload.location;
        String repoName = backupReplicationPayload.repository;
        String commitName = backupReplicationPayload.commitName;
        String name = backupReplicationPayload.name;
        Consumer<NamedList<?>> resultConsumer = result -> {
            response.result = result;
        };
        try {
            this.doSnapShoot(numberToKeep, numberBackupsToKeep, location, repoName, commitName, name, this.solrCore, resultConsumer);
            response.status = "OK";
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Exception while creating a snapshot", (Throwable)e);
            SnapshotBackupAPI.reportErrorOnResponse(response, "Error encountered while creating a snapshot: " + e.getMessage(), e);
        }
        return response;
    }

    protected void doSnapShoot(int numberToKeep, int numberBackupsToKeep, String location, String repoName, String commitName, String name, SolrCore solrCore, Consumer<NamedList<?>> resultConsumer) throws IOException {
        ReplicationHandler.doSnapShoot(numberToKeep, numberBackupsToKeep, location, repoName, commitName, name, solrCore, resultConsumer);
    }

    private static void reportErrorOnResponse(ReplicationBackupResponse response, String message, Exception e) {
        response.status = "ERROR";
        response.message = message;
        if (e != null) {
            response.exception = e;
        }
    }
}

