/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopSpan;
import io.opentracing.util.GlobalTracer;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.servlet.HttpSolrCall;
import org.apache.solr.util.RTimerTree;

public interface SolrQueryRequest
extends AutoCloseable {
    public static final String SOLR_ALLOW_PARTIAL_RESULTS_DEFAULT = "solr.allowPartialResultsDefault";
    public static final boolean ALLOW_PARTIAL_RESULTS_DEFAULT = EnvUtils.getPropertyAsBool((String)"solr.allowPartialResultsDefault", (Boolean)true);

    public static boolean allowPartialResults(SolrParams params) {
        return params.getBool("partialResults", ALLOW_PARTIAL_RESULTS_DEFAULT);
    }

    public static boolean disallowPartialResults(SolrParams params) {
        return !SolrQueryRequest.allowPartialResults(params);
    }

    public SolrParams getParams();

    public void setParams(SolrParams var1);

    public Iterable<ContentStream> getContentStreams();

    public SolrParams getOriginalParams();

    public Map<Object, Object> getContext();

    @Override
    public void close();

    public long getStartTime();

    public RTimerTree getRequestTimer();

    public SolrIndexSearcher getSearcher();

    public SolrCore getCore();

    public IndexSchema getSchema();

    public void updateSchemaToLatest();

    public String getParamString();

    public Map<String, Object> getJSON();

    public void setJSON(Map<String, Object> var1);

    public Principal getUserPrincipal();

    default public String getPath() {
        return (String)this.getContext().get("path");
    }

    default public Map<String, String> getPathTemplateValues() {
        return Collections.emptyMap();
    }

    default public List<CommandOperation> getCommands(boolean validateInput) {
        return Collections.emptyList();
    }

    default public String getHttpMethod() {
        return (String)this.getContext().get("httpMethod");
    }

    default public HttpSolrCall getHttpSolrCall() {
        return null;
    }

    default public Tracer getTracer() {
        return GlobalTracer.get();
    }

    default public Span getSpan() {
        return NoopSpan.INSTANCE;
    }

    default public CoreContainer getCoreContainer() {
        SolrCore core = this.getCore();
        return core == null ? null : core.getCoreContainer();
    }

    default public CloudDescriptor getCloudDescriptor() {
        return this.getCore().getCoreDescriptor().getCloudDescriptor();
    }

    default public QueryResponseWriter getResponseWriter() {
        SolrCore core = this.getCore();
        String wt = this.getParams().get("wt");
        if (core != null) {
            return core.getQueryResponseWriter(wt);
        }
        return SolrCore.DEFAULT_RESPONSE_WRITERS.getOrDefault(wt, SolrCore.DEFAULT_RESPONSE_WRITERS.get("standard"));
    }
}

