/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.VersionedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFloatSource
extends ValueSource {
    private SchemaField field;
    private final SchemaField keyField;
    private final float defVal;
    private final String dataDir;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static Cache floatCache = new Cache(){

        @Override
        protected Object createValue(IndexReader reader, Object key) {
            return FileFloatSource.getFloats(((Entry)key).ffs, reader);
        }
    };
    static Object onlyForTesting;

    public FileFloatSource(SchemaField field, SchemaField keyField, float defVal, String dataDir) {
        this.field = field;
        this.keyField = keyField;
        this.defVal = defVal;
        this.dataDir = dataDir;
    }

    public String description() {
        return "float(" + this.field + ")";
    }

    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final int off = readerContext.docBase;
        IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)readerContext);
        final float[] arr = this.getCachedFloats(topLevelContext.reader());
        return new FloatDocValues(this){

            public float floatVal(int doc) {
                return arr[doc + off];
            }

            public Object objectVal(int doc) {
                return Float.valueOf(this.floatVal(doc));
            }
        };
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileFloatSource)) {
            return false;
        }
        FileFloatSource other = (FileFloatSource)((Object)o);
        return this.field.getName().equals(other.field.getName()) && this.keyField.getName().equals(other.keyField.getName()) && this.defVal == other.defVal && this.dataDir.equals(other.dataDir);
    }

    public int hashCode() {
        return FileFloatSource.class.hashCode() + this.field.getName().hashCode();
    }

    public String toString() {
        return "FileFloatSource(field=" + this.field.getName() + ",keyField=" + this.keyField.getName() + ",defVal=" + this.defVal + ",dataDir=" + this.dataDir + ")";
    }

    public static void resetCache() {
        floatCache.resetCache();
    }

    public void refreshCache(IndexReader reader) {
        if (log.isInfoEnabled()) {
            log.info("Refreshing FileFloatSource cache for field {}", (Object)this.field.getName());
        }
        floatCache.refresh(reader, new Entry(this));
        if (log.isInfoEnabled()) {
            log.info("FileFloatSource cache for field {} reloaded", (Object)this.field.getName());
        }
    }

    private final float[] getCachedFloats(IndexReader reader) {
        return (float[])floatCache.get(reader, new Entry(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float[] getFloats(FileFloatSource ffs, IndexReader reader) {
        InputStream is;
        float[] vals = new float[reader.maxDoc()];
        if (ffs.defVal != 0.0f) {
            Arrays.fill(vals, ffs.defVal);
        }
        String fname = "external_" + ffs.field.getName();
        try {
            is = VersionedFile.getLatestFile(ffs.dataDir, fname);
        }
        catch (IOException e) {
            log.error("Error opening external value source file: ", (Throwable)e);
            return vals;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        String idName = ffs.keyField.getName();
        FieldType idType = ffs.keyField.getType();
        ArrayList<String> notFound = new ArrayList<String>();
        int notFoundCount = 0;
        int otherErrors = 0;
        int delimiter = 61;
        BytesRefBuilder internalKey = new BytesRefBuilder();
        try {
            String line;
            TermsEnum termsEnum = MultiTerms.getTerms((IndexReader)reader, (String)idName).iterator();
            PostingsEnum postingsEnum = null;
            while ((line = r.readLine()) != null) {
                int doc;
                float fval;
                int delimIndex = line.lastIndexOf(delimiter);
                if (delimIndex < 0) continue;
                int endIndex = line.length();
                String key = line.substring(0, delimIndex);
                String val = line.substring(delimIndex + 1, endIndex);
                try {
                    idType.readableToIndexed(key, internalKey);
                    fval = Float.parseFloat(val);
                }
                catch (Exception e) {
                    if (++otherErrors > 10) continue;
                    log.error("Error loading external value source: {} {}{}", new Object[]{fname, e, otherErrors < 10 ? "" : "\tSkipping future errors for this file."});
                    continue;
                }
                if (!termsEnum.seekExact(internalKey.get())) {
                    if (notFoundCount < 10) {
                        notFound.add(key);
                    }
                    ++notFoundCount;
                    continue;
                }
                postingsEnum = termsEnum.postings(postingsEnum, 0);
                while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    vals[doc] = fval;
                }
            }
        }
        catch (IOException e) {
            log.error("Error loading external value source: ", (Throwable)e);
        }
        finally {
            try {
                r.close();
            }
            catch (Exception e) {}
        }
        if (log.isInfoEnabled()) {
            String tmp = notFoundCount == 0 ? "" : " :" + notFoundCount + " missing keys " + notFound;
            log.info("Loaded external value source {}{}", (Object)fname, (Object)tmp);
        }
        return vals;
    }

    public static class ReloadCacheRequestHandler
    extends RequestHandlerBase {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
            FileFloatSource.resetCache();
            log.debug("readerCache has been reset.");
            UpdateRequestProcessor processor = req.getCore().getUpdateProcessingChain(null).createProcessor(req, rsp);
            try {
                RequestHandlerUtils.handleCommit(req, processor, req.getParams(), true);
            }
            finally {
                try {
                    processor.finish();
                }
                finally {
                    processor.close();
                }
            }
        }

        @Override
        public String getDescription() {
            return "Reload readerCache request handler";
        }

        @Override
        public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
            return PermissionNameProvider.Name.UPDATE_PERM;
        }
    }

    private static class Entry {
        final FileFloatSource ffs;

        public Entry(FileFloatSource ffs) {
            this.ffs = ffs;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            return this.ffs.equals((Object)other.ffs);
        }

        public int hashCode() {
            return this.ffs.hashCode();
        }
    }

    static final class CreationPlaceholder {
        Object value;

        CreationPlaceholder() {
        }
    }

    static abstract class Cache {
        private final Map<IndexReader, Map<Object, Object>> readerCache = new WeakHashMap<IndexReader, Map<Object, Object>>();

        Cache() {
        }

        protected abstract Object createValue(IndexReader var1, Object var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh(IndexReader reader, Object key) {
            Object refreshedValues = this.createValue(reader, key);
            Map<IndexReader, Map<Object, Object>> map = this.readerCache;
            synchronized (map) {
                Map innerCache = this.readerCache.computeIfAbsent(reader, k -> new HashMap());
                innerCache.put(key, refreshedValues);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(IndexReader reader, Object key) {
            Object value;
            Map<Object, Object> innerCache;
            Object object = this.readerCache;
            synchronized (object) {
                innerCache = this.readerCache.get(reader);
                if (innerCache == null) {
                    innerCache = new HashMap<Object, Object>();
                    this.readerCache.put(reader, innerCache);
                    value = null;
                } else {
                    value = innerCache.get(key);
                }
                if (value == null) {
                    value = new CreationPlaceholder();
                    innerCache.put(key, value);
                }
            }
            if (value instanceof CreationPlaceholder) {
                object = value;
                synchronized (object) {
                    CreationPlaceholder progress = (CreationPlaceholder)value;
                    if (progress.value == null) {
                        progress.value = this.createValue(reader, key);
                        Map<IndexReader, Map<Object, Object>> map = this.readerCache;
                        synchronized (map) {
                            innerCache.put(key, progress.value);
                            onlyForTesting = progress.value;
                        }
                    }
                    return progress.value;
                }
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetCache() {
            Map<IndexReader, Map<Object, Object>> map = this.readerCache;
            synchronized (map) {
                this.readerCache.clear();
            }
        }
    }
}

