/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.eclipse.jetty.client.api.Request;

public abstract class AuthenticationPlugin
implements SolrInfoBean {
    public static final String AUTHENTICATION_PLUGIN_PROP = "authenticationPlugin";
    public static final String HTTP_HEADER_X_SOLR_AUTHDATA = "X-Solr-AuthData";
    private Set<String> metricNames = ConcurrentHashMap.newKeySet();
    protected SolrMetricsContext solrMetricsContext;
    protected Meter numErrors = new Meter();
    protected Counter requests = new Counter();
    protected Timer requestTimes = new Timer();
    protected Counter totalTime = new Counter();
    protected Counter numAuthenticated = new Counter();
    protected Counter numPassThrough = new Counter();
    protected Counter numWrongCredentials = new Counter();
    protected Counter numMissingCredentials = new Counter();

    public abstract void init(Map<String, Object> var1);

    public abstract boolean doAuthenticate(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws Exception;

    public final boolean authenticate(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        Timer.Context timer = this.requestTimes.time();
        this.requests.inc();
        try {
            boolean bl = this.doAuthenticate(request, response, filterChain);
            return bl;
        }
        catch (Exception e) {
            this.numErrors.mark();
            throw e;
        }
        finally {
            long elapsed = timer.stop();
            this.totalTime.inc(elapsed);
        }
    }

    protected HttpServletRequest wrapWithPrincipal(HttpServletRequest request, Principal principal) {
        return this.wrapWithPrincipal(request, principal, principal.getName());
    }

    protected HttpServletRequest wrapWithPrincipal(HttpServletRequest request, final Principal principal, final String username) {
        return new HttpServletRequestWrapper(request){

            public Principal getUserPrincipal() {
                return principal;
            }

            public String getRemoteUser() {
                return username;
            }
        };
    }

    protected boolean interceptInternodeRequest(HttpRequest httpRequest, HttpContext httpContext) {
        return this instanceof HttpClientBuilderPlugin;
    }

    protected boolean interceptInternodeRequest(Request request) {
        return this instanceof HttpClientBuilderPlugin;
    }

    public void closeRequest() {
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        this.numErrors = this.solrMetricsContext.meter("errors", this.getCategory().toString(), scope);
        this.requests = this.solrMetricsContext.counter("requests", this.getCategory().toString(), scope);
        this.numAuthenticated = this.solrMetricsContext.counter("authenticated", this.getCategory().toString(), scope);
        this.numPassThrough = this.solrMetricsContext.counter("passThrough", this.getCategory().toString(), scope);
        this.numWrongCredentials = this.solrMetricsContext.counter("failWrongCredentials", this.getCategory().toString(), scope);
        this.numMissingCredentials = this.solrMetricsContext.counter("failMissingCredentials", this.getCategory().toString(), scope);
        this.requestTimes = this.solrMetricsContext.timer("requestTimes", this.getCategory().toString(), scope);
        this.totalTime = this.solrMetricsContext.counter("totalTime", this.getCategory().toString(), scope);
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getDescription() {
        return "Authentication Plugin " + this.getClass().getName();
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.SECURITY;
    }
}

