/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.shader;

import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;

public class PhongShader
implements Shader {
    private Color diff = Color.GRAY;
    private Color spec = Color.GRAY;
    private float power = 20.0f;
    private int numRays = 4;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.diff = parameterList.getColor("diffuse", this.diff);
        this.spec = parameterList.getColor("specular", this.spec);
        this.power = parameterList.getFloat("power", this.power);
        this.numRays = parameterList.getInt("samples", this.numRays);
        return true;
    }

    protected Color getDiffuse(ShadingState shadingState) {
        return this.diff;
    }

    public Color getRadiance(ShadingState shadingState) {
        shadingState.faceforward();
        shadingState.initLightSamples();
        shadingState.initCausticSamples();
        return shadingState.diffuse(this.getDiffuse(shadingState)).add(shadingState.specularPhong(this.spec, this.power, this.numRays));
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
        shadingState.faceforward();
        Color color2 = this.getDiffuse(shadingState);
        shadingState.storePhoton(shadingState.getRay().getDirection(), color, color2);
        float f = color2.getAverage();
        float f2 = this.spec.getAverage();
        double d = shadingState.getRandom(0, 0, 1);
        if (d < (double)f) {
            color.mul(color2).mul(1.0f / f);
            OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
            double d2 = Math.PI * 2 * d / (double)f;
            double d3 = shadingState.getRandom(0, 1, 1);
            float f3 = (float)Math.sqrt(d3);
            float f4 = (float)Math.sqrt(1.0 - d3);
            Vector3 vector3 = new Vector3((float)Math.cos(d2) * f3, (float)Math.sin(d2) * f3, f4);
            vector3 = orthoNormalBasis.transform(vector3, new Vector3());
            shadingState.traceDiffusePhoton(new Ray(shadingState.getPoint(), vector3), color);
        } else if (d < (double)(f + f2)) {
            float f5 = 2.0f * shadingState.getCosND();
            Vector3 vector3 = new Vector3();
            vector3.x = f5 * shadingState.getNormal().x + shadingState.getRay().dx;
            vector3.y = f5 * shadingState.getNormal().y + shadingState.getRay().dy;
            vector3.z = f5 * shadingState.getNormal().z + shadingState.getRay().dz;
            color.mul(this.spec).mul(1.0f / f2);
            OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
            double d4 = Math.PI * 2 * (d - (double)f) / (double)f2;
            double d5 = shadingState.getRandom(0, 1, 1);
            float f6 = (float)Math.pow(d5, 1.0f / (this.power + 1.0f));
            float f7 = (float)Math.sqrt(1.0f - f6 * f6);
            Vector3 vector32 = new Vector3((float)Math.cos(d4) * f7, (float)Math.sin(d4) * f7, f6);
            vector32 = orthoNormalBasis.transform(vector32, new Vector3());
            shadingState.traceReflectionPhoton(new Ray(shadingState.getPoint(), vector32), color);
        }
    }

    public boolean isOpaque() {
        return true;
    }

    public Color getOpacity(ShadingState shadingState) {
        return null;
    }
}

