/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.openide.util.Exceptions;

public class WriteLockUtils {
    static final String PREFIX = ".LCK";
    static final String SUFFIX = "~";

    private WriteLockUtils() {
    }

    public static synchronized boolean hasActiveLockFileSigns(String string) {
        return string.startsWith(PREFIX) && string.endsWith(SUFFIX);
    }

    public static synchronized boolean isActiveLockFile(File file) {
        String string = file.getName();
        boolean bl = WriteLockUtils.hasActiveLockFileSigns(string);
        if (bl) {
            String string2 = string.substring(PREFIX.length(), string.length() - SUFFIX.length());
            bl = FileChangedManager.getInstance().exists(new File(file.getParentFile(), string2));
        }
        return bl;
    }

    public static File getAssociatedLockFile(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        File file2 = file.getParentFile();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PREFIX);
        stringBuilder.append(file.getName());
        stringBuilder.append(SUFFIX);
        String string = stringBuilder.toString();
        File file3 = new File(file2, string);
        return file3;
    }

    static String getContentOfLckFile(File file, FileChannel fileChannel) throws IOException {
        byte[] byArray = new byte[(int)file.length()];
        fileChannel.read(ByteBuffer.wrap(byArray));
        String string = new String(byArray);
        return FileChangedManager.getInstance().exists(new File(string)) ? string : null;
    }

    static String writeContentOfLckFile(File file, FileChannel fileChannel) throws IOException {
        String string = file.getAbsolutePath();
        ByteBuffer byteBuffer = ByteBuffer.wrap(string.getBytes());
        fileChannel.write(byteBuffer);
        return string;
    }
}

