/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.events.AChart2DAction;
import info.monitorenter.gui.chart.io.FileFilterExtensions;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class Chart2DActionSaveImageSingleton
extends AChart2DAction {
    private JFileChooser m_filechooser;
    private static Map<String, Chart2DActionSaveImageSingleton> instances = new HashMap<String, Chart2DActionSaveImageSingleton>();

    private static String key(Chart2D chart) {
        return chart.getClass().getName() + chart.hashCode();
    }

    public static Chart2DActionSaveImageSingleton getInstance(Chart2D chart, String actionName) {
        Chart2DActionSaveImageSingleton result = instances.get(Chart2DActionSaveImageSingleton.key(chart));
        if (result == null) {
            result = new Chart2DActionSaveImageSingleton(chart, actionName);
            instances.put(Chart2DActionSaveImageSingleton.key(chart), result);
        }
        return result;
    }

    private Chart2DActionSaveImageSingleton(Chart2D chart, String colorName) {
        super(chart, colorName);
        chart.addPropertyChangeListener("Chart2D.PROPERTY_GRID_COLOR", this);
        this.m_filechooser = new JFileChooser();
        this.m_filechooser.setAcceptAllFileFilterUsed(false);
    }

    public void actionPerformed(ActionEvent e) {
        BufferedImage img = this.m_chart.snapShot();
        FileFilter[] farr = this.m_filechooser.getChoosableFileFilters();
        for (int i = 0; i < farr.length; ++i) {
            this.m_filechooser.removeChoosableFileFilter(farr[i]);
        }
        String[] encodings = ImageIO.getWriterFormatNames();
        TreeSet<String> writers = new TreeSet<String>();
        ImageTypeSpecifier spec = ImageTypeSpecifier.createFromRenderedImage(img);
        for (int i = 0; i < encodings.length; ++i) {
            Iterator<ImageWriter> itWriters = ImageIO.getImageWriters(spec, encodings[i]);
            if (!itWriters.hasNext()) continue;
            writers.add(encodings[i].toLowerCase());
        }
        for (String extension : writers) {
            this.m_filechooser.addChoosableFileFilter(new FileFilterExtensions(new String[]{extension}));
        }
        int ret = this.m_filechooser.showSaveDialog(this.m_chart);
        if (ret == 0) {
            String extension;
            File file = this.m_filechooser.getSelectedFile();
            extension = this.m_filechooser.getFileFilter().getDescription().substring(2);
            ImageWriter imgWriter = ImageIO.getImageWritersBySuffix(extension).next();
            ImageWriteParam params = imgWriter.getDefaultWriteParam();
            if (params.canWriteCompressed()) {
                params.setCompressionMode(0);
            }
            try {
                imgWriter.setOutput(new FileImageOutputStream(new File(file.getAbsolutePath() + "." + extension)));
                imgWriter.write(img);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }
}

