/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public abstract class BranchStatement
extends Statement {
    public char[] label;
    public BranchLabel targetLabel;
    public SubRoutineStatement[] subroutines;
    public int initStateIndex = -1;

    public BranchStatement(char[] cArray, int n, int n2) {
        this.label = cArray;
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    protected void setSubroutineSwitchExpression(SubRoutineStatement subRoutineStatement) {
    }

    protected void restartExceptionLabels(CodeStream codeStream) {
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (this.subroutines != null) {
            int n2 = this.subroutines.length;
            for (int i = 0; i < n2; ++i) {
                SubRoutineStatement subRoutineStatement = this.subroutines[i];
                SwitchExpression switchExpression = subRoutineStatement.getSwitchExpression();
                this.setSubroutineSwitchExpression(subRoutineStatement);
                boolean bl = subRoutineStatement.generateSubRoutineInvocation(blockScope, codeStream, this.targetLabel, this.initStateIndex, null);
                subRoutineStatement.setSwitchExpression(switchExpression);
                if (!bl) continue;
                codeStream.recordPositionsFrom(n, this.sourceStart);
                SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, i, codeStream);
                if (this.initStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.initStateIndex);
                    codeStream.addDefinitelyAssignedVariables(blockScope, this.initStateIndex);
                }
                this.restartExceptionLabels(codeStream);
                return;
            }
        }
        codeStream.goto_(this.targetLabel);
        codeStream.recordPositionsFrom(n, this.sourceStart);
        SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, -1, codeStream);
        if (this.initStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.initStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.initStateIndex);
        }
    }

    @Override
    public void resolve(BlockScope blockScope) {
    }
}

