/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.beans;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.provider.AbstractProviderDefinition;
import io.micronaut.inject.qualifiers.AnyQualifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.spring.beans.MicronautContextInternal;
import java.util.Arrays;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.OrderComparator;

@Internal
public final class ObjectProviderBeanDefinition
extends AbstractProviderDefinition<ObjectProvider<Object>> {
    public boolean isEnabled(BeanContext context, BeanResolutionContext resolutionContext) {
        return true;
    }

    public Class<ObjectProvider<Object>> getBeanType() {
        return ObjectProvider.class;
    }

    public boolean isPresent() {
        return true;
    }

    protected ObjectProvider<Object> buildProvider(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanContext context, @NonNull Argument<Object> argument, @Nullable Qualifier<Object> qualifier, boolean singleton) {
        return new MicronautObjectProvider(qualifier, context, resolutionContext, argument);
    }

    protected boolean isAllowEmptyProviders(BeanContext context) {
        return true;
    }

    private final class MicronautObjectProvider
    implements ObjectProvider<Object>,
    MicronautContextInternal {
        private final Qualifier<Object> finalQualifier;
        private final Qualifier<Object> qualifier;
        private final BeanContext context;
        private final BeanResolutionContext resolutionContext;
        private final Argument<Object> argument;

        public MicronautObjectProvider(Qualifier<Object> qualifier, BeanContext context, BeanResolutionContext resolutionContext, Argument<Object> argument) {
            this.qualifier = qualifier;
            this.context = context;
            this.resolutionContext = resolutionContext;
            this.argument = argument;
            this.finalQualifier = qualifier instanceof AnyQualifier ? null : qualifier;
        }

        public Stream<Object> stream() {
            return ((DefaultBeanContext)this.context).streamOfType(this.resolutionContext.copy(), this.argument, this.finalQualifier);
        }

        public Stream<Object> orderedStream() {
            return ((DefaultBeanContext)this.context).streamOfType(this.resolutionContext.copy(), this.argument, this.finalQualifier).sorted(OrderComparator.INSTANCE);
        }

        public Object getObject(Object ... args) throws BeansException {
            try {
                BeanDefinition beanDefinition = this.context.getBeanDefinition(this.argument, this.finalQualifier);
                Class beanType = beanDefinition.getBeanType();
                return InstantiationUtils.instantiate((Class)beanType, (Class[])((Class[])Arrays.stream(beanDefinition.getConstructor().getArguments()).map(Object::getClass).toArray(Class[]::new)), (Object[])args);
            }
            catch (Exception e) {
                throw new BeanCreationException(e.getMessage(), (Throwable)e);
            }
        }

        public Object getIfAvailable() throws BeansException {
            if (this.context.containsBean(this.argument, this.finalQualifier)) {
                return this.getObject();
            }
            return null;
        }

        public Object getIfUnique() throws BeansException {
            if (this.context.getBeanDefinitions(this.argument, this.finalQualifier).size() == 1) {
                try {
                    return ((DefaultBeanContext)this.context).getBean(this.resolutionContext.copy(), this.argument, this.qualify(this.qualifier));
                }
                catch (Exception e) {
                    throw new BeanCreationException(e.getMessage(), (Throwable)e);
                }
            }
            return null;
        }

        public Object getObject() throws BeansException {
            try {
                return ((DefaultBeanContext)this.context).getBean(this.resolutionContext.copy(), this.argument, this.finalQualifier);
            }
            catch (Exception e) {
                throw new BeanCreationException(e.getMessage(), (Throwable)e);
            }
        }

        private Qualifier<Object> qualify(Qualifier<Object> qualifier) {
            if (this.finalQualifier == null) {
                return qualifier;
            }
            if (qualifier == null) {
                return this.finalQualifier;
            }
            return Qualifiers.byQualifiers((Qualifier[])new Qualifier[]{this.finalQualifier, qualifier});
        }
    }
}

