/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.IUnknown;
import com.sun.jna.platform.win32.COM.util.IComEnum;
import com.sun.jna.platform.win32.COM.util.IDispatch;
import com.sun.jna.platform.win32.COM.util.ObjectFactory;
import com.sun.jna.platform.win32.COM.util.ProxyObject;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;

class Convert {
    Convert() {
    }

    public static Variant.VARIANT toVariant(Object value2) {
        if (value2 instanceof Variant.VARIANT) {
            return (Variant.VARIANT)value2;
        }
        if (value2 instanceof Byte) {
            return new Variant.VARIANT((Byte)value2);
        }
        if (value2 instanceof Character) {
            return new Variant.VARIANT(((Character)value2).charValue());
        }
        if (value2 instanceof Short) {
            return new Variant.VARIANT((Short)value2);
        }
        if (value2 instanceof Integer) {
            return new Variant.VARIANT((Integer)value2);
        }
        if (value2 instanceof Long) {
            return new Variant.VARIANT((Long)value2);
        }
        if (value2 instanceof Float) {
            return new Variant.VARIANT(((Float)value2).floatValue());
        }
        if (value2 instanceof Double) {
            return new Variant.VARIANT((Double)value2);
        }
        if (value2 instanceof String) {
            return new Variant.VARIANT((String)value2);
        }
        if (value2 instanceof Boolean) {
            return new Variant.VARIANT((Boolean)value2);
        }
        if (value2 instanceof Dispatch) {
            return new Variant.VARIANT((Dispatch)value2);
        }
        if (value2 instanceof Date) {
            return new Variant.VARIANT((Date)value2);
        }
        if (value2 instanceof Proxy) {
            InvocationHandler ih = Proxy.getInvocationHandler(value2);
            ProxyObject pobj = (ProxyObject)ih;
            return new Variant.VARIANT(pobj.getRawDispatch());
        }
        if (value2 instanceof IComEnum) {
            IComEnum enm = (IComEnum)value2;
            return new Variant.VARIANT(new WinDef.LONG(enm.getValue()));
        }
        Constructor<?> constructor2 = null;
        if (value2 != null) {
            for (Constructor<?> m : Variant.VARIANT.class.getConstructors()) {
                Class<?>[] parameters2 = m.getParameterTypes();
                if (parameters2.length != 1 || !parameters2[0].isAssignableFrom(value2.getClass())) continue;
                constructor2 = m;
            }
        }
        if (constructor2 != null) {
            try {
                return (Variant.VARIANT)constructor2.newInstance(value2);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public static Object toJavaObject(Variant.VARIANT value2, Class<?> targetClass, ObjectFactory factory2, boolean addReference, boolean freeValue) {
        Object result2;
        int varType;
        int n = varType = value2 != null ? value2.getVarType().intValue() : 1;
        if (varType == 0 || varType == 1) {
            return null;
        }
        if (targetClass != null && !targetClass.isAssignableFrom(Object.class)) {
            if (targetClass.isAssignableFrom(value2.getClass())) {
                return value2;
            }
            Object vobj = value2.getValue();
            if (vobj != null && targetClass.isAssignableFrom(vobj.getClass())) {
                return vobj;
            }
        }
        Variant.VARIANT inputValue = value2;
        if (varType == 16396) {
            value2 = (Variant.VARIANT)value2.getValue();
            varType = value2.getVarType().intValue();
        }
        if (targetClass == null || targetClass.isAssignableFrom(Object.class)) {
            targetClass = null;
            switch (varType) {
                case 16: 
                case 17: {
                    targetClass = Byte.class;
                    break;
                }
                case 2: {
                    targetClass = Short.class;
                    break;
                }
                case 18: {
                    targetClass = Character.class;
                    break;
                }
                case 3: 
                case 19: 
                case 22: 
                case 23: {
                    targetClass = Integer.class;
                    break;
                }
                case 20: 
                case 21: {
                    targetClass = Long.class;
                    break;
                }
                case 4: {
                    targetClass = Float.class;
                    break;
                }
                case 5: {
                    targetClass = Double.class;
                    break;
                }
                case 11: {
                    targetClass = Boolean.class;
                    break;
                }
                case 10: {
                    targetClass = WinDef.SCODE.class;
                    break;
                }
                case 6: {
                    targetClass = OaIdl.CURRENCY.class;
                    break;
                }
                case 7: {
                    targetClass = Date.class;
                    break;
                }
                case 8: {
                    targetClass = String.class;
                    break;
                }
                case 13: {
                    targetClass = IUnknown.class;
                    break;
                }
                case 9: {
                    targetClass = IDispatch.class;
                    break;
                }
                case 16396: {
                    targetClass = Variant.class;
                    break;
                }
                case 16384: {
                    targetClass = WinDef.PVOID.class;
                    break;
                }
                case 16398: {
                    targetClass = OaIdl.DECIMAL.class;
                    break;
                }
                default: {
                    if ((varType & 0x2000) <= 0) break;
                    targetClass = OaIdl.SAFEARRAY.class;
                }
            }
        }
        if (Byte.class.equals(targetClass) || Byte.TYPE.equals(targetClass)) {
            result2 = value2.byteValue();
        } else if (Short.class.equals(targetClass) || Short.TYPE.equals(targetClass)) {
            result2 = value2.shortValue();
        } else if (Character.class.equals(targetClass) || Character.TYPE.equals(targetClass)) {
            result2 = Character.valueOf((char)value2.intValue());
        } else if (Integer.class.equals(targetClass) || Integer.TYPE.equals(targetClass)) {
            result2 = value2.intValue();
        } else if (Long.class.equals(targetClass) || Long.TYPE.equals(targetClass) || IComEnum.class.isAssignableFrom(targetClass)) {
            result2 = value2.longValue();
        } else if (Float.class.equals(targetClass) || Float.TYPE.equals(targetClass)) {
            result2 = Float.valueOf(value2.floatValue());
        } else if (Double.class.equals(targetClass) || Double.TYPE.equals(targetClass)) {
            result2 = value2.doubleValue();
        } else if (Boolean.class.equals(targetClass) || Boolean.TYPE.equals(targetClass)) {
            result2 = value2.booleanValue();
        } else if (Date.class.equals(targetClass)) {
            result2 = value2.dateValue();
        } else if (String.class.equals(targetClass)) {
            result2 = value2.stringValue();
        } else {
            result2 = value2.getValue();
            if (result2 instanceof Dispatch) {
                Dispatch d = (Dispatch)result2;
                if (targetClass != null && targetClass.isInterface()) {
                    Object proxy = factory2.createProxy(targetClass, d);
                    if (!addReference) {
                        int n2 = d.Release();
                    }
                    result2 = proxy;
                } else {
                    result2 = d;
                }
            }
        }
        if (IComEnum.class.isAssignableFrom(targetClass)) {
            result2 = targetClass.cast(Convert.toComEnum(targetClass, result2));
        }
        if (freeValue) {
            Convert.free(inputValue, result2);
        }
        return result2;
    }

    public static <T extends IComEnum> T toComEnum(Class<T> enumType, Object value2) {
        try {
            IComEnum[] values2;
            Method m = enumType.getMethod("values", new Class[0]);
            for (IComEnum t : values2 = (IComEnum[])m.invoke(null, new Object[0])) {
                if (!value2.equals(t.getValue())) continue;
                return (T)t;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException2) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public static void free(Variant.VARIANT variant, Class<?> javaType) {
        Object value2;
        if ((javaType == null || !WTypes.BSTR.class.isAssignableFrom(javaType)) && variant != null && variant.getVarType().intValue() == 8 && (value2 = variant.getValue()) instanceof WTypes.BSTR) {
            OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)value2);
        }
    }

    public static void free(Variant.VARIANT variant, Object value2) {
        Convert.free(variant, value2 == null ? null : value2.getClass());
    }
}

