/*
 * Decompiled with CFR 0.152.
 */
package de.danielnaber.jwordsplitter.tools;

import de.danielnaber.jwordsplitter.GermanWordSplitter;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;

public final class TestjWordSplitterGerman {
    private TestjWordSplitterGerman() {
    }

    public static void main(String[] args) throws IOException {
        int argCount;
        long startTime = System.currentTimeMillis();
        if (args.length < 1 || args.length > 4 || args[0].equals("-h") || args[0].equals("--help")) {
            TestjWordSplitterGerman.usage();
        }
        String plainDict = null;
        boolean hideGlueChars = true;
        for (argCount = 0; argCount < args.length; ++argCount) {
            if (args[argCount].equals("-h")) {
                TestjWordSplitterGerman.usage();
                continue;
            }
            if (args[argCount].equals("-d")) {
                plainDict = args[++argCount];
                continue;
            }
            if (!args[argCount].equals("-f")) continue;
            hideGlueChars = false;
        }
        String inputFile = args[argCount - 1];
        GermanWordSplitter wordSplitter = plainDict != null ? new GermanWordSplitter(hideGlueChars, new File(plainDict)) : new GermanWordSplitter(hideGlueChars);
        wordSplitter.setStrictMode(true);
        try (Scanner scanner = new Scanner(new File(inputFile));){
            while (scanner.hasNext()) {
                String token = scanner.next();
                List<String> col = wordSplitter.splitWord(token);
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    System.out.print((String)it.next());
                    if (!it.hasNext()) continue;
                    System.out.print(", ");
                }
                System.out.println();
            }
        }
        System.err.println("Time: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    private static void usage() {
        System.out.println("Usage: TestjWordSplitterGerman [-f] [-d dictionary] <file>");
        System.out.println("    <file> Textdatei mit zu zerlegenden W\u00f6rtern");
        System.out.println("    -f  Fugenelemente mit ausgeben");
        System.out.println("    -d  Wortliste mit potenziellen Komposita-Teilen (statt der integrierten)");
        System.exit(1);
    }
}

