/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.net;

import com.install4j.runtime.beans.actions.net.DualDigest;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public enum DigestAlgorithm {
    SHA256("SHA-256"),
    MD5("MD5"),
    SHA256_OR_MD5("SHA-256 or MD5");

    private final String verbose;

    private DigestAlgorithm(String verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        return this.verbose;
    }

    public MessageDigest createMessageDigest() {
        try {
            switch (this) {
                case SHA256: {
                    return MessageDigest.getInstance("SHA-256");
                }
                case MD5: {
                    return MessageDigest.getInstance("MD5");
                }
                case SHA256_OR_MD5: {
                    return new DualDigest(true, true);
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException();
    }
}

